/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.ui.ml2.ML2PortGraphic;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.Observable;

public class ML2Card
extends CardGraphic {
    private static final int HORIZONTAL_CARD_PG_Y_OFFSET = 38;
    private static final int HORIZONTAL_CARD_PG_X_OFFSET = 12;
    private static final int HORIZONTAL_CARD_PG_X_OFFSET_SIX_PORT = 22;
    private static final int PORT_SIZE = 22;
    private static final int PORT_SPACING = 4;
    private static final int PORT_SPACING_SIX_PORT = 13;
    private PortModel[] portModels = null;
    protected ML2PortGraphic[] portGraphics = null;

    public ML2Card(ML2ModuleModel mL2ModuleModel, AbstractShelfLayout abstractShelfLayout) {
        super(mL2ModuleModel, abstractShelfLayout, new SDebug((KDebug)AbstractShelfLayout.db, "ML2Card:" + mL2ModuleModel.getSlot()), true);
        this.portModels = mL2ModuleModel.getEtherPortModels();
        int n = this.portModels.length;
        this.portGraphics = new ML2PortGraphic[n];
        boolean bl = false;
        int n2 = 0;
        if (this.pci.positionPortsVertically()) {
            int n3;
            int n4;
            int n5;
            int n6;
            if (n <= 4) {
                n6 = this.cardPainter.getOpticonYOffset();
                n5 = this.cardPainter.getOpticonYSpacing();
                n4 = this.cardPainter.getPortWidth();
                n3 = this.cardPainter.getPortHeight();
            } else if (n > 4 && n <= 6) {
                n6 = this.cardPainter.getMiniOpticonYOffset();
                n5 = this.cardPainter.getMiniOpticonYSpacing();
                n5 += n5 / 2;
                n4 = this.cardPainter.getMiniPortWidth();
                n3 = this.cardPainter.getMiniPortHeight();
            } else if (n > 6 && n <= 8) {
                n6 = this.cardPainter.getMiniOpticonYOffset();
                n5 = this.cardPainter.getMiniOpticonYSpacing();
                n4 = this.cardPainter.getMiniPortWidth();
                n3 = this.cardPainter.getMiniPortHeight();
                bl = true;
                n2 = n / 2;
            } else {
                n6 = this.cardPainter.getSmallMiniOpticonYOffset();
                n5 = this.cardPainter.getSmallMiniOpticonYSpacing();
                n4 = this.cardPainter.getSmallMiniPortWidth();
                n3 = this.cardPainter.getSmallMiniPortHeight();
            }
            int n7 = 0;
            for (int i = 0; i < n; ++i) {
                n7 = bl && i >= n2 ? (this.cardPainter.getMiniOpticonYSpacing() - this.cardPainter.getMiniPortHeight()) * 2 : 0;
                this.portGraphics[i] = new ML2PortGraphic(this, this.cardPainter.getMultiPortOpticonXOffset() + this.cardPainter.getOpticonXSpacing() * i, n6 + (n5 * i + n7), n4, n3, this.portModels[i]);
            }
        } else {
            int n8 = this.getEqType() == 284 ? 22 : 12;
            for (int i = 0; i < this.portModels.length; ++i) {
                this.portGraphics[i] = new ML2PortGraphic(this, n8, 38, 22, 22, this.portModels[i]);
                if (this.getEqType() == 284) {
                    n8 += 35;
                    continue;
                }
                n8 += i == 3 ? 38 : 26;
            }
        }
        if (this.alarmStore != null) {
            this.update(this.alarmStore.getAlarmStatusObservable(), this.alarmStore.getAlarmStatus());
        }
    }

    public String getTooltipText(MouseEvent mouseEvent) {
        try {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (this.portGraphics[i] == null || !this.portGraphics[i].contains(mouseEvent.getPoint())) continue;
                return this.portGraphics[i].getTooltipText();
            }
            return super.getTooltipText(mouseEvent);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return "";
        }
    }

    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (object instanceof AlarmStatus && this.portModels != null && this.portGraphics != null) {
            for (int i = 0; i < this.portModels.length; ++i) {
                PortModel portModel = this.portModels[i];
                IAlarmStatus iAlarmStatus = this.alarmStore.getEntityAlarmStatus(portModel);
                if (iAlarmStatus == null) continue;
                if (this.db.on()) {
                    int n = this.entityM.getSlot();
                    this.db.println("SlotNo=" + n + ", PortNo=" + portModel.getPort() + ", portEqType=" + portModel.getEqType() + ", AlarmStatus=" + iAlarmStatus + ", highest=" + iAlarmStatus.getHighestSeverity());
                }
                this.portGraphics[i].setAlarmState(iAlarmStatus.getHighestSeverity());
            }
        }
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        super.paintIcon(component, graphics, n, n2);
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (!this.pci.positionPortsVertically()) {
                if (this.getEqType() == 284) {
                    graphics2D.drawRect(8, 34, 224, 30);
                } else {
                    graphics2D.drawRect(8, 34, 108, 30);
                    graphics2D.drawRect(124, 34, 108, 30);
                }
            }
            for (int i = 0; i < this.portGraphics.length; ++i) {
                this.portGraphics[i].draw(graphics2D);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("disposing");
        }
        for (int i = 0; i < this.portGraphics.length; ++i) {
            this.portGraphics[i].dispose();
            this.portGraphics[i] = null;
        }
        super.dispose();
    }
}

