/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ms;

import cerent.cms.model.ChassisModelUpdate;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.IShelfViewModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.MultishelfViewController;
import cerent.cms.ui.ms.BayViewPanel;
import cerent.cms.ui.ms.RackViewPanel;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import cerent.util.gui.ActionOrganizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class MultishelfViewPanel
extends JPanel
implements ActionListener,
IObserver {
    private JPopupMenu popup;
    private MultishelfViewController msvc;
    private NodeModelDelegate nmd;
    private ChassisModels cms;
    private IUiToolkit uiToolkit;
    private HashMap<Integer, RackViewPanel> rackMap = new HashMap(12);
    private HashMap<Integer, RackBundle> bundleMap = new HashMap(12);
    private ActionOrganizer actOrg;
    private AbstractShelfLayout selectedShelf = null;
    private static final String CMD_UP = "Go To Parent View";
    private static final String CMD_ADD_RACK = "Add Rack";
    private static final int BORDER_SPACE = 22;
    protected static final Border SELECTED_BORDER = BorderFactory.createLineBorder(Color.black, 3);
    protected static final Border UNSELECTED_BORDER = BorderFactory.createLineBorder(Color.black, 1);
    protected static final SDebug db = new SDebug("MultishelfViewPanel");

    public MultishelfViewPanel(MultishelfViewController multishelfViewController, NodeModelDelegate nodeModelDelegate, IUiToolkit iUiToolkit) {
        if (db.on()) {
            db.println("<init>");
        }
        this.msvc = multishelfViewController;
        this.nmd = nodeModelDelegate;
        this.cms = nodeModelDelegate.getChassisModelsInstance();
        this.uiToolkit = iUiToolkit;
        this.cms.addObserver(this);
        this.setBorder(BorderFactory.createEmptyBorder(22, 22, 22, 22));
        this.setLayout(new BoxLayout(this, 0));
        this.popup = new JPopupMenu();
        this.actOrg = new ActionOrganizer(this);
        this.actOrg.addMenuItem((JComponent)this.popup, null, CMD_UP, 85);
        this.actOrg.addMenuItem((JComponent)this.popup, null, CMD_ADD_RACK, 65);
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
        this.buildPane();
    }

    public NodeModelDelegate getNodeModel() {
        return this.nmd;
    }

    public AbstractViewController getViewController() {
        return this.msvc;
    }

    public IUiToolkit getUiToolkit() {
        return this.uiToolkit;
    }

    private synchronized void buildPane() {
        ArrayList<RackViewPanel> arrayList = new ArrayList<RackViewPanel>();
        Object object = this.rackMap.keySet().iterator();
        while (object.hasNext()) {
            RackViewPanel rackViewPanel = this.rackMap.get(object.next());
            for (int i = 0; i < rackViewPanel.getMaxBays(); ++i) {
                BayViewPanel object2 = rackViewPanel.getBay(i + 1);
                if (object2.isEmpty() || this.cms.getChassisByPosition(rackViewPanel.getRackNum(), object2.getBayNum()) != null) continue;
                object2.bayRemoved();
            }
        }
        for (IShelfViewModel iShelfViewModel : this.cms.getShelfViewModels()) {
            BayViewPanel bayViewPanel;
            RackViewPanel rackViewPanel;
            short s = iShelfViewModel.getRackNumber();
            short s2 = iShelfViewModel.getRackPosition();
            if (this.rackMapContainsKey(s)) {
                rackViewPanel = this.getRack(s);
                bayViewPanel = rackViewPanel.getBay(s2);
                if (bayViewPanel.getChassis() == iShelfViewModel) continue;
                bayViewPanel.update((IObservable)iShelfViewModel, ModelUpdateType.ADDED);
                continue;
            }
            rackViewPanel = new RackViewPanel(this, this.nmd.isSdh(), s);
            bayViewPanel = rackViewPanel.getBay(s2);
            bayViewPanel.update((IObservable)iShelfViewModel, ModelUpdateType.ADDED);
            this.addToRackMap(s, rackViewPanel);
            arrayList.add(rackViewPanel);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            this.addRack((RackViewPanel)object.next());
        }
        this.actOrg.getMenuItem(CMD_ADD_RACK).setEnabled(this.isAddRackEnabled());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == CMD_UP) {
            this.msvc.tryJumpView(this.msvc.getParentVC().getViewName());
        } else if (string == CMD_ADD_RACK) {
            this.addRack((short)0);
        } else if (string == "Functional View") {
            this.msvc.execFv();
        }
    }

    private synchronized void addToBundleMap(int n, RackBundle rackBundle) {
        this.bundleMap.put(new Integer(n), rackBundle);
    }

    private synchronized RackBundle getFromBundleMap(int n) {
        return this.bundleMap.get(new Integer(n));
    }

    private synchronized void removeFromBundleMap(int n) {
        this.bundleMap.remove(new Integer(n));
    }

    private synchronized void addToRackMap(int n, RackViewPanel rackViewPanel) {
        this.rackMap.put(new Integer(n), rackViewPanel);
    }

    private synchronized boolean rackMapContainsKey(int n) {
        return this.rackMap.containsKey(new Integer(n));
    }

    public synchronized RackViewPanel getRack(int n) {
        return this.rackMap.get(new Integer(n));
    }

    private synchronized void removeFromRackMap(int n) {
        this.rackMap.remove(new Integer(n));
    }

    private synchronized int getRackMapSize() {
        return this.rackMap.size();
    }

    private boolean isAddRackEnabled() {
        return this.getRackMapSize() < 12;
    }

    private void addRack(RackViewPanel rackViewPanel) {
        JPanel jPanel = new JPanel();
        this.addToRackMap(rackViewPanel.getRackNum(), rackViewPanel);
        jPanel.add(rackViewPanel);
        RackBundle rackBundle = new RackBundle();
        Component component = Box.createHorizontalGlue();
        this.add(component);
        rackBundle.add(component);
        component = Box.createHorizontalStrut(Math.round(11.0f));
        this.add(component);
        rackBundle.add(component);
        component = Box.createHorizontalGlue();
        this.add(component);
        rackBundle.add(component);
        rackBundle.add(jPanel);
        this.addToBundleMap(rackViewPanel.getRackNum(), rackBundle);
        this.add(jPanel);
    }

    private void addRack(short s) {
        final short s2 = s < 1 ? this.nextAvailRackNum() : s;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (s2 > 0) {
                    MultishelfViewPanel.this.addRack(new RackViewPanel(MultishelfViewPanel.this, MultishelfViewPanel.this.nmd.isSdh(), s2));
                }
                MultishelfViewPanel.this.actOrg.getMenuItem(MultishelfViewPanel.CMD_ADD_RACK).setEnabled(MultishelfViewPanel.this.isAddRackEnabled());
                MultishelfViewPanel.this.revalidate();
            }
        });
    }

    void removeRack(final RackViewPanel rackViewPanel) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                short s = rackViewPanel.getRackNum();
                MultishelfViewPanel.this.removeFromRackMap(s);
                RackBundle rackBundle = MultishelfViewPanel.this.getFromBundleMap(s);
                Iterator<Component> iterator = rackBundle.iterator();
                while (iterator.hasNext()) {
                    Component component = iterator.next();
                    MultishelfViewPanel.this.remove(component);
                }
                MultishelfViewPanel.this.removeFromBundleMap(s);
                MultishelfViewPanel.this.actOrg.getMenuItem(MultishelfViewPanel.CMD_ADD_RACK).setEnabled(MultishelfViewPanel.this.isAddRackEnabled());
                MultishelfViewPanel.this.revalidate();
            }
        });
    }

    private short nextAvailRackNum() {
        short s = -1;
        for (int n = 0; n < 12; n = (int)((short)(n + 1))) {
            if (this.rackMapContainsKey(n + 1)) continue;
            s = (short)(n + 1);
            break;
        }
        return s;
    }

    public IShelfViewModel getSelectedShelf() {
        if (this.selectedShelf != null) {
            return this.selectedShelf.getChassis();
        }
        return null;
    }

    public void update(IObservable iObservable, Object object) {
        db.fine("update(" + iObservable + ", " + object + ")");
        int n = -1;
        IShelfViewModel iShelfViewModel = null;
        short s = -1;
        int n2 = -1;
        if (iObservable instanceof ChassisModels) {
            Object object2;
            if (object instanceof ChassisModelUpdate) {
                object2 = (ChassisModelUpdate)object;
                iShelfViewModel = ((ChassisModelUpdate)object2).getChassisModel();
                s = ((ChassisModelUpdate)object2).getRackNum();
                n2 = ((ChassisModelUpdate)object2).getRackPos();
                n = 2;
            } else {
                n = (Integer)object;
            }
            switch (n) {
                case 2: {
                    Object object3;
                    if (iShelfViewModel == null) break;
                    db.fine("ADDED " + iShelfViewModel);
                    object2 = null;
                    if (this.rackMapContainsKey(s)) {
                        object2 = this.getRack(s);
                    } else {
                        object3 = object2 = new RackViewPanel(this, this.nmd.isSdh(), s);
                        SwingUtilities.invokeLater(new Runnable((RackViewPanel)object3){
                            final /* synthetic */ RackViewPanel val$newRack;
                            {
                                this.val$newRack = rackViewPanel;
                            }

                            public void run() {
                                MultishelfViewPanel.this.addRack(this.val$newRack);
                                MultishelfViewPanel.this.revalidate();
                            }
                        });
                    }
                    object3 = ((RackViewPanel)object2).getBay(n2);
                    ((BayViewPanel)object3).update((IObservable)iShelfViewModel, ModelUpdateType.ADDED);
                    break;
                }
                case 0: {
                    break;
                }
                case 1: {
                    db.fine("Received CHANGED, rebuilding everything ...");
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MultishelfViewPanel.this.buildPane();
                            MultishelfViewPanel.this.revalidate();
                            MultishelfViewPanel.this.repaint(MultishelfViewPanel.this.getVisibleRect());
                        }
                    });
                    break;
                }
                default: {
                    db.severe("Unknown update type " + n);
                }
            }
        }
    }

    public void setSelectedShelf(AbstractShelfLayout abstractShelfLayout) {
        db.fine("setSelectedShelf(" + abstractShelfLayout + ")");
        if (this.selectedShelf != null && this.selectedShelf != abstractShelfLayout) {
            this.selectedShelf.setBorder(UNSELECTED_BORDER);
        }
        this.selectedShelf = abstractShelfLayout;
        if (this.selectedShelf != null) {
            this.selectedShelf.setBorder(SELECTED_BORDER);
            AbstractViewController.setActiveObject((Object)this.selectedShelf);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RackBundle {
        private List<Component> components = new ArrayList<Component>();

        public Iterator<Component> iterator() {
            return this.components.iterator();
        }

        public void add(Component component) {
            this.components.add(component);
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                MultishelfViewPanel.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

