/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.nodesetup.NodeSetupParser;
import cerent.cms.ui.nodesetup.NodeSetupSelection;
import cerent.cms.ui.nodesetup.NodeSetupWizard;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.shelf.SppNodeSetupPane;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class NodeSetupController {
    private SppNodeSetupPane pane;
    private NodeModelDelegate nmd;
    private SDebug dbg;
    private File mpFile;
    private NsdWizardInfo wizInfo = null;
    private NodeSetupParser nsp;

    public NodeSetupController(SppNodeSetupPane sppNodeSetupPane, NodeModelDelegate nodeModelDelegate, File file, File file2, SDebug sDebug) {
        this.pane = sppNodeSetupPane;
        this.nmd = nodeModelDelegate;
        this.mpFile = file;
        this.dbg = sDebug;
        this.wizInfo = new NsdWizardInfo(file2);
        this.wizInfo.setNodeName(this.nmd.getName());
        this.setup();
        if (this.dbg.on()) {
            this.dbg.println("NodeSetupController: start");
        }
    }

    private void setup() {
        String string = this.mpFile.getAbsolutePath();
        this.nsp = new NodeSetupParser(this.nmd, this.dbg);
        try {
            Node node = this.nsp.parse(this.mpFile);
            this.wizInfo = this.nsp.extractNodeDescriptions(node, this.wizInfo);
            NodeSetupSelection nodeSetupSelection = new NodeSetupSelection(JOptionPane.getFrameForComponent((Component)((Object)this.pane)), true, this.wizInfo, this.wizInfo.getNodesArray());
            nodeSetupSelection.show();
            if (this.wizInfo.getSelNode() != null) {
                this.wizInfo = this.nsp.extractNodeInfo(this.wizInfo.getSelNode(), node, this.wizInfo);
            }
            if (this.wizInfo.getSelNode() != null || this.wizInfo.getNodeCnt() == 1) {
                NodeSetupWizard nodeSetupWizard = new NodeSetupWizard(this.nmd, JOptionPane.getFrameForComponent((Component)((Object)this.pane)), this.wizInfo, true);
                nodeSetupWizard.show();
            }
        }
        catch (Exception exception) {
            if (exception instanceof SAXParseException) {
                String string2 = this.composeExceptionMsg((SAXParseException)exception, string);
                ErrorMsg.displayDetailed((Component)((Object)this.pane), EMC.EID_CANNOT_PERFORM, string2);
            }
            this.dbg.println(exception.toString());
            if (this.dbg.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            ErrorMsg.displayDetailed((Component)((Object)this.pane), EMC.EID_CANNOT_PERFORM, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String composeExceptionMsg(SAXException sAXException, String string) {
        int n = ((SAXParseException)sAXException).getLineNumber();
        String string2 = sAXException.getMessage();
        String string3 = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            for (int i = 1; (string3 = bufferedReader.readLine()) != null && i != n; ++i) {
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            this.dbg.println("IO Exception in composeExceptionMsg: " + iOException);
            if (this.dbg.on()) {
                SDebug.printStackTrace((Throwable)iOException);
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (string2.endsWith("for type 'null'.")) {
            int n2 = string2.length();
            string2 = string2.substring(1, n2 - 16);
        }
        int n3 = 0;
        n3 = string2.indexOf(":");
        if (n3 != -1) {
            string2 = string2.substring(n3 + 2, string2.length());
        }
        string3 = string3 != null ? string3.trim() : "<empty file>";
        String string4 = "File: " + string + "\n" + "Line#: " + n + "\n" + "Line: " + string3 + "\n" + "Message: " + string2;
        return string4;
    }
}

