/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class NodeSetupParser {
    private static final String BADXML_WT = "Invalid Metroplanner xml file";
    private static final String MISSING_SCHEMA_WT = "The schema file was not found. It is impossible to proceed.";
    private static final String MULTISHELF_XML_WT = "Invalid Multi Shelf xml file: the node is single shelf";
    private static final String ANP_SECT = ", see cards provisioning section";
    private static final String PARAMS_SECT = ", see card parameters provisioning section";
    private static final String PATCHCORDS_SECT = ", see internal patchcords provisioning section";
    private static final String SIDES_SECT = ", see optical sides provisioning section";
    private static final String PPM_SECT = ", see pluggable port modules provisioning section";
    private static final String SHELFID_XML_WT = "Invalid Single Shelf xml file: incorrect shelf id ";
    private static final String ANS_XML_WT = "Invalid Metroplanner xml file: incorrect ANS section";
    private int shelfCounter = -1;
    private boolean isSingleShelf = false;
    private static String debugDtdFileName;

    public NodeSetupParser(NodeModelDelegate nodeModelDelegate, SDebug sDebug) {
        this.isSingleShelf = !nodeModelDelegate.isMultishelf();
        debugDtdFileName = null;
    }

    private NodeSetupParser(String string) {
        debugDtdFileName = string;
    }

    public Node parse(File file) throws FactoryConfigurationError, ParserConfigurationException, IOException, SAXException {
        String string = file.getAbsolutePath();
        String string2 = "file:" + string;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new Handler());
        documentBuilder.setEntityResolver(new SchemaLoader());
        Document document = documentBuilder.parse(string2);
        return document;
    }

    public NsdWizardInfo extractNodeDescriptions(Node node, NsdWizardInfo nsdWizardInfo) throws Exception {
        switch (node.getNodeType()) {
            case 9: {
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    this.extractNodeDescriptions(nodeList.item(i), nsdWizardInfo);
                }
                break;
            }
            case 1: {
                String string = node.getNodeName();
                if (string.equalsIgnoreCase("network")) {
                    NodeList nodeList = node.getChildNodes();
                    if (nodeList == null) break;
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        this.extractNodeDescriptions(nodeList.item(i), nsdWizardInfo);
                    }
                    break;
                }
                if (string.equalsIgnoreCase("nodesetup")) {
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                        Node node2 = namedNodeMap.item(i);
                        String string2 = node2.getNodeName();
                        if (string2.equalsIgnoreCase("descr")) {
                            nsdWizardInfo.setNodesArray(nsdWizardInfo.getNodeCnt(), node2.getNodeValue());
                            nsdWizardInfo.incNodeCnt();
                            continue;
                        }
                        if (!string2.equalsIgnoreCase("version")) continue;
                        nsdWizardInfo.setNodesVer(nsdWizardInfo.getNodeCnt(), node2.getNodeValue());
                    }
                    break;
                }
                throw new Exception(BADXML_WT);
            }
        }
        return nsdWizardInfo;
    }

    public NsdWizardInfo extractNodeInfo(String string, Node node, NsdWizardInfo nsdWizardInfo) throws Exception {
        switch (node.getNodeType()) {
            case 9: {
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    this.extractNodeInfo(string, nodeList.item(i), nsdWizardInfo);
                }
                break;
            }
            case 1: {
                String string2 = node.getNodeName();
                if (string2.equalsIgnoreCase("network")) {
                    NodeList nodeList = node.getChildNodes();
                    if (nodeList == null) break;
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        this.extractNodeInfo(string, nodeList.item(i), nsdWizardInfo);
                    }
                    break;
                }
                if (string2.equalsIgnoreCase("nodesetup")) {
                    NodeList nodeList = node.getChildNodes();
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    Node node2 = namedNodeMap.item(0);
                    if (nodeList == null || !node2.getNodeValue().equalsIgnoreCase(string)) break;
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        this.extractNodeInfo(string, nodeList.item(i), nsdWizardInfo);
                    }
                    break;
                }
                if (string2.equalsIgnoreCase("ans")) {
                    NodeList nodeList = node.getChildNodes();
                    if (nodeList == null) break;
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        this.extractAnsInfo(nodeList.item(i), nsdWizardInfo);
                    }
                    break;
                }
                if (string2.equalsIgnoreCase("anp")) {
                    NodeList nodeList = node.getChildNodes();
                    if (nodeList == null) break;
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        this.extractShelfOrPassiveUnitsInfo(nodeList.item(i), nsdWizardInfo);
                    }
                    break;
                }
                if (string2.equalsIgnoreCase("ppms")) {
                    NodeList nodeList = node.getChildNodes();
                    if (nodeList == null) break;
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        this.extractPpmInfo(nodeList.item(i), nsdWizardInfo);
                    }
                    break;
                }
                if (string2.equalsIgnoreCase("parameters")) {
                    NodeList nodeList = node.getChildNodes();
                    if (nodeList == null) break;
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        this.extractParamInfo(nodeList.item(i), nsdWizardInfo);
                    }
                    break;
                }
                if (string2.equalsIgnoreCase("patchcords")) {
                    NodeList nodeList = node.getChildNodes();
                    if (nodeList == null) break;
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        this.extractPatchcordInfo(nodeList.item(i), nsdWizardInfo);
                    }
                    break;
                }
                if (string2.equalsIgnoreCase("sides")) {
                    NodeList nodeList = node.getChildNodes();
                    if (nodeList == null) break;
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        this.extractSideInfo(nodeList.item(i), nsdWizardInfo);
                    }
                    break;
                }
                throw new Exception(BADXML_WT);
            }
        }
        return nsdWizardInfo;
    }

    private void extractPatchcordInfo(Node node, NsdWizardInfo nsdWizardInfo) throws Exception {
        NsdWizardInfo.PatchcordsStructure patchcordsStructure = null;
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null & nodeList.getLength() > 0) {
            patchcordsStructure = nsdWizardInfo.new NsdWizardInfo.PatchcordsStructure();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string = nodeList.item(i).getFirstChild() != null ? nodeList.item(i).getFirstChild().getNodeValue() : "";
                String string2 = nodeList.item(i).getNodeName();
                if (string2.equalsIgnoreCase("from_shelf")) {
                    patchcordsStructure.from_shelf = string;
                    if (string.equals("") || Integer.parseInt(string) <= 1 || !this.isSingleShelf) continue;
                    throw new Exception("Invalid Multi Shelf xml file: the node is single shelf, see internal patchcords provisioning section");
                }
                if (string2.equalsIgnoreCase("to_shelf")) {
                    patchcordsStructure.to_shelf = string;
                    if (string.equals("") || Integer.parseInt(string) <= 1 || !this.isSingleShelf) continue;
                    throw new Exception("Invalid Multi Shelf xml file: the node is single shelf, see internal patchcords provisioning section");
                }
                if (string2.equalsIgnoreCase("from_slot")) {
                    patchcordsStructure.from_slot = string;
                    continue;
                }
                if (string2.equalsIgnoreCase("to_slot")) {
                    patchcordsStructure.to_slot = string;
                    continue;
                }
                if (string2.equalsIgnoreCase("from_unit")) {
                    patchcordsStructure.from_unit = string;
                    continue;
                }
                if (string2.equalsIgnoreCase("to_unit")) {
                    patchcordsStructure.to_unit = string;
                    continue;
                }
                if (string2.equalsIgnoreCase("from_port")) {
                    patchcordsStructure.from_port = string;
                    continue;
                }
                if (!string2.equalsIgnoreCase("to_port")) continue;
                patchcordsStructure.to_port = string;
            }
            nsdWizardInfo.getPatchcords().addElement(patchcordsStructure);
        }
    }

    private void extractParamInfo(Node node, NsdWizardInfo nsdWizardInfo) throws Exception {
        NsdWizardInfo.ParamStructure paramStructure = null;
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string = nodeList.item(i).getFirstChild() != null ? nodeList.item(i).getFirstChild().getNodeValue() : "";
                String string2 = nodeList.item(i).getNodeName();
                if (string2.equalsIgnoreCase("shelf_position")) {
                    paramStructure = nsdWizardInfo.new NsdWizardInfo.ParamStructure();
                    paramStructure.shelf = string;
                    if (Integer.parseInt(paramStructure.shelf) <= 1 || !this.isSingleShelf) continue;
                    throw new Exception("Invalid Multi Shelf xml file: the node is single shelf, see card parameters provisioning section");
                }
                if (string2.equalsIgnoreCase("unit_id")) {
                    paramStructure = nsdWizardInfo.new NsdWizardInfo.ParamStructure();
                    paramStructure.unitid = string;
                    continue;
                }
                if (string2.equalsIgnoreCase("slot_position")) {
                    paramStructure.slot = string;
                    continue;
                }
                if (string2.equalsIgnoreCase("port_position")) {
                    paramStructure.port = string;
                    continue;
                }
                if (string2.equalsIgnoreCase("ppm_position")) {
                    paramStructure.ppm = string;
                    continue;
                }
                if (string2.equalsIgnoreCase("name")) {
                    paramStructure.paramName = string;
                    continue;
                }
                if (!string2.equalsIgnoreCase("value")) continue;
                paramStructure.paramValue = string;
                nsdWizardInfo.getParams().addElement(paramStructure);
            }
        }
    }

    private void extractPpmInfo(Node node, NsdWizardInfo nsdWizardInfo) throws Exception {
        NsdWizardInfo.PpmStructure ppmStructure = null;
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null & nodeList.getLength() > 0) {
            ppmStructure = nsdWizardInfo.new NsdWizardInfo.PpmStructure();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string = nodeList.item(i).getFirstChild() != null ? nodeList.item(i).getFirstChild().getNodeValue() : "";
                String string2 = nodeList.item(i).getNodeName();
                if (string2.equalsIgnoreCase("ppmshelf")) {
                    ppmStructure.shelf = string;
                    if (Integer.parseInt(ppmStructure.shelf) <= 1 || !this.isSingleShelf) continue;
                    throw new Exception("Invalid Multi Shelf xml file: the node is single shelf, see pluggable port modules provisioning section");
                }
                if (string2.equalsIgnoreCase("ppmslot")) {
                    ppmStructure.slot = string;
                    continue;
                }
                if (string2.equalsIgnoreCase("ppmnum")) {
                    ppmStructure.ppmnum = string;
                    continue;
                }
                if (string2.equalsIgnoreCase("ppmtype")) {
                    ppmStructure.ppmtype = string;
                    continue;
                }
                if (string2.equalsIgnoreCase("ppmport")) {
                    ppmStructure.ppmport = string;
                    continue;
                }
                if (!string2.equalsIgnoreCase("ppmporttype")) continue;
                ppmStructure.ppmporttype = string;
            }
            nsdWizardInfo.getPpm().addElement(ppmStructure);
        }
    }

    private void extractShelfOrPassiveUnitsInfo(Node node, NsdWizardInfo nsdWizardInfo) throws Exception {
        block9: {
            int n;
            NodeList nodeList;
            NsdWizardInfo.NodeStructure nodeStructure;
            block10: {
                String string = node.getNodeName();
                nodeStructure = null;
                if (!string.equalsIgnoreCase("shelf")) break block9;
                nodeList = node.getChildNodes();
                NamedNodeMap namedNodeMap = node.getAttributes();
                nodeStructure = nsdWizardInfo.new NsdWizardInfo.NodeStructure();
                for (n = 0; n < namedNodeMap.getLength(); ++n) {
                    Node node2 = namedNodeMap.item(n);
                    String string2 = node2.getNodeName();
                    if (string2.equalsIgnoreCase("id")) {
                        nodeStructure.shelf = node2.getNodeValue();
                        if (!this.isSingleShelf || nodeStructure.shelf.equals("1")) continue;
                        throw new Exception(SHELFID_XML_WT + nodeStructure.shelf);
                    }
                    if (string2.equalsIgnoreCase("type")) {
                        nodeStructure.shType = node2.getNodeValue();
                        continue;
                    }
                    if (string2.equalsIgnoreCase("rackNum")) {
                        nodeStructure.rackNum = node2.getNodeValue();
                        continue;
                    }
                    if (string2.equalsIgnoreCase("rackPos")) {
                        nodeStructure.rackPos = node2.getNodeValue();
                        continue;
                    }
                    if (string2.equalsIgnoreCase("RUPos")) {
                        nodeStructure.RUPos = node2.getNodeValue();
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("RUSize")) continue;
                    nodeStructure.RUSize = node2.getNodeValue();
                }
                if (!nodeStructure.shType.equalsIgnoreCase("PASSIVE CHASSIS")) break block10;
                for (n = 0; n < nodeList.getLength(); ++n) {
                    this.extractPUnitInfo(nodeList.item(n), nsdWizardInfo, nodeStructure);
                }
                break block9;
            }
            ++this.shelfCounter;
            if (this.shelfCounter > 0 && this.isSingleShelf) {
                throw new Exception("Invalid Multi Shelf xml file: the node is single shelf, see cards provisioning section");
            }
            nsdWizardInfo.getAnp().addElement(nodeStructure);
            if (nodeList == null) break block9;
            for (n = 0; n < nodeList.getLength(); ++n) {
                this.extractSlotInfo(this.shelfCounter, nodeList.item(n), nsdWizardInfo);
            }
        }
    }

    private void extractSlotInfo(int n, Node node, NsdWizardInfo nsdWizardInfo) {
        String string = node.getNodeName();
        NsdWizardInfo.NodeStructure nodeStructure = null;
        if (string.equalsIgnoreCase("slot")) {
            int n2;
            String string2 = null;
            NodeList nodeList = node.getChildNodes();
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (n2 = 0; n2 < namedNodeMap.getLength(); ++n2) {
                Node node2 = namedNodeMap.item(n2);
                nodeStructure = nsdWizardInfo.getAnp().elementAt(n);
                string2 = node2.getNodeValue();
                nodeStructure.slot.addElement(string2);
            }
            if (nodeList != null) {
                for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                    this.extractEqInfo(n, nodeList.item(n2), nsdWizardInfo);
                }
            }
        }
    }

    private void extractPUnitInfo(Node node, NsdWizardInfo nsdWizardInfo, NsdWizardInfo.NodeStructure nodeStructure) {
        String string = node.getNodeName();
        if (string.equalsIgnoreCase("slot")) {
            int n;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (n = 0; n < namedNodeMap.getLength(); ++n) {
                Node node2 = namedNodeMap.item(n);
                String string7 = node2.getNodeName();
                if (string7.equalsIgnoreCase("pos")) {
                    string2 = node2.getNodeValue();
                    continue;
                }
                if (!string7.equalsIgnoreCase("occupancy")) continue;
                string3 = node2.getNodeValue();
            }
            NodeList nodeList = node.getChildNodes();
            if (nodeList != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    Node node3 = nodeList.item(n);
                    String string8 = node3.getNodeName();
                    if (string8.equalsIgnoreCase("eqtype")) {
                        string5 = node3.getFirstChild().getNodeValue();
                        continue;
                    }
                    if (string8.equalsIgnoreCase("description")) {
                        string6 = node3.getFirstChild().getNodeValue();
                        continue;
                    }
                    if (!string8.equalsIgnoreCase("unit_id")) continue;
                    string4 = node3.getFirstChild().getNodeValue();
                }
            }
            NsdWizardInfo.PUnitStructure pUnitStructure = nsdWizardInfo.new NsdWizardInfo.PUnitStructure();
            pUnitStructure.unitNumber = string4;
            pUnitStructure.eqType = string5;
            pUnitStructure.description = string6;
            pUnitStructure.rackNum = nodeStructure.rackNum;
            pUnitStructure.rackPos = nodeStructure.rackPos;
            pUnitStructure.RUPos = nodeStructure.RUPos;
            pUnitStructure.RUSize = nodeStructure.RUSize;
            pUnitStructure.slotPos = string2;
            pUnitStructure.slotOccupied = string3;
            nsdWizardInfo.getPassiveUnits().addElement(pUnitStructure);
        }
    }

    private void extractEqInfo(int n, Node node, NsdWizardInfo nsdWizardInfo) {
        String string = node.getNodeName();
        NsdWizardInfo.NodeStructure nodeStructure = null;
        nodeStructure = nsdWizardInfo.getAnp().elementAt(n);
        if (string.equalsIgnoreCase("eqtype")) {
            nodeStructure.eqType.addElement(node.getFirstChild().getNodeValue());
        }
    }

    private void extractSideInfo(Node node, NsdWizardInfo nsdWizardInfo) throws Exception {
        NsdWizardInfo.SidesStructure sidesStructure = null;
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null & nodeList.getLength() > 0) {
            sidesStructure = nsdWizardInfo.new NsdWizardInfo.SidesStructure();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string = nodeList.item(i).getFirstChild() != null ? nodeList.item(i).getFirstChild().getNodeValue() : "";
                String string2 = nodeList.item(i).getNodeName();
                if (string2.equalsIgnoreCase("side_name")) {
                    sidesStructure.side_name = string;
                    continue;
                }
                if (string2.equalsIgnoreCase("shelf_in")) {
                    sidesStructure.shelf_in = string;
                    if (Integer.parseInt(sidesStructure.shelf_in) <= 1 || !this.isSingleShelf) continue;
                    throw new Exception("Invalid Multi Shelf xml file: the node is single shelf, see optical sides provisioning section");
                }
                if (string2.equalsIgnoreCase("shelf_out")) {
                    sidesStructure.shelf_out = string;
                    if (Integer.parseInt(sidesStructure.shelf_out) <= 1 || !this.isSingleShelf) continue;
                    throw new Exception("Invalid Multi Shelf xml file: the node is single shelf, see optical sides provisioning section");
                }
                if (string2.equalsIgnoreCase("slot_in")) {
                    sidesStructure.slot_in = string;
                    continue;
                }
                if (string2.equalsIgnoreCase("slot_out")) {
                    sidesStructure.slot_out = string;
                    continue;
                }
                if (string2.equalsIgnoreCase("port_in")) {
                    sidesStructure.port_in = string;
                    continue;
                }
                if (!string2.equalsIgnoreCase("port_out")) continue;
                sidesStructure.port_out = string;
            }
            nsdWizardInfo.getSides().addElement(sidesStructure);
        }
    }

    private void extractAnsValue(Node node, NsdWizardInfo.AnsParamStructure ansParamStructure) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            String string = node2.getNodeName();
            if (string.equalsIgnoreCase("value")) {
                ansParamStructure.paramValue = node2.getNodeValue();
                continue;
            }
            if (!string.equalsIgnoreCase("wl")) continue;
            ansParamStructure.wavelength = node2.getNodeValue();
        }
    }

    private void extractAnsPortParamInfo(NodeList nodeList, NsdWizardInfo nsdWizardInfo) throws Exception {
        NsdWizardInfo.AnsParamStructure ansParamStructure = null;
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string = nodeList.item(i).getFirstChild() != null ? nodeList.item(i).getFirstChild().getNodeValue() : "";
                String string2 = nodeList.item(i).getNodeName();
                if (string2.equalsIgnoreCase("shelf_position")) {
                    ansParamStructure = nsdWizardInfo.new NsdWizardInfo.AnsParamStructure();
                    ansParamStructure.shelf = string;
                    if (Integer.parseInt(ansParamStructure.shelf) <= 1 || !this.isSingleShelf) continue;
                    throw new Exception("Invalid Multi Shelf xml file: the node is single shelf, see card parameters provisioning section");
                }
                if (string2.equalsIgnoreCase("slot_position")) {
                    ansParamStructure.slot = string;
                    continue;
                }
                if (string2.equalsIgnoreCase("port_position")) {
                    ansParamStructure.port = string;
                    continue;
                }
                if (string2.equalsIgnoreCase("#text")) continue;
                ansParamStructure.paramName = string2;
                this.extractAnsValue(nodeList.item(i), ansParamStructure);
                nsdWizardInfo.getAnsParameters().addElement(ansParamStructure);
                ansParamStructure = ansParamStructure.clone_value();
            }
        }
    }

    private void extractAnsNodeParamInfo(NodeList nodeList, NsdWizardInfo nsdWizardInfo) throws Exception {
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string = nodeList.item(i).getNodeName();
                if (string.equalsIgnoreCase("#text")) continue;
                NsdWizardInfo.AnsParamStructure ansParamStructure = nsdWizardInfo.new NsdWizardInfo.AnsParamStructure();
                ansParamStructure.paramName = string;
                this.extractAnsValue(nodeList.item(i), ansParamStructure);
                nsdWizardInfo.getAnsParameters().addElement(ansParamStructure);
            }
        }
    }

    private void extractAnsInfo(Node node, NsdWizardInfo nsdWizardInfo) throws Exception {
        String string = node.getNodeName();
        if (string.equalsIgnoreCase("port_parameter")) {
            NodeList nodeList = node.getChildNodes();
            if (nodeList != null) {
                this.extractAnsPortParamInfo(nodeList, nsdWizardInfo);
            }
        } else if (string.equalsIgnoreCase("node_parameter")) {
            NodeList nodeList = node.getChildNodes();
            if (nodeList != null) {
                this.extractAnsNodeParamInfo(nodeList, nsdWizardInfo);
            }
        } else if (!string.equalsIgnoreCase("#text")) {
            throw new Exception("Invalid Metroplanner xml file: incorrect ANS section Unknown section: " + string);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 2) {
            String string = stringArray[0];
            String string2 = stringArray[1];
            NodeSetupParser nodeSetupParser = new NodeSetupParser(string2);
            try {
                Node node = nodeSetupParser.parse(new File(string));
                NsdWizardInfo nsdWizardInfo = new NsdWizardInfo();
                nodeSetupParser.extractNodeDescriptions(node, nsdWizardInfo);
                for (int i = 0; i < nsdWizardInfo.getNodeCnt(); ++i) {
                    String string3 = nsdWizardInfo.getSingleNodeArray(i);
                    nodeSetupParser.extractNodeInfo(string3, node, nsdWizardInfo);
                    System.out.println("Site: " + string3);
                    nsdWizardInfo.dump();
                    nsdWizardInfo.init();
                    nodeSetupParser.shelfCounter = -1;
                }
                System.out.println("Parse succeeded for " + string);
            }
            catch (SAXParseException sAXParseException) {
                System.out.println(string + ":" + sAXParseException.getLineNumber() + " " + sAXParseException.getMessage());
            }
            catch (Exception exception) {
                System.out.println(string + ":" + exception);
            }
        } else {
            System.out.println("usage: NodeSetupParser <fullyQualifiedXmlFileToValidate> <fullyQualifiedSchemaFileLocation>");
        }
    }

    private static class SchemaLoader
    implements EntityResolver {
        private static final String XSD = "schema/nodesetup/mp-schema.dtd";

        private SchemaLoader() {
        }

        public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
            InputStream inputStream = null;
            URL uRL = this.getClass().getClassLoader().getResource(XSD);
            if (debugDtdFileName != null) {
                uRL = new URL("file://" + debugDtdFileName);
            }
            try {
                inputStream = uRL.openStream();
            }
            catch (Exception exception) {
                KDebug.printStackTrace((Throwable)exception);
            }
            if (inputStream == null) {
                throw new IOException(NodeSetupParser.MISSING_SCHEMA_WT);
            }
            return new InputSource(inputStream);
        }
    }

    private static class Handler
    implements ErrorHandler {
        public void error(SAXParseException sAXParseException) throws SAXParseException {
            System.out.println(" There was an error in the parsing ");
            sAXParseException.printStackTrace();
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
            System.out.println(" There was an error in the parsing ");
            sAXParseException.printStackTrace();
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) {
            System.out.println(" There was a warning in the parsing ");
            sAXParseException.printStackTrace();
        }
    }
}

