/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.model.ConfigError;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayer;
import cerent.cms.ui.pm.PmLayerDs3xmCpbit;
import cerent.cms.ui.pm.PmLayerDs3xmLine;
import cerent.cms.ui.pm.PmLayerDs3xmPbit;

public class PmLayerDs3xm
extends PmLayer {
    protected int cpbitCount;
    protected PmLayer cpbitLayer;
    protected int lineCount;
    protected PmLayer lineLayer;
    protected int numParms;
    protected int pbitCount;
    protected PmLayer pbitLayer;

    public PmLayerDs3xm(PmTableModel pmTableModel, Ds123LineModel ds123LineModel, int n) {
        this.setLayers(pmTableModel, ds123LineModel, n);
        this.lineCount = this.lineLayer.parmCount();
        this.pbitCount = this.pbitLayer.parmCount();
        this.cpbitCount = this.cpbitLayer.parmCount();
        this.numParms = this.lineCount + this.pbitCount + this.cpbitCount;
    }

    protected void setLayers(PmTableModel pmTableModel, Ds123LineModel ds123LineModel, int n) {
        this.lineLayer = new PmLayerDs3xmLine(pmTableModel, ds123LineModel, n);
        this.pbitLayer = new PmLayerDs3xmPbit(pmTableModel, ds123LineModel, n);
        this.cpbitLayer = new PmLayerDs3xmCpbit(pmTableModel, ds123LineModel, n);
    }

    public void clearStats() throws NoSuchInterface, WrongInterfaceType, InternalCommError, ConfigError, UnsupportedOperation {
        this.lineLayer.clearStats();
    }

    public boolean hasFarEnd() {
        return this.lineLayer.hasFarEnd() || this.pbitLayer.hasFarEnd() || this.cpbitLayer.hasFarEnd();
    }

    public void setNearEnd(boolean bl) {
        this.lineLayer.setNearEnd(bl);
        this.pbitLayer.setNearEnd(bl);
        this.cpbitLayer.setNearEnd(bl);
    }

    public void setIntervalType(eIntervalType eIntervalType2) {
        this.lineLayer.setIntervalType(eIntervalType2);
        this.pbitLayer.setIntervalType(eIntervalType2);
        this.cpbitLayer.setIntervalType(eIntervalType2);
    }

    public Object getPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if (n < this.lineCount) {
            return this.lineLayer.getPmValue(n, n2);
        }
        if ((n -= this.lineCount) < this.pbitCount) {
            return this.pbitLayer.getPmValue(n, n2);
        }
        return this.cpbitLayer.getPmValue(n -= this.pbitCount, n2);
    }

    public String layerLabel() {
        return "DS3";
    }

    public int parmCount() {
        return this.numParms;
    }

    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.lineLayer.refreshPmStats(n);
        this.pbitLayer.refreshPmStats(n);
        this.cpbitLayer.refreshPmStats(n);
        this.fromPeerCard = this.lineLayer.isFromPeerCard() || this.pbitLayer.isFromPeerCard() || this.cpbitLayer.isFromPeerCard();
    }

    public String parmName(int n) {
        if (n < this.lineCount) {
            return this.lineLayer.parmName(n);
        }
        if ((n -= this.lineCount) < this.pbitCount) {
            return this.pbitLayer.parmName(n);
        }
        return this.cpbitLayer.parmName(n -= this.pbitCount);
    }

    public void setModel(InterfaceModel interfaceModel) {
        this.lineLayer.setModel(interfaceModel);
        this.pbitLayer.setModel(interfaceModel);
        this.cpbitLayer.setModel(interfaceModel);
    }

    public void tossData() {
        this.lineLayer.tossData();
        this.pbitLayer.tossData();
        this.cpbitLayer.tossData();
        this.fromPeerCard = false;
    }

    public void destroy() {
        this.lineLayer.destroy();
        this.pbitLayer.destroy();
        this.cpbitLayer.destroy();
        super.destroy();
    }
}

