/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Optics.eOpticalAmplifierRole;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.OpticsCardView;
import cerent.cms.ui.shelf.OpticsPortGraphic;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Observable;

public class AmplifierCard
extends CardGraphic {
    protected OpticsPortGraphic[] portGraphics = null;

    public AmplifierCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug) {
        super(entityModel, abstractShelfLayout, sDebug, true);
        this.addPortGraphics(entityModel);
        if (this.alarmStore != null) {
            this.update(this.alarmStore.getAlarmStatusObservable(), this.alarmStore.getAlarmStatus());
        }
    }

    protected void addPortGraphics(EntityModel entityModel) {
        if (entityModel instanceof ModuleModel) {
            List list = entityModel.getChildren();
            int n = list.size();
            this.portGraphics = new OpticsPortGraphic[n];
            int n2 = this.cardPainter.getMiniPortHeight();
            int n3 = this.cardPainter.getMiniPortWidth();
            int n4 = this.cardPainter.getMultiPortOpticonXOffset();
            int n5 = this.cardPainter.getMiniOpticonYSpacing();
            int n6 = this.cardPainter.getMiniOpticonYOffset();
            int n7 = this.cardPainter.getOpticonXSpacing();
            int n8 = 0;
            for (int i = 0; i < n; ++i) {
                int n9;
                int n10;
                OpticsPortModel opticsPortModel = (OpticsPortModel)list.get(i);
                n8 = this.getPortModelIdx(opticsPortModel.getPort() - 1);
                if (((AbstractOpticsLineModel)opticsPortModel.getInterfaceModel()).isPortTypeRX()) {
                    n10 = n4 + n7 * n8 - 6;
                    n9 = n6 + (n5 - 7) * n8;
                } else {
                    n10 = n4 + n7 * n8 + 6;
                    n9 = n6 + (n5 - 7) * (n8 - 1);
                }
                this.portGraphics[n8] = new OpticsPortGraphic((CardGraphic)this, n10, n9, n3, n2, opticsPortModel);
            }
        }
    }

    public String getTooltipText(MouseEvent mouseEvent) {
        try {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (!this.portGraphics[i].contains(mouseEvent.getPoint())) continue;
                return this.portGraphics[i].getTooltipText();
            }
            return super.getTooltipText(mouseEvent);
        }
        catch (Exception exception) {
            this.db.println("exception in getTooltipText: " + exception);
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (object instanceof AlarmStatus && this.portGraphics != null) {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (this.portGraphics[i] == null) continue;
                this.portGraphics[i].update(observable, this.alarmStore);
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.portGraphics != null) {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (this.portGraphics[i] == null) continue;
                this.portGraphics[i].dispose();
                this.portGraphics[i] = null;
            }
            this.portGraphics = null;
        }
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintIcon(component, graphics2D, n, n2);
        if (this.pci.is600()) {
            return;
        }
        for (int i = 0; i < this.portGraphics.length; ++i) {
            this.portGraphics[i].drawOnlyOneConnector(graphics2D, true, false);
        }
        this.addRoleLabel(graphics);
    }

    private void addRoleLabel(Graphics graphics) {
        float f = 0.76363635f;
        try {
            eOpticalAmplifierRole eOpticalAmplifierRole2 = ((OpticsModuleModel)this.entityM).getAmpliRole();
            if (this.isRoletobeDisplayed(eOpticalAmplifierRole2)) {
                int n = this.cardPainter.getCardWidth();
                int n2 = this.cardPainter.getCardHeight();
                int n3 = Math.round((float)n2 * f);
                Font font = graphics.getFont();
                graphics.setFont(font.deriveFont((float)(font.getSize() - 1)));
                graphics.setColor(Color.black);
                String string = eOpticalAmplifierRole2 == eOpticalAmplifierRole.BST_AMPLI ? "LINE" : (eOpticalAmplifierRole2 == eOpticalAmplifierRole.PRE_AMPLI ? "PRE" : "");
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n4 = (n - fontMetrics.stringWidth(string)) / 2;
                graphics.drawString(string, n4, n3);
                graphics.setFont(font);
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            this.db.println("exception retrieving role: " + (Object)((Object)noSuchInterface));
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            this.db.println("exception retrieving role: " + (Object)((Object)wrongInterfaceType));
        }
    }

    private boolean isRoletobeDisplayed(eOpticalAmplifierRole eOpticalAmplifierRole2) {
        boolean bl = false;
        if (eOpticalAmplifierRole2 != eOpticalAmplifierRole.NO_AMPLI) {
            switch (this.entityM.getEqType()) {
                case 129: 
                case 287: 
                case 294: 
                case 295: 
                case 296: 
                case 321: {
                    bl = false;
                    break;
                }
                default: {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private int getPortModelIdx(int n) {
        int n2 = n;
        if (this.entityM != null && this.entityM.getEqType() == 249) {
            n2 = OpticsCardView.MMU_PORT_MODEL_ARRAY[n];
        }
        if (this.entityM != null && this.entityM.getEqType() == 281) {
            n2 = OpticsCardView.AMP_C_L_PORT_MODEL_ARRAY[n];
        }
        if (this.entityM != null && this.entityM.getEqType() == 240) {
            return OpticsCardView.AMP_C_L_PORT_MODEL_ARRAY[n];
        }
        return n2;
    }
}

