/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.model.Attribute;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.MrSlot;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.ui.ppm.PpmCard;
import cerent.cms.ui.ppm.PpmSlot;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.DwdmPortGraphic;
import cerent.cms.ui.shelf.OpticalPortGraphic;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Observable;
import javax.swing.SwingUtilities;

public class DwdmCard
extends CardGraphic {
    private static final int MAX_PPM_PORT_PER_LINE = 5;
    protected List<PortModel> ports = new ArrayList<PortModel>();
    protected OpticalPortGraphic[] portGraphics = new OpticalPortGraphic[0];
    protected PpmSlot[] ppmSlots = new PpmSlot[0];
    protected DwdmModuleModel moduleM;
    protected MrSlot mrSlot;
    protected ObservableManager _obsMgr;

    public DwdmCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout) {
        super(entityModel, abstractShelfLayout, new SDebug((KDebug)AbstractShelfLayout.db, "DWDMCard:" + entityModel.getSlot()), true);
        this.moduleM = (DwdmModuleModel)entityModel;
        this.mrSlot = this.moduleM.getMrSlot();
        this._obsMgr = new ObservableManager(this, false);
        this.addPorts();
        this.registerForLocalUpdates();
    }

    protected void registerForLocalUpdates() {
        this._obsMgr.reset();
        if (this.mrSlot != null) {
            this._obsMgr.addObservable((Observable)((Object)this.mrSlot));
            this._obsMgr.addObservable((Observable[])this.mrSlot.getDescendantsOfClassType(7).toArray(new PortModel[0]));
        }
        this._obsMgr.setActive(true);
        this._obsMgr.setPassing(true);
    }

    protected void addPorts() {
        ArrayList arrayList = new ArrayList();
        if (this.moduleM.supportSfpPort()) {
            this.addPpmPorts();
        } else {
            this.addMrPorts(arrayList);
        }
        if (this.moduleM.getEqType() != 293) {
            this.addTrunkPorts(arrayList);
        }
        this.portGraphics = arrayList.toArray(new OpticalPortGraphic[0]);
        if (this.alarmStore != null) {
            this.update(this.alarmStore.getAlarmStatusObservable(), this.alarmStore.getAlarmStatus());
        }
    }

    protected void addPpmPorts() {
        PluggableSlotModel[] pluggableSlotModelArray = this.moduleM.getPpmSlots();
        boolean bl = pluggableSlotModelArray.length > 5;
        this.ppmSlots = new PpmSlot[pluggableSlotModelArray.length];
        for (int i = 0; i < pluggableSlotModelArray.length; ++i) {
            this.ppmSlots[i] = new DwdmPpmSlot(pluggableSlotModelArray[i], this.parent, this.db, this.getPpmBounds(i, bl));
        }
    }

    protected void addMrPorts(List list) {
        if (this.mrSlot == null) {
            if (this.db.on()) {
                this.db.println("Cannot find MR_SLOT");
            }
            return;
        }
        List list2 = this.mrSlot.getDescendantsOfClassType(7);
        OpticalPortGraphic[] opticalPortGraphicArray = new OpticalPortGraphic[list2.size()];
        for (int i = 0; i < list2.size(); ++i) {
            PortModel portModel = (PortModel)list2.get(i);
            opticalPortGraphicArray[i] = new DwdmPortGraphic(this, this.cardPainter.getPortX(1, i), this.cardPainter.getPortY(1, i), portModel);
        }
        list.addAll(Arrays.asList(opticalPortGraphicArray));
        this.ports.addAll(list2);
        this.db.info("Added " + list2.size() + " multirate port(s)");
    }

    protected void addTrunkPorts(List list) {
        List list2 = this.moduleM.getDescendantsOfEqType(123);
        OpticalPortGraphic[] opticalPortGraphicArray = new OpticalPortGraphic[list2.size()];
        int n = this.getTrunkOffset();
        this.db.info("Trunk ports offset by " + n + " client ports");
        int n2 = 0;
        while (n2 < list2.size()) {
            PortModel portModel = (PortModel)list2.get(n2);
            opticalPortGraphicArray[n2] = new DwdmPortGraphic(this, this.cardPainter.getPortX(1, n), this.cardPainter.getPortY(1, n), portModel);
            ++n2;
            ++n;
        }
        list.addAll(Arrays.asList(opticalPortGraphicArray));
        this.ports.addAll(list2);
        this.db.info("Added " + list2.size() + " Trunk port(s)");
    }

    protected int getTrunkOffset() {
        int n = this.moduleM.supportSfpPort() ? this.ppmSlots.length : (this.mrSlot != null ? this.mrSlot.getMaxPorts() : 0);
        return n > 5 ? n / 2 + n % 2 : n;
    }

    public String getTooltipText(MouseEvent mouseEvent) {
        try {
            int n;
            for (n = 0; n < this.portGraphics.length; ++n) {
                if (!this.portGraphics[n].contains(mouseEvent.getPoint())) continue;
                return this.portGraphics[n].getTooltipText();
            }
            for (n = 0; n < this.ppmSlots.length; ++n) {
                if (!this.ppmSlots[n].contains(mouseEvent.getPoint())) continue;
                return this.ppmSlots[n].getTooltipText(mouseEvent);
            }
            return super.getTooltipText(mouseEvent);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return "";
        }
    }

    protected String getStateString() {
        if (this.eqState == null) {
            return "";
        }
        return ElementDefaults.eqStateToOCNString(this.eqState);
    }

    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (object instanceof AlarmStatus) {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                PortModel portModel = this.ports.get(i);
                IAlarmStatus iAlarmStatus = this.alarmStore.getEntityAlarmStatus(portModel);
                if (iAlarmStatus == null) continue;
                if (this.db.on()) {
                    int n = this.entityM.getSlot();
                    this.db.println("SlotNo=" + n + ", PortNo=" + portModel.getPort() + ", portEqType=" + portModel.getEqType() + ", AlarmStatus=" + iAlarmStatus + ", highest=" + iAlarmStatus.getHighestSeverity());
                }
                this.portGraphics[i].setAlarmState(iAlarmStatus.getHighestSeverity());
            }
        } else if (observable instanceof EntityModel && this.entityM != null && this.entityM.getNodeModel().isInited() && object instanceof Integer) {
            Integer n = (Integer)object;
            this.db.info("update(): DwdmCard, From=" + observable + ", arg=" + n);
            if (n.equals(ModelUpdateType.ADDED) && observable == this.mrSlot) {
                SwingUtilities.invokeLater(new ReplacePort());
                if (this.db.on()) {
                    this.db.println("Port ADDED to MR_SLOT");
                }
            } else if (n.equals(ModelUpdateType.DELETED)) {
                SwingUtilities.invokeLater(new ReplacePort());
                if (this.db.on()) {
                    this.db.println("Port DELETED");
                }
            }
        }
    }

    public void dispose() {
        this.localDispose();
        super.dispose();
    }

    protected void localDispose() {
        int n;
        if (this._obsMgr != null) {
            this._obsMgr.reset();
        }
        for (n = 0; n < this.ppmSlots.length; ++n) {
            if (this.ppmSlots[n] == null) continue;
            this.ppmSlots[n].dispose();
        }
        this.ppmSlots = new PpmSlot[0];
        for (n = 0; n < this.portGraphics.length; ++n) {
            if (this.portGraphics[n] == null) continue;
            this.portGraphics[n].dispose();
        }
        this.portGraphics = new OpticalPortGraphic[0];
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintIcon(component, graphics2D, n, n2);
        if (this.mrSlot != null && this.mrSlot.getDescendantsOfClassType(7).size() < this.mrSlot.getMaxPorts()) {
            this.drawPortSlot(graphics2D);
        }
        for (int i = 0; i < this.portGraphics.length; ++i) {
            this.portGraphics[i].draw(graphics2D);
        }
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.black);
        for (int i = 0; i < this.ppmSlots.length; ++i) {
            this.ppmSlots[i].draw(graphics2D);
        }
        graphics2D.setColor(color);
    }

    private void drawPortSlot(Graphics2D graphics2D) {
        Rectangle rectangle = new Rectangle(this.cardPainter.getPortX(1, 0), this.cardPainter.getPortY(1, 0), this.cardPainter.getPortWidth(), this.cardPainter.getSmallPortHeight());
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.lightGray);
        graphics2D.fill(rectangle);
        graphics2D.setColor(Color.black);
        graphics2D.draw(rectangle);
        graphics2D.setColor(color);
    }

    protected int getMiniPortX(int n) {
        int n2 = this.cardPainter.getMultiPortOpticonXOffset() - 6;
        int n3 = this.cardPainter.getMiniOpticonXSpacing();
        return n2 + n3 * n + n % 2 * 12;
    }

    protected int getMiniPortY(int n) {
        int n2 = this.cardPainter.getMiniOpticonYOffset() + 10;
        int n3 = this.cardPainter.getMiniOpticonYSpacing() - 7;
        return n2 + n3 * 2 * (n / 2);
    }

    protected Rectangle getPpmBounds(int n, boolean bl) {
        int n2 = this.cardPainter.getMiniPortWidth();
        int n3 = this.cardPainter.getMiniPortHeight();
        if (bl) {
            return new Rectangle(this.getMiniPortX(n), this.getMiniPortY(n), n2, n3);
        }
        return new Rectangle(this.cardPainter.getPortX(1, n), this.cardPainter.getPortY(1, n), n2, n3);
    }

    protected String getExtraInfo() {
        if (this.entityM instanceof DwdmModuleModel) {
            String string = ((DwdmModuleModel)this.entityM).getWavelengthAsString();
            if (string != null && string.length() > 0) {
                return "WL: " + string + " nm";
            }
            if (string == null) {
                string = "First Tunable Wavelength";
                return "WL: " + string;
            }
        }
        return "";
    }

    protected String getModeLabel() {
        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.entityM;
        eCardOperMode eCardOperMode2 = dwdmModuleModel.getCardOperMode();
        if (eCardOperMode2 != eCardOperMode.OPER_MODE_UNDEFINED) {
            Attribute attribute = ElementDefaults.getAttributeMap(dwdmModuleModel).getAttributeForVal(this.getCardModeString(), dwdmModuleModel.getCardOperMode().value());
            return attribute == null ? "" : " (" + attribute.getKey() + ")";
        }
        return "";
    }

    protected String getCardModeString() {
        return this.moduleM.isMxpMr25G() ? "mxpMr25GCardMode" : "mxpMr10DMECardMode";
    }

    private static class DwdmPpmSlot
    extends PpmSlot {
        public DwdmPpmSlot(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug, Rectangle rectangle) {
            super(entityModel, abstractShelfLayout, sDebug, rectangle);
        }

        protected PpmCard createPpmCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug, Rectangle rectangle) {
            return new DwdmPpmCard(entityModel, abstractShelfLayout, sDebug, rectangle);
        }
    }

    private static class DwdmPpmCard
    extends PpmCard {
        public DwdmPpmCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug, Rectangle rectangle) {
            super(entityModel, abstractShelfLayout, sDebug, rectangle);
        }

        protected OpticalPortGraphic createPortGraphic(int n, int n2, PortModel portModel) {
            return new DwdmPortGraphic(this, n, n2, portModel);
        }

        protected OpticalPortGraphic createPortGraphic(int n, int n2, int n3, int n4, PortModel portModel) {
            return new DwdmPortGraphic(this, n, n2, n3, n4, portModel);
        }
    }

    private class ReplacePort
    implements Runnable {
        private ReplacePort() {
        }

        public void run() {
            block4: {
                try {
                    DwdmCard.this.localDispose();
                    if (DwdmCard.this.moduleM != null) {
                        DwdmCard.this.addPorts();
                        DwdmCard.this.registerForLocalUpdates();
                    }
                }
                catch (Exception exception) {
                    if (!DwdmCard.this.db.on()) break block4;
                    DwdmCard.this.db.println("Error replacing port: " + exception);
                    SDebug cfr_ignored_0 = DwdmCard.this.db;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (DwdmCard.this.parent != null) {
                DwdmCard.this.parent.repaint();
            }
        }
    }
}

