/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Common.sIpFtpHost;
import cerent.cms.model.CmsNodeUpgradingException;
import cerent.cms.model.FtpHostAlreadyExistsException;
import cerent.cms.model.FtpHostsModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.MaxFtpHostsException;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.shelf.FtpHostTableModel;
import cerent.cms.ui.shelf.FtpHostsDialog;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class FtpHostPane
extends NodeProvPane
implements TableModelListener,
ListSelectionListener {
    protected INodeModel node;
    protected FtpHostsModel ftpModelObj = null;
    protected FtpHostTableModel tableModelObj = null;
    private JButton createButton;
    private JButton deleteButton;
    private static final SDebug db = new SDebug("FtpHostPane");

    public FtpHostPane(String string, CSHelpID cSHelpID, TabbedView tabbedView, FtpHostsModel ftpHostsModel) {
        super(string, tabbedView);
        this.node = tabbedView.getUiModel().getNodeModel();
        Object var5_5 = null;
        this.ftpModelObj = ftpHostsModel;
        this.ftpModelObj.addObserver((Observer)((Object)this));
        this.tableModelObj = this.getDataModel();
        this.tableModelObj.addTableModelListener(this);
        this.table = new UTable((TableModel)this.tableModelObj);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(180);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(180);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(180);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(180);
        this.table.getSelectionModel().addListSelectionListener(this);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        uScrollPane.setPreferredSize(new Dimension(200, 150));
        this.add((Component)uScrollPane);
        JPanel jPanel = this.addButtonPanelOnSouth();
        this.add(jPanel, "South");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FtpHostPane.this.createFtpHost();
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FtpHostPane.this.deleteFtpHost();
            }
        });
        this.registerWithModel();
    }

    protected JPanel addButtonPanelOnSouth() {
        JPanel jPanel = FtpHostPane.createHorizontalPanel(null);
        Dimension dimension = new Dimension(90, 25);
        this.createButton = new JButton("Create...");
        this.createButton.setMinimumSize(dimension);
        this.createButton.setMaximumSize(dimension);
        this.deleteButton = new JButton("Delete...");
        this.deleteButton.setMinimumSize(dimension);
        this.manageButtons();
        jPanel.add(this.createButton);
        jPanel.add(this.deleteButton);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add(jPanel);
        return jPanel2;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = 0;
        int n2 = this.tableModelObj.getRowCount() - 1;
        if (n != -1) {
            n = tableModelEvent.getFirstRow() < 0 ? 0 : tableModelEvent.getFirstRow();
            n2 = tableModelEvent.getLastRow() > this.tableModelObj.getRowCount() ? this.tableModelObj.getRowCount() - 1 : tableModelEvent.getLastRow();
        }
        db.info("tableChanged: first/last row are " + n + "/" + n2);
        for (int i = n; i <= n2; ++i) {
            if (!this.tableModelObj.isRowDirty(i)) continue;
            db.info(" rows are dirty");
            this.setDirty();
            return;
        }
        db.info("No rows are dirty");
        this.resetDirty();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.manageButtons();
    }

    protected FtpHostTableModel getDataModel() {
        INodeModel iNodeModel = this.uiModel.getNodeModel();
        return new FtpHostTableModel(iNodeModel, this.ftpModelObj);
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.FtpHostPane;
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void refreshFromModel() {
        this.tableModelObj.refreshFromModel();
        this.resetDirty();
    }

    protected void refreshMyLines(Object object) {
        this.tableModelObj.refreshMyLines(this.ftpModelObj);
    }

    private void manageButtons() {
        SecurityLevel securityLevel = SecurityLevel.SUPERUSER;
        this.createButton.setEnabled(this.isUserAuthorized(securityLevel));
        this.deleteButton.setEnabled(this.isUserAuthorized(securityLevel) && this.isSelected());
    }

    private void createFtpHost() {
        block5: {
            FtpHostsDialog ftpHostsDialog = FtpHostsDialog.instance(this);
            ftpHostsDialog.show();
            if (ftpHostsDialog.ok()) {
                try {
                    this.ftpModelObj.addFtpHost(ftpHostsDialog.getFtpHost());
                }
                catch (FtpHostAlreadyExistsException ftpHostAlreadyExistsException) {
                    ErrorMsg.displayDetailed((Component)((Object)ftpHostsDialog), EMC.EID_PROVISION_ERROR, "Failed to add the new FTP host:\nEither the FTP host already exists or there is overlapping subnet level provisioning.");
                }
                catch (MaxFtpHostsException maxFtpHostsException) {
                    ErrorMsg.displayDetailed((Component)((Object)ftpHostsDialog), EMC.EID_PROVISION_ERROR, "Failed to add the new FTP host:\n  No more FTP hosts can be added.");
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    if (!(exception instanceof CmsNodeUpgradingException)) break block5;
                    ErrorMsg.displayDetailed((Component)((Object)this), CEMC.EID_NODE_UPGRADING_EXCEPTION, exception);
                }
            }
        }
    }

    private void deleteFtpHost() {
        sIpFtpHost[] sIpFtpHostArray = this.getSelected();
        if (sIpFtpHostArray != null && sIpFtpHostArray.length > 0 && CerentDialog.yesNoDialog((Component)((Object)this), (String)"Are you sure you want to delete the selected FTP host?", (String)"Confirmation Dialog")) {
            for (int i = 0; i < sIpFtpHostArray.length; ++i) {
                this.ftpModelObj.deleteFtpHost(sIpFtpHostArray[i]);
            }
        }
    }

    private boolean validateFields(sIpFtpHost sIpFtpHost2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (sIpFtpHost2.relayTimer > 60 || sIpFtpHost2.relayTimer < 0) {
            stringBuffer.append("The valid value for FTP Relay Timer is from 0 to 60.");
        }
        if (stringBuffer.length() > 0) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CANNOT_VALIDATE_DATA_PARAM_1, (Object)stringBuffer.toString());
        }
        return stringBuffer.length() == 0;
    }

    private void updateFtpHost() {
        sIpFtpHost[] sIpFtpHostArray = this.getDirtyRows();
        if (sIpFtpHostArray != null && sIpFtpHostArray.length > 0) {
            for (int i = 0; i < sIpFtpHostArray.length; ++i) {
                if (!this.validateFields(sIpFtpHostArray[i])) continue;
                this.ftpModelObj.updateFtpHost(sIpFtpHostArray[i]);
            }
        }
    }

    boolean isSelected() {
        return this.table.getSelectedRowCount() > 0;
    }

    sIpFtpHost[] getSelected() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray != null && nArray.length > 0) {
            sIpFtpHost[] sIpFtpHostArray = new sIpFtpHost[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                sIpFtpHostArray[i] = this.tableModelObj.getRowInfo(nArray[i]);
            }
            return sIpFtpHostArray;
        }
        return null;
    }

    sIpFtpHost[] getDirtyRows() {
        int n = this.tableModelObj.getRowCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.tableModelObj.isRowDirty(i)) continue;
            ++n2;
        }
        sIpFtpHost[] sIpFtpHostArray = new sIpFtpHost[n2];
        n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.tableModelObj.isRowDirty(i)) continue;
            sIpFtpHostArray[n2] = this.tableModelObj.getRowInfo(i);
            ++n2;
        }
        return sIpFtpHostArray;
    }

    public void update(Observable observable, Object object) {
        this.requestRefresh(observable, null);
        this.manageButtons();
    }

    public void applyChangesToModel() throws Exception {
        this.updateFtpHost();
    }
}

