/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.ObserverPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.shelf.AbstractShelfMaintenancePane;
import cerent.cms.ui.shelf.MaintViewAllFacilitiesColumnRenderer;
import cerent.cms.ui.shelf.MaintViewAllFacilitiesDataSource;
import cerent.cms.ui.shelf.MaintViewCachedFacility;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.WindowHelper;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableModel;

public class MaintViewAllFacilitiesPane
extends ObserverPane
implements ActionListener,
Runnable {
    public static final SDebug db = new SDebug((KDebug)AbstractShelfMaintenancePane.db, "MaintViewAllFacilitiesPane");
    private NodeModelDelegate nodeModel;
    private boolean inited = false;
    private SortableRowTableModel model = null;
    private MaintViewAllFacilitiesDataSource dataSource = null;
    private ColumnRenderer[] colRenderers = null;
    private UScrollPane scrollPane;
    private JButton refreshButton;
    private JLabel refreshLabel;
    private String refreshLabelText = "";
    private JProgressBar refreshBar;
    public static final int REFRESH_STARTED = 0;
    public static final int REFRESH_COMPLETED = 100;
    private int refreshPercentage = 0;
    static String MARK_ON = "Mark";
    static String MARK_OFF = "Unmark";
    private JButton toggleButton;
    private Collection toggles = new HashSet();
    private static final String CTC = "ctc";
    private static final String MARKED_KEY = ".marked.";

    public MaintViewAllFacilitiesPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    public void enteringPage() throws Exception {
        if (!this.inited) {
            this.nodeModel = (NodeModelDelegate)this.getUiModel().getNodeModel();
            this.dataSource = new MaintViewAllFacilitiesDataSource(this, this.nodeModel);
            this.setDataSourceControl(this.dataSource);
            this.colRenderers = MaintViewAllFacilitiesColumnRenderer.createTableRenderers(this);
            this.model = new SortableRowTableModel((RowDataSource)this.dataSource, this.colRenderers);
            this.table = new MaintViewAllFacilitiesTable((TableModel)((Object)this.model));
            this.table.setSelectionMode(2);
            this.model.initTable(this.table);
            this.setLayout(new BorderLayout());
            this.scrollPane = new UScrollPane((Component)this.table);
            this.add((Component)this.scrollPane, "Center");
            this.initButtons();
            this.inited = true;
        }
        super.enteringPage();
        this.getMarkedPreferences();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    private void initButtons() {
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.MaintViewAllFacilitiesPane);
        this.toggleButton = new JButton(MARK_ON);
        WindowHelper.setEnabled((JComponent)this.toggleButton, (boolean)false);
        this.toggleButton.setSize(new Dimension(100, 22));
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.setSize(new Dimension(100, 22));
        this.refreshLabel = new JLabel(this.refreshLabelText);
        this.refreshBar = new JProgressBar(0, 100);
        cSHelpButtonPane.addLeft(this.toggleButton);
        cSHelpButtonPane.addLeft(this.refreshButton);
        cSHelpButtonPane.addLeft(this.refreshLabel);
        cSHelpButtonPane.addLeft(this.refreshBar);
        this.refreshBar.setVisible(false);
        this.add(cSHelpButtonPane, "South");
        this.toggleButton.addActionListener(this);
        this.refreshButton.addActionListener(this);
    }

    private String getParsedClassName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        return string.substring(n + 1);
    }

    private String getMarkedPreferenceKey() {
        StringBuffer stringBuffer = new StringBuffer(this.getParsedClassName() + MARKED_KEY);
        if (this.nodeModel != null) {
            String string = String.valueOf(this.nodeModel.getNodeId());
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String createMarkedPreferences() {
        StringBuffer stringBuffer = new StringBuffer("");
        for (Object e : this.toggles) {
            boolean bl;
            block5: {
                bl = false;
                try {
                    for (int i = 0; i < this.table.getRowCount(); ++i) {
                        Object object = this.table.getValueAt(i, 0);
                        if (!(object instanceof MaintViewCachedFacility)) continue;
                        MaintViewCachedFacility maintViewCachedFacility = (MaintViewCachedFacility)object;
                        if (!e.equals(maintViewCachedFacility.ifModel)) continue;
                        bl = true;
                        break;
                    }
                }
                catch (Exception exception) {
                    if (!db.isFinerEnabled()) break block5;
                    db.finer(exception.getMessage());
                }
            }
            if (bl) {
                stringBuffer.append(e.toString());
                stringBuffer.append("\n");
                continue;
            }
            if (!db.on()) continue;
            db.println("Not Adding " + e.toString() + " to prefs.");
        }
        return stringBuffer.toString();
    }

    private void getMarkedPreferences() {
        String string = Preferences.instance().getProperty(CTC, this.getMarkedPreferenceKey(), "");
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                Object object = this.table.getValueAt(i, 0);
                if (!(object instanceof MaintViewCachedFacility)) continue;
                MaintViewCachedFacility maintViewCachedFacility = (MaintViewCachedFacility)object;
                if (!maintViewCachedFacility.ifModel.toString().equals(string2)) continue;
                this.toggles.add(maintViewCachedFacility.ifModel);
            }
        }
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        Preferences.instance().setProperty(CTC, this.getMarkedPreferenceKey(), this.createMarkedPreferences());
        super.leavingPage();
    }

    public void dispose() {
        if (this.dataSource != null) {
            this.dataSource.disposeDataSource();
        }
        if (this.model != null) {
            this.model.release();
        }
        if (this.toggles != null) {
            this.toggles.clear();
        }
        super.dispose();
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        Preferences.instance().setProperty(CTC, this.getMarkedPreferenceKey(), this.createMarkedPreferences());
        super.destroy();
    }

    public boolean isToggled(Object object) {
        if (this.toggles == null) {
            return false;
        }
        return this.toggles.contains(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.toggleButton) {
            if (this.table.getSelectedRowCount() > 0) {
                boolean bl = MARK_OFF.equals(this.toggleButton.getText());
                int[] nArray = this.table.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    Object object = this.table.getValueAt(nArray[i], 0);
                    if (!(object instanceof MaintViewCachedFacility)) continue;
                    MaintViewCachedFacility maintViewCachedFacility = (MaintViewCachedFacility)object;
                    if (bl) {
                        this.toggles.remove(maintViewCachedFacility.ifModel);
                        continue;
                    }
                    this.toggles.add(maintViewCachedFacility.ifModel);
                }
                if (bl) {
                    this.toggleButton.setText(MARK_ON);
                } else {
                    this.toggleButton.setText(MARK_OFF);
                }
                this.dataSource.liteRefresh();
            }
        } else if (actionEvent.getSource() == this.refreshButton && this.dataSource != null) {
            this.dataSource.refreshFromModel();
        }
    }

    public void run() {
        this.refreshLabel.setText(this.refreshLabelText);
        if (this.refreshPercentage == 0) {
            this.refreshBar.setVisible(true);
        } else if (this.refreshPercentage == 100) {
            this.refreshBar.setVisible(false);
        } else {
            if (!this.refreshBar.isVisible()) {
                this.refreshBar.setVisible(true);
            }
            this.refreshBar.setValue(this.refreshPercentage);
            if (this.refreshPercentage % 15 == 0) {
                this.table.repaint(this.table.getBounds());
            }
        }
        WindowHelper.setEnabled((JComponent)this.refreshButton, (this.refreshPercentage == 100 ? 1 : 0) != 0);
    }

    public void updateRefreshLabel(int n) {
        this.refreshPercentage = n;
        this.refreshLabelText = this.refreshPercentage != 100 ? "Refreshing..." : "Refreshed: " + MaintViewAllFacilitiesPane.getFormattedDateTime(new Date());
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    public void refresh() {
        this.updateRefreshLabel(100);
        super.refresh();
    }

    class MaintViewAllFacilitiesTable
    extends UTable {
        public MaintViewAllFacilitiesTable(TableModel tableModel) {
            super(tableModel);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            super.valueChanged(listSelectionEvent);
            if (MaintViewAllFacilitiesPane.this.toggleButton != null) {
                boolean bl = false;
                if (this.getSelectedRowCount() > 0 && MaintViewAllFacilitiesPane.this.refreshPercentage == 100) {
                    int[] nArray = this.getSelectedRows();
                    int n = 0;
                    int n2 = 0;
                    for (int i = 0; i < nArray.length; ++i) {
                        Object object = this.getValueAt(nArray[i], 0);
                        MaintViewCachedFacility maintViewCachedFacility = (MaintViewCachedFacility)object;
                        if (MaintViewAllFacilitiesPane.this.isToggled(maintViewCachedFacility.ifModel)) {
                            ++n;
                            continue;
                        }
                        ++n2;
                    }
                    if (n > 0 && n2 == 0) {
                        MaintViewAllFacilitiesPane.this.toggleButton.setText(MARK_OFF);
                        bl = true;
                    } else if (n2 > 0 && n == 0) {
                        MaintViewAllFacilitiesPane.this.toggleButton.setText(MARK_ON);
                        bl = true;
                    }
                }
                WindowHelper.setEnabled((JComponent)MaintViewAllFacilitiesPane.this.toggleButton, (boolean)bl);
            }
        }
    }
}

