/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.OSI.sRouter;
import cerent.cms.model.CannotRemovePAA;
import cerent.cms.model.DuplicateAreaAddress;
import cerent.cms.model.IModel;
import cerent.cms.model.MaxMAA;
import cerent.cms.model.NoSuchAreaAddress;
import cerent.cms.model.NoSuchRouter;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.Pane;
import cerent.cms.ui.shelf.OsiRouterEditPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class OsiRouterEditDialog
extends UDialog
implements ActionListener {
    public static final String TITLE = "OSI Router Editor";
    private JButton okButton;
    private JButton cancelButton;
    OsiRouterEditPane attributesPane;
    static Object model;

    public static OsiRouterEditDialog instance(Pane pane) {
        Frame frame = JOptionPane.getFrameForComponent((Component)pane);
        model = pane.getUiModel();
        return new OsiRouterEditDialog(frame, model);
    }

    private OsiRouterEditDialog(Frame frame, Object object) {
        super(frame, TITLE, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        jPanel.add((Component)this.createAttributesPanel(object), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    public void setSelectedRouter(sRouter sRouter2) {
        this.attributesPane.setSelectedRouter(sRouter2);
    }

    public void dispose() {
        if (this.attributesPane != null) {
            this.attributesPane.destroy();
            this.attributesPane = null;
        }
        super.dispose();
        model = null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            try {
                this.onValidate();
                this.apply();
                this.dispose();
            }
            catch (NoSuchRouter noSuchRouter) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ROUTER_NO_EXIST);
            }
            catch (MaxMAA maxMAA) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_MAA_MAX);
            }
            catch (CannotRemovePAA cannotRemovePAA) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_MAA_CAN_NOT_REMOVE_PAA);
            }
            catch (NoSuchAreaAddress noSuchAreaAddress) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_MAA_NO_SUCH_AREA_ADDR);
            }
            catch (DuplicateAreaAddress duplicateAreaAddress) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_MAA_DUPLICATED_AREA_ADDR);
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_CONFIG_PARAM_1, (Object)exception.getMessage());
                SDebug.printStackTrace((Throwable)exception);
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    protected void onValidate() throws Exception {
        this.attributesPane.onValidate();
    }

    protected void apply() throws Exception {
        this.attributesPane.applyChangesToModel();
    }

    private JPanel createAttributesPanel(Object object) {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)((IModel)object).getNodeModel();
        this.attributesPane = new OsiRouterEditPane(nodeModelDelegate);
        return this.attributesPane;
    }

    public JPanel getAttributesPanel() {
        return this.attributesPane;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }
}

