/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.OSI.eLinkType;
import cerent.cms.idl.OSI.sRouter;
import cerent.cms.idl.OSI.sSubnet;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IOsiConstants;
import cerent.cms.model.LapdTermModel;
import cerent.cms.model.OsiModel;
import cerent.cms.model.RouterModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SubnetModel;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfEditTablePane;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.cms.ui.shelf.OsiSubnetDialog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.WindowHelper;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;

public class OsiRouterSubnetPane
extends AbstractShelfEditTablePane
implements IOsiConstants {
    public static final int ROUTER_ID = 0;
    public static final int SLOT_PORT_ID = 1;
    public static final int SUBNET_TYPE_ID = 2;
    public static final int PROTOCOL_ID = 3;
    public static final int ESH_ID = 4;
    public static final int ISH_ID = 5;
    public static final int IIH_ID = 6;
    public static final int DISP_PRIO_ID = 7;
    public static final int METRIC_ID = 8;
    private OsiModel osiModel;
    private RouterModel routerModel;
    private SubnetModel subnetModel;
    private LapdTermModel lapdTermModel;
    private boolean hasLanSubnet;
    private static final SDebug db = new SDebug((KDebug)AbstractShelfProvPane.db, "OsiRouterSubnetPane");

    public OsiRouterSubnetPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
    }

    protected void localInit() {
        super.localInit();
        this.ENTRY_TYPE = "OSI SNPA";
    }

    protected JPanel getButtonBar() {
        this.createButton = this.makeActionButton("Enable LAN Subnet...");
        this.editButton = this.makeActionButton("Edit...");
        this.deleteButton = this.makeActionButton("Disable LAN Subnet...");
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(this.getHelpID());
        cSHelpButtonPane.addLeft(this.createButton);
        cSHelpButtonPane.addLeft(this.editButton);
        cSHelpButtonPane.addLeft(this.deleteButton);
        return cSHelpButtonPane;
    }

    protected void initModels() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[]{new RouterColumnRenderer(), new SlotPortColumnRenderer(), new SubnetTypeColumnRenderer(), new ProtocolColumnRenderer(), new ESHColumnRenderer(), new ISHColumnRenderer(), new IIHColumnRenderer(), new DispPrioColumnRenderer(), new MetricColumnRenderer()};
        int[] nArray = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        this.routerModel = this.nodeModel.getRouterModel();
        this.subnetModel = this.nodeModel.getSubnetModel();
        this.lapdTermModel = this.nodeModel.getLapdModel();
        this.osiModel = this.nodeModel.getOsiModel();
        SubnetRowSource subnetRowSource = new SubnetRowSource();
        this.model = new SortableRowTableModel((RowDataSource)subnetRowSource, columnRendererArray, nArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.deleteButton) {
            if (this.hasLanSubnet()) {
                try {
                    int n = this.findLanSubnet();
                    this.deleteSelectedTableEntry(n);
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_DELETE_ERROR_PARAM_1, (Object)this.ENTRY_TYPE);
                }
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateTableData() {
        db.fine("populateTableData");
        List list = this.tableData;
        synchronized (list) {
            this.tableData = new ArrayList();
            this.hasLanSubnet = false;
            try {
                short s = 0;
                sRouter[] sRouterArray = this.routerModel.getRouterList();
                db.fine("populateTableData(): " + sRouterArray.length + " routers");
                for (int i = 0; i < sRouterArray.length; ++i) {
                    s = sRouterArray[i].routerNumber;
                    sSubnet[] sSubnetArray = this.subnetModel.getSubnetList(s);
                    db.fine("populateTableData(): router " + s + " subnets  " + sSubnetArray.length + " subnets");
                    for (int j = 0; j < sSubnetArray.length; ++j) {
                        this.tableData.add(sSubnetArray[j]);
                        if (!sSubnetArray[j].type.equals(eLinkType.LINK_TYPE_LAN)) continue;
                        this.hasLanSubnet = true;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                db.println("Error in getting subnets: " + exception);
            }
        }
    }

    public void destroy() {
        if (this.table != null) {
            this.table.removeMouseListener(this);
        }
        super.destroy();
    }

    private boolean hasLanSubnet() {
        return this.hasLanSubnet;
    }

    private int findLanSubnet() {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            sSubnet sSubnet2 = (sSubnet)this.model.getValueAt(i, 0);
            if (!sSubnet2.type.equals(eLinkType.LINK_TYPE_LAN)) continue;
            return i;
        }
        return -1;
    }

    public void setEditDeleteEnabled(boolean bl) {
        if (this.hasLanSubnet()) {
            WindowHelper.setEnabled((JComponent)this.createButton, (boolean)false);
            WindowHelper.setEnabled((JComponent)this.deleteButton, (boolean)this.isUserAuthorized());
        } else {
            try {
                if (this.osiModel.getRoutingMode() == 0 && this.subnetModel.getSubnetList((short)1).length > 0) {
                    WindowHelper.setEnabled((JComponent)this.createButton, (boolean)false);
                } else {
                    WindowHelper.setEnabled((JComponent)this.createButton, (boolean)this.isUserAuthorized());
                }
            }
            catch (Exception exception) {
                db.println("Error in getting subnets: " + exception);
            }
            WindowHelper.setEnabled((JComponent)this.deleteButton, (boolean)false);
        }
        if (this.model.getRowCount() > 0) {
            WindowHelper.setEnabled((JComponent)this.editButton, (bl && this.isUserAuthorized() ? 1 : 0) != 0);
        } else {
            WindowHelper.setEnabled((JComponent)this.editButton, (boolean)false);
        }
    }

    protected void createTableEntry() {
        db.fine("createTableEntry()");
        OsiSubnetDialog osiSubnetDialog = OsiSubnetDialog.instance(this, 0);
        osiSubnetDialog.show();
        osiSubnetDialog.dispose();
    }

    private void helpEditDeleteSelectedTableEntry(int n, int n2) {
        sSubnet sSubnet2 = (sSubnet)this.model.getValueAt(n, 0);
        if (sSubnet2 != null) {
            OsiSubnetDialog osiSubnetDialog = OsiSubnetDialog.instance(this, n2);
            osiSubnetDialog.setSelectedSubnet(sSubnet2);
            osiSubnetDialog.show();
            osiSubnetDialog.dispose();
        } else {
            JOptionPane.showMessageDialog(null, "Error", "No subnets were selected!", 0);
        }
    }

    protected void editSelectedTableEntry(int n) {
        this.helpEditDeleteSelectedTableEntry(n, 1);
    }

    protected void deleteSelectedTableEntry(int n) {
        this.helpEditDeleteSelectedTableEntry(n, 2);
    }

    protected void registerWithModels() {
        if (this.routerModel != null) {
            this.getObservableManager().addObservable((Observable)((Object)this.routerModel));
        }
        if (this.lapdTermModel != null) {
            this.getObservableManager().addObservable((Observable)((Object)this.lapdTermModel));
        }
        if (this.subnetModel != null) {
            this.getObservableManager().addObservable((Observable)((Object)this.subnetModel));
        }
    }

    protected void setDataSourceControl() {
        this.setDataSourceControl(new InnerDsc());
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.OsiRouterSubnetPane;
    }

    class MetricColumnRenderer
    extends BaseColumnRenderer {
        MetricColumnRenderer() {
        }

        public int getWidth() {
            return 50;
        }

        public String getName() {
            return "IS-IS Cost";
        }
    }

    class DispPrioColumnRenderer
    extends BaseColumnRenderer {
        DispPrioColumnRenderer() {
        }

        public int getWidth() {
            return 50;
        }

        public String getName() {
            return "DIS Priority";
        }
    }

    class IIHColumnRenderer
    extends BaseColumnRenderer {
        IIHColumnRenderer() {
        }

        public int getWidth() {
            return 50;
        }

        public String getName() {
            return "IIH (sec)";
        }
    }

    class ISHColumnRenderer
    extends BaseColumnRenderer {
        ISHColumnRenderer() {
        }

        public int getWidth() {
            return 50;
        }

        public String getName() {
            return "ISH (sec)";
        }
    }

    class ESHColumnRenderer
    extends BaseColumnRenderer {
        ESHColumnRenderer() {
        }

        public int getWidth() {
            return 50;
        }

        public String getName() {
            return "ESH (sec)";
        }
    }

    class ProtocolColumnRenderer
    extends BaseColumnRenderer {
        ProtocolColumnRenderer() {
        }

        public String getName() {
            return "Protocol";
        }
    }

    class SubnetTypeColumnRenderer
    extends BaseColumnRenderer {
        SubnetTypeColumnRenderer() {
        }

        public String getName() {
            return "Subnet Type";
        }
    }

    class SlotPortColumnRenderer
    extends EntityCellRenderer
    implements ColumnRenderer {
        public SlotPortColumnRenderer() {
            super("slot ");
        }

        public int getWidth() {
            return 100;
        }

        public boolean isResizable() {
            return true;
        }

        public int getAlignment() {
            return 2;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            sSubnet sSubnet2 = (sSubnet)jTable.getValueAt(n, 0);
            if (sSubnet2.type.equals(eLinkType.LINK_TYPE_LAN)) {
                object = "N/A";
            } else {
                try {
                    object = OsiRouterSubnetPane.this.nodeModel.getEntityTable().getEntityModelByIndex(sSubnet2.dccIndex);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    db.severe(abstractCmsNoSuchEntityException.toString());
                    object = "!ERROR!";
                }
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        public String getName() {
            return "Slot/Port";
        }

        public int compareColumn(Object object, Object object2, int n) {
            String string;
            IEntityModel iEntityModel;
            String string2;
            sSubnet sSubnet2 = (sSubnet)object;
            sSubnet sSubnet3 = (sSubnet)object2;
            if (sSubnet2.type.equals(eLinkType.LINK_TYPE_LAN)) {
                string2 = "N/A";
            } else {
                try {
                    iEntityModel = OsiRouterSubnetPane.this.nodeModel.getEntityTable().getEntityModelByIndex(sSubnet2.dccIndex);
                    string2 = this.getString(iEntityModel, "slot ");
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    db.severe(abstractCmsNoSuchEntityException.toString());
                    string2 = "!ERROR!";
                }
            }
            if (sSubnet3.type.equals(eLinkType.LINK_TYPE_LAN)) {
                string = "N/A";
            } else {
                try {
                    iEntityModel = OsiRouterSubnetPane.this.nodeModel.getEntityTable().getEntityModelByIndex(sSubnet3.dccIndex);
                    string = this.getString(iEntityModel, "slot ");
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    db.severe(abstractCmsNoSuchEntityException.toString());
                    string = "!ERROR!";
                }
            }
            return string2.compareTo(string);
        }
    }

    class RouterColumnRenderer
    extends BaseColumnRenderer {
        RouterColumnRenderer() {
        }

        public String getName() {
            return "Router #";
        }
    }

    abstract class BaseColumnRenderer
    extends EntityCellRenderer
    implements ColumnRenderer {
        BaseColumnRenderer() {
        }

        public int getWidth() {
            return 100;
        }

        public boolean isResizable() {
            return true;
        }

        public int getAlignment() {
            return 2;
        }

        protected String getStringValue(sSubnet sSubnet2, int n) {
            db.fine("getStringValue(): " + (sSubnet2 == null ? "null subnet" : "DCC=" + sSubnet2.dccIndex + "ISH=" + sSubnet2.ish + "ESH=" + sSubnet2.esh + "IIH=" + sSubnet2.iih + "DISPRIO=" + sSubnet2.disPrio + "METRIC" + sSubnet2.metric));
            String string = "??";
            switch (n) {
                case 0: {
                    Short s = new Short(sSubnet2.routerNumber);
                    string = s.toString();
                    break;
                }
                case 1: {
                    try {
                        EntityCellRenderer entityCellRenderer = new EntityCellRenderer("slot ");
                        if (sSubnet2.type.equals(eLinkType.LINK_TYPE_LAN)) {
                            string = "N/A";
                            break;
                        }
                        IEntityModel iEntityModel = OsiRouterSubnetPane.this.nodeModel.getEntityTable().getEntityModelByIndex(sSubnet2.dccIndex);
                        string = entityCellRenderer.getString(iEntityModel, "slot ");
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        db.severe(abstractCmsNoSuchEntityException.toString());
                        string = "!ERROR!";
                    }
                    break;
                }
                case 2: {
                    if (sSubnet2.type == eLinkType.LINK_TYPE_LAN) {
                        string = "LAN";
                        break;
                    }
                    if (sSubnet2.type == eLinkType.LINK_TYPE_SDCC) {
                        string = OsiRouterSubnetPane.this.nodeModel.getTDMTerminology().getGeneralTerms(8);
                        break;
                    }
                    if (sSubnet2.type == eLinkType.LINK_TYPE_LDCC) {
                        string = OsiRouterSubnetPane.this.nodeModel.getTDMTerminology().getGeneralTerms(10);
                        break;
                    }
                    if (sSubnet2.type == eLinkType.LINK_TYPE_GCC) {
                        string = "GCC";
                        break;
                    }
                    if (sSubnet2.type != eLinkType.LINK_TYPE_OSC) break;
                    string = "OSC";
                    break;
                }
                case 3: {
                    if (sSubnet2.type == eLinkType.LINK_TYPE_LAN) {
                        string = "802.3";
                        break;
                    }
                    if (OsiRouterSubnetPane.this.lapdTermModel.getLapdByIndex(sSubnet2.dccIndex) != null) {
                        string = "LAPD";
                        break;
                    }
                    string = "PPP";
                    break;
                }
                case 4: {
                    Short s = new Short(sSubnet2.esh);
                    string = s.toString();
                    break;
                }
                case 5: {
                    Short s = new Short(sSubnet2.ish);
                    string = s.toString();
                    break;
                }
                case 6: {
                    Short s = new Short(sSubnet2.iih);
                    string = s.toString();
                    break;
                }
                case 7: {
                    if (sSubnet2.type == eLinkType.LINK_TYPE_LAN) {
                        Short s = new Short(sSubnet2.disPrio);
                        string = s.toString();
                        break;
                    }
                    string = "N/A";
                    break;
                }
                case 8: {
                    Short s = new Short(sSubnet2.metric);
                    string = s.toString();
                    break;
                }
                default: {
                    db.severe("Unknown column " + n);
                    string = "!ERROR!";
                }
            }
            return string;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            sSubnet sSubnet2 = (sSubnet)jTable.getValueAt(n, 0);
            String string = this.getStringValue(sSubnet2, n2);
            return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
        }

        public int compareColumn(Object object, Object object2, int n) {
            String string = this.getStringValue((sSubnet)object, n);
            String string2 = this.getStringValue((sSubnet)object2, n);
            return string.compareTo(string2);
        }
    }

    class SubnetRowSource
    extends AbstractRowDataSource {
        SubnetRowSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getObjectAtRow(int n) {
            Object var2_2 = null;
            List list = OsiRouterSubnetPane.this.tableData;
            synchronized (list) {
                var2_2 = OsiRouterSubnetPane.this.tableData.get(n);
            }
            return var2_2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            int n = -1;
            List list = OsiRouterSubnetPane.this.tableData;
            synchronized (list) {
                n = OsiRouterSubnetPane.this.tableData.size();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection getAllObjects() {
            List list = OsiRouterSubnetPane.this.tableData;
            synchronized (list) {
                return OsiRouterSubnetPane.this.tableData;
            }
        }
    }

    public class InnerDsc
    extends AbstractRoDataSourceControl {
        boolean initedOM = false;

        private void initObservableManager() {
            OsiRouterSubnetPane.this.resetObservableManager();
            OsiRouterSubnetPane.this.registerWithModels();
            OsiRouterSubnetPane.this.setObservableManagerActive();
            this.initedOM = true;
            if (db.on()) {
                db.println("initObservabledManager() done");
            }
        }

        public void refreshFromModel() throws Exception {
            if (db.on()) {
                db.println("InnerDsc::refreshFromModel()");
            }
            if (!this.initedOM) {
                this.initObservableManager();
            } else if (db.on()) {
                db.println("did not call initObservableManager()");
            }
            OsiRouterSubnetPane.this.repopulateTable();
        }

        public IObservableManager getObservableManager() {
            if (this.dscObservableManager == null) {
                this.dscObservableManager = new ObservableManager((Observer)((Object)OsiRouterSubnetPane.this), true);
            }
            return this.dscObservableManager;
        }
    }
}

