/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IIpAddr;
import cerent.cms.model.IOspfVLink;
import cerent.cms.model.OspfLanConfig;
import cerent.cms.model.OspfLanConfigModel;
import cerent.cms.model.OspfVLink;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfEditTablePane;
import cerent.cms.ui.shelf.AuthKeyDialog;
import cerent.cms.ui.shelf.OspfPane;
import cerent.cms.ui.shelf.OspfVLinkCreateDialog;
import cerent.cms.ui.shelf.OspfVLinkEditDialog;
import cerent.cms.ui.shelf.SppNetworkPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.WindowHelper;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.table.AbstractTableModel;

public class OspfVLinkPane
extends AbstractShelfEditTablePane {
    public static final int NEIGHBOR = 0;
    public static final int TRANSIT_DELAY = 1;
    public static final int RETRANSIT_INTERVAL = 2;
    public static final int HELLO_INTERVAL = 3;
    public static final int DEAD_INTERVAL = 4;
    public static final int AUTHTYPE = 5;
    public static final int AUTHKEY = 6;
    private OspfLanConfigModel ospfLanConfigModel;
    private static final SDebug db = new SDebug((KDebug)SppNetworkPane.db, "OspfVLinkPane");

    public OspfVLinkPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
    }

    protected void initModels() {
        this.model = new OspfVLinkTableModel();
    }

    protected void populateTableData() {
        OspfVLink ospfVLink = (OspfVLink)this.ospfLanConfigModel.getOspfVLink();
        String string = InetUtil.makeDottedString(ospfVLink.getNeighbor(), false);
        if (!ospfVLink.hasEmptyNeighbor()) {
            this.tableData.add(ospfVLink);
        }
    }

    public void destroy() {
        if (this.ospfLanConfigModel == null) {
            this.ospfLanConfigModel.deleteObserver((Observer)((Object)this));
            this.ospfLanConfigModel = null;
        }
        super.destroy();
        this.nodeModel = null;
    }

    public void setEditDeleteEnabled(boolean bl) {
        OspfLanConfig ospfLanConfig;
        if (this.disableAllButtons) {
            WindowHelper.setEnabled((JComponent)this.createButton, (boolean)false);
            WindowHelper.setEnabled((JComponent)this.deleteButton, (boolean)false);
            WindowHelper.setEnabled((JComponent)this.editButton, (boolean)false);
            return;
        }
        boolean bl2 = false;
        if (this.ospfLanConfigModel != null && (ospfLanConfig = this.ospfLanConfigModel.getLanOspfConf()) != null) {
            bl2 = ospfLanConfig.getIfAdminStat();
        }
        WindowHelper.setEnabled((JComponent)this.createButton, (bl2 && this.isUserAuthorized() && this.tableData.isEmpty() ? 1 : 0) != 0);
        WindowHelper.setEnabled((JComponent)this.editButton, (bl2 && this.isUserAuthorized() && !this.tableData.isEmpty() && bl ? 1 : 0) != 0);
        WindowHelper.setEnabled((JComponent)this.deleteButton, (this.isUserAuthorized() && !this.tableData.isEmpty() && bl ? 1 : 0) != 0);
    }

    protected void createTableEntry() {
        if (this.nodeModel.isInited() && this.nodeModel.getConnectionState()) {
            IOspfVLink iOspfVLink = this.ospfLanConfigModel.getOspfVLink();
            OspfVLinkCreateDialog ospfVLinkCreateDialog = OspfVLinkCreateDialog.instance(this);
            ospfVLinkCreateDialog.setVLink(iOspfVLink);
            ospfVLinkCreateDialog.show();
            ospfVLinkCreateDialog.dispose();
        }
    }

    protected boolean authCheckSucceeded(IOspfVLink iOspfVLink) {
        boolean bl = false;
        if (this.isUserAuthorized(SecurityLevel.SUPERUSER)) {
            return true;
        }
        if (iOspfVLink.getAuthType() == 0) {
            return true;
        }
        String string = iOspfVLink.getAuthKey();
        if (string.equals("")) {
            return true;
        }
        JPasswordField jPasswordField = new JPasswordField();
        Object[] objectArray = new Object[]{"Enter Authentication Key", jPasswordField};
        String string2 = "OK";
        String string3 = "Cancel";
        Object[] objectArray2 = new Object[]{string2, string3};
        JOptionPane jOptionPane = new JOptionPane(objectArray, -1, 0, null, objectArray2, objectArray2[0]);
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        arrayList.add(jOptionPane);
        arrayList.add(jPasswordField);
        AuthKeyDialog authKeyDialog = AuthKeyDialog.instance((Component)((Object)this), true, "Authentication Key Entry", arrayList);
        try {
            authKeyDialog.show();
            if (jOptionPane.getValue().equals(string2)) {
                String string4 = new String(jPasswordField.getPassword());
                if (string4.equals(string)) {
                    bl = true;
                } else {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_AUTH_KEYS_DIFFER);
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_AUTH_ERROR);
        }
        return bl;
    }

    protected void deleteSelectedTableEntry(int n) {
        IOspfVLink iOspfVLink = ((OspfVLinkTableModel)this.model).getVLink(n);
        if (this.authCheckSucceeded(iOspfVLink)) {
            if (CerentDialog.yesNoDialog((Component)((Object)this), (String)"Are you sure you want to delete this Virtual Link?", (String)"Confirmation Dialog")) {
                this.setEditDeleteEnabled(false);
                if (this.ospfLanConfigModel != null) {
                    this.ospfLanConfigModel.deleteOspfVLink();
                } else if (db.on()) {
                    db.println("deleteSelectedVLink: ospfLanConfigModel is null");
                }
            }
        } else if (db.on()) {
            db.println("deleteSelectedVLink: failed auth check");
        }
    }

    protected void editSelectedTableEntry(int n) {
        IOspfVLink iOspfVLink = ((OspfVLinkTableModel)this.model).getVLink(n);
        if (this.authCheckSucceeded(iOspfVLink)) {
            OspfVLinkEditDialog ospfVLinkEditDialog = OspfVLinkEditDialog.instance(this);
            if (iOspfVLink != null) {
                ospfVLinkEditDialog.setVLink(iOspfVLink);
            }
            ospfVLinkEditDialog.show();
            ospfVLinkEditDialog.dispose();
        } else if (db.on()) {
            db.println("editSelectedVLink: failed auth check");
        }
    }

    protected void registerWithModels() {
        this.ospfLanConfigModel = (OspfLanConfigModel)this.nodeModel.getOspfLanConfigModel();
        if (this.ospfLanConfigModel != null) {
            this.getObservableManager().addObservable((Observable)((Object)this.ospfLanConfigModel));
        } else {
            db.println("could not register model; ospfLanConfigModel is null");
        }
    }

    protected void setDataSourceControl() {
        this.setDataSourceControl(new InnerDsc());
    }

    class OspfVLinkTableModel
    extends AbstractTableModel {
        final String[] columnNames = new String[]{"Neighbor", "Transmit Delay (sec)", "Retransmit Int (sec)", "Hello Int (sec)", "Dead Int (sec)", "Auth Type", "Auth Key"};

        public Class getColumnClass(int n) {
            return super.getColumnClass(n);
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            int n = OspfVLinkPane.this.tableData.size();
            return OspfVLinkPane.this.tableData.size();
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public IOspfVLink getVLink(int n) {
            OspfVLink ospfVLink = null;
            if (n < OspfVLinkPane.this.tableData.size()) {
                String string = (String)this.getValueAt(n, 0);
                String string2 = (String)this.getValueAt(n, 1);
                String string3 = (String)this.getValueAt(n, 2);
                String string4 = (String)this.getValueAt(n, 3);
                String string5 = (String)this.getValueAt(n, 4);
                String string6 = (String)this.getValueAt(n, 5);
                IOspfVLink iOspfVLink = (IOspfVLink)OspfVLinkPane.this.tableData.get(n);
                String string7 = iOspfVLink.getAuthKey();
                IIpAddr iIpAddr = InetUtil.makeIpAddr(string);
                Integer n2 = new Integer(string2);
                short s = n2.shortValue();
                Integer n3 = new Integer(string3);
                short s2 = n3.shortValue();
                Integer n4 = new Integer(string4);
                short s3 = n4.shortValue();
                Integer n5 = new Integer(string5);
                int n6 = n5;
                int n7 = -1;
                for (int i = 0; i < OspfPane.authChoices.length; ++i) {
                    if (!string6.equals(OspfPane.authChoices[i])) continue;
                    n7 = i;
                    break;
                }
                ospfVLink = new OspfVLink(iIpAddr, s, s2, s3, n6, n7, string7);
            }
            return ospfVLink;
        }

        public Object getValueAt(int n, int n2) {
            String string = "Test";
            if (n < OspfVLinkPane.this.tableData.size()) {
                IOspfVLink iOspfVLink = (IOspfVLink)OspfVLinkPane.this.tableData.get(n);
                switch (n2) {
                    case 0: {
                        string = InetUtil.makeDottedString(iOspfVLink.getNeighbor(), false);
                        break;
                    }
                    case 1: {
                        Integer n3 = new Integer(iOspfVLink.getTransitDelay());
                        string = n3.toString();
                        break;
                    }
                    case 2: {
                        Integer n4 = new Integer(iOspfVLink.getRetransitInterval());
                        string = n4.toString();
                        break;
                    }
                    case 3: {
                        Integer n5 = new Integer(iOspfVLink.getHelloInterval());
                        string = n5.toString();
                        break;
                    }
                    case 4: {
                        Integer n6 = new Integer(iOspfVLink.getDeadInterval());
                        string = n6.toString();
                        break;
                    }
                    case 5: {
                        int n7 = iOspfVLink.getAuthType();
                        if (n7 >= OspfPane.authChoices.length) {
                            string = "ERROR! Type = " + n7;
                            break;
                        }
                        string = OspfPane.authChoices[n7];
                        break;
                    }
                    case 6: {
                        String string2 = iOspfVLink.getAuthKey();
                        StringBuffer stringBuffer = new StringBuffer(string2.length());
                        for (int i = 0; i < string2.length(); ++i) {
                            stringBuffer.append("*");
                        }
                        string = stringBuffer.toString();
                    }
                }
            }
            return string;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    public class InnerDsc
    extends AbstractRoDataSourceControl {
        boolean initedOM = false;

        private void initObservableManager() {
            OspfVLinkPane.this.resetObservableManager();
            OspfVLinkPane.this.registerWithModels();
            OspfVLinkPane.this.setObservableManagerActive();
            this.initedOM = true;
            if (db.on()) {
                db.println("initObservabledManager() done");
            }
        }

        public void refreshFromModel() throws Exception {
            if (db.on()) {
                db.println("InnerDsc::refreshFromModel()");
            }
            if (!this.initedOM) {
                this.initObservableManager();
            } else if (db.on()) {
                db.println("did not call initObservableManager()");
            }
            OspfVLinkPane.this.repopulateTable();
        }

        public IObservableManager getObservableManager() {
            if (this.dscObservableManager == null) {
                this.dscObservableManager = new ObservableManager((Observer)((Object)OspfVLinkPane.this), true);
            }
            return this.dscObservableManager;
        }
    }
}

