/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.Busy;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.DwdmOpticalSetupModel;
import cerent.cms.model.EventUtilities;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.ISideModel;
import cerent.cms.model.MissingEquipment;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongParameterValue;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.DwdmSideRenderer;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ans.AnsPathDataSource;
import cerent.cms.ui.ans.AnsPathTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public class ProvSpPathPane
extends AbstractPane
implements ActionListener,
Runnable {
    private static final String LAUNCH = "Launch ANS";
    private static final String REFRESH = "Refresh";
    private static final String NODE = "node";
    private static final String SIDE_LABEL = "Side: ";
    public static final String ALL_SIDES = "All";
    public static final String NO_SIDE = "No side";
    static final SimpleDateFormat timeFmt = new SimpleDateFormat("MMMMM d,yyyy H:mm:ss a,z");
    private JComboBox sidesCB = new JComboBox();
    private JLabel sidesLabel = new JLabel("Side: ");
    private JButton launchButton = new JButton("Launch ANS");
    private JButton refreshButton = new JButton("Refresh");
    private JLabel label = new JLabel(" ");
    private String labelText;
    private AnsPathTableModel dataModel;
    private AnsPathDataSource dataSource;
    private EventUtilities eventutilities;
    private int[] sortCols = new int[]{0};
    private boolean[] sortDir = new boolean[]{true};
    private TabbedView parent;
    private NodeModelDelegate nodeModel;
    private DwdmOpticalSetupModel opticalSetupModel;
    private boolean initialized = false;
    private static final SDebug db = new SDebug("ProvSpPathPane");

    public ProvSpPathPane(String string, TabbedView tabbedView, DwdmOpticalSetupModel dwdmOpticalSetupModel) {
        super(string, tabbedView);
        this.parent = tabbedView;
        this.eventutilities = EventUtilities.getInstance((NodeModelDelegate)this.getUiModel().getNodeModel());
        this.opticalSetupModel = dwdmOpticalSetupModel;
    }

    private void init() {
        if (db.on()) {
            db.println("Initialization has begun.");
        }
        this.setLayout(new BorderLayout());
        this.nodeModel = (NodeModelDelegate)this.opticalSetupModel.getNodeModel();
        this.dataSource = new AnsPathDataSource(this.opticalSetupModel);
        this.dataModel = new AnsPathTableModel(this.dataSource, this.sortCols, this.sortDir);
        this.table = new UTable((TableModel)((Object)this.dataModel));
        ((AnsPathTableModel)((Object)this.table.getModel())).initTable(this.table);
        this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
        this.add(this.makeSidesPanel(), "North");
        this.add(this.makeControlPanel(), "South");
        this.add((Component)new UScrollPane((Component)this.table), "Center");
        if (db.on()) {
            db.println("Initialization has ended.");
        }
    }

    private JPanel makeControlPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
        this.launchButton.addActionListener(this);
        this.launchButton.setEnabled(false);
        this.refreshButton.addActionListener(this);
        this.refreshButton.setEnabled(true);
        jPanel2.add(this.launchButton);
        jPanel2.add(this.refreshButton);
        jPanel3.add(this.label);
        jPanel3.add(new CSHelpButton(CSHelpConst.ProvSpPathPane));
        this.enableComponent(this.launchButton, this.nodeModel, SecurityLevel.SUPERUSER);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.launchButton) {
            if (!CerentDialog.yesNoDialog((Component)this.parent, (String)"If there are circuits the operation could be traffic affecting.\nDo you want to continue?", (String)"Apply Launch ANS")) {
                return;
            }
            try {
                this.dataSource.startONS();
                CerentDialog.infoDialog((Component)((Object)this), (String)"ANS Completed", (String)LAUNCH);
            }
            catch (MissingEquipment missingEquipment) {
                SDebug.printStackTrace((Throwable)missingEquipment);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ERROR_EQPT_NOT_PLUG);
            }
            catch (FeatureUnsupported featureUnsupported) {
                SDebug.printStackTrace((Throwable)featureUnsupported);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CANNOT_PERFORM);
            }
            catch (Busy busy) {
                SDebug.printStackTrace((Throwable)busy);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ERROR_ANS_BUSY);
            }
            catch (CannotPerform cannotPerform) {
                SDebug.printStackTrace((Throwable)cannotPerform);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ERROR_ANS_CANT_PERF);
            }
            catch (WrongParameterValue wrongParameterValue) {
                SDebug.printStackTrace((Throwable)((Object)wrongParameterValue));
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ERROR_ANS_WRONG_PARAM, (Object)wrongParameterValue.getParamName());
            }
            finally {
                this.filterDataSource();
                this.refresh();
                this.updateLabel(NODE);
            }
        } else if (object == this.refreshButton) {
            try {
                this.refresh();
                this.updateLabel(NODE);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH_ANS);
            }
        } else if (object == this.sidesCB) {
            this.filterDataSource();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteringPage() throws Exception {
        if (db.on()) {
            db.println("Entering into page.");
        }
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if (this.dataSource == null) {
                if (db.on()) {
                    db.println("Data source needs to be initialized!");
                }
                this.init();
            }
            if (!this.initialized) {
                if (db.on()) {
                    db.println("This seems to be the very first time!");
                }
                this.updateLabel(NODE);
                this.initialized = true;
            }
            this.refresh();
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
    }

    private JPanel makeSidesPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.loadSides();
        this.sidesCB.addActionListener(this);
        this.sidesCB.setRenderer(new DwdmSideRenderer());
        jPanel.add(this.sidesLabel);
        jPanel.add(this.sidesCB);
        return jPanel;
    }

    private void loadSides() {
        if (db.on()) {
            db.println("Sides are being (re)loaded.");
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        ISideModel[] iSideModelArray = this.nodeModel.getSideModelsModel().getSides();
        for (int i = 0; i < iSideModelArray.length; ++i) {
            if (iSideModelArray[i].getId() == 0) continue;
            treeSet.add(iSideModelArray[i].getName());
        }
        if (treeSet.size() > 0) {
            if (db.on()) {
                db.println(treeSet.size() + " sides exist.");
            }
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(treeSet.toArray());
            defaultComboBoxModel.addElement(ALL_SIDES);
            this.sidesCB.setModel(defaultComboBoxModel);
            this.sidesCB.setEnabled(true);
            this.sidesLabel.setEnabled(true);
            this.sidesCB.setSelectedItem(ALL_SIDES);
        } else {
            if (db.on()) {
                db.println("No side available.");
            }
            String[] stringArray = new String[]{NO_SIDE};
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(stringArray);
            this.sidesCB.setModel(defaultComboBoxModel);
            this.sidesCB.setSelectedItem(NO_SIDE);
            this.sidesLabel.setEnabled(false);
            this.sidesCB.setEnabled(false);
        }
    }

    public void updateLabel(String string) {
        long l = this.eventutilities.convertSecondsToMilliSeconds(this.opticalSetupModel.getAnsLastTimeStamp());
        timeFmt.setTimeZone(this.nodeModel.getCtcTimeZone());
        Date date = new Date(l);
        timeFmt.format(date);
        String string2 = "Launched: Not Available from " + string;
        if (l != 0L) {
            string2 = "Launched: " + timeFmt.format(date) + " from " + string;
        }
        this.setLabel(string2);
    }

    public void clearLabel() {
        this.setLabel(" ");
    }

    private void setLabel(String string) {
        this.labelText = string;
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    public void run() {
        this.label.setText(this.labelText);
    }

    public void leavingPage() throws Exception {
        if (db.on()) {
            db.println("Leaving the page.");
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.initialized = false;
    }

    public void filterDataSource() {
        this.dataSource.getOpticalLinkList((String)this.sidesCB.getSelectedItem());
    }

    public void refresh() {
        if (db.on()) {
            db.println("A refresh has been invoked.");
        }
        this.dataSource.refresh();
        this.loadSides();
        if (db.on()) {
            db.println("A refresh has been done.");
        }
    }

    public void destroy() {
        if (db.on()) {
            db.println("The pane has been required to be destroyed.");
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
        if (this.dataSource != null) {
            this.dataSource.dispose();
            this.dataSource = null;
        }
    }
}

