/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SideInUse;
import cerent.cms.model.SideModels;
import cerent.cms.model.WrongNodeSide;
import cerent.cms.ui.DwdmSide;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UDialog;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.omg.CORBA.UserException;

public class SideEditDialog
extends UDialog
implements ActionListener {
    protected JButton okButton;
    protected JButton cancelButton;
    protected JComboBox sideIdCB;
    protected DefaultComboBoxModel sideIdComboModel;
    private NodeModelDelegate nm = null;
    private SortableRowTableModel dataModel = null;
    protected static final SDebug db = new SDebug("SideEditDialog");
    private static final String TITLE = "Edit Side ID";
    private static final String SIDE_ID = "Side ID:    ";
    private ISideModel oldSide = null;
    private SideModels smod;

    public static SideEditDialog instance(Frame frame, IModel iModel, int n, SortableRowTableModel sortableRowTableModel) {
        return new SideEditDialog(frame, iModel, n, sortableRowTableModel);
    }

    private SideEditDialog(Frame frame, IModel iModel, int n, SortableRowTableModel sortableRowTableModel) {
        super(frame, TITLE, true);
        if (SideEditDialog.db.on) {
            db.println(this.getClass().toString() + "::SideEditDialog constructor");
        }
        this.nm = (NodeModelDelegate)iModel.getNodeModel();
        this.smod = SideModels.getInstance(this.nm);
        this.dataModel = sortableRowTableModel;
        this.oldSide = (ISideModel)sortableRowTableModel.getValueAt(n, 0);
        this.initMainPane(frame);
        this.setVisible(true);
    }

    protected void initMainPane(Frame frame) {
        if (SideEditDialog.db.on) {
            db.println(this.getClass().toString() + "::initMainPane");
        }
        Container container = this.getContentPane();
        this.setSize(new Dimension(180, 130));
        container.setLayout(new BorderLayout());
        container.add((Component)this.getLocalPanel(), "North");
        container.add((Component)this.getButtonPanel(), "South");
    }

    protected JPanel getButtonPanel() {
        if (SideEditDialog.db.on) {
            db.println(this.getClass().toString() + "::getButtonPanel");
        }
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel2.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel2.add(this.cancelButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    protected JPanel getLocalPanel() {
        if (SideEditDialog.db.on) {
            db.println(this.getClass().toString() + "::getFieldPanel");
        }
        JPanel jPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(5);
        jPanel.setLayout(borderLayout);
        this.sideIdComboModel = new DefaultComboBoxModel<DwdmSide.SideEnum>(this.filterOutSideInUse().toArray(new DwdmSide.SideEnum[0]));
        this.sideIdCB = new JComboBox(this.sideIdComboModel);
        this.sideIdCB.setRenderer(new ComboBoxCellRenderer());
        jPanel.add((Component)new JPanel(), "North");
        jPanel.add((Component)new JLabel(SIDE_ID), "West");
        jPanel.add((Component)this.sideIdCB, "Center");
        return jPanel;
    }

    private ArrayList filterOutSideInUse() {
        ArrayList<DwdmSide.SideEnum> arrayList = new ArrayList<DwdmSide.SideEnum>(DwdmSide.getSideEnumList());
        ISideModel[] iSideModelArray = this.smod.getSides();
        for (int i = 0; i < iSideModelArray.length; ++i) {
            if (iSideModelArray[i].getId() == 0) continue;
            DwdmSide.SideEnum sideEnum = DwdmSide.getValue(iSideModelArray[i].getId());
            arrayList.remove(sideEnum);
        }
        return arrayList;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (SideEditDialog.db.on) {
            db.println(this.getClass().toString() + "::actionPerformed");
        }
        Object object = actionEvent.getSource();
        db.fine("actionPerformed from " + object);
        if (object == this.okButton) {
            this.ok();
        } else if (object == this.cancelButton) {
            this.dispose();
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected JButton makeActionButton(String string) {
        if (SideEditDialog.db.on) {
            db.println(this.getClass().toString() + "::makeActionButton");
        }
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    protected void ok() {
        if (SideEditDialog.db.on) {
            db.println(this.getClass().toString() + "::ok()");
        }
        DwdmSide.SideEnum sideEnum = (DwdmSide.SideEnum)this.sideIdCB.getSelectedItem();
        try {
            this.smod.editSide(this.oldSide.getId(), sideEnum.toInt(), this.oldSide.getLineIn());
            this.dispose();
        }
        catch (WrongNodeSide wrongNodeSide) {
            if (db.on()) {
                db.println("Editing of side " + this.oldSide.getId() + " failed\n" + wrongNodeSide.getMessage());
            }
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_WRONG_NODE_SIDE, (Object)("The side " + this.oldSide.getId() + " could not be edited.\n" + wrongNodeSide.getMessage()));
            return;
        }
        catch (SideInUse sideInUse) {
            if (db.on()) {
                db.println("The side (" + sideEnum.toString() + ") is already in use. \n" + sideInUse.getMessage());
            }
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_SIDE_CARRYING_TRAFFIC);
            return;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            CerentDialog.errorDialog((Component)((Object)this), (String)userException.getMessage(), (String)"Error");
        }
    }

    protected void initContentPane(JPanel jPanel, Object object) {
    }

    private class ComboBoxCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = "";
            if (object instanceof DwdmSide.SideEnum) {
                string = ((DwdmSide.SideEnum)object).toString();
            }
            this.setText(string);
            Color color = new Color(205, 205, 255);
            this.setBackground(bl ? color : Color.white);
            this.setForeground(Color.black);
            return this;
        }
    }
}

