/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.RadiusServerModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.cms.ui.shelf.RadiusServerInfoPane;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SppRadiusServerPane
extends NodeProvPane
implements ActionListener {
    protected static final SDebug db = new SDebug((KDebug)AbstractShelfProvPane.db, "SppRadiusRadiusPane");
    private boolean bInit;
    private JCheckBox authCB;
    private JCheckBox acctCB;
    private JCheckBox nodeAuthCB;
    private NodeModelDelegate nodeModel = (NodeModelDelegate)this.getUiModel().getNodeModel();
    private RadiusServerModel radiusServerModel = this.nodeModel.getRadiusServerModel();
    private RadiusServerInfoPane radiusInfoPane;

    public SppRadiusServerPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.radiusServerModel.addObserver((Observer)((Object)this));
        this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
    }

    public void destroy() {
        if (this.radiusServerModel != null) {
            this.radiusServerModel.deleteObserver((Observer)((Object)this));
        }
        super.destroy();
    }

    public boolean hasSubTabs() {
        return false;
    }

    public void applyChangesToModel() throws Exception {
        boolean bl = this.authCB.isSelected();
        if (this.radiusServerModel.getAAAServerAuthentication() != bl) {
            this.radiusServerModel.setAAAServerAuthentication(bl);
        }
        if (bl) {
            this.radiusServerModel.setAAAServerAccounting(this.acctCB.isSelected());
            this.radiusServerModel.setUseLocalDatabase(this.nodeAuthCB.isSelected());
        } else {
            this.radiusServerModel.setAAAServerAccounting(false);
        }
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshFromModel: start");
        }
        if (this.bInit) {
            if (this.radiusServerModel.getRadiusServerList().length == 0) {
                this.authCB.setEnabled(false);
            } else {
                this.authCB.setEnabled(true);
            }
            this.authCB.setSelected(this.radiusServerModel.getAAAServerAuthentication());
            this.acctCB.setSelected(this.radiusServerModel.getAAAServerAccounting());
            this.nodeAuthCB.setSelected(this.radiusServerModel.getUseLocalDatabase());
            this.toggleCB(this.authCB.isSelected());
        }
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update: start");
        }
        this.requestRefresh(this, null);
    }

    public void enteringPage() throws Exception {
        if (!this.bInit) {
            this.init();
        }
        this.radiusInfoPane.enteringPage();
        super.enteringPage();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SppRadiusServerPane;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.authCB) {
            this.toggleCB(this.authCB.isSelected());
        }
        this.setDirty();
    }

    private void toggleCB(boolean bl) {
        if (bl) {
            this.acctCB.setEnabled(true);
            this.nodeAuthCB.setEnabled(true);
        } else {
            this.acctCB.setSelected(false);
            this.acctCB.setEnabled(false);
            this.nodeAuthCB.setEnabled(false);
        }
    }

    private void init() {
        JPanel jPanel = SppRadiusServerPane.createVerticalPanel(null);
        this.add((Component)new UScrollPane((Component)jPanel));
        this.authCB = new JCheckBox("Enable RADIUS Authentication");
        jPanel.add(this.getCheckboxPane(this.authCB));
        this.acctCB = new JCheckBox("Enable RADIUS Accounting");
        jPanel.add(this.getCheckboxPane(this.acctCB));
        this.nodeAuthCB = new JCheckBox("Enable node as Final Authenticator when no RADIUS Server is reachable");
        jPanel.add(this.getCheckboxPane(this.nodeAuthCB));
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this.getRadiusInfoPane());
        jPanel.add(Box.createVerticalStrut(5));
        this.enableComponent(this.authCB);
        this.enableComponent(this.acctCB);
        this.enableComponent(this.nodeAuthCB);
        this.bInit = true;
    }

    private JPanel getCheckboxPane(JCheckBox jCheckBox) {
        jCheckBox.addActionListener(this);
        JPanel jPanel = SppRadiusServerPane.createVerticalPanel(null);
        JPanel jPanel2 = SppRadiusServerPane.createHorizontalPanel(null);
        if (jCheckBox != this.authCB) {
            jPanel2.add(new JLabel("     "));
            jPanel2.add(jCheckBox);
        } else {
            jPanel2.add(jCheckBox);
        }
        jPanel2.add(Box.createHorizontalGlue());
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JPanel getRadiusInfoPane() {
        JPanel jPanel = SppRadiusServerPane.createHorizontalPanel("RADIUS Servers in Order of Authentication");
        jPanel.setPreferredSize(new Dimension(300, 150));
        this.radiusInfoPane = new RadiusServerInfoPane("", this.getParentView(), this.nodeModel);
        jPanel.add((Component)((Object)this.radiusInfoPane));
        return jPanel;
    }
}

