/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.ISecurityModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.SecurityPolicyPanel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;

public class SppSecurityPolicyPane
extends NodeProvPane
implements PropertyChangeListener {
    private JPanel tab;
    private SecurityPolicyPanel securityPolicyPanel;
    private ISecurityModel securityModel;
    protected static final SDebug db = new SDebug((KDebug)AbstractShelfProvPane.db, "SppSecurityPolicyPane");

    public SppSecurityPolicyPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
        this.tab = SppSecurityPolicyPane.createVerticalPanel(null);
        this.add((Component)new UScrollPane((Component)this.tab));
    }

    public void destroy() {
        if (this.securityModel != null) {
            this.securityModel.deleteObserver((Observer)((Object)this));
            this.securityModel = null;
        }
        super.destroy();
    }

    public boolean hasSubTabs() {
        return false;
    }

    public void applyChangesToModel() throws Exception {
        if (db.on()) {
            db.println("applyChangesToModel: start");
        }
        this.securityModel.setSecurityPolicy(this.securityPolicyPanel.getSecurityPolicy());
        if (db.on()) {
            db.println("applyChangesToModel: end");
        }
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshFromModel: start");
        }
        this.securityPolicyPanel.setNodeModel((NodeModelDelegate)this.getUiModel().getNodeModel());
        this.securityPolicyPanel.setSecurityPolicy(this.securityModel.getSecurityPolicy());
        if (db.on()) {
            db.println("refreshFromModel: finish");
        }
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update: start");
        }
        this.requestRefresh(this, null);
    }

    public void enteringPage() throws Exception {
        if (this.securityPolicyPanel == null) {
            this.securityPolicyPanel = new SecurityPolicyPanel(this);
        }
        this.tab.add(this.securityPolicyPanel);
        this.securityModel = ((NodeModelDelegate)this.getUiModel().getNodeModel()).getSecurityModel();
        if (this.securityModel != null) {
            this.securityModel.addObserver((Observer)((Object)this));
        }
        super.enteringPage();
    }

    public void leavingPage() throws Exception {
        super.leavingPage();
        this.tab.remove(this.securityPolicyPanel);
        if (this.securityModel != null) {
            this.securityModel.deleteObserver((Observer)((Object)this));
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty(true);
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SppSecurityPolicyPane;
    }
}

