/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.ChassisModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.ShelfTabbedView;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SppVoltageTempPane
extends NodeProvPane {
    private JTextField nameTF;
    private static final SDebug db = new SDebug((KDebug)ShelfTabbedView.db, "SppVoltageTempTab");
    private static final String alphabets = "ABCDEF";
    private JLabel tempLbl;
    private JPanel[] voltagePnl = new JPanel[4];

    public SppVoltageTempPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    private void init() {
        db.info("init: start");
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel);
        this.add((Component)uScrollPane);
        jPanel.add(this.createVoltagePanel());
        jPanel.add(this.createTempPanel());
        this.registerWithModel();
        db.info("init: finish");
    }

    private JPanel createVoltagePanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
        jPanel.setBorder(BorderFactory.createTitledBorder("Voltage"));
        Dimension dimension = new Dimension(500, 120);
        jPanel.setPreferredSize(dimension);
        jPanel.setMinimumSize(dimension);
        ChassisModel chassisModel = (ChassisModel)this.getUiModel();
        Integer[] integerArray = null;
        if (chassisModel.isPowerMonitorSupported() && (chassisModel.getPlatform().is600() || chassisModel.getPlatform().is600SDH()) || chassisModel.getPlatform().is454() || chassisModel.getPlatform().is455()) {
            try {
                integerArray = chassisModel.getChassisVoltages();
            }
            catch (Exception exception) {
                db.println("Error in retrieving voltages");
            }
            if (integerArray != null) {
                for (int i = 0; i < integerArray.length - 1; ++i) {
                    this.voltagePnl[i] = new JPanel(new FlowLayout(0, 0, 0));
                    this.voltagePnl[i].add(new JLabel("Voltage " + alphabets.substring(i, i + 1) + ": " + integerArray[i] + "mV"));
                    this.voltagePnl[i].add(Box.createHorizontalStrut(700));
                    jPanel.add(this.voltagePnl[i]);
                }
                this.voltagePnl[integerArray.length - 1] = new JPanel(new FlowLayout(0, 0, 0));
                this.voltagePnl[integerArray.length - 1].add(new JLabel("Voltage " + alphabets.substring(integerArray.length - 1, integerArray.length) + ": " + integerArray[integerArray.length - 1] + "mV"));
                this.voltagePnl[integerArray.length - 1].add(Box.createHorizontalStrut(700));
                jPanel.add(this.voltagePnl[integerArray.length - 1]);
            } else {
                this.voltagePnl[0] = new JPanel(new FlowLayout(0, 0, 0));
                this.voltagePnl[0].add(new JLabel("Unable to retrieve chassis voltages."));
                jPanel.add(this.voltagePnl[0]);
            }
        } else {
            this.voltagePnl[0] = new JPanel(new FlowLayout(0, 0, 0));
            this.voltagePnl[0].add(new JLabel("Voltage monitoring not supported on this chassis."));
            jPanel.add(this.voltagePnl[0]);
        }
        return jPanel;
    }

    private JPanel createTempPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
        jPanel.setBorder(BorderFactory.createTitledBorder("Temperature"));
        ChassisModel chassisModel = (ChassisModel)this.getUiModel();
        Integer n = null;
        try {
            n = chassisModel.getChassisTemp();
        }
        catch (Exception exception) {
            db.println("Error in retrieving temperature");
        }
        if (n != null) {
            this.tempLbl = new JLabel("Chassis Temperature: " + n + '\u00b0' + "C");
            jPanel.add(this.tempLbl);
        } else {
            this.tempLbl = new JLabel("Unable to retrieve chassis temperature.");
            jPanel.add(this.tempLbl);
        }
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteringPage() throws Exception {
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if (this.nameTF == null) {
                this.init();
            }
            super.enteringPage();
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
    }

    public void refreshFromModel() throws Exception {
        ChassisModel chassisModel = (ChassisModel)this.getUiModel();
        Integer n = null;
        Integer[] integerArray = null;
        try {
            n = chassisModel.getChassisTemp();
        }
        catch (Exception exception) {
            db.println("Error in retrieving temperature");
        }
        this.tempLbl = n != null ? new JLabel("Chassis Temperature: " + n + '\u00b0' + "C") : new JLabel("Unable to retrieve chassis temperature.");
        if (chassisModel.isPowerMonitorSupported() && (chassisModel.getPlatform().is600() || chassisModel.getPlatform().is600SDH()) || chassisModel.getPlatform().is454() || chassisModel.getPlatform().is455()) {
            try {
                integerArray = chassisModel.getChassisVoltages();
            }
            catch (Exception exception) {
                db.println("Error in retrieving voltages");
            }
            if (integerArray != null) {
                for (int i = 0; i < integerArray.length - 1; ++i) {
                    this.voltagePnl[i].removeAll();
                    this.voltagePnl[i].add(new JLabel("Voltage " + alphabets.substring(i, i + 1) + ": " + integerArray[i] + "mV"));
                    this.voltagePnl[i].add(Box.createHorizontalStrut(700));
                }
                this.voltagePnl[integerArray.length - 1].removeAll();
                this.voltagePnl[integerArray.length - 1].add(new JLabel("Voltage " + alphabets.substring(integerArray.length - 1, integerArray.length) + ": " + integerArray[integerArray.length - 1] + "mV"));
                this.voltagePnl[integerArray.length - 1].add(Box.createHorizontalStrut(700));
            } else {
                this.voltagePnl[0].removeAll();
                this.voltagePnl[0].add(new JLabel("Unable to retrieve chassis voltages."));
            }
        }
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SppVoltageTempPane;
    }
}

