/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.lmp;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.Lmp.eControlChannelOperationalState;
import cerent.cms.idl.Lmp.eLmpError;
import cerent.cms.idl.Lmp.sControlChannelAttrsEx;
import cerent.cms.idl.Node.eProductId;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.LmpConstants;
import cerent.cms.model.LmpCtrlChannelModel;
import cerent.cms.model.LmpCtrlChannelModels;
import cerent.cms.model.LmpException;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchDefault;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.nedefaults.DefaultsManager;
import cerent.cms.model.nedefaults.ValueAccessor;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.shelf.lmp.NodeTypeWrapper;
import cerent.cms.ui.shelf.lmp.PortWrapper;
import cerent.util.ComparisonUtil;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTable;

class CtrlChannelDataSource
extends AbstractRowDataSource
implements LmpConstants {
    static final EntityCellRenderer _renderer = new EntityCellRenderer("", true);
    private LmpCtrlChannelModels _model;
    private ArrayList _data;
    private Observer _observer;
    private SortableRowTableModel _tm;
    private Column[] _columns;
    private HashMap _columnMap;
    private HashMap _defaultsMap;
    private static final SDebug db = new SDebug("CtrlChannelDataSource");
    private ArrayList _candidates = new ArrayList();

    CtrlChannelDataSource(LmpCtrlChannelModels lmpCtrlChannelModels) {
        this._model = lmpCtrlChannelModels;
        this._data = new ArrayList();
        this._observer = new Observer(){

            public void update(Observable observable, Object object) {
                EventQueue.invokeLater(new Refresher(observable, object));
            }
        };
        this._tm = null;
        this._columns = this.newColumns();
        this._columnMap = new HashMap();
        this._defaultsMap = new HashMap();
        for (int i = 0; i < this._columns.length; ++i) {
            this._columnMap.put(this._columns[i].getName(), this._columns[i]);
            String string = this._columns[i].getDefaultsPath();
            if (string == null) continue;
            this._defaultsMap.put(string, this._columns[i]);
        }
        this.trace("<init>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        ArrayList arrayList = this._data;
        synchronized (arrayList) {
            Iterator iterator = this._data.iterator();
            while (iterator.hasNext()) {
                ((Info)iterator.next()).dispose(this._observer);
            }
            this._data.clear();
        }
        this.trace("dispose");
    }

    private Column[] newColumns() {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        arrayList.add(new Column(){

            public String getName() {
                return "Admin State";
            }

            String getDefaultsPath() {
                return "NODE.lmp.controlChannel.AdminState";
            }

            String getDefaultValue() {
                return LmpConstants.ADMIN_STATE_DEFAULT;
            }

            Class getColumnClass() {
                return String.class;
            }

            Object getColumnValue(Info info) {
                return info._adminState;
            }

            void setColumnValue(Info info, Object object) {
                info.setAdminState(((AdminState)object).getAdminStateEnum(), CtrlChannelDataSource.this.getTdmTerminology());
            }

            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vAdminState.value(), (int)info2._vAdminState.value());
            }
        });
        arrayList.add(new Column(){

            public String getName() {
                return "Operational State";
            }

            Class getColumnClass() {
                return String.class;
            }

            Object getColumnValue(Info info) {
                return info._operationalState;
            }

            void setColumnValue(Info info, Object object) {
                info.setOperationalState(CtrlChannelDataSource.this.getOperationalStateChoice((Attribute)object));
            }

            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vOperationalState.value(), (int)info2._vOperationalState.value());
            }
        });
        arrayList.add(new Column(){

            public String getName() {
                return "Local Port";
            }

            Class getColumnClass() {
                return String.class;
            }

            Object getColumnValue(Info info) {
                return info._localPort;
            }

            void setColumnValue(Info info, Object object) throws Exception {
                PortWrapper portWrapper = (PortWrapper)object;
                if (portWrapper == null) {
                    throw new Exception("No local port was chosen.");
                }
                info.setLocalPortId(portWrapper.getPortId());
            }

            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vLocalPortId, (int)info2._vLocalPortId);
            }
        });
        arrayList.add(new Column(){

            public String getName() {
                return "Local Port Id";
            }

            Class getColumnClass() {
                return Integer.class;
            }

            Object getColumnValue(Info info) {
                return info._localPortId;
            }

            void setColumnValue(Info info, Object object) throws Exception {
                PortWrapper portWrapper = (PortWrapper)object;
                if (portWrapper == null) {
                    throw new Exception("No local port was chosen.");
                }
                info.setLocalPortId(portWrapper.getPortId());
            }

            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vLocalPortId, (int)info2._vLocalPortId);
            }
        });
        arrayList.add(new Column(){

            public String getName() {
                return "Local Control Channel Id";
            }

            Class getColumnClass() {
                return Integer.class;
            }

            Object getColumnValue(Info info) {
                return info._localCtrlChannelId;
            }

            void setColumnValue(Info info, Object object) {
            }

            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vLocalCtrlChannelId, (int)info2._vLocalCtrlChannelId);
            }
        });
        arrayList.add(new Column(){

            public String getName() {
                return "Remote Node Address";
            }

            Class getColumnClass() {
                return String.class;
            }

            Object getColumnValue(Info info) {
                return info._remoteNodeIpAddress;
            }

            void setColumnValue(Info info, Object object) {
                info.setRemoteNodeIpAddress(CtrlChannelDataSource.this.asIpAddr(object));
            }

            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((byte[])info._vRemoteNodeIpAddress.addr, (byte[])info2._vRemoteNodeIpAddress.addr);
            }
        });
        arrayList.add(new Column(){

            public String getName() {
                return "Remote Node Id";
            }

            Class getColumnClass() {
                return Integer.class;
            }

            Object getColumnValue(Info info) {
                return info._remoteNodeId;
            }

            void setColumnValue(Info info, Object object) throws Exception {
                info.setRemoteNodeId(CtrlChannelDataSource.this.asIpAddr(object));
            }

            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((byte[])info._vRemoteNodeId.addr, (byte[])info2._vRemoteNodeId.addr);
            }
        });
        arrayList.add(new Column(){

            public String getName() {
                return "Remote Control Channel Id";
            }

            Class getColumnClass() {
                return Integer.class;
            }

            Object getColumnValue(Info info) {
                return info._remoteCtrlChannelId;
            }

            void setColumnValue(Info info, Object object) throws Exception {
                info.setRemoteCtrlChannelId(this.getLong((String)object));
            }

            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vRemoteCtrlChannelId, (int)info2._vRemoteCtrlChannelId);
            }
        });
        arrayList.add(new Column(){

            public String getName() {
                return "Requested Hello Interval";
            }

            String getDefaultsPath() {
                return "NODE.lmp.controlChannel.HelloInterval";
            }

            String getDefaultValue() {
                return "500";
            }

            Class getColumnClass() {
                return Integer.class;
            }

            Object getColumnValue(Info info) {
                return info._hello;
            }

            void setColumnValue(Info info, Object object) {
                info.setHello(this.getInt((String)object));
            }

            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vHello, (int)info2._vHello);
            }
        });
        arrayList.add(new Column(){

            public String getName() {
                return "Min Hello Interval";
            }

            String getDefaultsPath() {
                return "NODE.lmp.controlChannel.MinHelloInterval";
            }

            String getDefaultValue() {
                return "300";
            }

            Class getColumnClass() {
                return Integer.class;
            }

            Object getColumnValue(Info info) {
                return info._helloMin;
            }

            void setColumnValue(Info info, Object object) {
                info.setHelloMin(this.getInt((String)object));
            }

            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vHelloMin, (int)info2._vHelloMin);
            }
        });
        arrayList.add(new Column(){

            public String getName() {
                return "Max Hello Interval";
            }

            String getDefaultsPath() {
                return "NODE.lmp.controlChannel.MaxHelloInterval";
            }

            String getDefaultValue() {
                return "2000";
            }

            Class getColumnClass() {
                return Integer.class;
            }

            Object getColumnValue(Info info) {
                return info._helloMax;
            }

            void setColumnValue(Info info, Object object) {
                info.setHelloMax(this.getInt((String)object));
            }

            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vHelloMax, (int)info2._vHelloMax);
            }
        });
        arrayList.add(new Column(){

            public String getName() {
                return "Actual Hello Interval";
            }

            Class getColumnClass() {
                return Integer.class;
            }

            Object getColumnValue(Info info) {
                return info._helloAct;
            }

            void setColumnValue(Info info, Object object) {
                info.setHelloAct(this.getInt((String)object));
            }

            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vHelloAct, (int)info2._vHelloAct);
            }
        });
        arrayList.add(new Column(){

            public String getName() {
                return "Requested Hello Dead Interval";
            }

            String getDefaultsPath() {
                return "NODE.lmp.controlChannel.HelloDeadInterval";
            }

            String getDefaultValue() {
                return "12000";
            }

            Class getColumnClass() {
                return Integer.class;
            }

            Object getColumnValue(Info info) {
                return info._helloDead;
            }

            void setColumnValue(Info info, Object object) {
                info.setHelloDead(this.getInt((String)object));
            }

            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vHelloDead, (int)info2._vHelloDead);
            }
        });
        arrayList.add(new Column(){

            public String getName() {
                return "Min Hello Dead Interval";
            }

            String getDefaultsPath() {
                return "NODE.lmp.controlChannel.MinHelloDeadInterval";
            }

            String getDefaultValue() {
                return "2000";
            }

            Class getColumnClass() {
                return Integer.class;
            }

            Object getColumnValue(Info info) {
                return info._helloDeadMin;
            }

            void setColumnValue(Info info, Object object) {
                info.setHelloDeadMin(this.getInt((String)object));
            }

            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vHelloDeadMin, (int)info2._vHelloDeadMin);
            }
        });
        arrayList.add(new Column(){

            public String getName() {
                return "Max Hello Dead Interval";
            }

            String getDefaultsPath() {
                return "NODE.lmp.controlChannel.MaxHelloDeadInterval";
            }

            String getDefaultValue() {
                return "20000";
            }

            Class getColumnClass() {
                return Integer.class;
            }

            Object getColumnValue(Info info) {
                return info._helloDeadMax;
            }

            void setColumnValue(Info info, Object object) {
                info.setHelloDeadMax(this.getInt((String)object));
            }

            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vHelloDeadMax, (int)info2._vHelloDeadMax);
            }
        });
        arrayList.add(new Column(){

            public String getName() {
                return "Actual Hello Dead Interval";
            }

            Class getColumnClass() {
                return Integer.class;
            }

            Object getColumnValue(Info info) {
                return info._helloDeadAct;
            }

            void setColumnValue(Info info, Object object) {
                info.setHelloDeadAct(this.getInt((String)object));
            }

            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vHelloDeadAct, (int)info2._vHelloDeadAct);
            }
        });
        arrayList.add(new Column(){

            public String getName() {
                return "Remote Node Type";
            }

            Class getColumnClass() {
                return NodeTypeWrapper.class;
            }

            Object getColumnValue(Info info) {
                return info.getNodeType();
            }

            void setColumnValue(Info info, Object object) {
                info.setRemoteNodeType((NodeTypeWrapper)object);
            }

            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vRemoteNodeType.getId(), (int)info2._vRemoteNodeType.getId());
            }
        });
        return arrayList.toArray(new Column[arrayList.size()]);
    }

    void setTableModel(SortableRowTableModel sortableRowTableModel) {
        this._tm = sortableRowTableModel;
    }

    TDMTerminology getTdmTerminology() {
        return this._model.getNodeModel().getTDMTerminology();
    }

    boolean isSonet() {
        return AdminState.isANSI(this.getTdmTerminology());
    }

    String asString(int n, char c, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        long l = (long)n & 0xFFFFFFFFL;
        stringBuffer.append(Long.toHexString(l));
        while (stringBuffer.length() < n2) {
            stringBuffer.insert(0, c);
        }
        stringBuffer.insert(0, "0x");
        return stringBuffer.toString();
    }

    private String asString(sIpAddr sIpAddr2) {
        return InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(sIpAddr2));
    }

    private sIpAddr asIpAddr(Object object) {
        return IpAddrFactory.getIpAddr(InetUtil.makeIpAddr(((String)object).trim()));
    }

    private String getDescription(int n) {
        if (n == 0) {
            return "Routed";
        }
        try {
            INodeModel iNodeModel = this._model.getNodeModel();
            return _renderer.getString(iNodeModel.getEntityTable().getEntityModelByIndex(n), iNodeModel.isMultishelf() ? "shelf " : "slot ");
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return this.asString(n, '0', 8);
        }
    }

    AdminState[] getAdminStateChoices() {
        AdminState[] adminStateArray = this.isSonet() ? new AdminState[]{AdminState.OOS_DSBLD, AdminState.IS} : new AdminState[]{AdminState.OOS_DSBLD_ETSI, AdminState.IS_ETSI};
        return adminStateArray;
    }

    AdminState getAdminStateChoice(eAdminState eAdminState2) {
        return AdminState.enumToAdminState(eAdminState2, this.isSonet());
    }

    AdminState getAdminStateChoice(int n) {
        return this.getAdminStateChoice(eAdminState.from_int(n));
    }

    AdminState getAdminStateChoice(Info info) {
        return this.getAdminStateChoice(info.getAdminState());
    }

    AdminState getAdminStateChoice(String string) {
        return this.getAdminStateChoice(Integer.parseInt(string));
    }

    Attribute[] getOperationalStateChoices() {
        return ElementDefaults.getAttributeMap(this._model).getAttributeArray("LMP-Control-Channel-Operational-State");
    }

    Attribute getOperationalStateChoice(eControlChannelOperationalState eControlChannelOperationalState2) {
        Attribute[] attributeArray = this.getOperationalStateChoices();
        int n = eControlChannelOperationalState2.value();
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i].getIntValue() != n) continue;
            return attributeArray[i];
        }
        return null;
    }

    Attribute getOperationalStateChoice(Info info) {
        return this.getOperationalStateChoice(info.getOperationalState());
    }

    eControlChannelOperationalState getOperationalStateChoice(Attribute attribute) {
        return eControlChannelOperationalState.from_int(attribute.getIntValue());
    }

    PortWrapper[] getLocalPortChoices(Info info) throws LmpException {
        this._candidates.clear();
        int[] nArray = this._model.getCandidates();
        for (int i = 0; i < nArray.length; ++i) {
            this._candidates.add(new PortWrapper(nArray[i], this.getDescription(nArray[i])));
        }
        PortWrapper portWrapper = this.getLocalPortChoice(info);
        if (portWrapper == null) {
            portWrapper = new PortWrapper(info.getLocalPortId(), (String)this.getColumn("Local Port").getColumnValue(info));
            this._candidates.add(portWrapper);
        }
        Collections.sort(this._candidates);
        return this._candidates.toArray(new PortWrapper[this._candidates.size()]);
    }

    PortWrapper getLocalPortChoice(Info info) {
        int n = info.getLocalPortId();
        for (PortWrapper portWrapper : this._candidates) {
            if (portWrapper.getPortId() != n) continue;
            return portWrapper;
        }
        return null;
    }

    String getDefaultValue(String string) {
        Column column = this.getColumn(string);
        String string2 = column.getDefaultValue();
        try {
            String string3 = column.getDefaultsPath();
            String string4 = null;
            if (string3 != null) {
                string4 = this._model.getNodeModel().getDefaultValue(string3);
            }
            if (string4 != null && !string4.equals("UNKNOWN")) {
                string2 = string4;
            }
        }
        catch (NoSuchDefault noSuchDefault) {
            db.println("Cannot find default for " + string);
        }
        return string2;
    }

    private void validate(Info info, Column column) throws ProvisionError {
        String string = column.getDefaultsPath();
        if (string != null) {
            DefaultsManager.getInstance((NodeModelDelegate)this._model.getNodeModel()).validate("NodeDefaults." + string, CtrlChannelDataSource.noUnits((String)column.getColumnValue(info)), new Accessor(info));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Info find(ArrayList arrayList, int n) {
        ArrayList arrayList2 = arrayList;
        synchronized (arrayList2) {
            for (Info info : arrayList) {
                if (info.getLocalCtrlChannelId() != n) continue;
                return info;
            }
        }
        return null;
    }

    private static boolean isInvalidIndex(LmpException lmpException) {
        return eLmpError.INVALID_CONTROL_CHANNEL_INDEX.equals(lmpException.getLmpError());
    }

    private static String noUnits(String string) {
        int n = string.indexOf("ms");
        if (n != -1) {
            int n2 = "ms".length();
            int n3 = string.length();
            string = n == 0 ? string.substring(n + n2, n3) : (n + n2 == n3 ? string.substring(0, n) : string.substring(0, n) + string.substring(n + n2, n3));
        }
        return string.trim();
    }

    void refreshFromModel() {
        block7: {
            this.trace("refreshFromModel");
            try {
                ArrayList<LmpException> arrayList = new ArrayList<LmpException>();
                LmpCtrlChannelModel[] lmpCtrlChannelModelArray = this._model.getCtrlChannels();
                ArrayList<Info> arrayList2 = new ArrayList<Info>(lmpCtrlChannelModelArray.length);
                for (int i = 0; i < lmpCtrlChannelModelArray.length; ++i) {
                    try {
                        Info info = this.find(this._data, lmpCtrlChannelModelArray[i].getIndex());
                        if (info == null) {
                            info = new Info(lmpCtrlChannelModelArray[i]);
                        }
                        arrayList2.add(info);
                        continue;
                    }
                    catch (LmpException lmpException) {
                        if (CtrlChannelDataSource.isInvalidIndex(lmpException)) continue;
                        arrayList.add(lmpException);
                    }
                }
                EventQueue.invokeLater(new Refresher(arrayList2));
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ErrorMsg.displayError(null, (EID)((LmpException)((Object)iterator.next())).getEid());
                }
            }
            catch (Exception exception) {
                db.println("exception: " + exception);
                if (!db.on()) break block7;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    ColumnRenderer[] getRenderers() {
        return this._columns;
    }

    Column getColumn(String string) {
        return (Column)this._columnMap.get(string);
    }

    String getColumnName(int n) {
        return this._columns[n].getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectAtRow(int n) {
        ArrayList arrayList = this._data;
        synchronized (arrayList) {
            return this._data.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        ArrayList arrayList = this._data;
        synchronized (arrayList) {
            return this._data.size();
        }
    }

    public Class getRowObjectClass() {
        return Info.class;
    }

    void println(String string) {
        db.println(string);
    }

    private void trace(String string) {
        if (db.on()) {
            db.println(string + "(" + this._model.getNodeModel().getHostName() + ")");
        }
    }

    abstract class Column
    implements ColumnRenderer {
        Column() {
        }

        public abstract String getName();

        String getDefaultsPath() {
            return null;
        }

        String getDefaultValue() {
            return null;
        }

        abstract Class getColumnClass();

        abstract Object getColumnValue(Info var1);

        abstract void setColumnValue(Info var1, Object var2) throws Exception;

        void checkValue(Info info) throws Exception {
            try {
                CtrlChannelDataSource.this.validate(info, this);
            }
            catch (ProvisionError provisionError) {
                throw this.fixMessage(provisionError);
            }
        }

        abstract int cmpValue(Info var1, Info var2);

        public int getWidth() {
            return 96;
        }

        public int getAlignment() {
            return 2;
        }

        public boolean isResizable() {
            return true;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return jTable.getDefaultRenderer(this.getColumnClass()).getTableCellRendererComponent(jTable, this.getColumnValue((Info)object), bl, bl2, n, n2);
        }

        public int compareColumn(Object object, Object object2, int n) {
            if (object instanceof Info) {
                if (object2 instanceof Info) {
                    return this.cmpValue((Info)object, (Info)object2);
                }
                return -1;
            }
            return 1;
        }

        int rangeCheck(long l, long l2, long l3) throws Exception {
            if (l2 <= l3 && (l < l2 || l > l3)) {
                throw new Exception("The value (" + l + ") must be between " + l2 + " and " + l3 + ".");
            }
            return (int)l;
        }

        int getInt(String string) {
            return Integer.decode(CtrlChannelDataSource.noUnits(string));
        }

        int getLong(String string) throws Exception {
            return this.rangeCheck(Long.decode(string.trim()), 0L, 0xFFFFFFFFL);
        }

        private ProvisionError fixMessage(ProvisionError provisionError) {
            String string;
            String string2 = this.getDefaultsPath();
            if (string2 != null && (string = provisionError.getMessage()).startsWith(string2 = string2 + ": ")) {
                provisionError = new ProvisionError(string.substring(string2.length() + 1));
            }
            return provisionError;
        }
    }

    private class Refresher
    implements Runnable {
        private ArrayList _newModels;
        private ArrayList _oldModels;
        private ArrayList _updModels;

        Refresher(ArrayList arrayList) {
            this._newModels = arrayList;
            this._oldModels = null;
            this._updModels = null;
        }

        Refresher(Object object, Object object2) {
            this._newModels = null;
            if (ModelUpdateType.DELETED.equals(object2)) {
                this._oldModels = new ArrayList();
                this._oldModels.add(object);
                this._updModels = null;
            } else {
                this._oldModels = null;
                this._updModels = new ArrayList();
                this._updModels.add(object);
            }
        }

        private int findAndRemove(ArrayList arrayList, Info info) {
            int n = arrayList.indexOf(info);
            if (n != -1) {
                arrayList.remove(n);
            }
            return n;
        }

        private void removeOldModels(ArrayList arrayList, ArrayList arrayList2) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n = CtrlChannelDataSource.this._data.indexOf((Info)iterator.next());
                if (n == -1) continue;
                arrayList2.add(new Integer(n));
            }
            for (Info info : arrayList) {
                int n = this.findAndRemove(CtrlChannelDataSource.this._data, info);
                if (n == -1) continue;
                info.dispose(CtrlChannelDataSource.this._observer);
            }
        }

        private void notifyDeletedRows(ArrayList arrayList) {
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((Integer)object2).compareTo((Integer)object);
                }
            });
            int n = -1;
            int n2 = -1;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (n2 == -1) {
                    n = n2 = ((Integer)iterator.next()).intValue();
                    continue;
                }
                int n3 = (Integer)iterator.next();
                if (n3 == n - 1) {
                    n = n3;
                    continue;
                }
                CtrlChannelDataSource.this._tm.rowsDeleted(n, n2);
                n = n2 = n3;
            }
            if (n2 != -1) {
                CtrlChannelDataSource.this._tm.rowsDeleted(n, n2);
            }
        }

        private void findUpdModels(ArrayList arrayList, ArrayList arrayList2) {
            for (Info info : arrayList) {
                int n = CtrlChannelDataSource.this._data.indexOf(info);
                if (n == -1) continue;
                arrayList2.add(new Integer(n));
            }
        }

        private void notifyUpdatedRows(ArrayList arrayList) {
            int n = -1;
            int n2 = -1;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (n == -1) {
                    n = n2 = ((Integer)iterator.next()).intValue();
                    continue;
                }
                int n3 = (Integer)iterator.next();
                if (n3 == n2 + 1) {
                    n2 = n3;
                    continue;
                }
                CtrlChannelDataSource.this._tm.rowsUpdated(n, n2);
                n = n2 = n3;
            }
            if (n != -1) {
                CtrlChannelDataSource.this._tm.rowsUpdated(n, n2);
            }
        }

        private void addNewModels(ArrayList arrayList) {
            for (Info info : arrayList) {
                info.init(CtrlChannelDataSource.this._observer);
                CtrlChannelDataSource.this._data.add(info);
            }
        }

        private void notifyAddedRows(int n, int n2) {
            if (n2 >= n) {
                CtrlChannelDataSource.this._tm.rowsAdded(n, n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList arrayList = CtrlChannelDataSource.this._data;
            synchronized (arrayList) {
                ArrayList arrayList2;
                ArrayList<Info> arrayList3 = new ArrayList<Info>();
                ArrayList arrayList4 = new ArrayList();
                if (this._newModels != null && !this._newModels.isEmpty()) {
                    arrayList4.addAll(CtrlChannelDataSource.this._data);
                    for (Info info : this._newModels) {
                        if (this.findAndRemove(arrayList4, info) != -1) continue;
                        arrayList3.add(info);
                    }
                }
                if (this._oldModels != null) {
                    this._oldModels.addAll(arrayList4);
                } else {
                    this._oldModels = arrayList4;
                }
                if (this._oldModels != null && !this._oldModels.isEmpty()) {
                    arrayList2 = new ArrayList();
                    this.removeOldModels(this._oldModels, arrayList2);
                    this.notifyDeletedRows(arrayList2);
                }
                if (this._updModels != null && !this._updModels.isEmpty()) {
                    arrayList2 = new ArrayList();
                    this.findUpdModels(this._updModels, arrayList2);
                    this.notifyUpdatedRows(arrayList2);
                }
                if (arrayList3 != null && !arrayList3.isEmpty()) {
                    int n = CtrlChannelDataSource.this._data.size();
                    this.addNewModels(arrayList3);
                    this.notifyAddedRows(n, CtrlChannelDataSource.this._data.size() - 1);
                }
            }
            this._updModels = null;
            this._oldModels = null;
            this._newModels = null;
        }
    }

    class Info
    extends Observable
    implements Comparable,
    Observer {
        LmpCtrlChannelModel _vModel;
        eAdminState _vAdminState;
        eControlChannelOperationalState _vOperationalState;
        int _vLocalPortId;
        int _vLocalCtrlChannelId;
        sIpAddr _vRemoteNodeIpAddress;
        sIpAddr _vRemoteNodeId;
        int _vRemoteCtrlChannelId;
        int _vHello;
        int _vHelloMin;
        int _vHelloMax;
        int _vHelloAct;
        int _vHelloDead;
        int _vHelloDeadMin;
        int _vHelloDeadMax;
        int _vHelloDeadAct;
        NodeTypeWrapper _vRemoteNodeType;
        String _adminState;
        String _operationalState;
        String _localPort;
        String _localPortId;
        String _localCtrlChannelId;
        String _remoteNodeIpAddress;
        String _remoteNodeId;
        String _remoteCtrlChannelId;
        String _hello;
        String _helloMin;
        String _helloMax;
        String _helloAct;
        String _helloDead;
        String _helloDeadMin;
        String _helloDeadMax;
        String _helloDeadAct;

        Info() {
        }

        Info(Info info) {
            this._vModel = info._vModel;
            this._vAdminState = info._vAdminState;
            this._vOperationalState = info._vOperationalState;
            this._vLocalPortId = info._vLocalPortId;
            this._vLocalCtrlChannelId = info._vLocalCtrlChannelId;
            this._vRemoteNodeIpAddress = this.duplicate(info._vRemoteNodeIpAddress);
            this._vRemoteNodeId = this.duplicate(info._vRemoteNodeId);
            this._vRemoteCtrlChannelId = info._vRemoteCtrlChannelId;
            this._vHello = info._vHello;
            this._vHelloMin = info._vHelloMin;
            this._vHelloMax = info._vHelloMax;
            this._vHelloAct = info._vHelloAct;
            this._vHelloDead = info._vHelloDead;
            this._vHelloDeadMin = info._vHelloDeadMin;
            this._vHelloDeadMax = info._vHelloDeadMax;
            this._vHelloDeadAct = info._vHelloDeadAct;
            this._vRemoteNodeType = info._vRemoteNodeType;
            this._adminState = info._adminState;
            this._operationalState = info._operationalState;
            this._localPort = info._localPort;
            this._localPortId = info._localPortId;
            this._localCtrlChannelId = info._localCtrlChannelId;
            this._remoteNodeIpAddress = info._remoteNodeIpAddress;
            this._remoteNodeId = info._remoteNodeId;
            this._remoteCtrlChannelId = info._remoteCtrlChannelId;
            this._hello = info._hello;
            this._helloMin = info._helloMin;
            this._helloMax = info._helloMax;
            this._helloAct = info._helloAct;
            this._helloDead = info._helloDead;
            this._helloDeadMin = info._helloDeadMin;
            this._helloDeadMax = info._helloDeadMax;
            this._helloDeadAct = info._helloDeadAct;
        }

        private sIpAddr duplicate(sIpAddr sIpAddr2) {
            sIpAddr sIpAddr3 = null;
            if (sIpAddr2 != null) {
                sIpAddr3 = new sIpAddr();
                if (sIpAddr2.addr != null) {
                    sIpAddr3.addr = new byte[sIpAddr2.addr.length];
                    System.arraycopy(sIpAddr2.addr, 0, sIpAddr3.addr, 0, sIpAddr2.addr.length);
                }
            }
            return sIpAddr3;
        }

        Info(LmpCtrlChannelModel lmpCtrlChannelModel) throws LmpException {
            this._vModel = lmpCtrlChannelModel;
            this.refresh();
        }

        private void refresh() throws LmpException {
            this.setLocalCtrlChannelId(this._vModel.getLocalCtrlChannelId());
            CtrlChannelDataSource.this.trace("refresh-" + this);
            this.setAdminState(this._vModel.getAdminState(), this._vModel.getNodeModel().getTDMTerminology());
            this.setOperationalState(this._vModel.getOperationalState());
            this.setLocalPortId(this._vModel.getLocalPortId());
            this.setRemoteNodeIpAddress(this._vModel.getRemoteNodeIpAddress());
            this.setRemoteNodeId(this._vModel.getRemoteNodeId());
            this.setRemoteCtrlChannelId(this._vModel.getRemoteCtrlChannelId());
            this.setHello(this._vModel.getHello());
            this.setHelloMin(this._vModel.getHelloMin());
            this.setHelloMax(this._vModel.getHelloMax());
            this.setHelloAct(this._vModel.getHelloAct());
            this.setHelloDead(this._vModel.getHelloDead());
            this.setHelloDeadMin(this._vModel.getHelloDeadMin());
            this.setHelloDeadMax(this._vModel.getHelloDeadMax());
            this.setHelloDeadAct(this._vModel.getHelloDeadAct());
            this.setRemoteNodeType(this._vModel.getRemoteNodeType());
        }

        public void update(Observable observable, Object object) {
            if (ModelUpdateType.CHANGED.equals(object)) {
                CtrlChannelDataSource.this.trace("changed-" + this);
                try {
                    this.refresh();
                    this.setChanged();
                    this.notifyObservers(object);
                }
                catch (LmpException lmpException) {
                    if (!CtrlChannelDataSource.isInvalidIndex(lmpException)) {
                        ErrorMsg.displayError(null, (EID)lmpException.getEid());
                    }
                }
            } else if (ModelUpdateType.DELETED.equals(object)) {
                CtrlChannelDataSource.this.trace("deleted-" + this);
                this.setChanged();
                this.notifyObservers(object);
            } else {
                CtrlChannelDataSource.this.trace("update-" + object + "-" + this);
            }
        }

        void init(Observer observer) {
            CtrlChannelDataSource.this.trace("init-" + this);
            if (this._vModel != null) {
                this._vModel.addObserver(this);
            }
            this.addObserver(observer);
        }

        void dispose(Observer observer) {
            CtrlChannelDataSource.this.trace("dispose-" + this);
            this.deleteObserver(observer);
            if (this._vModel != null) {
                this._vModel.deleteObserver(this);
            }
        }

        LmpCtrlChannelModel getModel() {
            return this._vModel;
        }

        void setAdminState(eAdminState eAdminState2, TDMTerminology tDMTerminology) {
            this._vAdminState = eAdminState2;
            this._adminState = AdminState.enumAdminStateToStr(this._vAdminState, tDMTerminology);
        }

        eAdminState getAdminState() {
            return this._vAdminState;
        }

        void setOperationalState(eControlChannelOperationalState eControlChannelOperationalState2) {
            this._vOperationalState = eControlChannelOperationalState2;
            this._operationalState = CtrlChannelDataSource.this.getOperationalStateChoice(this._vOperationalState).toString();
        }

        eControlChannelOperationalState getOperationalState() {
            return this._vOperationalState;
        }

        void setLocalPortId(int n) {
            this._vLocalPortId = n;
            this._localPortId = CtrlChannelDataSource.this.asString(this._vLocalPortId, '0', 8);
            this._localPort = CtrlChannelDataSource.this.getDescription(this._vLocalPortId);
        }

        int getLocalPortId() {
            return this._vLocalPortId;
        }

        void setLocalCtrlChannelId(int n) {
            this._vLocalCtrlChannelId = n;
            this._localCtrlChannelId = CtrlChannelDataSource.this.asString(this._vLocalCtrlChannelId, '0', 8);
        }

        int getLocalCtrlChannelId() {
            return this._vLocalCtrlChannelId;
        }

        void setRemoteNodeIpAddress(sIpAddr sIpAddr2) {
            this._vRemoteNodeIpAddress = sIpAddr2;
            this._remoteNodeIpAddress = CtrlChannelDataSource.this.asString(this._vRemoteNodeIpAddress);
        }

        sIpAddr getRemoteNodeIpAddress() {
            return this._vRemoteNodeIpAddress;
        }

        void setRemoteNodeId(sIpAddr sIpAddr2) {
            this._vRemoteNodeId = sIpAddr2;
            this._remoteNodeId = CtrlChannelDataSource.this.asString(this._vRemoteNodeId);
        }

        sIpAddr getRemoteNodeId() {
            return this._vRemoteNodeId;
        }

        void setRemoteCtrlChannelId(int n) {
            this._vRemoteCtrlChannelId = n;
            this._remoteCtrlChannelId = CtrlChannelDataSource.this.asString(this._vRemoteCtrlChannelId, '0', 8);
        }

        int getRemoteCtrlChannelId() {
            return this._vRemoteCtrlChannelId;
        }

        void setHello(int n) {
            this._vHello = n;
            this._hello = Integer.toString(this._vHello) + "ms";
        }

        int getHello() {
            return this._vHello;
        }

        void setHelloMin(int n) {
            this._vHelloMin = n;
            this._helloMin = Integer.toString(this._vHelloMin) + "ms";
        }

        int getHelloMin() {
            return this._vHelloMin;
        }

        void setHelloMax(int n) {
            this._vHelloMax = n;
            this._helloMax = Integer.toString(this._vHelloMax) + "ms";
        }

        int getHelloMax() {
            return this._vHelloMax;
        }

        void setHelloAct(int n) {
            this._vHelloAct = n;
            this._helloAct = Integer.toString(this._vHelloAct) + "ms";
        }

        int getHelloAct() {
            return this._vHelloAct;
        }

        void setHelloDead(int n) {
            this._vHelloDead = n;
            this._helloDead = Integer.toString(this._vHelloDead) + "ms";
        }

        int getHelloDead() {
            return this._vHelloDead;
        }

        void setHelloDeadMin(int n) {
            this._vHelloDeadMin = n;
            this._helloDeadMin = Integer.toString(this._vHelloDeadMin) + "ms";
        }

        int getHelloDeadMin() {
            return this._vHelloDeadMin;
        }

        void setHelloDeadMax(int n) {
            this._vHelloDeadMax = n;
            this._helloDeadMax = Integer.toString(this._vHelloDeadMax) + "ms";
        }

        int getHelloDeadMax() {
            return this._vHelloDeadMax;
        }

        void setHelloDeadAct(int n) {
            this._vHelloDeadAct = n;
            this._helloDeadAct = Integer.toString(this._vHelloDeadAct) + "ms";
        }

        int getHelloDeadAct() {
            return this._vHelloDeadAct;
        }

        public String toString() {
            return this._localCtrlChannelId;
        }

        public int compareTo(Object object) {
            return CtrlChannelDataSource.this.getColumn("Local Control Channel Id").cmpValue(this, (Info)object);
        }

        public int hashCode() {
            return this._vLocalCtrlChannelId;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof Info) {
                bl = this._vLocalCtrlChannelId == ((Info)object)._vLocalCtrlChannelId;
            }
            return bl;
        }

        public NodeTypeWrapper getNodeType() {
            return this._vRemoteNodeType;
        }

        public void setRemoteNodeType(NodeTypeWrapper nodeTypeWrapper) {
            this._vRemoteNodeType = nodeTypeWrapper;
        }

        public sControlChannelAttrsEx toAttrs() {
            sControlChannelAttrsEx sControlChannelAttrsEx2 = new sControlChannelAttrsEx();
            sControlChannelAttrsEx2.admin_status = this.getAdminState();
            sControlChannelAttrsEx2.ifIndex = this.getLocalPortId();
            sControlChannelAttrsEx2.remote_ne = this.getRemoteNodeId();
            sControlChannelAttrsEx2.remote_ip = this.getRemoteNodeIpAddress();
            sControlChannelAttrsEx2.requested_hello = (short)this.getHello();
            sControlChannelAttrsEx2.hello_min = (short)this.getHelloMin();
            sControlChannelAttrsEx2.hello_max = (short)this.getHelloMax();
            sControlChannelAttrsEx2.requested_hello_dead = (short)this.getHelloDead();
            sControlChannelAttrsEx2.hello_dead_min = (short)this.getHelloDeadMin();
            sControlChannelAttrsEx2.hello_dead_max = (short)this.getHelloDeadMax();
            sControlChannelAttrsEx2.neType = eProductId.from_int(this.getNodeType().getId());
            return sControlChannelAttrsEx2;
        }
    }

    private class Accessor
    implements ValueAccessor {
        private Info info;

        Accessor(Info info) {
            this.info = info;
        }

        public String getValue(String string) {
            String string2 = null;
            Column column = (Column)CtrlChannelDataSource.this._defaultsMap.get(string);
            if (column != null) {
                string2 = CtrlChannelDataSource.noUnits((String)column.getColumnValue(this.info));
            }
            return string2;
        }
    }
}

