/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.snmp;

import cerent.cms.idl.Node.SnmpV3AuthProtocol;
import cerent.cms.idl.Node.SnmpV3PrivProtocol;
import cerent.cms.idl.Node.sSnmpV3User;
import cerent.cms.model.Attribute;
import cerent.cms.ui.shelf.snmp.UserCreateDialog;
import cerent.util.SDebug;
import cerent.util.gui.SnmpV3RowTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class UserCreatePane
extends JPanel
implements ActionListener {
    static final int MARGIN = 5;
    protected JTextField nameTF;
    protected JTextField authPassTF;
    protected JTextField privPassTF;
    protected JTextField groupNameTF;
    protected JComboBox authProtocolCB;
    protected JComboBox privProtocolCB;
    protected UserCreateDialog uDialog = null;
    private static final SDebug db = new SDebug("UserCreatePane");

    public UserCreatePane(UserCreateDialog userCreateDialog) {
        this.uDialog = userCreateDialog;
        this.add((Component)this.createAttrsPanel(), "Center");
    }

    private JPanel createAttrsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel2.add(this.createLabel("User Name:", 70, 20));
        this.nameTF = new SnmpV3RowTextField(20);
        jPanel2.add(this.nameTF);
        jPanel2.add(this.createLabel("Group Name:", 70, 20));
        this.groupNameTF = new SnmpV3RowTextField(20);
        jPanel2.add(this.groupNameTF);
        jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel3.add(this.createLabel("Protocol:", 70, 20));
        Attribute[] attributeArray = new Attribute[]{new Attribute("NONE", 0), new Attribute("MD5", 1), new Attribute("SHA", 2)};
        this.authProtocolCB = new JComboBox<Attribute>(attributeArray);
        jPanel3.add(this.authProtocolCB);
        this.authProtocolCB.setSelectedIndex(0);
        this.authProtocolCB.addActionListener(this);
        jPanel3.add(this.createLabel("Password:", 70, 20));
        this.authPassTF = new JPasswordField(20);
        jPanel3.add(this.authPassTF);
        this.authPassTF.setEnabled(false);
        jPanel3.setBorder(BorderFactory.createTitledBorder("Authentication"));
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(0, 2, 5, 5));
        Attribute[] attributeArray2 = new Attribute[]{new Attribute("NONE", 0), new Attribute("DES", 1)};
        jPanel4.add(this.createLabel("Protocol:", 70, 20));
        this.privProtocolCB = new JComboBox<Attribute>(attributeArray2);
        jPanel4.add(this.privProtocolCB);
        this.privProtocolCB.setSelectedIndex(0);
        this.privProtocolCB.addActionListener(this);
        jPanel4.add(this.createLabel("Password:", 70, 20));
        this.privPassTF = new JPasswordField(20);
        jPanel4.add(this.privPassTF);
        this.privPassTF.setEnabled(false);
        jPanel4.setBorder(BorderFactory.createTitledBorder("Privacy"));
        jPanel.add(jPanel4);
        return jPanel;
    }

    public void setSelectedItem(sSnmpV3User sSnmpV3User2) {
        this.nameTF.setText(sSnmpV3User2.username);
        this.nameTF.setEnabled(false);
        this.groupNameTF.setText(sSnmpV3User2.group);
        this.authPassTF.setText("");
        this.authProtocolCB.setSelectedItem(this.convertAuthProto(sSnmpV3User2.authProtocol));
        this.authProtocolCB.setEnabled(false);
        this.privPassTF.setText("");
        this.privProtocolCB.setSelectedItem(this.convertPrivProto(sSnmpV3User2.privProtocol));
        this.privProtocolCB.setEnabled(false);
    }

    public Attribute convertAuthProto(SnmpV3AuthProtocol snmpV3AuthProtocol) {
        switch (snmpV3AuthProtocol.value()) {
            case 1: {
                return new Attribute("MD5", 1);
            }
            case 2: {
                return new Attribute("SHA", 2);
            }
            case 0: {
                return new Attribute("NONE", 0);
            }
        }
        return new Attribute("???", -1);
    }

    public Attribute convertPrivProto(SnmpV3PrivProtocol snmpV3PrivProtocol) {
        switch (snmpV3PrivProtocol.value()) {
            case 1: {
                return new Attribute("DES", 1);
            }
            case 0: {
                return new Attribute("NONE", 0);
            }
        }
        return new Attribute("???", -1);
    }

    private JLabel createLabel(String string, int n, int n2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(n, n2));
        return jLabel;
    }

    public String getAuthPass() {
        return this.authPassTF.getText();
    }

    public String getPrivPass() {
        return this.privPassTF.getText();
    }

    public String getUserName() {
        return this.nameTF.getText();
    }

    public String getGroupName() {
        return this.groupNameTF.getText();
    }

    public int getAuthProtocol() {
        int n = ((Attribute)this.authProtocolCB.getSelectedItem()).getValue();
        return n;
    }

    public int getPrivProtocol() {
        int n = ((Attribute)this.privProtocolCB.getSelectedItem()).getValue();
        return n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.authProtocolCB) {
            if (this.authProtocolCB.getSelectedIndex() > 0) {
                this.authPassTF.setEnabled(true);
            } else {
                this.authPassTF.setEnabled(false);
                this.authPassTF.setText("");
                this.privProtocolCB.setSelectedIndex(0);
                this.privPassTF.setEnabled(false);
                this.privPassTF.setText("");
            }
        } else if (object == this.privProtocolCB) {
            if (this.privProtocolCB.getSelectedIndex() > 0) {
                this.privPassTF.setEnabled(true);
                if (this.uDialog.isCreate() && this.authProtocolCB.getSelectedIndex() == 0) {
                    this.authProtocolCB.setSelectedIndex(1);
                }
                this.authPassTF.setEnabled(true);
            } else {
                this.privPassTF.setEnabled(false);
                this.privPassTF.setText("");
            }
        }
    }
}

