/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.snmp;

import cerent.cms.idl.Node.sSnmpV3ViewTreeFamily;
import cerent.cms.model.Attribute;
import cerent.cms.ui.shelf.snmp.SnmpV3Util;
import cerent.util.gui.BinaryTextField;
import cerent.util.gui.OIDTextField;
import cerent.util.gui.SnmpV3RowTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ViewTreeCreatePane
extends JPanel {
    static final int MARGIN = 5;
    protected SnmpV3RowTextField viewNameTF;
    protected OIDTextField oidTF;
    protected BinaryTextField maskTF;
    protected JComboBox viewTypeCB;

    public ViewTreeCreatePane() {
        this.add((Component)this.createAttrsPanel(), "Center");
    }

    private JPanel createAttrsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel2.add(this.createLabel("Name:", 70, 20));
        this.viewNameTF = new SnmpV3RowTextField(20);
        jPanel2.add(this.viewNameTF);
        jPanel2.add(this.createLabel("Subtree OID:", 70, 20));
        this.oidTF = new OIDTextField(20);
        jPanel2.add(this.oidTF);
        this.oidTF.setPreferredSize(new Dimension(20, 20));
        this.oidTF.setMaximumSize(new Dimension(20, 20));
        this.oidTF.setMinimumSize(new Dimension(20, 20));
        jPanel2.add(this.createLabel("Bit Mask:", 70, 20));
        this.maskTF = new BinaryTextField(20);
        jPanel2.add(this.maskTF);
        this.maskTF.setToolTipText("indicates which sub-identifiers of the associated subtree OID.");
        jPanel2.add(this.createLabel("Type:", 70, 20));
        Attribute[] attributeArray = new Attribute[]{new Attribute("include", 1), new Attribute("exclude", 2)};
        this.viewTypeCB = new JComboBox<Attribute>(attributeArray);
        jPanel2.add(this.viewTypeCB);
        this.viewTypeCB.setSelectedIndex(0);
        jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void setSelectedItem(sSnmpV3ViewTreeFamily sSnmpV3ViewTreeFamily2) {
        this.viewNameTF.setText(sSnmpV3ViewTreeFamily2.viewName);
        this.viewNameTF.setEnabled(false);
        this.oidTF.setText(this.getOID(sSnmpV3ViewTreeFamily2.subtree.oidarray, sSnmpV3ViewTreeFamily2.subtree.oidlen));
        this.oidTF.setEnabled(false);
        this.maskTF.setText((String)sSnmpV3ViewTreeFamily2.mask.subSequence(0, sSnmpV3ViewTreeFamily2.subtree.oidlen));
        this.viewTypeCB.setSelectedItem(new Attribute(SnmpV3Util.getViewTreeType(sSnmpV3ViewTreeFamily2.type.value()), sSnmpV3ViewTreeFamily2.type.value()));
    }

    private JLabel createLabel(String string, int n, int n2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(n, n2));
        return jLabel;
    }

    public String getOID(int[] nArray, int n) {
        int n2;
        String string = "";
        for (n2 = 0; n2 < n - 1; ++n2) {
            string = string + nArray[n2] + ".";
        }
        string = string + nArray[n2];
        return string;
    }

    public String getViewName() {
        return this.viewNameTF.getText();
    }

    public String getMask() {
        return this.maskTF.getText();
    }

    public String getOID() {
        if (!this.oidTF.getText().endsWith(".")) {
            return this.oidTF.getText() + ".";
        }
        return this.oidTF.getText();
    }

    public int getViewTreeFamilyType() {
        return ((Attribute)this.viewTypeCB.getSelectedItem()).getValue();
    }
}

