/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.model.INodeModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.TdmHoModel;
import cerent.cms.model.TdmLoModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.sonet.TdmVtIppmTableModel;
import cerent.util.AnnotatedException;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class TdmVtIppmProvPane
extends NodeProvPane
implements TableModelListener {
    private TdmVtIppmTableModel dataModel = null;
    private TdmLoModel[] loModels = null;
    private TdmHoModel[] hoModels = null;
    private InterfaceModel[] lineModels;
    private int indexOfLos = 0;
    private ObservableManager _obsMgr;
    private static final SDebug db = new SDebug("TdmVtIppmProvPane");

    public TdmVtIppmProvPane(String string, TabbedView tabbedView, InterfaceModel[] interfaceModelArray, int n) {
        super(string, tabbedView);
        TableColumn tableColumn = null;
        this.lineModels = interfaceModelArray;
        this.indexOfLos = n;
        this.loModels = this.getVts(interfaceModelArray);
        this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        INodeModel iNodeModel = this.getUiModel().getNodeModel();
        this.dataModel = new TdmVtIppmTableModel(iNodeModel, this.loModels);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[0]);
        tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        tableColumn.setPreferredWidth(225);
        this.add((Component)uScrollPane, "Center");
        this.registerWithModel();
    }

    public void applyChangesToModel() throws Exception {
        if (this.loModels == null) {
            return;
        }
        for (int i = 0; i < this.loModels.length; ++i) {
            try {
                db.fine("Setting Enable IPPM");
                if (!this.dataModel.isDirty(i, 1)) continue;
                this.loModels[i].setVtIppmEnabled(this.dataModel.getVtIppmEnabled(i));
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                this.refreshFromModel();
                throw new AnnotatedException("An error occurred while applying changes to row " + (i + 1) + ".", (Exception)((Object)noSuchInterface));
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                this.refreshFromModel();
                throw new AnnotatedException("An error occurred while applying changes to row " + (i + 1) + ".", (Exception)((Object)wrongInterfaceType));
            }
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        for (int i = 0; i < this.loModels.length; ++i) {
            for (int j = 0; j < this.dataModel.getColumnCount(); ++j) {
                if (!this.dataModel.isDirty(i, j)) continue;
                if (db.on()) {
                    db.println("setting dirty (" + i + "," + j + ")");
                }
                this.setDirty();
                return;
            }
        }
        this.resetDirty();
    }

    protected void changeMessage(Observable observable, Object object) {
        if (this.loModels == null) {
            return;
        }
        final int n = Arrays.asList(this.loModels).indexOf(observable);
        if (db.on()) {
            db.println("Processing changed from " + observable + ", Changed line is " + n);
        }
        if (n != -1) {
            this.requestRefresh(observable, new Runnable(){

                public void run() {
                    TdmVtIppmProvPane.this.dataModel.refreshVtFromModel(n);
                }
            });
        }
    }

    protected void deleteMessage(Observable observable, Object object) {
        this.initializeVts();
    }

    protected synchronized void initializeVts() {
        this.deregisterForUpdates();
        this.loModels = this.getVts(this.lineModels);
        this.registerForUpdates();
        this.dataModel.setLoModel(this.loModels);
    }

    private TdmLoModel[] getVts(InterfaceModel[] interfaceModelArray) {
        TdmLoModel[] tdmLoModelArray;
        block5: {
            tdmLoModelArray = new TdmLoModel[]{};
            Collection collection = InterfaceModel.getHigherLayerModels(interfaceModelArray, this.indexOfLos, this.getUiModel());
            if (collection.size() == 0) {
                return tdmLoModelArray;
            }
            this.hoModels = collection.toArray(new TdmHoModel[0]);
            for (int i = 0; i < this.hoModels.length; ++i) {
                this.hoModels[i].updateLayerIndexes();
            }
            Collection collection2 = InterfaceModel.getHigherLayerModels(this.hoModels, this.indexOfLos, this.getUiModel());
            if (collection2.size() == 0) {
                return tdmLoModelArray;
            }
            try {
                tdmLoModelArray = collection2.toArray(new TdmLoModel[0]);
            }
            catch (Exception exception) {
                if (!db.on()) break block5;
                db.println("Error in getting LOs for DS1");
            }
        }
        return tdmLoModelArray;
    }

    public void destroy() {
        this.deregisterForUpdates();
        super.destroy();
    }

    private void registerForUpdates() {
        this._obsMgr.addObservable((Observable[])this.loModels);
        this._obsMgr.addObservable((Observable[])this.hoModels);
        this._obsMgr.addObservable((Observable[])this.lineModels);
    }

    private void deregisterForUpdates() {
        this._obsMgr.removeObservable((Observable[])this.loModels);
        this._obsMgr.removeObservable((Observable[])this.hoModels);
        this._obsMgr.removeObservable((Observable[])this.lineModels);
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing Data Model " + this.dataModel);
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.TdmVtIppmProvPane;
    }

    public void setShowing(boolean bl) throws Exception {
        if (bl) {
            this.initializeVts();
        }
        super.setShowing(bl);
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        this._obsMgr.setPassing(true);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        this._obsMgr.setPassing(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof OcnLineUpdate) {
            this.deregisterForUpdates();
            this.lineModels = (InterfaceModel[])((OcnLineUpdate)object).getModels();
            this.initializeVts();
            this.registerForUpdates();
        }
    }
}

