/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.wxc;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.CommonHelper;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.ui.AbstractLeavePageException;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.ObflPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ampli.WlPowerPane;
import cerent.cms.ui.wxc.WxcMaintenanceTabPane;
import java.awt.Component;

public class WxcMaintenancePane
extends NodeProvPane {
    private WxcMaintenanceTabPane tabPane;

    public WxcMaintenancePane(String string, TabbedView tabbedView, ModuleModel moduleModel) {
        super(string, tabbedView);
        OpticsLineModel[] opticsLineModelArray = ((OpticsModuleModel)moduleModel).getOpticsLineModels();
        this.subTabs = new SubTabbedView(moduleModel, tabbedView);
        this.subTabs.addTab("OCHNC", (Component)this.getwxcMaintTabs(opticsLineModelArray));
        if (CommonHelper.isChannelPowerSupported((OpticsModuleModel)this.getUiModel())) {
            AbstractOpticsLineModel[] abstractOpticsLineModelArray = ((OpticsModuleModel)this.getUiModel()).getLinesSupportingChanelPower();
            this.subTabs.addTab("Wavelength Power", (Component)this.getWlPowerTab(abstractOpticsLineModelArray));
        }
        if (((OpticsModuleModel)moduleModel).isOFBLSupported()) {
            this.subTabs.addTab("OBFL", (Component)this.getOBFLTab((OpticsModuleModel)moduleModel));
        }
        this.subTabs.setTabPlacement(2);
        this.add((Component)this.subTabs);
    }

    protected Pane getOBFLTab(OpticsModuleModel opticsModuleModel) {
        return new ObflPane("OBFL", this.getParentView(), opticsModuleModel);
    }

    protected Pane getWlPowerTab(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        return new WlPowerPane("Wavelength Power", this.getParentView(), abstractOpticsLineModelArray);
    }

    private Pane getwxcMaintTabs(OpticsLineModel[] opticsLineModelArray) {
        this.tabPane = new WxcMaintenanceTabPane("Parameters", this.getParentView(), this, opticsLineModelArray);
        return this.tabPane;
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.WxcOCHParametersMaintPane;
    }

    protected AbstractLeavePageException createLeavePageException(String string) {
        return null;
    }

    public void leavingPage() throws Exception {
    }

    public void enteringPage() throws Exception {
    }

    public void customBehaviour() {
        this.enableApply(false);
        this.tabPane.resetModel();
    }

    public void applyChangesToModel() throws Exception {
        this.tabPane.updateModel();
    }

    public void enableApply(boolean bl) {
        this.setDirty(bl);
    }
}

