/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.wxc;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticalPortType;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractCardProvPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.muxdemux.MuxDmuxOTSParametersProvPane;
import cerent.cms.ui.muxdemux.MuxDmuxOpticalThresholdPane;
import cerent.cms.ui.wxc.WxcOchTermProvPane;
import cerent.cms.ui.wxc.WxcWxcLineParametersProvPane;
import cerent.util.SDebug;
import java.awt.Component;
import java.util.ArrayList;

public class WxcProvPane
extends NodeProvPane
implements ITabName {
    ModuleModel eqpmtModel = null;
    private OpticsModuleModel model = (OpticsModuleModel)this.getUiModel();
    private OpticsLineModel[] otsModels = this.model.getOpticsLineModels();

    public WxcProvPane(String string, TabbedView tabbedView, ModuleModel moduleModel) {
        super(string, tabbedView);
        this.eqpmtModel = moduleModel;
        this.subTabs = new SubTabbedView(moduleModel, tabbedView);
        this.subTabs.addTab("WXC Line", (Component)this.getWxcLineTabs(this.subTabs, this.otsModels));
        this.subTabs.addTab("Optical Line", (Component)this.getOtsTabs(this.subTabs, this.otsModels));
        this.subTabs.addTab("OCH", (Component)this.getOchTermTabs(this.subTabs));
        if (moduleModel.getEqType() == 297) {
            this.subTabs.addTab("Card", (Component)((Object)new WxcCardProvPane("Card", this.subTabs)));
        }
        this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, false));
        this.subTabs.setTabPlacement(2);
        this.add((Component)this.subTabs);
    }

    public static boolean isWxc40ExpOrAdd(OpticsLineModel opticsLineModel) throws NoSuchInterface, WrongInterfaceType {
        return opticsLineModel.getOptPortType() == OpticalPortType.IN_EXPRESS || opticsLineModel.getOptPortType() == OpticalPortType.ADD;
    }

    public static boolean isWxc80ExpOrAdd(OpticsLineModel opticsLineModel) throws NoSuchInterface, WrongInterfaceType {
        return opticsLineModel.getOptPortType() == OpticalPortType.EAD_BIDI || opticsLineModel.getOptPortType() == OpticalPortType.AD_BIDI;
    }

    protected Pane getOtsTabs(TabbedView tabbedView, OpticsLineModel[] opticsLineModelArray) {
        return new WxcOTSProvPane(tabbedView, opticsLineModelArray);
    }

    protected Pane getWxcLineTabs(TabbedView tabbedView, OpticsLineModel[] opticsLineModelArray) {
        return new WxcWxcLineProvPane(tabbedView, opticsLineModelArray);
    }

    protected Pane getOchTermTabs(TabbedView tabbedView) {
        return new WxcOchTermProvPane(tabbedView);
    }

    protected Pane getOTSParametersProvTab(OpticsLineModel[] opticsLineModelArray) {
        return new MuxDmuxOTSParametersProvPane("Parameters", this.getParentView(), opticsLineModelArray);
    }

    protected Pane getWxcLineParametersProvTab(OpticsLineModel[] opticsLineModelArray) {
        return new WxcWxcLineParametersProvPane("Parameters", this.getParentView(), opticsLineModelArray);
    }

    protected Pane getOptThresholdsTab(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        return new MuxDmuxOpticalThresholdPane("Optics Thresholds", this.getParentView(), abstractOpticsLineModelArray);
    }

    public boolean hasSubTabs() {
        return true;
    }

    private class WxcCardProvPane
    extends AbstractCardProvPane {
        public WxcCardProvPane(String string, TabbedView tabbedView) {
            super(string, tabbedView);
        }

        protected Attribute[] getModeChoices() {
            return this.getAttributeFor("Wxc80CardMode");
        }

        public void refreshFromModel() throws Exception {
            Attribute attribute = ElementDefaults.getAttributeForCardOperMode(this.model, "Wxc80CardMode");
            this.modeCB.setSelectedItem(attribute);
        }

        protected boolean changeMode() {
            return true;
        }

        public CSHelpID getHelpID() {
            return CSHelpConst.WxcMeshppPanel;
        }
    }

    private class WxcOTSProvPane
    extends NodeProvPane {
        public WxcOTSProvPane(TabbedView tabbedView, OpticsLineModel[] opticsLineModelArray) {
            super("WxcOTSProvPane", tabbedView);
            int n = 0;
            ArrayList<OpticsLineModel> arrayList = new ArrayList<OpticsLineModel>();
            for (n = 0; n < opticsLineModelArray.length; ++n) {
                try {
                    if (WxcProvPane.isWxc40ExpOrAdd(opticsLineModelArray[n]) || WxcProvPane.isWxc80ExpOrAdd(opticsLineModelArray[n])) continue;
                    arrayList.add(opticsLineModelArray[n]);
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                    continue;
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
            this.subTabs.addTab("Parameters", (Component)WxcProvPane.this.getOTSParametersProvTab(arrayList.toArray(new OpticsLineModel[0])));
            this.subTabs.addTab("Optics Thresholds", (Component)WxcProvPane.this.getOptThresholdsTab(arrayList.toArray(new OpticsLineModel[0])));
            this.add((Component)this.subTabs);
        }

        public boolean hasSubTabs() {
            return true;
        }
    }

    private class WxcWxcLineProvPane
    extends NodeProvPane {
        public WxcWxcLineProvPane(TabbedView tabbedView, OpticsLineModel[] opticsLineModelArray) {
            super("WxcWxcLineProvPane", tabbedView);
            ArrayList<OpticsLineModel> arrayList = new ArrayList<OpticsLineModel>();
            int n = 0;
            for (n = 0; n < opticsLineModelArray.length; ++n) {
                try {
                    if (!WxcProvPane.isWxc40ExpOrAdd(opticsLineModelArray[n]) && !WxcProvPane.isWxc80ExpOrAdd(opticsLineModelArray[n])) continue;
                    arrayList.add(opticsLineModelArray[n]);
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                    continue;
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
            this.subTabs.addTab("Parameters", (Component)WxcProvPane.this.getWxcLineParametersProvTab(arrayList.toArray(new OpticsLineModel[0])));
            this.add((Component)this.subTabs);
        }

        public boolean hasSubTabs() {
            return true;
        }
    }
}

