/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.eNiValue;
import cerent.cms.idl.EtherL2Media.eQinQMode;
import cerent.cms.idl.EtherL2Media.sQinQInfo;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IVlanInfo;
import cerent.cms.model.IXPL2QinQSvlanTableModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InvalidOperation;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.PortModel;
import cerent.cms.model.QinQSettings;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2Layer2LineModel;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.xpl2.OPERMODE;
import cerent.cms.ui.xpl2.XPL2QinQRangeDialog;
import cerent.cms.ui.xpl2.XPL2QinQSvlanTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class XPL2QinQProvPane
extends NodeProvPane
implements TableModelListener,
ActionListener {
    private short selNetPort;
    protected short selSVLANId;
    protected boolean fromNet = false;
    private INodeModel nm;
    protected PortModel[] portModels = null;
    protected XPL2ModuleModel eqpmtModel = null;
    protected XPL2LineModel[] linesModels = null;
    protected XPL2Layer2LineModel[] layer2Models = null;
    private JLabel portLabel;
    private UComboBox portCB;
    private UComboBox bpduCB;
    private UComboBox modeCB;
    private UComboBox svlanCB;
    private UComboBox svlanCBEditor;
    private UComboBox intSvlanCBEditor;
    private UComboBox cosCBEditor;
    private UComboBox operationCBEditor;
    private ComboBoxRenderer comboRenderer = new ComboBoxRenderer();
    private TableColumn cosColumn;
    private JButton addRowButton;
    private JButton removeRowButton;
    private JButton rangeButton;
    private JButton closeButton;
    private JButton resetButton;
    private CSHelpButton helpButton;
    public static final String CLOSE = "Apply";
    protected XPL2QinQSvlanTableModel dataSvlanModel = null;
    private JPanel sVlanPane = null;
    private JPanel cVlanPane = null;
    private GridBagPanel gbp = null;
    private boolean dialogDisplayed;
    private boolean applyChanges = false;
    private ObservableManager _obsMgr;
    private QinQSettings qinqInfoFromNet = null;
    private static final SDebug db = new SDebug("XPL2QinQProvPane");

    public XPL2QinQProvPane(String string, TabbedView tabbedView, XPL2ModuleModel xPL2ModuleModel, short s, short s2, QinQSettings qinQSettings) {
        super(string, (IModel)xPL2ModuleModel.getNodeModel(), tabbedView);
        this.nm = xPL2ModuleModel.getNodeModel();
        this.eqpmtModel = xPL2ModuleModel;
        this.portModels = xPL2ModuleModel.getXPL2EtherPorts();
        this.linesModels = xPL2ModuleModel.getXPL2EtherLines();
        this.layer2Models = xPL2ModuleModel.getXPL2Layer2EtherLines();
        this.selNetPort = s;
        this.selSVLANId = s2;
        if (qinQSettings != null) {
            this.fromNet = true;
            this.qinqInfoFromNet = qinQSettings;
        }
        if (xPL2ModuleModel == null || this.portModels == null) {
            if (db.on()) {
                db.println("Error during initialization");
                db.println("eqpmtModel=" + xPL2ModuleModel + " portModels=" + this.portModels);
            }
            return;
        }
        this.init();
    }

    protected void registerWithModel() {
        int n;
        super.registerWithModel();
        for (n = 0; n < this.portModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.portModels[n]));
        }
        for (n = 0; n < this.linesModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.linesModels[n]));
        }
        for (n = 0; n < this.layer2Models.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.layer2Models[n]));
        }
    }

    protected void unRegisterWithModel() {
        int n;
        super.registerWithModel();
        for (n = 0; n < this.portModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.portModels[n]));
        }
        for (n = 0; n < this.linesModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.linesModels[n]));
        }
        for (n = 0; n < this.layer2Models.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.layer2Models[n]));
        }
    }

    private ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.gbp = new GridBagPanel();
        this.gbp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.gbp.fillBoth();
        this.gbp.add((Component)this.createPortPane(), 0, 1);
        this.gbp.fillBoth();
        this.gbp.add((Component)this.createSVlanPane(), 1, 1);
        this.add((Component)new UScrollPane((Component)this.gbp));
        this.createCVlanPane();
        if (this.fromNet) {
            this.buttonPanel.setVisible(false);
            this.add(this.getButtonPanel(), "East");
            for (PortModel portModel : this.portModels) {
                if (portModel.getParent().getParent().getPositionInParent() != this.selNetPort) continue;
                this.portCB.setSelectedItem((Object)portModel);
                break;
            }
            try {
                if (this.qinqInfoFromNet.getQinQMode() == -1) {
                    this.initQinQInfoFromNet();
                } else if (db.on()) {
                    db.println("Already inizialized QinQ mode and BPDU");
                }
                this.refreshFromModel();
            }
            catch (Exception exception) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            finally {
                this.portCB.setEnabled(false);
            }
        }
    }

    private JPanel getButtonPanel() {
        Dimension dimension = new Dimension(75, 25);
        this.closeButton = new JButton(CLOSE);
        this.closeButton.setMinimumSize(dimension);
        this.closeButton.setMaximumSize(dimension);
        this.closeButton.addActionListener(this);
        this.resetButton = new JButton("Reset");
        this.resetButton.setMinimumSize(dimension);
        this.resetButton.setMaximumSize(dimension);
        this.resetButton.addActionListener(this);
        JPanel jPanel = XPL2QinQProvPane.createVerticalPanel(null);
        jPanel.add(this.closeButton);
        jPanel.add(Box.createVerticalStrut(this.closeButton.getPreferredSize().height / 3));
        jPanel.add(this.resetButton);
        if (this.getHelpID() != null) {
            this.helpButton = new CSHelpButton(this);
            this.helpButton.setMinimumSize(dimension);
            this.helpButton.setMaximumSize(dimension);
            jPanel.add(Box.createVerticalStrut(this.closeButton.getPreferredSize().height / 3));
            jPanel.add(this.helpButton);
        }
        return jPanel;
    }

    private void initQinQInfoFromNet() throws WrongInterfaceType, InvalidOperation, NoSuchInterface {
        PortModel portModel;
        if (this.fromNet && this.portModels.length != 0 && ((XPL2ModuleModel)(portModel = (PortModel)this.portCB.getSelectedItem()).getModuleModel()).isL2Switch()) {
            XPL2LineModel xPL2LineModel = (XPL2LineModel)portModel.getInterfaceModel();
            XPL2Layer2LineModel xPL2Layer2LineModel = xPL2LineModel.getLayer2LineModel();
            sQinQInfo sQinQInfo2 = null;
            sQinQInfo2 = xPL2Layer2LineModel.getQinQInfo();
            if (db.on()) {
                db.println("Initializing QinQ mode and BPDU " + sQinQInfo2.qinqMode.value() + " " + xPL2Layer2LineModel.getBpdu());
            }
            this.qinqInfoFromNet.setQinQMode(sQinQInfo2.qinqMode.value());
            this.qinqInfoFromNet.setQinQBPDU(xPL2Layer2LineModel.getBpdu().booleanValue());
        }
    }

    private JPanel createPortPane() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setPreferredSize(new Dimension(350, 160));
        jPanel.setBorder(BorderFactory.createTitledBorder("Select Port"));
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        double[] dArray = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 1.0E-4};
        double[] dArray2 = new double[]{1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0E-4};
        gridBagLayout.columnWidths = nArray;
        gridBagLayout.rowHeights = nArray2;
        gridBagLayout.columnWeights = dArray;
        gridBagLayout.rowWeights = dArray2;
        this.portLabel = new JLabel("Port: ");
        jPanel.add((Component)this.portLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.portCB = new UComboBox((Object[])this.portModels);
        this.portCB.setRenderer((ListCellRenderer)this.comboRenderer);
        jPanel.add((Component)this.portCB, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel = new JLabel("Mode: ");
        jPanel.add((Component)jLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.modeCB = new UComboBox(new DefaultComboBoxModel<String>(new String[]{"Transparent", "Selective"}));
        this.modeCB.setRenderer((ListCellRenderer)this.comboRenderer);
        this.modeCB.addActionListener((ActionListener)this);
        this.enableComponent((JComponent)this.modeCB, (IModel)this.nm);
        jPanel.add((Component)this.modeCB, new GridBagConstraints(2, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel2 = new JLabel("BPDU: ");
        jPanel.add((Component)jLabel2, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.bpduCB = new UComboBox(new DefaultComboBoxModel<String>(new String[]{"Drop", "Tunnel"}));
        this.bpduCB.setRenderer((ListCellRenderer)this.comboRenderer);
        this.bpduCB.addActionListener((ActionListener)this);
        this.enableComponent((JComponent)this.bpduCB, (IModel)this.nm);
        jPanel.add((Component)this.bpduCB, new GridBagConstraints(2, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createSVlanPane() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.sVlanPane = new JPanel(gridBagLayout);
        this.sVlanPane.setPreferredSize(new Dimension(350, 160));
        this.sVlanPane.setBorder(BorderFactory.createTitledBorder("Transparent Mode"));
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0, 0};
        double[] dArray = new double[]{1.0, 0.0, 1.0, 0.0, 1.0, 1.0E-4};
        double[] dArray2 = new double[]{1.0, 0.0, 1.0, 1.0E-4};
        gridBagLayout.columnWidths = nArray;
        gridBagLayout.rowHeights = nArray2;
        gridBagLayout.columnWeights = dArray;
        gridBagLayout.rowWeights = dArray2;
        JLabel jLabel = new JLabel("SVLAN: ");
        this.sVlanPane.add((Component)jLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.svlanCB = new UComboBox();
        this.svlanCB.addActionListener((ActionListener)this);
        this.svlanCB.setRenderer((ListCellRenderer)this.comboRenderer);
        this.enableComponent((JComponent)this.svlanCB, (IModel)this.nm);
        this.sVlanPane.add((Component)this.svlanCB, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        return this.sVlanPane;
    }

    private JPanel createCVlanPane() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0, 0};
        double[] dArray = new double[]{11.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        double[] dArray2 = new double[]{1.0, 0.0, 0.0, 1.0E-4};
        gridBagLayout.columnWidths = nArray;
        gridBagLayout.rowHeights = nArray2;
        gridBagLayout.columnWeights = dArray;
        gridBagLayout.rowWeights = dArray2;
        this.cVlanPane = new JPanel(gridBagLayout);
        this.cVlanPane.setPreferredSize(new Dimension(380, 160));
        this.cVlanPane.setBorder(BorderFactory.createTitledBorder("Selective Mode"));
        if (this.fromNet) {
            if (this.qinqInfoFromNet.getQinQTable() != null) {
                if (db.on()) {
                    db.println("Already inizialized table model ");
                }
                this.dataSvlanModel = (XPL2QinQSvlanTableModel)this.qinqInfoFromNet.getQinQTable();
            } else {
                if (db.on()) {
                    db.println("Initializing table model ");
                }
                this.dataSvlanModel = new XPL2QinQSvlanTableModel((Container)((Object)this), true);
                this.qinqInfoFromNet.setQinQTable((IXPL2QinQSvlanTableModel)this.dataSvlanModel);
            }
        } else {
            this.dataSvlanModel = new XPL2QinQSvlanTableModel((Container)((Object)this), false);
        }
        this.dataSvlanModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataSvlanModel);
        this.cosColumn = this.table.getColumnModel().getColumn(4);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.customizedTableSvlan();
        this.cVlanPane.add((Component)uScrollPane, new GridBagConstraints(0, 0, 5, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.rangeButton = new JButton("Add Range");
        this.rangeButton.addActionListener(this);
        this.enableComponent(this.rangeButton, (IModel)this.nm);
        this.addRowButton = new JButton("Add Row");
        this.addRowButton.addActionListener(this);
        this.enableComponent(this.addRowButton, (IModel)this.nm);
        this.removeRowButton = new JButton("Remove Row(s)");
        this.removeRowButton.addActionListener(this);
        this.enableComponent(this.removeRowButton, (IModel)this.nm);
        this.cVlanPane.add((Component)this.addRowButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cVlanPane.add((Component)this.removeRowButton, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cVlanPane.add((Component)this.rangeButton, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 13, new Insets(0, 0, 0, 5), 0, 0));
        return this.cVlanPane;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setDirty();
        Object object = actionEvent.getSource();
        IVlanInfo[] iVlanInfoArray = this.eqpmtModel.getVlanDb();
        if ((object == this.addRowButton || object == this.rangeButton) && iVlanInfoArray.length == 0) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NO_VLAN_VLAN_DB_EMPTY);
            return;
        }
        if (object == this.addRowButton) {
            if (this.svlanCB.getModel().getSize() != iVlanInfoArray.length) {
                this.svlanCB.setModel(new DefaultComboBoxModel<IVlanInfo>(iVlanInfoArray));
                this.svlanCBEditor.setModel(new DefaultComboBoxModel<IVlanInfo>(iVlanInfoArray));
                this.intSvlanCBEditor.setModel(new DefaultComboBoxModel<IVlanInfo>(iVlanInfoArray));
            }
            short s = this.fromNet ? this.selSVLANId : (iVlanInfoArray.length > 0 ? iVlanInfoArray[0].getVlanId() : (short)0);
            this.dataSvlanModel.addRow(s);
        } else if (object == this.removeRowButton) {
            this.dataSvlanModel.removeRows(this.table.getSelectedRows());
        } else if (object == this.modeCB) {
            if (this.modeCB.getSelectedItem().equals("Transparent")) {
                this.prepareTabForTransparentMode(this.selSVLANId);
            } else {
                this.prepareTabForSelectiveMode();
            }
            this.setDirty();
        } else if (object == this.closeButton) {
            EventBus.instance().notifyEvent((Object)this, (Object)CLOSE);
        } else if (object == this.helpButton) {
            this.helpButton.launchHelp(this.getHelpID());
        } else if (object == this.resetButton) {
            this.reset();
        } else if (object == this.bpduCB) {
            if (this.fromNet) {
                this.qinqInfoFromNet.setQinQBPDU(this.bpduCB.getSelectedIndex() == 0);
            }
        } else if (object == this.rangeButton) {
            XPL2QinQRangeDialog.getInstance(this, this.eqpmtModel).setVisible(true);
        }
    }

    private void prepareTabForTransparentMode(int n) {
        this.svlanCB.removeActionListener((ActionListener)this);
        this.modeCB.removeActionListener((ActionListener)this);
        this.enableComponent((JComponent)this.svlanCB, (IModel)this.nm);
        this.gbp.remove(this.cVlanPane);
        this.gbp.add((Component)this.sVlanPane, 1, 1);
        int n2 = this.svlanCB.getModel().getSize();
        IVlanInfo iVlanInfo = null;
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            iVlanInfo = (IVlanInfo)this.svlanCB.getItemAt(i);
            if (iVlanInfo.getVlanId() != n) continue;
            bl = true;
            this.svlanCB.setSelectedItem((Object)iVlanInfo);
            break;
        }
        if (!bl && this.svlanCB.getItemCount() > 0) {
            this.svlanCB.setSelectedIndex(0);
        }
        this.modeCB.setSelectedIndex(0);
        this.svlanCB.addActionListener((ActionListener)this);
        this.modeCB.addActionListener((ActionListener)this);
        this.resetDirty();
        this.validate();
        this.updateUI();
        if (this.fromNet) {
            this.qinqInfoFromNet.setQinQMode(1);
            this.svlanCB.setEnabled(false);
        }
    }

    private void prepareTabForSelectiveMode() {
        block9: {
            this.modeCB.removeActionListener((ActionListener)this);
            this.svlanCB.setEnabled(false);
            this.gbp.remove(this.sVlanPane);
            this.gbp.add((Component)this.cVlanPane, 1, 1);
            PortModel portModel = (PortModel)this.portCB.getSelectedItem();
            XPL2LineModel xPL2LineModel = (XPL2LineModel)portModel.getInterfaceModel();
            XPL2Layer2LineModel xPL2Layer2LineModel = xPL2LineModel.getLayer2LineModel();
            this.dataSvlanModel.updateModel(xPL2Layer2LineModel);
            if (this.fromNet) {
                this.qinqInfoFromNet.setQinQMode(0);
                if (this.dataSvlanModel.getRowCount() > 0 && !this.dataSvlanModel.hasSvlanEntryOnlyFromNet()) {
                    this.modeCB.setEnabled(false);
                }
            }
            try {
                if (xPL2LineModel.getEtherBasicL2Info().sIngressCOS == 9) {
                    if (this.table.getColumnModel().getColumnCount() < 5) {
                        this.table.getColumnModel().addColumn(this.cosColumn);
                    }
                } else {
                    this.table.getColumnModel().removeColumn(this.cosColumn);
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            catch (InvalidOperation invalidOperation) {
                if (!db.on()) break block9;
                SDebug.printStackTrace((Throwable)invalidOperation);
            }
        }
        this.modeCB.setSelectedIndex(1);
        this.resetDirty();
        this.modeCB.addActionListener((ActionListener)this);
        this.validate();
        this.updateUI();
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        if (db.on()) {
            db.println("calling enteringPage");
        }
        this.getObsMgr().setPassing(true);
        this.registerWithModel();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    private void setUpArrayAndComboBoxes() {
        Serializable serializable;
        ArrayList<IPortModel> arrayList = new ArrayList<IPortModel>();
        ArrayList<XPL2Layer2LineModel> arrayList2 = new ArrayList<XPL2Layer2LineModel>();
        for (int i = 0; i < this.layer2Models.length; ++i) {
            serializable = this.layer2Models[i];
            try {
                if (((XPL2Layer2LineModel)serializable).getEtherBasicL2Info().niMode != eNiValue.UNI_MODE) continue;
                arrayList.add(((InterfaceModel)serializable).getPortModel());
                arrayList2.add((XPL2Layer2LineModel)serializable);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
                continue;
            }
            catch (InvalidOperation invalidOperation) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)invalidOperation);
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        this.portModels = arrayList.toArray(new PortModel[0]);
        this.layer2Models = arrayList2.toArray(new XPL2Layer2LineModel[0]);
        if (!this.fromNet) {
            final XPL2QinQProvPane xPL2QinQProvPane = this;
            serializable = new VetoableComboBoxModel(this.portModels);
            ((VetoableComboBoxModel)serializable).addVetoableSelectionListener(new VetoableComboBoxSelectionListener(){

                public boolean selectionChanged(VetoableChangeEvent vetoableChangeEvent) {
                    if (XPL2QinQProvPane.this.isProvPaneDirty()) {
                        switch (CerentDialog.cancelableQuestionDialog((Component)((Object)xPL2QinQProvPane), (String)"Is it OK to apply these changes?", (String)"Changes Not Applied")) {
                            case 0: {
                                XPL2QinQProvPane.this.applyChanges = true;
                                return true;
                            }
                            case 1: {
                                return true;
                            }
                        }
                        return false;
                    }
                    return true;
                }
            });
            this.portCB.setModel((ComboBoxModel)((Object)serializable));
        }
        IVlanInfo[] iVlanInfoArray = this.eqpmtModel.getVlanDb();
        this.svlanCB.setModel(new DefaultComboBoxModel<IVlanInfo>(iVlanInfoArray));
        this.svlanCBEditor.setModel(new DefaultComboBoxModel<IVlanInfo>(iVlanInfoArray));
        this.intSvlanCBEditor.setModel(new DefaultComboBoxModel<IVlanInfo>(iVlanInfoArray));
        if (this.portModels.length == 0) {
            this.portCB.setEnabled(false);
            this.modeCB.setEnabled(false);
            this.svlanCB.setEnabled(false);
            this.bpduCB.setEnabled(false);
            this.addRowButton.setEnabled(false);
            this.removeRowButton.setEnabled(false);
        } else {
            this.portCB.setEnabled(true);
            this.enableComponent((JComponent)this.modeCB, (IModel)this.nm);
            this.enableComponent((JComponent)this.svlanCB, (IModel)this.nm);
            this.enableComponent((JComponent)this.bpduCB, (IModel)this.nm);
            this.enableComponent(this.addRowButton, (IModel)this.nm);
            this.enableComponent(this.removeRowButton, (IModel)this.nm);
        }
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("calling leavingPage");
        }
        super.leavingPage();
        this.getObsMgr().setPassing(false);
        this.unRegisterWithModel();
    }

    protected void customizedTableSvlan() {
        TableColumn tableColumn = null;
        tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new ColorTableRenderer());
        tableColumn = this.table.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(new ColorTableRenderer());
        if (this.fromNet) {
            tableColumn.setCellRenderer(new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    if (n2 == 1) {
                        this.setBackground(Color.LIGHT_GRAY);
                        this.setHorizontalAlignment(4);
                    }
                    return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
            });
        }
        this.svlanCBEditor = new UComboBox();
        this.svlanCBEditor.setRenderer((ListCellRenderer)this.comboRenderer);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor((JComboBox<?>)this.svlanCBEditor);
        defaultCellEditor.setClickCountToStart(2);
        tableColumn.setCellEditor(defaultCellEditor);
        tableColumn = this.table.getColumnModel().getColumn(2);
        this.operationCBEditor = new UComboBox();
        this.operationCBEditor.setRenderer((ListCellRenderer)this.comboRenderer);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OPERMODE.ADD.getName());
        arrayList.add(OPERMODE.TRANSLATE.getName());
        arrayList.add(OPERMODE.DOUBLE_ADD.getName());
        arrayList.add(OPERMODE.TRANSLATE_ADD.getName());
        this.operationCBEditor.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        defaultCellEditor = new DefaultCellEditor((JComboBox<?>)this.operationCBEditor);
        defaultCellEditor.setClickCountToStart(2);
        tableColumn.setCellEditor(defaultCellEditor);
        tableColumn = this.table.getColumnModel().getColumn(3);
        tableColumn.setCellRenderer(new ColorTableRenderer());
        this.intSvlanCBEditor = new UComboBox();
        this.intSvlanCBEditor.setRenderer((ListCellRenderer)this.comboRenderer);
        defaultCellEditor = new DefaultCellEditor((JComboBox<?>)this.intSvlanCBEditor);
        defaultCellEditor.setClickCountToStart(2);
        tableColumn.setCellEditor(defaultCellEditor);
        tableColumn = this.table.getColumnModel().getColumn(4);
        this.cosCBEditor = new UComboBox();
        this.cosCBEditor.setRenderer((ListCellRenderer)this.comboRenderer);
        ArrayList<Short> arrayList2 = new ArrayList<Short>();
        for (int i = 0; i < 8; ++i) {
            arrayList2.add(new Short((short)i));
        }
        this.cosCBEditor.setModel(new DefaultComboBoxModel<Object>(arrayList2.toArray()));
        defaultCellEditor = new DefaultCellEditor((JComboBox<?>)this.cosCBEditor);
        defaultCellEditor.setClickCountToStart(2);
        tableColumn.setCellEditor(defaultCellEditor);
    }

    public void dispose() {
        if (this._obsMgr != null) {
            this._obsMgr.reset();
        }
        super.dispose();
    }

    public void destroy() {
        if (this.dataSvlanModel != null) {
            this.dataSvlanModel.removeTableModelListener(this);
            this.dataSvlanModel.dispose();
        }
        super.destroy();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataSvlanModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void applyChangesToModel() throws Exception {
        PortModel portModel = (PortModel)this.portCB.getSelectedItem();
        XPL2LineModel xPL2LineModel = (XPL2LineModel)portModel.getInterfaceModel();
        XPL2Layer2LineModel xPL2Layer2LineModel = xPL2LineModel.getLayer2LineModel();
        sQinQInfo sQinQInfo2 = xPL2Layer2LineModel.getQinQInfo();
        if (this.checkDiplayWarningMsgAndIfToContinue(portModel, this.modeCB.getSelectedIndex() == 0)) {
            if (this.bpduCB.getSelectedIndex() == 0) {
                xPL2Layer2LineModel.setBpdu(Boolean.TRUE);
            } else {
                xPL2Layer2LineModel.setBpdu(Boolean.FALSE);
            }
            if (this.modeCB.getSelectedIndex() == 0) {
                sQinQInfo2.qinqMode = eQinQMode.TRASPARENT_MODE;
                IVlanInfo[] iVlanInfoArray = this.eqpmtModel.getVlanDb();
                if (iVlanInfoArray.length == 0) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NO_VLAN_VLAN_DB_EMPTY);
                    this.refresh();
                    return;
                }
                sQinQInfo2.trasparentSvlanId = ((IVlanInfo)this.svlanCB.getSelectedItem()).getVlanId();
                xPL2Layer2LineModel.setQinQInfo(sQinQInfo2);
            } else {
                sQinQInfo2.qinqMode = eQinQMode.SELECTIVE_MODE;
                xPL2Layer2LineModel.setQinQInfo(sQinQInfo2);
                xPL2Layer2LineModel.setVlanCrossInfoList(this.dataSvlanModel.getVlanCrossInfoList());
            }
            this.resetDirty();
        }
    }

    public boolean checkDiplayWarningMsgAndIfToContinue(PortModel portModel, boolean bl) {
        block7: {
            try {
                if (portModel.getAdminState() != 1) {
                    XPL2LineModel xPL2LineModel = (XPL2LineModel)portModel.getInterfaceModel();
                    XPL2Layer2LineModel xPL2Layer2LineModel = xPL2LineModel.getLayer2LineModel();
                    sQinQInfo sQinQInfo2 = xPL2Layer2LineModel.getQinQInfo();
                    short s = 0;
                    if (bl) {
                        s = ((IVlanInfo)this.svlanCB.getSelectedItem()).getVlanId();
                    }
                    if (!bl && this.dataSvlanModel.isVlanCrossInfoListUpdated() || bl && sQinQInfo2.trasparentSvlanId != s && sQinQInfo2.qinqMode == eQinQMode.TRASPARENT_MODE) {
                        return ErrorMsg.displayWarningYesNo((Component)((Object)this), (EID)EMC.WID_SVLAN_SETTING, "Warning Message", "QinQ");
                    }
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (db.on()) {
                    db.println("NoSuchInterface caught in checkDiplayWarningMsgAndIfToContinue() " + (Object)((Object)noSuchInterface));
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!db.on()) break block7;
                db.println("WrongInterfaceType caught in checkDiplayWarningMsgAndIfToContinue() " + (Object)((Object)wrongInterfaceType));
            }
        }
        return true;
    }

    private void reset() {
        block2: {
            try {
                this.initQinQInfoFromNet();
                this.dataSvlanModel.clearSvlanCrossInfoList();
                this.refreshFromModel();
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("Exception caught in reset() " + exception);
            }
        }
    }

    public void refreshFromModel() throws Exception {
        this.portModels = this.eqpmtModel.getPortModels();
        this.linesModels = this.eqpmtModel.getXPL2EtherLines();
        this.layer2Models = this.eqpmtModel.getXPL2Layer2EtherLines();
        int n = this.portCB.getSelectedIndex();
        if (!this.isProvPaneDirty()) {
            this.setUpArrayAndComboBoxes();
        }
        if (n != -1 && this.portCB.getModel().getSize() > n) {
            this.portCB.setSelectedIndex(n);
        }
        if (this.fromNet) {
            this.portCB.setEnabled(false);
            this.refreshFromModelSelectItemNet();
        } else {
            this.refreshFromModelSelectItem();
        }
    }

    public void refreshFromModelSelectItem() throws Exception {
        PortModel portModel;
        if (this.portModels.length != 0 && ((XPL2ModuleModel)(portModel = (PortModel)this.portCB.getSelectedItem()).getModuleModel()).isL2Switch()) {
            XPL2LineModel xPL2LineModel = (XPL2LineModel)portModel.getInterfaceModel();
            XPL2Layer2LineModel xPL2Layer2LineModel = xPL2LineModel.getLayer2LineModel();
            sQinQInfo sQinQInfo2 = null;
            try {
                sQinQInfo2 = xPL2Layer2LineModel.getQinQInfo();
            }
            catch (NoSuchInterface noSuchInterface) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
                return;
            }
            if (xPL2Layer2LineModel.getBpdu().booleanValue()) {
                this.bpduCB.setSelectedIndex(0);
            } else {
                this.bpduCB.setSelectedIndex(1);
            }
            if (sQinQInfo2.qinqMode == eQinQMode.SELECTIVE_MODE) {
                this.prepareTabForSelectiveMode();
            } else {
                this.prepareTabForTransparentMode(sQinQInfo2.trasparentSvlanId);
            }
        }
    }

    public void refreshFromModelSelectItemNet() throws Exception {
        if (this.portModels.length != 0) {
            if (this.qinqInfoFromNet.getQinQBPDU()) {
                this.bpduCB.setSelectedIndex(0);
            } else {
                this.bpduCB.setSelectedIndex(1);
            }
            if (this.qinqInfoFromNet.getQinQMode() == 0) {
                this.prepareTabForSelectiveMode();
            } else {
                this.prepareTabForTransparentMode(this.selSVLANId);
            }
        }
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.XPL2QinQProvPane;
    }

    public void update(Observable observable, Object object) {
        if (object instanceof DwdmLineUpdate) {
            this.requestRefresh(observable, this.getEtherPortUpdateThread(observable));
        }
        if ((observable instanceof PortModel || observable instanceof XPL2LineModel || observable instanceof XPL2Layer2LineModel || observable instanceof XPL2ModuleModel) && object instanceof Integer) {
            if (object.equals(ModelUpdateType.DELETED)) {
                this.resetDirty();
            }
            this.requestRefresh(observable, this.getEtherPortUpdateThread(observable));
        }
    }

    private Runnable getEtherPortUpdateThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                try {
                    XPL2QinQProvPane.this.refreshEtherPortFromUpdates(observable);
                }
                catch (Exception exception) {
                    db.fine("Caught " + exception + " in Refreshing XPL2QinQProvPane");
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshEtherPortFromUpdates(Observable observable) {
        XPL2QinQProvPane xPL2QinQProvPane = this;
        synchronized (xPL2QinQProvPane) {
            if (this.dialogDisplayed) {
                return;
            }
            this.stopTableCellEditing();
            if (this.isProvPaneDirty()) {
                this.dialogDisplayed = true;
                switch (CerentDialog.questionDialog((Component)((Object)this), (String)"New update(s) have arrived.  Is it OK to apply these changes before updating?", (String)"New Updates")) {
                    case 0: {
                        this.apply();
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.unRegisterWithModel();
                        this.refresh();
                        this.registerWithModel();
                    }
                }
                this.dialogDisplayed = false;
            } else {
                this.unRegisterWithModel();
                this.refresh();
                this.registerWithModel();
            }
        }
    }

    public ComboBoxRenderer getComboRenderer() {
        return this.comboRenderer;
    }

    class VetoableComboBoxModel
    extends DefaultComboBoxModel {
        private ArrayList<VetoableComboBoxSelectionListener> selectionListeners;

        public VetoableComboBoxModel() {
            this.selectionListeners = new ArrayList();
        }

        public VetoableComboBoxModel(Object[] objectArray) {
            super(objectArray);
            this.selectionListeners = new ArrayList();
        }

        public void addVetoableSelectionListener(VetoableComboBoxSelectionListener vetoableComboBoxSelectionListener) {
            this.selectionListeners.add(vetoableComboBoxSelectionListener);
        }

        public void removeVetoableSelectionListener(VetoableComboBoxSelectionListener vetoableComboBoxSelectionListener) {
            this.selectionListeners.remove(vetoableComboBoxSelectionListener);
        }

        protected boolean fireVetoableSelectionChange(Object object) {
            boolean bl = true;
            VetoableChangeEvent vetoableChangeEvent = new VetoableChangeEvent(this, object);
            for (VetoableComboBoxSelectionListener vetoableComboBoxSelectionListener : this.selectionListeners) {
                bl &= vetoableComboBoxSelectionListener.selectionChanged(vetoableChangeEvent);
            }
            return bl;
        }

        public void setSelectedItem(Object object) {
            Object object2 = this.getSelectedItem();
            if (this.fireVetoableSelectionChange(object)) {
                if (XPL2QinQProvPane.this.applyChanges) {
                    XPL2QinQProvPane.this.apply();
                    XPL2QinQProvPane.this.applyChanges = false;
                }
                super.setSelectedItem(object);
                try {
                    XPL2QinQProvPane.this.refreshFromModelSelectItem();
                }
                catch (Exception exception) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
            } else {
                super.setSelectedItem(object2);
            }
        }
    }

    static interface VetoableComboBoxSelectionListener
    extends EventListener {
        public boolean selectionChanged(VetoableChangeEvent var1);
    }

    class VetoableChangeEvent
    extends ChangeEvent {
        private Object newValue;

        public VetoableChangeEvent(Object object, Object object2) {
            super(object);
            this.newValue = object2;
        }

        public Object getNewValue() {
            return this.newValue;
        }
    }

    class ColorTableRenderer
    extends DefaultTableCellRenderer {
        public ColorTableRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = jTable.convertColumnIndexToModel(n2);
            if (n3 == 3) {
                TableModel tableModel = jTable.getModel();
                if (tableModel.getValueAt(n, 2).equals(OPERMODE.ADD.getName()) || tableModel.getValueAt(n, 2).equals(OPERMODE.TRANSLATE.getName())) {
                    component.setBackground((Color)UIManager.get("Label.disabledForeground"));
                } else if (!bl) {
                    component.setBackground((Color)UIManager.get("List.textBackground"));
                }
            } else if (n3 == 0) {
                TableModel tableModel = jTable.getModel();
                if (tableModel.getValueAt(n, 2).equals(OPERMODE.DOUBLE_ADD.getName())) {
                    component.setBackground((Color)UIManager.get("Label.disabledForeground"));
                } else if (!bl) {
                    component.setBackground((Color)UIManager.get("List.textBackground"));
                }
            }
            return component;
        }
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object == null) {
                this.setText("");
                return this;
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (object instanceof XPL2LineModel) {
                XPL2LineModel xPL2LineModel = (XPL2LineModel)object;
                EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
                try {
                    this.setText(entityCellRenderer.getPortString((IEntityModel)xPL2LineModel.getPort(), false));
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
            } else if (object instanceof PortModel) {
                IPortModel iPortModel = (IPortModel)object;
                EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
                this.setText(entityCellRenderer.getPortString((IEntityModel)iPortModel, false));
            } else if (object instanceof IVlanInfo) {
                this.setText(((IVlanInfo)object).getVlanId() + "");
            } else if (object instanceof Short) {
                this.setText(((Short)object).toString());
            } else if (object instanceof String) {
                this.setText((String)object);
            }
            return this;
        }
    }
}

