/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.Common.sEtherMacAddr;
import cerent.cms.idl.EtherL2Media.sMacInfo;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.xpl2.XPL2MacFilterTableModel;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;

public class XPL2SecurityTableModel
extends AbstractTableModel
implements Observer {
    public static final int PORT_INDEX = 0;
    public static final int MAC_ADDRESS_INDEX = 1;
    public static final int ALLOWED_INDEX = 2;
    static final String[] columnNames = new String[]{"Port", "MAC Address", "Allowed"};
    public static final int NUMBER_OF_BYTE_MAC = 6;
    public static final int CONTROL_OF_BYTE_MAC = 5;
    private XPL2ModuleModel eqpmtModel = null;
    private XPL2LineModel[] lineModels = null;
    private sMacInfo[] macInfoList = null;
    private EntityCellRenderer myPortRenderer = new EntityCellRenderer(false);
    private boolean[][] isDirty = null;
    private int numLines = 0;
    private static final SDebug db = new SDebug("XPL2SecurityTableModel");

    public XPL2SecurityTableModel(XPL2ModuleModel xPL2ModuleModel, XPL2LineModel[] xPL2LineModelArray) {
        this.eqpmtModel = xPL2ModuleModel;
        this.refreshMyLines(xPL2LineModelArray);
    }

    public void refreshMyLines(XPL2LineModel[] xPL2LineModelArray) {
        if (this.lineModels != null) {
            this.unRegisterWithLineModels();
        }
        this.lineModels = xPL2LineModelArray;
        this.numLines = this.lineModels.length;
        this.macInfoList = new sMacInfo[this.numLines];
        this.numLines = this.lineModels.length;
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.resetDirty();
        this.registerWithLineModels();
        this.fireTableDataChanged();
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.lineModels != null && this.numLines > 0 && AbstractPane.isUserAuthorized(this.lineModels[0], SecurityLevel.PROVISIONING)) {
            return n2 == 2;
        }
        return false;
    }

    public boolean flowControlChanged() {
        return false;
    }

    public boolean isCellDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public String getColumnName(int n) {
        if (n >= 0 && n < columnNames.length) {
            return columnNames[n];
        }
        return null;
    }

    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 2: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    public Object getValueAt(int n, int n2) {
        block9: {
            try {
                switch (n2) {
                    case 0: {
                        return this.getLineNumber(n);
                    }
                    case 1: {
                        String string = "";
                        if (this.macInfoList[n].macAddrFilterTable[0] != null) {
                            string = XPL2MacFilterTableModel.convertMacToString(this.macInfoList[n].macAddrFilterTable[0].addr);
                            if (this.macInfoList[n].macAddrFilterTable.length > 1) {
                                string = string + " ...";
                            }
                        }
                        return string;
                    }
                    case 2: {
                        return new Boolean(this.macInfoList[n].macAddrFilterMode);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block9;
                db.println("Error in getValueAt in XPL2SecurityTableModel " + exception);
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.macInfoList[n].macAddrFilterMode = (Boolean)object;
                this.isDirty[n][n2] = true;
                this.fireTableCellUpdated(n, n2);
                break;
            }
            default: {
                return;
            }
        }
    }

    private String getLineNumber(int n) {
        try {
            IPortModel iPortModel = this.lineModels[n].getPortModel();
            return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
        }
        catch (Exception exception) {
            if (XPL2SecurityTableModel.db.on) {
                KDebug.printStackTrace((Throwable)exception);
            }
            return "unknown";
        }
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public void resetDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshLineFromModel(int n) {
        block2: {
            try {
                this.resetLineCache(n);
                this.fireTableRowsUpdated(n, n);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                KDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private sMacInfo getMacInfoFromModel(int n) throws NoSuchInterface, WrongInterfaceType {
        sMacInfo sMacInfo2 = this.lineModels[n].getMacInfo();
        return sMacInfo2;
    }

    public void applyToModel(int n) throws Exception {
        if (this.isDirty[n][1] || this.isDirty[n][2]) {
            this.lineModels[n].setMacInfo(this.macInfoList[n]);
        }
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void refreshFromModel() throws Exception {
        this.refreshMyLines(this.eqpmtModel.getXPL2EtherLines());
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    protected void resetLineCache(int n) throws Exception {
        this.macInfoList[n] = this.getMacInfoFromModel(n);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public sEtherMacAddr[] getMacTable(int n) {
        return this.macInfoList[n].macAddrFilterTable;
    }

    public void updateMacTable(sEtherMacAddr[] sEtherMacAddrArray, int n) {
        this.macInfoList[n].macAddrFilterTable = sEtherMacAddrArray;
        this.isDirty[n][1] = true;
        this.fireTableCellUpdated(n, 1);
    }

    private void registerWithLineModels() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver(this);
        }
    }

    private void unRegisterWithLineModels() {
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].deleteObserver(this);
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            int n;
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            if ((n = Arrays.asList(this.lineModels).indexOf(observable)) != -1) {
                this.refreshLineFromModel(n);
            }
        }
    }

    public void dispose() {
        this.unRegisterWithLineModels();
    }
}

