/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.PortModel;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.xpl2.XPL2SvlanTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class XPL2SvlanProvPane
extends NodeProvPane
implements PropertyChangeListener,
TableModelListener {
    protected XPL2SvlanTableModel dataModel = null;
    protected XPL2ModuleModel eqpmtModel = null;
    protected XPL2LineModel[] lineModels = null;
    protected PortModel[] portModels = null;
    private ObservableManager _obsMgr;
    private static final SDebug db = new SDebug("XPL2SvlanProvPane");

    public XPL2SvlanProvPane(String string, TabbedView tabbedView, XPL2ModuleModel xPL2ModuleModel) {
        super(string, tabbedView);
        this.portModels = xPL2ModuleModel.getXPL2EtherPorts();
        this.lineModels = xPL2ModuleModel.getXPL2NNILines();
        this.eqpmtModel = xPL2ModuleModel;
        if (this.eqpmtModel == null || this.portModels == null || this.lineModels == null) {
            if (db.on()) {
                db.println("Error during initialization");
                db.println("eqpmtModel=" + this.eqpmtModel + " portModels=" + this.portModels + " lineModels=" + this.lineModels);
            }
            return;
        }
        this.dataModel = new XPL2SvlanTableModel(this.eqpmtModel, this.portModels, this.lineModels);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.customizedProvPane();
        this.add((Component)uScrollPane);
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        if (db.on()) {
            db.println("calling enteringPage");
        }
        this.lineModels = this.eqpmtModel.getXPL2NNILines();
        this.dataModel.dispose();
        this.dataModel = new XPL2SvlanTableModel(this.eqpmtModel, this.portModels, this.lineModels);
        this.dataModel.addTableModelListener(this);
        this.table.setModel(this.dataModel);
        this.dataModel.refreshFromModel();
        this.customizedProvPane();
        super.enteringPage();
        this.getObsMgr().setPassing(true);
        this.registerWithModel();
    }

    public void leavingPage() throws Exception {
        this.getObsMgr().setPassing(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("calling leavingPage");
        }
        super.leavingPage();
        this.unRegisterWithModel();
    }

    protected void registerWithModel() {
        int n;
        super.registerWithModel();
        for (n = 0; n < this.portModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.portModels[n]));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.lineModels[n]));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.lineModels[n].getLayer2LineModel()));
        }
    }

    protected void unRegisterWithModel() {
        int n;
        super.registerWithModel();
        for (n = 0; n < this.portModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.portModels[n]));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.lineModels[n]));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.lineModels[n].getLayer2LineModel()));
        }
    }

    private ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    protected void customizedProvPane() {
        TableColumn tableColumn = null;
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        for (int i = 0; i < this.dataModel.getColumnCount(); ++i) {
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(i));
            tableColumn.setPreferredWidth(120);
        }
        this.table.sizeColumnsToFit(-1);
    }

    public void dispose() {
        if (this._obsMgr != null) {
            this._obsMgr.reset();
        }
        super.dispose();
    }

    public void destroy() {
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.dispose();
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    public void applyChangesToModel() throws Exception {
        if (this.checkDiplayWarningMsgAndIfToContinue()) {
            for (int i = 0; i < this.dataModel.getColumnCount(); ++i) {
                this.dataModel.applyToModel(i);
            }
            this.resetDirty();
        }
    }

    public boolean checkDiplayWarningMsgAndIfToContinue() {
        block3: {
            try {
                if (this.dataModel.isSVLANRemoved()) {
                    return ErrorMsg.displayWarningYesNo((Component)((Object)this), (EID)EMC.WID_SVLAN_SETTING, "Warning Message", "SVLAN");
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) break block3;
                db.println("NoSuchInterface caught in checkDiplayWarningMsgAndIfToContinue() " + (Object)((Object)noSuchInterface));
            }
        }
        return true;
    }

    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromModel();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.XPL2SvlanProvPane;
    }
}

