/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml.helper;

import cerent.cms.model.CTCUserException;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.xml.MethodState;
import cerent.cms.xml.XmlNodeFactory;
import cerent.cms.xml.helper.BaseModelHelper;
import cerent.cms.xml.helper.BaseObjectHelper;
import cerent.cms.xml.helper.FakeModelArrayHelper;
import cerent.util.xml.DOMUtil;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ModelAsIdHelper
extends BaseObjectHelper {
    public static Node objectToXml(Object object, String string, Node node) throws CTCUserException {
        Node node2;
        if (db.on()) {
            db.println("[ModelAsIdHelper] objectToXml(" + object + ", " + string + ") ");
        }
        Node node3 = null;
        if (string != null) {
            node3 = XmlNodeFactory.makeElement(node, string);
            node2 = node3;
        } else {
            node2 = node;
        }
        if (object != null) {
            if (!(object instanceof IModel)) {
                throw new CTCUserException(object.getClass().getName() + " not an instance of IModel");
            }
            IModel iModel = (IModel)object;
            node3 = BaseModelHelper.printModelAsID(iModel, node2);
            if (string != null) {
                DOMUtil.appendChild((Node)node2, (Node)node3);
                node3 = node2;
            }
        } else if (db.on()) {
            db.println("Object is NULL");
        }
        return node3;
    }

    public static Object nodeToObject(Node node, String string, Object object) throws CTCUserException {
        Object object2 = null;
        Iterator iterator = DOMUtil.getChildElementsIterator((Node)node);
        if (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            object2 = ModelAsIdHelper.nodeToObject(node2, object);
        }
        return object2;
    }

    public static Object nodeToObject(Node node, Object object) throws CTCUserException {
        Model model = null;
        if (node != null) {
            Object object2;
            NodeModelDelegate nodeModelDelegate;
            if (object instanceof NonCachedValue) {
                nodeModelDelegate = ((NonCachedValue)object).getNode();
            } else if (object instanceof MethodState) {
                object2 = (Model)((MethodState)object).getInstance();
                nodeModelDelegate = (NodeModelDelegate)((Model)object2).getNodeModel();
            } else {
                throw new CTCUserException("Unknown Object received");
            }
            object2 = (Element)node;
            int n = Integer.parseInt(object2.getAttribute("index"));
            String string = object2.getTagName();
            String string2 = Model.createInstanceName(string, n);
            Throwable throwable = null;
            try {
                model = Model.getInstance((INodeModel)nodeModelDelegate, string2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            if (throwable != null) {
                db.println("getInstance error: " + throwable);
                throw new CTCUserException(ModelAsIdHelper.createModelMissingError(string, n), throwable);
            }
            if (model == null) {
                throw new CTCUserException(ModelAsIdHelper.createModelMissingError(string, n));
            }
        }
        return model;
    }

    private static String createModelMissingError(String string, int n) {
        return "Model could not be found for modelName = " + string + " index = " + n;
    }

    public static Object toSchema(String string, String string2) throws CTCUserException {
        return FakeModelArrayHelper.toSchema(string, string2);
    }
}

