/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import java.awt.Toolkit;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class SnmpV3RowComboBox
extends JComboBox {
    private static String lettersString = "_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTURVWXYZ";
    private static String digitsString = "0123456789";
    private static int MAX_LENGTH = 32;

    public SnmpV3RowComboBox(Object[] objectArray) {
        super(objectArray);
        this.init(MAX_LENGTH);
    }

    public SnmpV3RowComboBox() {
        this.init(MAX_LENGTH);
    }

    public SnmpV3RowComboBox(Object[] objectArray, int n) {
        super(objectArray);
        this.init(n);
    }

    public void init(int n) {
        JTextField jTextField;
        if (this.getEditor() != null && (jTextField = (JTextField)this.getEditor().getEditorComponent()) != null) {
            jTextField.setDocument(this.createDefaultModel(n));
        }
    }

    protected Document createDefaultModel(int n) {
        return new LetterOrDigitDocument(n);
    }

    static class LetterOrDigitDocument
    extends PlainDocument {
        int documentMaxLength;

        public LetterOrDigitDocument(int n) {
            this.documentMaxLength = n;
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            boolean bl = true;
            if (string != null) {
                if (string.length() + this.getLength() > this.documentMaxLength) {
                    bl = false;
                } else {
                    for (int i = 0; bl && i < string.length(); ++i) {
                        char c = string.charAt(i);
                        if (-1 != lettersString.indexOf(c) || -1 != digitsString.indexOf(c)) continue;
                        bl = false;
                    }
                }
            }
            if (bl) {
                super.insertString(n, string, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

