/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui.row;

import cerent.util.SDebug;
import cerent.util.gui.row.ColumnEditor;
import cerent.util.gui.row.DefaultColumnRenderer;
import java.awt.Component;
import java.util.Comparator;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;

public class DefaultColumnEditor
extends DefaultColumnRenderer
implements ColumnEditor {
    private Object currentEditObject;
    private Component currentComponent;
    private TableCellEditor editor;
    private static SDebug db = new SDebug("DefaultColumnEditor");

    public DefaultColumnEditor(String string, int n, int n2, boolean bl, Class clazz, AbstractEditableColumnAdapter abstractEditableColumnAdapter, Comparator comparator, JComponent jComponent) {
        super(string, n, n2, bl, clazz, abstractEditableColumnAdapter, comparator);
        DefaultCellEditor defaultCellEditor = null;
        if (jComponent instanceof JCheckBox) {
            defaultCellEditor = new DefaultCellEditor((JCheckBox)jComponent);
        } else if (jComponent instanceof JComboBox) {
            defaultCellEditor = new DefaultCellEditor((JComboBox)jComponent);
        } else if (jComponent instanceof JTextField) {
            defaultCellEditor = new DefaultCellEditor((JTextField)jComponent);
        } else {
            throw new IllegalArgumentException("unsupported cell editor component: " + jComponent);
        }
        this.editor = defaultCellEditor;
        defaultCellEditor.setClickCountToStart(2);
    }

    public DefaultColumnEditor(String string, int n, int n2, boolean bl, Class clazz, AbstractEditableColumnAdapter abstractEditableColumnAdapter, Comparator comparator, TableCellEditor tableCellEditor) {
        super(string, n, n2, bl, clazz, abstractEditableColumnAdapter, comparator);
        this.editor = tableCellEditor;
        if (tableCellEditor instanceof DefaultCellEditor) {
            ((DefaultCellEditor)tableCellEditor).setClickCountToStart(2);
        }
    }

    AbstractEditableColumnAdapter getEditableColumnAdapter() {
        return (AbstractEditableColumnAdapter)super.getAdapter();
    }

    public void setColumnValue(Object object, Object object2) {
        this.getEditableColumnAdapter().setColumnData(object, object2);
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.currentEditObject = object;
        this.currentComponent = this.editor.getTableCellEditorComponent(jTable, this.getAdapter().getColumnData(object), bl, n, n2);
        return this.getEditableColumnAdapter().postProcess(this.currentComponent);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        return this.getEditableColumnAdapter().postProcess(super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2));
    }

    public Component getComponent() {
        return this.currentComponent;
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.editor.addCellEditorListener(cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.editor.removeCellEditorListener(cellEditorListener);
    }

    public void cancelCellEditing() {
        this.editor.cancelCellEditing();
    }

    public Object getCellEditorValue() {
        return this.decode(this.editor.getCellEditorValue());
    }

    protected Object decode(Object object) {
        Object object2 = object;
        if (object == null) {
            return object2;
        }
        Class clazz = this.getColumnClass();
        if (clazz.isInstance(object)) {
            return object2;
        }
        if (Number.class.isAssignableFrom(clazz) && object instanceof String) {
            String string = (String)object;
            if (Integer.class.equals((Object)clazz)) {
                object2 = Integer.decode(string);
            } else if (Long.class.equals((Object)clazz)) {
                object2 = Long.decode(string);
            } else if (Short.class.equals((Object)clazz)) {
                object2 = Short.decode(string);
            }
        }
        return object2;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return eventObject == null ? false : this.editor.isCellEditable(eventObject);
    }

    public boolean isCellEditable() {
        return true;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return this.editor.shouldSelectCell(eventObject);
    }

    public boolean stopCellEditing() {
        Object object;
        boolean bl;
        block9: {
            bl = true;
            object = null;
            try {
                object = this.getCellEditorValue();
            }
            catch (RuntimeException runtimeException) {
                if (!db.on()) break block9;
                SDebug.printStackTrace((Throwable)runtimeException);
                return false;
            }
        }
        AbstractEditableColumnAdapter abstractEditableColumnAdapter = this.getEditableColumnAdapter();
        try {
            String string = abstractEditableColumnAdapter.isValidColumnData(this.currentEditObject, object);
            if (string == null) {
                if (db.on()) {
                    db.println("value: '" + object + "' deemed valid");
                }
            } else {
                if (db.on()) {
                    db.println("value: '" + object + "' deemed INVALID: " + string);
                }
                bl = this.handleInvalidData(string);
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            bl = this.handleStopCellEditingException(exception);
        }
        return !bl ? false : this.editor.stopCellEditing();
    }

    protected boolean handleStopCellEditingException(Exception exception) {
        this.cancelCellEditing();
        return true;
    }

    protected boolean handleInvalidData(String string) {
        this.cancelCellEditing();
        return true;
    }

    public static abstract class AbstractEditableColumnAdapter
    implements DefaultColumnRenderer.IColumnAdapter {
        public String isValidColumnData(Object object, Object object2) {
            return null;
        }

        public abstract void setColumnData(Object var1, Object var2);

        protected Component postProcess(Component component) {
            return component;
        }
    }
}

