/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.crs.model.parser;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.util.SDebug;
import cerent.util.tty.CLIParsingUtils;
import com.cisco.crs.model.ChassisModel;
import com.cisco.crs.model.EntityTableModel;
import com.cisco.crs.model.ModuleModel;
import com.cisco.crs.model.PlatformNodeModel;
import com.cisco.crs.model.PlimPortId;
import com.cisco.crs.model.PlimPortModel;
import com.cisco.crs.model.PortModel;
import com.cisco.crs.model.SlotModel;
import com.cisco.crs.model.core.CLIResponse;
import com.cisco.crs.model.core.ICLIParser;
import com.cisco.crs.model.parser.IdParser;

public class ShowInventoryParser
implements ICLIParser {
    private EntityTableModel entityTable;
    private SDebug db;

    public ShowInventoryParser(EntityTableModel entityTableModel, SDebug sDebug) {
        this.entityTable = entityTableModel;
        this.db = sDebug;
    }

    public CLIResponse parseResponse(String string) {
        ChassisModel[] chassisModelArray;
        string = CLIParsingUtils.extractCLIResponseFromXMLBody((String)string);
        for (ChassisModel chassisModel : chassisModelArray = this.entityTable.getAllChassis()) {
            chassisModel.markForDeletion();
        }
        PlatformNodeModel platformNodeModel = (PlatformNodeModel)this.entityTable.getNodeModel();
        IdParser idParser = IdParser.instance();
        String[] stringArray = string.split("\\n");
        Object var6_10 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            String[] stringArray2;
            String string3;
            String string4 = stringArray[i];
            String[] stringArray3 = string4.split("\"");
            if (!string4.startsWith("NAME:") || stringArray3.length < 4) continue;
            String string5 = stringArray3[1];
            String string6 = stringArray3[3];
            if (this.getEqTypeFromDesc(string6, string3 = (stringArray2 = (string2 = stringArray[++i]).split(","))[0]) == 329) continue;
            byte[] byArray = idParser.parseID(string5);
            byte by = byArray[0];
            ChassisModel chassisModel = null;
            try {
                chassisModel = this.entityTable.getChassis(by);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                // empty catch block
            }
            if (chassisModel == null) {
                byte[] byArray2 = new byte[]{by};
                chassisModel = new ChassisModel(platformNodeModel, idParser.getInternalID(byArray2), idParser.getIndex(byArray2), 288, (int)by);
                this.entityTable.addEntityModel(chassisModel);
            } else {
                chassisModel.unmarkForDeletion();
            }
            if (byArray.length < 3) continue;
            byte by2 = byArray[1];
            SlotModel slotModel = chassisModel.getSlot(by2);
            if (slotModel == null) {
                byte[] byArray3 = new byte[]{by, by2};
                slotModel = new SlotModel(platformNodeModel, chassisModel, idParser.getInternalID(byArray3), idParser.getIndex(byArray3), 289, by2);
                this.entityTable.addEntityModel(slotModel);
            } else {
                slotModel.unmarkForDeletion();
            }
            byte by3 = byArray[2];
            ModuleModel moduleModel = slotModel.getModuleModel();
            if (moduleModel == null) {
                byte[] byArray4 = new byte[]{by, by2, by3};
                moduleModel = new ModuleModel(platformNodeModel, slotModel, idParser.getInternalID(byArray4), idParser.getIndex(byArray4), this.getEqTypeFromDesc(string6, string3));
                this.entityTable.addEntityModel(moduleModel);
            } else {
                moduleModel.unmarkForDeletion();
            }
            if (byArray.length != 4) continue;
            byte by4 = byArray[3];
            PortModel portModel = moduleModel.getPort(by4);
            if (portModel == null) {
                int n = this.getEqTypeFromDesc(string6, string3);
                if (n != 291) continue;
                portModel = new PlimPortModel(platformNodeModel, moduleModel, idParser.getInternalID(byArray), idParser.getIndex(byArray), n, by4, this.getPlimTypeFromDesc(string6));
                this.entityTable.addEntityModel(portModel);
                continue;
            }
            portModel.unmarkForDeletion();
        }
        for (ChassisModel chassisModel : chassisModelArray = this.entityTable.getAllChassis()) {
            chassisModel.disposeIfMarkedForDeletion();
        }
        this.entityTable.updateCompleted();
        return null;
    }

    private int getEqTypeFromDesc(String string, String string2) {
        if (string.equals("4x10GE PLIM")) {
            return 290;
        }
        if (string.equals("Cisco CRS-1 4 port 10GE (C-band) DWDM PLIM")) {
            return 290;
        }
        if (string.equals("4x10GE PLIM - Optic Port")) {
            return 291;
        }
        if (string.equals("Cisco CRS-1 OC768 (C-band) DWDM PLIM")) {
            return 292;
        }
        if (string.equals("Cisco CRS-1 OC768 DPSK C-BAND STD CHAN PLIM")) {
            return 320;
        }
        if (string.equals("OC768 PLIM")) {
            if (string2.indexOf("DPSK") > -1) {
                return 320;
            }
            return 292;
        }
        if (string.equals("OC768 PLIM - Optic Port")) {
            return 291;
        }
        this.db.warning("Found unmanaged entity \"" + string + "\" with " + string2);
        return 329;
    }

    private PlimPortId.PlimType getPlimTypeFromDesc(String string) {
        if (string.equals("4x10GE PLIM - Optic Port")) {
            return PlimPortId.PlimType.TenGigE;
        }
        if (string.equals("OC768 PLIM - Optic Port")) {
            return PlimPortId.PlimType.POS;
        }
        this.db.warning("Found unmanaged entity");
        return PlimPortId.PlimType.Unknown;
    }
}

