/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.stm1e;

import cerent.cms.idl.If.sInterface;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.Model;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmHoModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import javax.swing.table.AbstractTableModel;

public class STM1EHoProvTableModel
extends AbstractTableModel {
    private TdmHoModel[] model;
    public static final String[] columnNames = new String[]{"VC4 #", "Enable IPPM"};
    private Boolean[] enableIPPM;
    private boolean[][] isDirty;
    private sInterface[] info;
    private int numLines;
    protected INodeModel node = null;
    public static final int LINENUMBER_INDEX = 0;
    public static final int ENABLE_IPPM_INDEX = 1;
    public static final Attribute notAvail = new Attribute("N/A", 0);
    private static final SDebug db = new SDebug("STM1E12HoProvTableModel");

    public STM1EHoProvTableModel(INodeModel iNodeModel, TdmHoModel[] tdmHoModelArray) {
        this.model = tdmHoModelArray;
        this.node = iNodeModel;
        if (tdmHoModelArray == null) {
            if (db.on()) {
                db.println("Model is null");
            }
            this.numLines = 0;
        } else {
            this.numLines = tdmHoModelArray.length;
            this.enableIPPM = new Boolean[this.numLines];
            this.info = new sInterface[this.numLines];
            this.isDirty = new boolean[this.numLines][this.getColumnCount()];
            for (int i = 0; i < this.numLines; ++i) {
                this.enableIPPM[i] = null;
            }
            this.resetDirtyBits();
        }
    }

    private boolean isE4Port(int n) {
        try {
            int n2 = this.model[n].getPortModel().getPayloadType();
            return n2 == 15 || n2 == 16;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public Boolean getEnableIPPM(int n) throws NoSuchInterface, WrongInterfaceType {
        if (null == this.enableIPPM[n]) {
            this.enableIPPM[n] = new Boolean(this.model[n].getIPPMEnabled());
        }
        return this.enableIPPM[n];
    }

    public int getNumLines() {
        return this.numLines;
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    protected TdmLineModel getLineModel(int n) {
        InterfaceModel interfaceModel = this.model[n];
        InterfaceModel interfaceModel2 = interfaceModel.getFirstLowerLayerModels();
        try {
            while (interfaceModel2 != null) {
                interfaceModel = interfaceModel2;
                interfaceModel2 = interfaceModel.getFirstLowerLayerModels();
            }
            return (TdmLineModel)interfaceModel;
        }
        catch (Exception exception) {
            db.println("Caught excpetion in getLineModel");
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.numLines > 0) {
            if (this.isE4Port(n)) {
                return false;
            }
            boolean bl = AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING);
            try {
                if (bl && !this.model[0].getModuleModel().isProtectModule()) {
                    return n2 > 0;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("Caught exception in isCellEditable");
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                return false;
            }
        }
        return false;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    protected sInterface getInfo(int n) throws NoSuchInterface {
        if (this.info[n] == null) {
            this.info[n] = this.model[n].getInfo();
        }
        return this.info[n];
    }

    protected String getLineNumber(int n) throws NoSuchInterface {
        StringBuffer stringBuffer = new StringBuffer();
        this.getInfo(n);
        String string = "VC4";
        if (this.info.length > n && this.info[n] != null) {
            try {
                TDMTerminology tDMTerminology = Model.getTDMTerminology((IModel)this.node);
                string = tDMTerminology.getGeneralTerms(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stringBuffer.append("Line  ");
            stringBuffer.append(this.info[n].portNumber);
            stringBuffer.append(", ");
            stringBuffer.append(string);
            stringBuffer.append(" ");
            short s = (short)this.info[n].muxIndex;
            stringBuffer.append(s);
        }
        return stringBuffer.toString();
    }

    public Class getColumnClass(int n) {
        Class clazz = null;
        switch (n) {
            case 1: {
                clazz = Boolean.class;
                break;
            }
            default: {
                clazz = Object.class;
            }
        }
        return clazz;
    }

    public Object getValueAt(int n, int n2) {
        Object object = null;
        boolean bl = this.isE4Port(n);
        try {
            switch (n2) {
                case 0: {
                    object = this.getLineNumber(n);
                    break;
                }
                case 1: {
                    object = bl ? Boolean.FALSE : this.getEnableIPPM(n);
                    break;
                }
            }
        }
        catch (Exception exception) {
            db.println("Caught exception in getValueAt");
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
        return object;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value " + n + " " + n2);
        }
        switch (n2) {
            case 1: {
                this.enableIPPM[n] = (Boolean)object;
                break;
            }
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    private void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.enableIPPM[i] = null;
        }
        this.resetDirtyBits();
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.enableIPPM[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
        this.fireTableRowsUpdated(n, n);
    }

    public synchronized void setHoModel(TdmHoModel[] tdmHoModelArray) {
        this.model = tdmHoModelArray;
        int n = this.numLines;
        this.numLines = this.model == null ? 0 : this.model.length;
        this.enableIPPM = new Boolean[this.numLines];
        this.info = new sInterface[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        if (db.on()) {
            db.println("Num lines = " + this.numLines + " num columns = " + this.getColumnCount());
        }
        this.refreshFromModel();
        this.fireTableDataChanged();
    }
}

