/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.shelf;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EnvAlarmModel;
import cerent.cms.model.EnvControlModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.ui.IGuestPaneFactory;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.alarmExt.AlarmExtProvPane;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.cms.ui.shelf.AbstractSppTimingProvPane;
import cerent.cms.ui.shelf.GeneralPane;
import cerent.cms.ui.shelf.SecondaryGeneralPane;
import cerent.cms.ui.shelf.SonetSppTimingProvPane;
import cerent.cms.ui.shelf.SppRingPane;
import cerent.cms.ui.shelf.sdh.SdhSppTimingProvPane;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ShelfProvPane
extends AbstractShelfProvPane {
    private HashMap tabMap;

    public ShelfProvPane(String string, TabbedView tabbedView, IGuestPaneFactory iGuestPaneFactory) {
        super(string, tabbedView, iGuestPaneFactory);
    }

    protected void localInit() {
        this.newTab(this.RING_TAB, (Component)((Object)new SppRingPane(this.RING_TAB, this.subTabs)));
        this.newTab("Alarm Extenders", (Component)((Object)new AlarmExtProvPane("Alarm Extenders", this.subTabs, this.getAlarmInput(), this.getControlOutput())));
    }

    protected Pane getGeneralPane(TabbedView tabbedView) {
        if (((IChassisModel)this.getUiModel()).isPowerMonitorSupported()) {
            return new GeneralPane("General", tabbedView);
        }
        return new SecondaryGeneralPane("General", tabbedView);
    }

    protected AbstractSppTimingProvPane getSppTimingPane(String string, TabbedView tabbedView) {
        IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
        if (this.pci.is600() && !this.pci.is600SDH()) {
            return new SonetSppTimingProvPane(string, tabbedView, iChassisModel.getSyncModel(), iChassisModel.getElementModels());
        }
        return new SdhSppTimingProvPane(string, tabbedView, iChassisModel.getSyncModel(), iChassisModel.getElementModels());
    }

    private EnvAlarmModel[] getAlarmInput() {
        IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
        List list = ((EntityModel)((Object)iChassisModel)).getDescendantsOfType(eEqType.ENVIRONMENT_ALARM);
        return list.toArray(new EnvAlarmModel[0]);
    }

    private EnvControlModel[] getControlOutput() {
        IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
        List list = ((EntityModel)((Object)iChassisModel)).getDescendantsOfType(eEqType.ENVIRONMENT_CONTROL);
        return list.toArray(new EnvControlModel[0]);
    }

    protected Map getTabMap() {
        return this.tabMap;
    }

    protected void initPositions() {
        this.tabMap = new HashMap();
        this.tabMap.put("General", new Integer(0));
        this.tabMap.put("Network", new Integer(1));
        this.tabMap.put("OSI", new Integer(2));
        this.tabMap.put(this.RING_TAB, new Integer(3));
        this.tabMap.put("Protection", new Integer(4));
        this.tabMap.put("Security", new Integer(5));
        this.tabMap.put("SNMP", new Integer(6));
        this.tabMap.put("Comm Channels", new Integer(7));
        this.tabMap.put("Timing", new Integer(8));
        this.tabMap.put("Alarm Profiles", new Integer(9));
        this.tabMap.put("Alarm Extenders", new Integer(10));
        this.tabMap.put("Defaults", new Integer(11));
    }
}

