/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.loader;

import cerent.cms.loader.FactoryMap;
import cerent.cms.loader.IElementFactory;
import cerent.cms.loader.INodeFactory;
import cerent.cms.model.Feature;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IProgressManager;
import cerent.cms.ui.IEntityCellRenderer;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.IViewController;
import cerent.launcher.Bootstrap;
import cerent.launcher.CmsClassLoader;
import cerent.launcher.CtcHttpRetriever;
import cerent.util.ConcurrentReaderMap;
import cerent.util.IIPAddressTranslator;
import cerent.util.IPAddressTranslator;
import cerent.util.KDebug;
import cerent.util.SDebug;
import com.cisco.ctc.core.ClassLoaderManager;
import com.cisco.ctc.core.CoreConstants;
import com.cisco.ctc.core.CoreVersionUtil;
import com.cisco.ctc.core.IClassLoaderManager;
import com.cisco.ctc.core.ICoreVersionUtil;
import com.cisco.ctc.core.NETypeEnum;
import java.awt.Image;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;

public class ElementFactory
implements IElementFactory {
    private static final IClassLoaderManager clm = ClassLoaderManager.instance();
    private static final ICoreVersionUtil cvu = CoreVersionUtil.instance();
    private static final String[] StringArrayTemplate = new String[0];
    private static CmsClassLoader myParent = null;
    protected static FactoryMap myFactories = null;
    protected static final String FTG_PKG_PREFIX = "cerent.cms.model.ftg.";
    private static final String FTG_UI_PKG_PREFIX = "cerent.cms.ui.ftg.";
    private static SDebug db = new SDebug("ElementFactory");
    private static ElementFactory instance = new ElementFactory();
    private static ConcurrentReaderMap versionTypeClMap = new ConcurrentReaderMap();
    private static final IIPAddressTranslator trans = IPAddressTranslator.instance();

    public static IElementFactory getInstance() {
        return instance;
    }

    public static final ElementFactory getElementFactoryInstance() {
        return instance;
    }

    protected SDebug getDb() {
        return db;
    }

    public static synchronized void setParent(CmsClassLoader cmsClassLoader) {
        if (myParent == null) {
            myParent = cmsClassLoader;
        }
        if (myFactories == null) {
            myFactories = new FactoryMap();
        }
    }

    protected ElementFactory() {
        SDebug sDebug = this.getDb();
        if (sDebug.on()) {
            sDebug.println("ctor: instance created");
        }
    }

    protected ClassLoader findClassLoader(String string, String string2) throws Exception {
        ClassLoader classLoader;
        SDebug sDebug = this.getDb();
        try {
            String string3;
            Comparable comparable = null;
            boolean bl = false;
            if (string != null) {
                string3 = CtcHttpRetriever.getApiVersion((String)string);
                comparable = cvu.createNeVersionOrdinal(string3);
                bl = cvu.isUnifiedCore(comparable);
            }
            string3 = NETypeEnum.getType((String)string2, (boolean)bl);
            classLoader = clm.getEleClassLoader(string, (NETypeEnum)string3, comparable);
        }
        catch (Exception exception) {
            try {
                URL uRL = new URL(string);
                URL uRL2 = new URL(uRL.getProtocol(), CoreConstants.GetActualAddress((String)uRL.getHost()), uRL.getPort(), uRL.getFile());
                string = uRL2.toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            sDebug.println("!Failed to load any JAR for " + trans.getActualAddressDisplay(string));
            SDebug.printStackTrace((Throwable)exception);
            throw exception;
        }
        if (sDebug.on()) {
            sDebug.println("findClassLoader=" + classLoader);
        }
        return classLoader;
    }

    public IViewController createSVC(IViewController iViewController, INodeModel iNodeModel, IUiToolkit iUiToolkit) {
        SDebug sDebug = this.getDb();
        if (sDebug.on()) {
            sDebug.println("createSVC " + iNodeModel);
        }
        INodeFactory iNodeFactory = myFactories.get(iNodeModel.loader());
        return iNodeFactory.createSVC(iViewController, iNodeModel, iUiToolkit);
    }

    protected Object InvokeFTGCtor(String string, Object object, Class clazz) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Class<?> clazz2 = Class.forName(string);
        Class[] classArray = new Class[]{clazz};
        Constructor<?> constructor = clazz2.getDeclaredConstructor(classArray);
        Object[] objectArray = new Object[]{object};
        return constructor.newInstance(objectArray);
    }

    public INodeModel createNodeModel(String string, int n, String string2, String string3, String string4, String string5, IUiToolkit iUiToolkit, IProgressManager iProgressManager) throws ClassNotFoundException, InstantiationException, IllegalAccessException, MalformedURLException, IOException, Exception {
        SDebug sDebug = this.getDb();
        sDebug.println("createNodeModel: NOT IMPLEMENTED");
        return null;
    }

    public INodeModel createNodeModel(INodeModel iNodeModel, KDebug kDebug, String string, String string2, int n) throws ClassNotFoundException, InstantiationException, IllegalAccessException, MalformedURLException, IOException, Exception {
        SDebug sDebug = this.getDb();
        if (sDebug.on()) {
            sDebug.println("createNodeModel: " + trans.getActualAddressDisplay(string));
        }
        ClassLoader classLoader = null;
        INodeModel iNodeModel2 = iNodeModel.getPeerNode();
        classLoader = iNodeModel2 != null ? iNodeModel2.getNodeModel().getDelegate().getClass().getClassLoader() : this.findClassLoader(string, string2);
        INodeFactory iNodeFactory = this.getNodeFactory(classLoader);
        INodeModel iNodeModel3 = iNodeFactory.createNodeModel(iNodeModel, kDebug, string, n);
        boolean bl = false;
        try {
            if (!iNodeModel3.provides(Feature.FTG)) {
                bl = true;
            }
        }
        catch (AbstractMethodError abstractMethodError) {
            bl = true;
        }
        if (bl) {
            iNodeModel3 = (INodeModel)this.InvokeFTGCtor("cerent.cms.model.ftg.OldNodeModelDelegateAdapter", iNodeModel3, INodeModel.class);
        }
        return iNodeModel3;
    }

    public IEntityCellRenderer createEntityCellRenderer(INodeModel iNodeModel, String string) {
        INodeFactory iNodeFactory = myFactories.get(iNodeModel.loader());
        IEntityCellRenderer iEntityCellRenderer = iNodeFactory.createEntityCellRenderer(string);
        return iEntityCellRenderer;
    }

    public IEntityCellRenderer createEntityCellRenderer(IModuleModel iModuleModel) {
        return this.createEntityCellRenderer(iModuleModel.getNodeModel());
    }

    public IEntityCellRenderer createEntityCellRenderer(INodeModel iNodeModel) {
        SDebug sDebug = this.getDb();
        INodeFactory iNodeFactory = myFactories.get(iNodeModel.loader());
        IEntityCellRenderer iEntityCellRenderer = iNodeFactory.createEntityCellRenderer();
        if (!Feature.delegateProvides((INodeModel)iNodeModel, (Feature)Feature.FTG)) {
            try {
                iEntityCellRenderer = (IEntityCellRenderer)this.InvokeFTGCtor("cerent.cms.ui.ftg.OldEntityCellRendererAdapter", iEntityCellRenderer, IEntityCellRenderer.class);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                sDebug.severe("Can't create the EntityCellRendererAdapter!");
                return null;
            }
        }
        return iEntityCellRenderer;
    }

    public IEntityCellRenderer createEntityCellRenderer(IModuleModel iModuleModel, boolean bl) {
        INodeFactory iNodeFactory = myFactories.get(iModuleModel.getNodeModel().loader());
        return iNodeFactory.createEntityCellRenderer(bl);
    }

    public boolean isCardViewAvailable(IModuleModel iModuleModel) {
        INodeFactory iNodeFactory = myFactories.get(iModuleModel.getNodeModel().loader());
        return iNodeFactory.isCardViewAvailable(iModuleModel);
    }

    public String getBuildInfo(INodeModel iNodeModel) {
        ClassLoader classLoader = iNodeModel.loader();
        String string = classLoader == null ? "Unavailable" : cvu.getBuildInfo(classLoader);
        return string;
    }

    public Image[] getIconSet(INodeModel iNodeModel) {
        INodeFactory iNodeFactory = myFactories.get(iNodeModel.loader());
        Image[] imageArray = null;
        if (iNodeFactory != null) {
            imageArray = Feature.provides((INodeModel)iNodeModel, (Feature)Feature.OCHNC_PROVISIONING) ? iNodeFactory.getIconSet(iNodeModel) : iNodeFactory.getIconSet();
        }
        return imageArray;
    }

    public String getConstString(INodeModel iNodeModel, Class clazz, int n) {
        INodeFactory iNodeFactory = myFactories.get(iNodeModel.loader());
        if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.FTG)) {
            return iNodeFactory.getConstString(iNodeModel, clazz, n);
        }
        return iNodeFactory.getConstString(clazz, n);
    }

    public void removeClassLoader(ClassLoader classLoader) throws Exception {
        myFactories.remove(classLoader);
        clm.removeClassLoader(classLoader);
    }

    private static String getKey(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(";");
        stringBuffer.append("neType");
        return stringBuffer.toString();
    }

    protected ClassLoader getClassLoader(String string, String string2, String string3) throws Exception {
        boolean bl = Bootstrap.isUnifiedEle((String)string2);
        String string4 = bl ? string2 : ElementFactory.getKey(string2, string3);
        ClassLoader classLoader = (ClassLoader)versionTypeClMap.get((Object)string4);
        if (classLoader == null) {
            classLoader = this.findClassLoader(string, string3);
            versionTypeClMap.put((Object)string4, (Object)classLoader);
        }
        return classLoader;
    }

    private INodeFactory getNodeFactoryByKeys(String string, String string2, String string3) throws Exception {
        ClassLoader classLoader = this.getClassLoader(string, string2, string3);
        INodeFactory iNodeFactory = this.getNodeFactory(classLoader);
        return iNodeFactory;
    }

    protected INodeFactory getNodeFactory(ClassLoader classLoader) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        INodeFactory iNodeFactory = myFactories.get(classLoader);
        if (iNodeFactory == null) {
            Class<?> clazz = classLoader.loadClass(this.getINodeFactoryClassName());
            try {
                iNodeFactory = (INodeFactory)clazz.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                SDebug.printStackTrace((Throwable)illegalAccessException);
                throw illegalAccessException;
            }
            catch (InstantiationException instantiationException) {
                SDebug.printStackTrace((Throwable)instantiationException);
                throw instantiationException;
            }
            catch (RuntimeException runtimeException) {
                SDebug.printStackTrace((Throwable)runtimeException);
                throw runtimeException;
            }
            myFactories.put(classLoader, iNodeFactory);
            if (db.on()) {
                db.println("createNodeFactory: cl=> " + classLoader + ", nf=> " + iNodeFactory);
            }
        }
        return iNodeFactory;
    }

    protected String getINodeFactoryClassName() {
        if (db.on()) {
            db.println("using cerent.cms.loader.NodeFactory");
        }
        return "cerent.cms.loader.NodeFactory";
    }

    public boolean provides(Feature feature, String string, String string2, String string3) throws Exception {
        INodeFactory iNodeFactory = this.getNodeFactoryByKeys(string, string2, string3);
        return iNodeFactory.provides(feature);
    }

    public Boolean isKnownDynamic(Feature feature, String string, String string2, String string3) throws Exception {
        INodeFactory iNodeFactory = this.getNodeFactoryByKeys(string, string2, string3);
        return iNodeFactory.isKnownDynamic(feature);
    }

    public void setDynamic(Feature feature, boolean bl, String string, String string2, String string3) throws Exception {
        INodeFactory iNodeFactory = this.getNodeFactoryByKeys(string, string2, string3);
        iNodeFactory.setDynamic(feature, bl);
    }
}

