/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.ncp.CircuitMergeError;
import cerent.cms.ncp.CircuitMergeSplicer;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitMergeOperator;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.NotFullyMerged;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircuitMergeManager {
    public static final int STRICT_MERGE = 0;
    public static final int LOOSE_MERGE = 1;
    public static final int GENERAL_MERGE = 2;
    private static final SDebug db = new SDebug("CircuitMergeManager");
    private static CircuitMergeManager singleton;
    private static final int UNINITIATED = 0;
    private static final int MERGING = 1;
    private CircuitMergeSplicer splicer;
    private List<NetVcatCircuit> vcatCktList = new ArrayList<NetVcatCircuit>();
    private Map circuitsInMergeMap = new HashMap();
    private Map nodeOperatorMap = new HashMap();
    private Set involvedCircuits = new HashSet();
    private INetCircuit masterCircuit;
    private int operation;
    private int state = 0;
    private Map openCktsMergeMap = new HashMap();
    private boolean adjustVcgs = false;

    private CircuitMergeManager() {
    }

    public static synchronized CircuitMergeManager instance() {
        if (singleton == null) {
            singleton = new CircuitMergeManager();
        }
        return singleton;
    }

    public CircuitMergeSplicer getSplicer() {
        return this.splicer;
    }

    private void validateCircuitsForMerge() throws CircuitMergeError {
        if (!this.inMerging()) {
            throw new IllegalStateException("init() has not been called");
        }
        Iterator iterator = this.circuitsInMergeMap.values().iterator();
        while (iterator.hasNext()) {
            ((NetCircuitMergeOperator)iterator.next()).validateForMerge();
        }
    }

    public void init(List<INetCircuit> list, int n) {
        Iterator iterator;
        Object object2;
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("No circuit has been selected for merging.");
        }
        if (this.inMerging()) {
            throw new IllegalStateException("Another merge operation is still processing.");
        }
        if (db.on()) {
            db.fine("Start to merge " + list.size() + " circuits. " + "operation = " + n);
        }
        if (list.size() == 2) {
            object2 = list.get(0);
            iterator = list.get(1);
            if (object2.isOpenEndedVcatCircuit() && iterator.isOpenEndedVcatCircuit()) {
                if (NetCircuitMergeOperator.readytoAdjust((INetCircuit)object2, (INetCircuit)((Object)iterator))) {
                    this.adjustVcgs = true;
                    if (db.on()) {
                        db.println("Ready to Adjust VCGs now.");
                    }
                    NetCircuitMergeOperator object4 = new NetCircuitMergeOperator(NetCircuitMergeOperator.getNetVcatCircuit((INetCircuit)object2), NetCircuitMergeOperator.getNetVcatCircuit((INetCircuit)((Object)iterator)));
                    this.openCktsMergeMap.put(NetCircuitMergeOperator.getNetVcatCircuit((INetCircuit)object2), object4);
                } else {
                    this.openCktsMergeMap.clear();
                    this.adjustVcgs = false;
                }
            }
        }
        try {
            Object object;
            this.splicer = new CircuitMergeSplicer();
            this.operation = n;
            this.state = 1;
            if (n == 0 || n == 1) {
                this.masterCircuit = list.get(0);
            }
            this.vcatCktList.clear();
            this.circuitsInMergeMap.clear();
            this.nodeOperatorMap.clear();
            this.involvedCircuits.clear();
            object2 = new ArrayList();
            for (INetCircuit iNetCircuit : list) {
                if (iNetCircuit.getCircuitTypeObj().isVcatCircuitType()) {
                    object = (NetVcatCircuit)iNetCircuit;
                    this.vcatCktList.add((NetVcatCircuit)object);
                    object2.addAll(((NetVcatCircuit)object).getAllMemberCircuits());
                    continue;
                }
                object2.add((NetCcatCircuit)iNetCircuit);
            }
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                NetCcatCircuit netCcatCircuit = (NetCcatCircuit)iterator.next();
                this.involvedCircuits.add(netCcatCircuit);
                object = new NetCircuitMergeOperator(netCcatCircuit, n);
                this.circuitsInMergeMap.put(netCcatCircuit, object);
                Iterator iterator2 = netCcatCircuit.getCircuitNodes().iterator();
                while (iterator2.hasNext()) {
                    this.nodeOperatorMap.put(iterator2.next(), object);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            SDebug.printStackTrace((Throwable)runtimeException);
            this.dispose();
            throw runtimeException;
        }
    }

    private synchronized void dispose() {
        this.state = 0;
        this.splicer.dispose();
        this.splicer = null;
        this.masterCircuit = null;
        for (NetCcatCircuit netCcatCircuit : this.circuitsInMergeMap.keySet()) {
            if (netCcatCircuit == null) continue;
            netCcatCircuit.setInCircuitMerge(false);
        }
        this.vcatCktList.clear();
        this.circuitsInMergeMap.clear();
        this.nodeOperatorMap.clear();
        this.involvedCircuits.clear();
    }

    public boolean inMerging() {
        return this.state != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MergeResult mergeCircuits() throws CircuitMergeError {
        MergeResult mergeResult;
        block12: {
            Map.Entry entry;
            if (!this.inMerging()) {
                throw new IllegalStateException("init() has not been called");
            }
            try {
                Object object;
                this.validateCircuitsForMerge();
                this.prepareMerge();
                this.startMerge();
                this.finalizeMerge();
                this.cleanup();
                List list = this.adjustVcatCircuits();
                MergeResult mergeResult2 = new MergeResult();
                mergeResult2.addedCircuitNum = this.involvedCircuits.size() - this.circuitsInMergeMap.size();
                for (Map.Entry object2 : this.circuitsInMergeMap.entrySet()) {
                    object = (NetCcatCircuit)object2.getKey();
                    if (((NetCcatCircuit)object).isMemberOfVcat()) continue;
                    NetCircuitMergeOperator netCircuitMergeOperator = (NetCircuitMergeOperator)object2.getValue();
                    if (object == null || !((NetCircuit)object).isCircuitRefValid()) {
                        ++mergeResult2.deletedCircuitNum;
                        continue;
                    }
                    if (!netCircuitMergeOperator.changed()) continue;
                    ++mergeResult2.changedCircuitNum;
                }
                block3: for (NetVcatCircuit netVcatCircuit : this.vcatCktList) {
                    if (list.contains(netVcatCircuit)) {
                        ++mergeResult2.changedCircuitNum;
                        continue;
                    }
                    for (Object e : netVcatCircuit.getAllMemberCircuits()) {
                        object = (NetCircuitMergeOperator)this.circuitsInMergeMap.get(e);
                        if (object == null || !((NetCircuitMergeOperator)object).changed()) continue;
                        ++mergeResult2.changedCircuitNum;
                        continue block3;
                    }
                }
                if (db.on()) {
                    db.println("involvedCircuits size=" + this.involvedCircuits.size());
                }
                for (INetCircuit iNetCircuit : this.involvedCircuits) {
                    if (iNetCircuit == null || !iNetCircuit.isCircuitRefValid()) continue;
                    if (db.on()) {
                        db.fine("add circuit: " + iNetCircuit.getCircuitName());
                    }
                    mergeResult2.validCircuitsAfterMerge.add(iNetCircuit);
                }
                if (db.on()) {
                    db.println("result=" + mergeResult2);
                }
                mergeResult = mergeResult2;
                Object var9_12 = null;
                this.dispose();
                if (!this.adjustVcgs) break block12;
                entry = this.openCktsMergeMap.entrySet().iterator().next();
            }
            catch (Throwable throwable) {
                block13: {
                    Object var9_13 = null;
                    this.dispose();
                    if (!this.adjustVcgs) break block13;
                    Map.Entry entry2 = this.openCktsMergeMap.entrySet().iterator().next();
                    NetCircuitMergeOperator netCircuitMergeOperator = (NetCircuitMergeOperator)entry2.getValue();
                    netCircuitMergeOperator.mergeOpenVcats();
                    this.openCktsMergeMap.clear();
                    this.adjustVcgs = false;
                }
                throw throwable;
            }
            NetCircuitMergeOperator netCircuitMergeOperator = (NetCircuitMergeOperator)entry.getValue();
            netCircuitMergeOperator.mergeOpenVcats();
            this.openCktsMergeMap.clear();
            this.adjustVcgs = false;
        }
        return mergeResult;
    }

    private void prepareMerge() {
        if (db.on()) {
            db.fine("prepareMerge started");
        }
        Iterator iterator = this.circuitsInMergeMap.values().iterator();
        while (iterator.hasNext()) {
            ((NetCircuitMergeOperator)iterator.next()).prepareMerge();
        }
    }

    private void startMerge() {
        if (db.on()) {
            db.fine("startMerge started");
        }
        this.splicer.startSplice();
    }

    private void finalizeMerge() throws CircuitMergeError {
        boolean bl;
        if (db.on()) {
            db.fine("finalizeMerge started");
        }
        NetCircuitMergeOperator netCircuitMergeOperator = null;
        if (this.operation == 0 || this.operation == 1) {
            netCircuitMergeOperator = this.getMergeOperator(this.masterCircuit);
            if (this.circuitsInMergeMap.size() > 1 && netCircuitMergeOperator.getNodeNumInAllDisjointParts() <= netCircuitMergeOperator.getCircuitNodeNumBeforeMerge()) {
                this.rollbackAllOperations();
                throw new CircuitMergeError("No cross-connects from the selected circuit" + (this.circuitsInMergeMap.size() > 2 ? "(s)" : "") + " can be merged into the current circuit.");
            }
            boolean bl2 = bl = netCircuitMergeOperator.getDisjointPartsNum() == 1 && netCircuitMergeOperator.canBeCompleted();
            if (this.operation == 0) {
                if (db.on()) {
                    db.println("# disjoint parts = " + this.getTotalDisjointPartsNum());
                }
                String string = "The selected circuit" + (this.circuitsInMergeMap.size() > 2 ? "(s)" : "") + " cannot be merged into the current circuit (\"<" + this.getMasterCircuit().getCircuitName() + ">\").";
                if (!bl) {
                    this.rollbackAllOperations();
                    throw new CircuitMergeError(string);
                }
                if (this.getTotalDisjointPartsNum() != 1) {
                    this.rollbackAllOperations();
                    throw new NotFullyMerged(string);
                }
            } else if (!bl) {
                this.rollbackAllOperations();
                throw new CircuitMergeError("Merging in the selected circuit connections cannot make the current circuit (\"<" + this.getMasterCircuit().getCircuitName() + ">\") DISCOVERED.");
            }
        }
        bl = true;
        if (netCircuitMergeOperator != null) {
            bl &= netCircuitMergeOperator.finalizeMerge();
        }
        for (NetCircuitMergeOperator netCircuitMergeOperator2 : this.circuitsInMergeMap.values()) {
            if (netCircuitMergeOperator2 == netCircuitMergeOperator) continue;
            bl &= netCircuitMergeOperator2.finalizeMerge();
        }
    }

    private void cleanup() {
        if (db.on()) {
            db.fine("cleanup started");
        }
        Iterator iterator = this.circuitsInMergeMap.values().iterator();
        while (iterator.hasNext()) {
            ((NetCircuitMergeOperator)iterator.next()).cleanup();
        }
    }

    private List adjustVcatCircuits() {
        db.fine("adjustVcatCircuits started");
        ArrayList<NetVcatCircuit> arrayList = new ArrayList<NetVcatCircuit>();
        for (NetVcatCircuit netVcatCircuit : this.vcatCktList) {
            if (!NetCircuitMergeOperator.adjustVcatCircuit(netVcatCircuit)) continue;
            arrayList.add(netVcatCircuit);
        }
        return arrayList;
    }

    private void rollbackAllOperations() {
        Iterator iterator = this.circuitsInMergeMap.values().iterator();
        while (iterator.hasNext()) {
            ((NetCircuitMergeOperator)iterator.next()).reloadWholeCircuit();
        }
    }

    private int getTotalDisjointPartsNum() {
        int n = 0;
        Iterator iterator = this.circuitsInMergeMap.values().iterator();
        while (iterator.hasNext()) {
            n += ((NetCircuitMergeOperator)iterator.next()).getDisjointPartsNum();
        }
        return n;
    }

    private boolean canAllCircuitsBeCompleted() {
        Iterator iterator = this.circuitsInMergeMap.values().iterator();
        while (iterator.hasNext()) {
            if (((NetCircuitMergeOperator)iterator.next()).canBeCompleted()) continue;
            return false;
        }
        return true;
    }

    public INetCircuit getMasterCircuit() {
        return this.masterCircuit;
    }

    public NetCircuitMergeOperator getMergeOperator(INetCircuit iNetCircuit) {
        return (NetCircuitMergeOperator)this.circuitsInMergeMap.get(iNetCircuit);
    }

    public static boolean isCktInMerge(INetCircuit iNetCircuit) {
        if (db.on()) {
            db.println("isCktInMerge called for circuit <" + iNetCircuit.getCircuitName() + ">");
        }
        return CircuitMergeManager.instance().inMerging() && CircuitMergeManager.instance().getMergeOperator(iNetCircuit) != null;
    }

    private static boolean isValidForMerge(INetCircuit iNetCircuit) {
        try {
            NetCircuitMergeOperator.validateForMerge(iNetCircuit);
            return true;
        }
        catch (CircuitMergeError circuitMergeError) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)circuitMergeError);
            }
            return false;
        }
    }

    public void addNewCreatedCircuit(INetCircuit iNetCircuit) {
        this.involvedCircuits.add(iNetCircuit);
    }

    public NetCircuitMergeOperator findOperatorBeforeMerge(NetCircuitNode netCircuitNode) {
        return (NetCircuitMergeOperator)this.nodeOperatorMap.get(netCircuitNode);
    }

    public static boolean qualifyForMergeMaster(INetCircuit iNetCircuit) {
        return CircuitMergeManager.isValidForMerge(iNetCircuit);
    }

    public class MergeResult {
        public int changedCircuitNum = 0;
        public int deletedCircuitNum = 0;
        public int addedCircuitNum = 0;
        public List validCircuitsAfterMerge = new ArrayList();

        public String toString() {
            return "[" + this.changedCircuitNum + "," + this.deletedCircuitNum + "," + this.addedCircuitNum + "," + this.validCircuitsAfterMerge.size() + "]";
        }
    }
}

