/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AlreadyInUse;
import cerent.cms.model.Feature;
import cerent.cms.model.FeatureNotSupported;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IDwdmLineModel;
import cerent.cms.model.IDwdmModuleModel;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IDwdmTrkLineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.INodeOpticsTopologyModel;
import cerent.cms.model.IOptLinkModel;
import cerent.cms.model.IOpticsChannelModel;
import cerent.cms.model.IPlimTrkLineModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IPpmModel;
import cerent.cms.model.IXPL2ModuleModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.OchTrailAttrsHelper;
import cerent.cms.model.OchncHelper;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.OchccCircuit;
import cerent.cms.ncp.OchncCircuitEnd;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.ui.helper.EqTypeHelper;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class OchTrailHelper {
    public static final String OCH_TRAIL_LABEL = "OCHTRAIL";
    private static final SDebug db = new SDebug("OchTrailHelper");
    static final int EQ_Rw = 120;
    static final int EQ_RwP = 121;
    static final int EQ_Be = 183;
    static final int EQ_BeP = 184;
    static final int EQ_SkT = 118;
    static final int EQ_SkM = 119;
    static final int EQ_MvT = 181;
    static final int EQ_MvM = 182;
    static final int EQ_AdM = 243;
    static final int EQ_ADMoaB = 273;
    static final int EQ_10GeXp = 271;
    static final int EQ_Otu2Xp = 293;
    public static final Map interOperabilityMap = new HashMap();

    private static List filterNodeForOchcc(CircuitCreatInfo circuitCreatInfo, INetCircuit iNetCircuit, INodeModel iNodeModel, OchccCircuitSize ochccCircuitSize, boolean bl) {
        StringBuffer stringBuffer;
        int[] nArray;
        IEntityTableModel iEntityTableModel;
        LinkedList<StringBuffer> linkedList;
        block21: {
            linkedList = new LinkedList<StringBuffer>();
            if (db.on()) {
                db.println("filterNodeForOchcc: " + iNodeModel);
            }
            if ((iEntityTableModel = iNodeModel.getEntityTable()) == null) {
                return linkedList;
            }
            nArray = new int[]{};
            try {
                if (iNodeModel.provides(Feature.OCHNC_SPLITTER_CIRCUIT)) {
                    nArray = iNodeModel.getINodeOpticsTopologyModel().getAvailEntitiesForOchcc(circuitCreatInfo.cktOptChannel(), OchTrailHelper.getEqTypeForSize(ochccCircuitSize), bl);
                } else if (iNodeModel.provides(Feature.OCH_TRAIL_PROVISIONING)) {
                    nArray = iNodeModel.getINodeOpticsTopologyModel().getAvailEntitiesForOchcc(circuitCreatInfo.cktOptChannel(), OchTrailHelper.getEqTypeForSize(ochccCircuitSize));
                }
            }
            catch (AlreadyInUse alreadyInUse) {
                if (db.on()) {
                    db.println("Channel/size already in use for OCHCC.");
                    SDebug.printStackTrace((Throwable)alreadyInUse);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block21;
                db.println("Cannot get avail entities for OCHCC.");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (nArray != null) {
            if (db.on()) {
                stringBuffer = new StringBuffer();
                for (int i = 0; i < nArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(Integer.toHexString(nArray[i]));
                }
                db.println("Called getAvailEntitiesForOchCC(" + circuitCreatInfo.cktOptChannel() + "," + OchTrailHelper.getEqTypeForSize(ochccCircuitSize) + "): [" + stringBuffer + "]");
            }
        } else if (db.on()) {
            db.println("Node does not provide OCH_TRAIL feature");
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            block22: {
                n = nArray[i];
                try {
                    stringBuffer = iEntityTableModel.getEntityModelByIndex(n);
                    if (!db.on()) break block22;
                    db.println("Found available entity [" + Integer.toHexString(n) + "] " + stringBuffer);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) continue;
                    db.println("Cannot get entity " + Integer.toHexString(n));
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    continue;
                }
            }
            IModuleModel iModuleModel = stringBuffer.getModuleModel();
            int n2 = stringBuffer.getEqType();
            int n3 = iModuleModel.getEqType();
            if (db.on()) {
                db.println("Starting filtering for module " + iModuleModel + " [ " + n3 + "]");
            }
            try {
                if (!OchTrailHelper.filterProtection(bl, circuitCreatInfo.isProtected(), iModuleModel, iNodeModel, n) || iNetCircuit != null && !OchTrailHelper.filterInterOperability(iNetCircuit, ochccCircuitSize, iModuleModel, n3, (IEntityModel)stringBuffer, n2)) continue;
                linkedList.add(stringBuffer);
                continue;
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("OCHCC filtering failure: " + exception.getMessage());
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return linkedList;
    }

    private static boolean filterProtection(boolean bl, boolean bl2, IModuleModel iModuleModel, INodeModel iNodeModel, int n) {
        if (OchTrailAttrsHelper.filterProtection(!bl && bl2, iModuleModel)) {
            return true;
        }
        if (!bl && bl2) {
            try {
                IEntityModel[] iEntityModelArray = OchTrailHelper.getTrunkPorts(iNodeModel, n);
                if (iEntityModelArray.length == 1 && OchTrailHelper.isProtectedOCHNCService(iEntityModelArray[0])) {
                    return true;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            catch (NoSuchEquipment noSuchEquipment) {
                SDebug.printStackTrace((Throwable)noSuchEquipment);
            }
        }
        return false;
    }

    public static List filterNodeForOchcc(CircuitCreatInfo circuitCreatInfo, INetCircuit iNetCircuit, INodeModel iNodeModel) {
        OchccCircuitSize ochccCircuitSize = OchccCircuitSize.fromInt(circuitCreatInfo.specificSize(), iNodeModel.getTdmProtocolType());
        if (db.on()) {
            db.println("Using och cc size " + ochccCircuitSize);
        }
        List list = OchTrailHelper.filterNodeForOchcc(circuitCreatInfo, iNetCircuit, iNodeModel, ochccCircuitSize, false);
        if (circuitCreatInfo.isProtected()) {
            list.addAll(OchTrailHelper.filterNodeForOchcc(circuitCreatInfo, iNetCircuit, iNodeModel, ochccCircuitSize, true));
        }
        return list;
    }

    public static List filterNodeForOchTrail(CircuitCreatInfo circuitCreatInfo, INetCircuit iNetCircuit, INodeModel iNodeModel) {
        StringBuffer stringBuffer;
        int[] nArray;
        IEntityTableModel iEntityTableModel;
        LinkedList<StringBuffer> linkedList;
        block22: {
            linkedList = new LinkedList<StringBuffer>();
            if (db.on()) {
                db.println("filterNodeForOchTrail: " + iNodeModel);
            }
            if ((iEntityTableModel = iNodeModel.getEntityTable()) == null) {
                return linkedList;
            }
            nArray = new int[]{};
            try {
                if (iNodeModel.provides(Feature.OCHNC_SPLITTER_CIRCUIT)) {
                    nArray = iNodeModel.getINodeOpticsTopologyModel().getAvailEntitiesForOchTrail(circuitCreatInfo.cktOptChannel(), 1, circuitCreatInfo.isProtected());
                } else if (iNodeModel.provides(Feature.STS_OVER_MSTP_ADM)) {
                    nArray = iNodeModel.getINodeOpticsTopologyModel().getAvailEntitiesForOchTrail(circuitCreatInfo.cktOptChannel(), 1);
                }
            }
            catch (AlreadyInUse alreadyInUse) {
                if (db.on()) {
                    db.println("Channel/size already in use for OCHTRAIL.");
                    SDebug.printStackTrace((Throwable)alreadyInUse);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block22;
                db.println("Cannot get avail entities for OCHTRAIL.");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (nArray != null) {
            if (db.on()) {
                stringBuffer = new StringBuffer();
                for (int i = 0; i < nArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(Integer.toHexString(nArray[i]));
                }
                db.println("Called getAvailEntitiesForOchTrail(" + circuitCreatInfo.cktOptChannel() + "): [" + stringBuffer + "]");
            }
        } else if (db.on()) {
            db.println("Node does not provide STS_OVER_MSTP_ADM feature");
        }
        for (int i = 0; i < nArray.length; ++i) {
            block23: {
                int n = nArray[i];
                try {
                    stringBuffer = iEntityTableModel.getEntityModelByIndex(n);
                    if (!db.on()) break block23;
                    db.println("Found available entity [" + Integer.toHexString(n) + "] " + stringBuffer);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) continue;
                    db.println("Cannot get entity " + Integer.toHexString(n));
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    continue;
                }
            }
            IModuleModel iModuleModel = stringBuffer.getModuleModel();
            int n = iModuleModel.getEqType();
            if (db.on()) {
                db.println("Starting filtering for module " + iModuleModel + " [ " + n + "]");
            }
            try {
                if (iNetCircuit == null) {
                    linkedList.add(stringBuffer);
                    continue;
                }
                INetCircuitEnd iNetCircuitEnd = iNetCircuit.getPrimarySource();
                INodeModel iNodeModel2 = iNetCircuitEnd.getNodeModel();
                IEntityTableModel iEntityTableModel2 = iNodeModel2.getEntityTable();
                IEntityModel iEntityModel = iEntityTableModel2.getEntityModelByIndex(circuitCreatInfo.getSrcTrkPort());
                IModuleModel iModuleModel2 = iEntityModel.getModuleModel();
                if (!OchTrailHelper.areOchTrailCardsCompatible(iModuleModel2, iModuleModel)) continue;
                linkedList.add(stringBuffer);
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) continue;
                db.println("OCHTRAIL filtering failure: " + abstractCmsNoSuchEntityException.getMessage());
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return linkedList;
    }

    public static boolean areOchTrailCardsCompatible(IModuleModel iModuleModel, IModuleModel iModuleModel2) {
        if (iModuleModel.getEqType() == 273 && iModuleModel2.getEqType() == 273) {
            return true;
        }
        if (iModuleModel.getEqType() == 290 && iModuleModel2.getEqType() == 290) {
            return true;
        }
        if (iModuleModel.getEqType() == 292 && iModuleModel2.getEqType() == 292) {
            return true;
        }
        if (iModuleModel.getEqType() == 320 && iModuleModel2.getEqType() == 320) {
            return true;
        }
        return !(iModuleModel.getEqType() != 271 && iModuleModel.getEqType() != 272 || iModuleModel2.getEqType() != 271 && iModuleModel2.getEqType() != 272 || !OchTrailHelper.isOchTrailCard((IEntityModel)iModuleModel) || !OchTrailHelper.isOchTrailCard((IEntityModel)iModuleModel2));
    }

    public static boolean checkInteroperability(OchccCircuitSize ochccCircuitSize, IEntityModel iEntityModel, IEntityModel iEntityModel2) {
        boolean bl = false;
        if (db.on()) {
            db.println("checkInteroperability(" + ochccCircuitSize + ", " + iEntityModel + ", " + iEntityModel2);
        }
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        int n = iModuleModel.getEqType();
        IModuleModel iModuleModel2 = iEntityModel2.getModuleModel();
        int n2 = iModuleModel2.getEqType();
        if (db.on()) {
            db.println("Filtering interoperability with : (" + iModuleModel + ", " + n + ") and (" + iModuleModel2 + ", " + n2 + ")");
        }
        if (n == n2) {
            if (db.on()) {
                db.println("Same card type always compatible");
            }
            bl = true;
        } else {
            Map map = (Map)interOperabilityMap.get(ochccCircuitSize);
            if (map != null) {
                int[] nArray = (int[])map.get(new Integer(n));
                if (db.on()) {
                    db.println("Interoperability matrix found for module A:\n" + OchTrailHelper.dumpArray(nArray));
                }
                for (int i = 0; !bl && nArray != null && i < nArray.length; ++i) {
                    if (nArray[i] != n2) continue;
                    bl = true;
                }
            }
        }
        if (db.on()) {
            db.println("Check result: " + bl);
        }
        return bl;
    }

    public static boolean filterInterOperability(INetCircuit iNetCircuit, OchccCircuitSize ochccCircuitSize, IModuleModel iModuleModel, int n, IEntityModel iEntityModel, int n2) {
        boolean bl;
        block19: {
            bl = false;
            INetCircuitEnd iNetCircuitEnd = iNetCircuit.getPrimarySource();
            if (iNetCircuitEnd.getEntityIndex() == 0) {
                if (OchTrailHelper.isLineCard(n)) {
                    OchccCircuitSize ochccCircuitSize2 = OchccCircuitSize.fromInt(n2, iNetCircuitEnd.getNetElement().getTdmProtocolType());
                    boolean bl2 = bl = ochccCircuitSize2 == ochccCircuitSize;
                    if (db.on()) {
                        db.println("Found entity index = 0; comparing tmp size " + ochccCircuitSize2 + " and cktSize " + ochccCircuitSize + ": " + bl);
                    }
                }
            } else if (!OchTrailHelper.isLineCard(n)) {
                try {
                    int n3;
                    int[] nArray;
                    Object object;
                    IEntityModel iEntityModel2 = iNetCircuitEnd.getEntityModel();
                    IModuleModel iModuleModel2 = iEntityModel2.getModuleModel();
                    int n4 = iModuleModel2.getEqType();
                    if (db.on()) {
                        db.println("Filtering interoperability with source: " + iModuleModel2 + " [ " + n4 + "]");
                    }
                    if (n4 == n) {
                        if (db.on()) {
                            db.println("Same card type always compatible");
                        }
                        bl = true;
                    } else {
                        object = (Map)interOperabilityMap.get(ochccCircuitSize);
                        nArray = (int[])object.get(new Integer(n4));
                        if (db.on()) {
                            db.println("Interoperability matrix found for source module:\n" + OchTrailHelper.dumpArray(nArray));
                        }
                        for (n3 = 0; !bl && nArray != null && n3 < nArray.length; ++n3) {
                            if (nArray[n3] != n) continue;
                            bl = true;
                        }
                    }
                    if (bl && OchTrailHelper.isMxpCard(n) && OchTrailHelper.isMxpCard(n4)) {
                        object = ((IPortModel)iEntityModel).getPortNum();
                        if (((Object)object).length == (nArray = ((IPortModel)iEntityModel2).getPortNum()).length) {
                            for (n3 = 0; bl && n3 < ((Object)object).length; ++n3) {
                                boolean bl3 = bl = object[n3] == nArray[n3];
                                if (bl || !db.on()) continue;
                                db.println("Found different client ports at index " + n3 + ": " + (int)object[n3] + " != " + nArray[n3]);
                            }
                        } else {
                            if (db.on()) {
                                db.println("Found different length of client ports: " + ((Object)object).length + " != " + nArray.length);
                            }
                            bl = false;
                        }
                    }
                }
                catch (ObjNotFound objNotFound) {
                    if (!db.on()) break block19;
                    db.println("Cannot check interoperability: " + objNotFound.getMessage());
                    SDebug.printStackTrace((Throwable)objNotFound);
                }
            }
        }
        if (db.on()) {
            db.println("Filter result: " + bl);
        }
        return bl;
    }

    public static boolean isWorkingPort(INodeModel iNodeModel, int n) {
        boolean bl;
        block4: {
            bl = false;
            IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
            try {
                IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                if (OchTrailHelper.isTrunkPort(iEntityModel)) {
                    bl = OchTrailHelper.isWorkingPort(iEntityModel);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("isWorkingPort(" + iNodeModel + ", " + n + ") - Cannot get entity model : " + exception.getMessage());
            }
        }
        if (db.on()) {
            db.println("isWorkingPort(" + iNodeModel + ", " + n + "):  " + bl);
        }
        return bl;
    }

    public static boolean isWorkingPort(IEntityModel iEntityModel) {
        boolean bl = false;
        IInterfaceModel iInterfaceModel = ((IPortModel)iEntityModel).getInterfaceModel();
        if (iInterfaceModel instanceof IPlimTrkLineModel) {
            if (db.on()) {
                db.println("isWorkingPort called for non protected plim card => true");
            }
            bl = true;
        } else if (iEntityModel instanceof IDwdmPortModel) {
            if (OchTrailHelper.isProtected(iEntityModel)) {
                IDwdmPortModel iDwdmPortModel = (IDwdmPortModel)iEntityModel;
                IDwdmTrkLineModel iDwdmTrkLineModel = (IDwdmTrkLineModel)iDwdmPortModel.getInterfaceModel();
                bl = iDwdmTrkLineModel.isWorkingLine();
            } else {
                if (db.on()) {
                    db.println("isWorkingPort called for non protected card => true");
                }
                bl = true;
            }
        }
        if (db.on()) {
            db.println("isWorkingPort(" + iEntityModel + "):  " + bl);
        }
        return bl;
    }

    public static boolean isActivePort(INodeModel iNodeModel, int n) {
        try {
            return OchTrailHelper.isActivePort(iNodeModel.getEntityTable().getEntityModelByIndex(n));
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            return false;
        }
    }

    public static boolean isActivePort(IEntityModel iEntityModel) {
        boolean bl;
        block8: {
            bl = false;
            if (iEntityModel instanceof IDwdmPortModel) {
                IDwdmPortModel iDwdmPortModel = (IDwdmPortModel)iEntityModel;
                IDwdmTrkLineModel iDwdmTrkLineModel = (IDwdmTrkLineModel)iDwdmPortModel.getInterfaceModel();
                try {
                    bl = iDwdmTrkLineModel.isCurrentlyActive();
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (db.on()) {
                        db.println("Cannot state if " + iDwdmTrkLineModel + " is active: " + noSuchInterface.getMessage());
                    }
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (db.on()) {
                        db.println("Cannot state if " + iDwdmTrkLineModel + " is active: " + wrongInterfaceType.getMessage());
                    }
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    if (!db.on()) break block8;
                    db.println("Cannot state if " + iDwdmTrkLineModel + " is active: " + unsupportedOperation.getMessage());
                }
            }
        }
        if (db.on()) {
            db.println("isActivePort(" + iEntityModel + "):  " + bl);
        }
        return bl;
    }

    public static IEntityModel getWorkingTrunk(IEntityModel iEntityModel) throws AbstractCmsNoSuchEntityException, NoSuchEquipment {
        if (db.on()) {
            db.println("getWorkingTrunk(" + iEntityModel);
        }
        IEntityModel iEntityModel2 = null;
        if (OchTrailHelper.isTrunkPort(iEntityModel)) {
            if (OchTrailHelper.isWorkingPort(iEntityModel)) {
                iEntityModel2 = iEntityModel;
            }
        } else {
            IEntityModel[] iEntityModelArray = OchTrailHelper.getTrunkPorts(iEntityModel);
            if (iEntityModelArray.length == 1) {
                iEntityModel2 = iEntityModelArray[0];
            } else {
                for (int i = 0; iEntityModel2 == null && i < iEntityModelArray.length; ++i) {
                    if (!OchTrailHelper.isWorkingPort(iEntityModelArray[i])) continue;
                    iEntityModel2 = iEntityModelArray[i];
                }
            }
        }
        if (db.on()) {
            db.println("getWorkingTrunk() return " + iEntityModel2);
        }
        return iEntityModel2;
    }

    public static IEntityModel[] getTrunkPorts(IEntityModel iEntityModel) throws AbstractCmsNoSuchEntityException, NoSuchEquipment {
        if (OchTrailHelper.isTrunkPort(iEntityModel)) {
            return new IEntityModel[]{iEntityModel};
        }
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        return OchTrailHelper.getTrunkPorts(iNodeModel, iEntityModel.getEntityIndex());
    }

    public static IEntityModel getOtherTrunkPort(IEntityModel iEntityModel) throws AbstractCmsNoSuchEntityException, NoSuchEquipment {
        IEntityModel[] iEntityModelArray;
        IEntityModel iEntityModel2 = null;
        IEntityModel[] iEntityModelArray2 = OchTrailHelper.getClientPortsForTrunk(iEntityModel);
        if (iEntityModelArray2.length != 0 && (iEntityModelArray = OchTrailHelper.getTrunkPorts(iEntityModelArray2[0])).length == 2) {
            for (int i = 0; i < iEntityModelArray.length; ++i) {
                if (iEntityModelArray[i].getEntityIndex() == iEntityModel.getEntityIndex()) continue;
                iEntityModel2 = iEntityModelArray[i];
                break;
            }
        }
        return iEntityModel2;
    }

    public static IEntityModel[] getTrunkPorts(INodeModel iNodeModel, int n) throws AbstractCmsNoSuchEntityException, NoSuchEquipment {
        Object object;
        if (db.on()) {
            db.println("Finding trunk ports for client " + n + ", node " + iNodeModel);
        }
        IEntityModel[] iEntityModelArray = new IEntityModel[]{};
        IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
        if (iNodeModel.provides(Feature.OCH_TRAIL_PROVISIONING)) {
            IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
            if (OchTrailHelper.isLineCard(iEntityModel.getModuleModel().getEqType())) {
                object = new int[]{n};
                iEntityModelArray = new IEntityModel[]{iEntityModel};
            } else {
                object = iNodeModel.getINodeOpticsTopologyModel().getOchTrailTrunkPort(n);
                iEntityModelArray = new IEntityModel[((Object)object).length];
                for (int i = 0; i < ((Object)object).length; ++i) {
                    iEntityModelArray[i] = iEntityTableModel.getEntityModelByIndex((int)object[i]);
                }
            }
            if (iEntityModelArray.length == 2 && OchTrailHelper.isWorkingPort(iEntityModelArray[1])) {
                IEntityModel iEntityModel2 = iEntityModelArray[0];
                iEntityModelArray[0] = iEntityModelArray[1];
                iEntityModelArray[1] = iEntityModel2;
            }
        } else if (db.on()) {
            db.println("Node does not provide OCH_TRAIL feature");
        }
        if (db.on()) {
            object = new StringBuffer();
            for (int i = 0; i < iEntityModelArray.length; ++i) {
                ((StringBuffer)object).append("\n" + iEntityModelArray[i]);
            }
            db.println("Found trunk ports: " + object);
        }
        return iEntityModelArray;
    }

    public static boolean areTrunkAndClientCoLocated(INetElement iNetElement, int n, int n2) {
        if (n == n2) {
            return true;
        }
        if (!OchTrailHelper.isClientPort(iNetElement.getNodeModel(), n)) {
            return false;
        }
        try {
            int[] nArray = iNetElement.getNodeModel().getINodeOpticsTopologyModel().getOchTrailTrunkPort(n);
            boolean bl = false;
            String string = "";
            for (int i = 0; i < nArray.length && !bl; ++i) {
                if (i > 0) {
                    string = string + ", ";
                }
                string = string + Integer.toHexString(nArray[i]);
                bl = nArray[i] == n2;
            }
            if (!bl) {
                if (db.on()) {
                    db.println("WARNING: Client port " + Integer.toHexString(n) + " is not co-located with Trunk port(s) " + string + " - Node " + iNetElement.getName());
                }
                return false;
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Exception checking trunk and client ports." + exception);
            }
            return false;
        }
        return true;
    }

    public static int getEqTypeForSize(OchccCircuitSize ochccCircuitSize) {
        return ochccCircuitSize.intValue();
    }

    public static OchccCircuitSize getSizeForEqType(int n, INodeModel iNodeModel) {
        OchccCircuitSize ochccCircuitSize = OchccCircuitSize.fromInt(n, iNodeModel.getTdmProtocolType());
        if (ochccCircuitSize == null && db.on()) {
            db.println("Cannot find valid mapping for equipment type " + n + " on node " + iNodeModel);
        }
        return ochccCircuitSize;
    }

    public static boolean isDwdmCard(int n) {
        boolean bl;
        boolean bl2 = bl = OchTrailHelper.isTxpCard(n) || OchTrailHelper.isMxpCard(n);
        if (db.on()) {
            db.println("isDwdmCard(" + n + " - " + EqTypeHelper.eqTypeToName((TDMTerminology)TDMTerminology.getDefault(), (int)n) + "):  " + bl);
        }
        return bl;
    }

    public static boolean isTxpCard(int n) {
        boolean bl;
        boolean bl2 = bl = n == 120 || n == 121 || n == 118 || n == 181 || n == 271 || n == 293;
        if (db.on()) {
            db.println("isTxpCard(" + n + ":  " + bl);
        }
        return bl;
    }

    public static boolean isMxpCard(int n) {
        boolean bl;
        boolean bl2 = bl = n == 183 || n == 184 || n == 119 || n == 182 || n == 243 || n == 282 || n == 272;
        if (db.on()) {
            db.println("isMxpCard(" + n + ": " + bl);
        }
        return bl;
    }

    public static boolean isLineCard(IEntityModel iEntityModel) {
        if (iEntityModel instanceof IModuleModel) {
            return OchTrailHelper.isLineCard(iEntityModel.getEqType());
        }
        return OchTrailHelper.isLineCard(iEntityModel.getModuleModel().getEqType());
    }

    public static boolean isLineCard(int n) {
        boolean bl;
        boolean bl2 = bl = n == 60 || n == 220 || n == 11 || n == 219 || n == 254 || n == 253;
        if (db.on()) {
            db.println("isLineCard(" + n + ":  " + bl);
        }
        return bl;
    }

    public static boolean isOchTrailCard(IEntityModel iEntityModel) {
        boolean bl = false;
        boolean bl2 = iEntityModel instanceof IXPL2ModuleModel ? ((IXPL2ModuleModel)iEntityModel).isL2Switch() : (bl = iEntityModel.getEqType() == 273);
        if (db.on()) {
            db.println("isLineCard(" + iEntityModel.getEqType() + ":  " + bl);
        }
        return bl;
    }

    public static boolean isTrunkPort(IEntityModel iEntityModel) {
        boolean bl;
        int n = iEntityModel.getEqType();
        boolean bl2 = bl = n == 30 || n == 61 || n == 123 || n == 291;
        if (iEntityModel.getModuleModel().getEqType() == 293) {
            IDwdmLineModel iDwdmLineModel = (IDwdmLineModel)((IPortModel)iEntityModel).getInterfaceModel();
            try {
                bl = !iDwdmLineModel.isClient();
            }
            catch (NoSuchInterface noSuchInterface) {
                noSuchInterface.printStackTrace();
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                wrongInterfaceType.printStackTrace();
            }
        }
        if (db.on()) {
            db.println("isTrunkPort(" + n + " - " + EqTypeHelper.eqTypeToName((TDMTerminology)TDMTerminology.getDefault(), (int)n) + "):  " + bl);
        }
        return bl;
    }

    public static boolean isClientPort(IEntityModel iEntityModel) {
        boolean bl;
        int n = iEntityModel.getEqType();
        boolean bl2 = bl = n == 122;
        if (iEntityModel.getModuleModel().getEqType() == 293) {
            IDwdmLineModel iDwdmLineModel = (IDwdmLineModel)((IPortModel)iEntityModel).getInterfaceModel();
            try {
                bl = iDwdmLineModel.isClient();
            }
            catch (NoSuchInterface noSuchInterface) {
                noSuchInterface.printStackTrace();
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                wrongInterfaceType.printStackTrace();
            }
        }
        if (db.on()) {
            db.println("isClientPort(int)(" + n + " - " + EqTypeHelper.eqTypeToName((TDMTerminology)TDMTerminology.getDefault(), (int)n) + "):  " + bl);
        }
        return bl;
    }

    public static boolean isTrunkPort(INodeModel iNodeModel, int n) {
        boolean bl;
        block2: {
            bl = false;
            try {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                bl = OchTrailHelper.isTrunkPort(iEntityModel);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("isTrunkPort: exception getting entity model" + exception);
            }
        }
        return bl;
    }

    public static boolean isClientPort(INodeModel iNodeModel, int n) {
        boolean bl;
        block2: {
            bl = false;
            try {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                bl = OchTrailHelper.isClientPort(iEntityModel);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("isClientPort: exception getting entity model" + exception);
            }
        }
        return bl;
    }

    public static boolean isProtected(INodeModel iNodeModel, int n) {
        boolean bl;
        block2: {
            bl = false;
            try {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                IModuleModel iModuleModel = iEntityModel.getModuleModel();
                bl = OchTrailHelper.isProtected(iModuleModel);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("isProtected: exception getting entity model" + exception);
            }
        }
        return bl;
    }

    public static boolean isProtected(IEntityModel iEntityModel) {
        return OchTrailHelper.isProtected(iEntityModel.getModuleModel());
    }

    public static boolean isProtected(IModuleModel iModuleModel) {
        boolean bl;
        INodeModel iNodeModel = iModuleModel.getNodeModel();
        if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.OTU2_XP) && iModuleModel instanceof IDwdmModuleModel) {
            return ((IDwdmModuleModel)iModuleModel).hasSplitterProtectedLine();
        }
        int n = iModuleModel.getEqType();
        boolean bl2 = bl = n == 121 || n == 184;
        if (db.on()) {
            db.println("isProtected(" + n + ": " + bl);
        }
        return bl;
    }

    public static IEntityModel[] getColocatedOchPorts(IEntityModel iEntityModel) {
        int n;
        Object object;
        IOptLinkModel[] iOptLinkModelArray;
        LinkedList<IEntityModel> linkedList = new LinkedList<IEntityModel>();
        if (iEntityModel.getNodeModel().provides(Feature.PASSIVE_UNITS)) {
            linkedList.addAll(((IPortModel)iEntityModel).getNextLogicalPorts());
            linkedList.addAll(((IPortModel)iEntityModel).getPrevLogicalPorts());
        } else {
            iOptLinkModelArray = OchTrailHelper.getInternalOptLinks(iEntityModel);
            object = iEntityModel.getNodeModel().getEntityTable();
            n = iEntityModel.getEntityIndex();
            for (int i = 0; i < iOptLinkModelArray.length; ++i) {
                IEntityModel iEntityModel2;
                IOptLinkModel iOptLinkModel = iOptLinkModelArray[i];
                if (n == iOptLinkModel.getFrom()) {
                    try {
                        iEntityModel2 = object.getEntityModelByIndex(iOptLinkModel.getTo());
                        linkedList.addFirst(iEntityModel2);
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                    continue;
                }
                if (n != iOptLinkModel.getTo()) continue;
                try {
                    iEntityModel2 = object.getEntityModelByIndex(iOptLinkModel.getFrom());
                    linkedList.addLast(iEntityModel2);
                    continue;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        iOptLinkModelArray = linkedList.toArray(new IEntityModel[0]);
        if (iOptLinkModelArray.length == 2 && !OchPortsHelper.isAddPort((IEntityModel)iOptLinkModelArray[0])) {
            object = iOptLinkModelArray[0];
            iOptLinkModelArray[0] = iOptLinkModelArray[1];
            iOptLinkModelArray[1] = object;
        }
        if (db.on()) {
            object = new StringBuffer();
            for (n = 0; n < iOptLinkModelArray.length; ++n) {
                ((StringBuffer)object).append("\n" + iOptLinkModelArray[n]);
            }
            db.println("Found " + linkedList.size() + " OCH ports colocated:" + object);
        }
        return iOptLinkModelArray;
    }

    public static IEntityModel[] getColocatedOchPorts(IEntityModel iEntityModel, int n) {
        int n2;
        Object object;
        IOptLinkModel[] iOptLinkModelArray;
        LinkedList<IEntityModel> linkedList = new LinkedList<IEntityModel>();
        if (iEntityModel.getNodeModel().provides(Feature.PASSIVE_UNITS)) {
            linkedList.addAll(((IPortModel)iEntityModel).getNextLogicalPorts());
            linkedList.addAll(((IPortModel)iEntityModel).getPrevLogicalPorts());
        } else {
            iOptLinkModelArray = OchTrailHelper.getInternalOptLinks(iEntityModel);
            object = iEntityModel.getNodeModel().getEntityTable();
            n2 = iEntityModel.getEntityIndex();
            for (int i = 0; i < iOptLinkModelArray.length; ++i) {
                IEntityModel iEntityModel2;
                IOptLinkModel iOptLinkModel = iOptLinkModelArray[i];
                if (n != iOptLinkModel.getWaveLength()) continue;
                if (n2 == iOptLinkModel.getFrom()) {
                    try {
                        iEntityModel2 = object.getEntityModelByIndex(iOptLinkModel.getTo());
                        linkedList.addFirst(iEntityModel2);
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                    continue;
                }
                if (n2 != iOptLinkModel.getTo()) continue;
                try {
                    iEntityModel2 = object.getEntityModelByIndex(iOptLinkModel.getFrom());
                    linkedList.addLast(iEntityModel2);
                    continue;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        iOptLinkModelArray = linkedList.toArray(new IEntityModel[0]);
        if (iOptLinkModelArray.length == 2 && !OchPortsHelper.isAddPort((IEntityModel)iOptLinkModelArray[0])) {
            object = iOptLinkModelArray[0];
            iOptLinkModelArray[0] = iOptLinkModelArray[1];
            iOptLinkModelArray[1] = object;
        }
        if (db.on()) {
            object = new StringBuffer();
            for (n2 = 0; n2 < iOptLinkModelArray.length; ++n2) {
                ((StringBuffer)object).append("\n" + iOptLinkModelArray[n2]);
            }
            db.println("Found " + linkedList.size() + " OCH ports colocated:" + object);
        }
        return iOptLinkModelArray;
    }

    public static int[] getColocatedOchPorts(INetElement iNetElement, int n) throws AbstractCmsNoSuchEntityException, FeatureUnsupported, NoSuchInterface {
        IEntityModel[] iEntityModelArray;
        IEntityModel iEntityModel;
        IEntityTableModel iEntityTableModel;
        int[] nArray = new int[]{};
        INodeModel iNodeModel = iNetElement.getNodeModel();
        if (iNodeModel != null && (iEntityTableModel = iNodeModel.getEntityTable()) != null && (iEntityModel = iEntityTableModel.getEntityModelByIndex(n)) != null && (iEntityModelArray = OchTrailHelper.getColocatedOchPorts(iEntityModel)).length != 0) {
            nArray = new int[iEntityModelArray.length];
            for (int i = 0; i < iEntityModelArray.length; ++i) {
                nArray[i] = iEntityModelArray[i].getEntityIndex();
            }
        }
        return nArray;
    }

    public static int[] getColocatedOchPorts(INetElement iNetElement, int n, int n2) throws AbstractCmsNoSuchEntityException, FeatureUnsupported, NoSuchInterface {
        IEntityModel[] iEntityModelArray;
        IEntityModel iEntityModel;
        IEntityTableModel iEntityTableModel;
        int[] nArray = new int[]{};
        INodeModel iNodeModel = iNetElement.getNodeModel();
        if (iNodeModel != null && (iEntityTableModel = iNodeModel.getEntityTable()) != null && (iEntityModel = iEntityTableModel.getEntityModelByIndex(n)) != null && (iEntityModelArray = OchTrailHelper.getColocatedOchPorts(iEntityModel, n2)).length != 0) {
            nArray = new int[iEntityModelArray.length];
            for (int i = 0; i < iEntityModelArray.length; ++i) {
                nArray[i] = iEntityModelArray[i].getEntityIndex();
            }
        }
        return nArray;
    }

    public static int getColocatedTrunkPort(INodeModel iNodeModel, int n, int n2) {
        int n3;
        block3: {
            n3 = 0;
            try {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                IEntityModel iEntityModel2 = OchTrailHelper.getColocatedTrunkPort(iEntityModel, n2);
                if (iEntityModel2 != null) {
                    n3 = iEntityModel2.getEntityIndex();
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block3;
                db.println("getColocatedTrunkPort: exception getting entity model" + exception);
            }
        }
        return n3;
    }

    public static IEntityModel getColocatedTrunkPort(IEntityModel iEntityModel, int n) {
        IPortModel iPortModel = null;
        if (iEntityModel.getNodeModel().provides(Feature.PASSIVE_UNITS)) {
            if (OchPortsHelper.isPortTypeRx(iEntityModel)) {
                List list = ((IPortModel)iEntityModel).getPrevLogicalPorts(n);
                for (IPortModel iPortModel2 : list) {
                    if (!OchTrailHelper.isTrunkPort((IEntityModel)iPortModel2)) continue;
                    iPortModel = iPortModel2;
                    break;
                }
            } else {
                List list = ((IPortModel)iEntityModel).getNextLogicalPorts(n);
                for (IPortModel iPortModel3 : list) {
                    if (!OchTrailHelper.isTrunkPort((IEntityModel)iPortModel3)) continue;
                    iPortModel = iPortModel3;
                    break;
                }
            }
        } else {
            IOptLinkModel[] iOptLinkModelArray = OchTrailHelper.getInternalOptLinks(iEntityModel);
            int n2 = iEntityModel.getEntityIndex();
            IEntityTableModel iEntityTableModel = iEntityModel.getNodeModel().getEntityTable();
            for (int i = 0; iPortModel == null && i < iOptLinkModelArray.length; ++i) {
                IEntityModel iEntityModel2;
                IOptLinkModel iOptLinkModel = iOptLinkModelArray[i];
                if (n2 == iOptLinkModel.getFrom()) {
                    try {
                        iEntityModel2 = iEntityTableModel.getEntityModelByIndex(iOptLinkModel.getTo());
                        if (!OchTrailHelper.isTrunkPort(iEntityModel2)) continue;
                        iPortModel = iEntityModel2;
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                    continue;
                }
                if (n2 != iOptLinkModel.getTo()) continue;
                try {
                    iEntityModel2 = iEntityTableModel.getEntityModelByIndex(iOptLinkModel.getFrom());
                    if (!OchTrailHelper.isTrunkPort(iEntityModel2)) continue;
                    iPortModel = iEntityModel2;
                    continue;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        if (db.on()) {
            db.println("Found colocated trunk :" + iPortModel);
        }
        return iPortModel;
    }

    public static IEntityModel getColocatedAggregatedPort(IEntityModel iEntityModel, int n) {
        IEntityModel iEntityModel2 = null;
        if (iEntityModel.getNodeModel().provides(Feature.PASSIVE_UNITS)) {
            iEntityModel2 = OchPortsHelper.isPortTypeRx(iEntityModel) ? (IEntityModel)((IPortModel)iEntityModel).getNextLogicalPorts(n).get(0) : (IEntityModel)((IPortModel)iEntityModel).getPrevLogicalPorts(n).get(0);
        }
        if (db.on()) {
            db.println("Found colocated aggregated port :" + iEntityModel2);
        }
        return iEntityModel2;
    }

    public static IEntityModel getColocatedPassiveChannelPort(IEntityModel iEntityModel, int n) {
        IEntityModel iEntityModel2 = null;
        if (iEntityModel.getNodeModel().provides(Feature.PASSIVE_UNITS)) {
            ArrayList<IPortModel> arrayList = null;
            List list = new ArrayList<IPortModel>();
            list.add((IPortModel)iEntityModel);
            if (OchPortsHelper.isPortTypeRx(iEntityModel)) {
                do {
                    arrayList = list;
                } while ((list = ((IPortModel)list.get(0)).getPrevPhysicalPorts(n)).size() > 0);
                return (IEntityModel)arrayList.get(0);
            }
            do {
                arrayList = list;
            } while ((list = ((IPortModel)list.get(0)).getNextPhysicalPorts(n)).size() > 0);
            return (IEntityModel)arrayList.get(0);
        }
        if (db.on()) {
            db.println("Found colocated aggregated port :" + iEntityModel2);
        }
        return iEntityModel2;
    }

    public static IEntityModel getColocatedTrunkPort(INetElement iNetElement, int n, int n2) {
        int[] nArray;
        INodeModel iNodeModel;
        IEntityModel iEntityModel;
        block21: {
            iEntityModel = null;
            iNodeModel = iNetElement.getNodeModel();
            if (!iNodeModel.provides(Feature.OCH_TRAIL_PROVISIONING)) {
                if (db.on()) {
                    db.println("Cannot check colocated trunk on node " + iNodeModel + " - It does not provide OCH_TRAIL_PROVISIONING");
                }
                return iEntityModel;
            }
            INodeOpticsTopologyModel iNodeOpticsTopologyModel = iNodeModel.getINodeOpticsTopologyModel();
            nArray = new int[]{};
            try {
                nArray = iNodeOpticsTopologyModel.getAvailOchncPathEntities(n2, n);
            }
            catch (AlreadyInUse alreadyInUse) {
                if (db.on()) {
                    db.println("OCH channel in use. Try to get index from exception");
                }
                if (alreadyInUse.hasEntityIndex()) {
                    nArray = iNodeModel.provides(Feature.OCHNC_SPLITTER_CIRCUIT) ? alreadyInUse.getEntityIndexes() : new int[]{alreadyInUse.getEntityIndex()};
                }
            }
            catch (NoSuchEquipment noSuchEquipment) {
                if (!db.on()) break block21;
                SDebug.printStackTrace((Throwable)noSuchEquipment);
            }
        }
        if (nArray.length > 0) {
            IEntityModel iEntityModel2;
            IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
            IEntityModel iEntityModel3 = null;
            for (int i = 0; iEntityModel == null && i < nArray.length; ++i) {
                iEntityModel2 = null;
                try {
                    iEntityModel2 = iEntityTableModel.getEntityModelByIndex(nArray[i]);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) continue;
                    db.println("Cannot get entity " + nArray[i] + " on node " + iNodeModel + " :" + abstractCmsNoSuchEntityException.getMessage());
                    continue;
                }
                if (OchPortsHelper.isOtsPort(iEntityModel2)) {
                    if (!db.on()) continue;
                    db.println("Skipping OTS port " + iEntityModel2);
                    continue;
                }
                if (db.on()) {
                    db.println("Trying with OCH port " + iEntityModel2);
                }
                if ((iEntityModel = OchTrailHelper.getColocatedTrunkPort(iEntityModel2, n2)) == null) continue;
                iEntityModel3 = iEntityModel2;
            }
            if (db.on()) {
                db.println("Found trunk: " + iEntityModel);
            }
            if (iEntityModel != null) {
                IEntityModel iEntityModel4 = OchncHelper.getReversePort(n2, iEntityModel3);
                if (db.on()) {
                    db.println("Trying with other OCH port " + iEntityModel4);
                }
                if (iEntityModel4 != null) {
                    iEntityModel2 = OchTrailHelper.getColocatedTrunkPort(iEntityModel4, n2);
                    if (db.on()) {
                        db.println("Found other trunk: " + iEntityModel2);
                    }
                    if (iEntityModel2 == null || iEntityModel2.getEntityIndex() != iEntityModel.getEntityIndex()) {
                        iEntityModel = null;
                    }
                } else {
                    iEntityModel = null;
                }
            }
        }
        if (db.on()) {
            db.println("Found colocated trunk :" + iEntityModel);
        }
        return iEntityModel;
    }

    public static String getCircuitSizeString(OchccCircuit ochccCircuit) {
        OchccCircuitSize ochccCircuitSize = OchccCircuitSize.fromInt(ochccCircuit.getSpecificSize(), ochccCircuit.getSourceNE().getTdmProtocolType());
        if (ochccCircuitSize != null) {
            return ochccCircuitSize.toString();
        }
        return "Unknown size " + ochccCircuit.getSpecificSize();
    }

    public static IEntityModel[] getConnectedPorts(IEntityModel iEntityModel) {
        Object object;
        IEntityModel iEntityModel2 = null;
        IEntityModel iEntityModel3 = null;
        int n = iEntityModel.getEntityIndex();
        INetElement iNetElement = Network.instance().findNetElem(iEntityModel.getNodeModel());
        if (iNetElement != null && (object = Network.instance().findNetLinkFromSource(false, iNetElement, n, null)) != null) {
            INetElement iNetElement2 = object.getDst();
            int n2 = object.getDstEntityIndex();
            IEntityTableModel iEntityTableModel = iNetElement2.getNodeModel().getEntityTable();
            try {
                iEntityModel2 = iEntityTableModel.getEntityModelByIndex(n2);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (db.on()) {
                    db.println("Cannot find Entity Model for och port " + n2 + " on  node " + iNetElement2.getName());
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                return null;
            }
            if (OchTrailHelper.isTrunkPort(iEntityModel2)) {
                return new IEntityModel[]{iEntityModel2};
            }
            if (OchPortsHelper.isAddPort(iEntityModel2)) {
                int n3;
                try {
                    n3 = ((IOpticsChannelModel)((IPortModel)iEntityModel2).getInterfaceModel()).getExpectedWaveLength();
                }
                catch (Exception exception) {
                    if (db.on()) {
                        db.println("Cannot find wlen for och port " + iEntityModel2);
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    return null;
                }
                iEntityModel3 = OchncHelper.getReversePort(n3, iEntityModel2);
                if (iEntityModel3 != null) {
                    return new IEntityModel[]{iEntityModel2, iEntityModel3};
                }
                if (db.on()) {
                    db.println("Cannot find wlreverse Tx port for och port " + iEntityModel2);
                }
                return null;
            }
            if (db.on()) {
                db.println("Found port connected to trunk " + iEntityModel + " via VL, but it is nor OCH Rx: " + iEntityModel2);
            }
            return null;
        }
        object = OchTrailHelper.getColocatedOchPorts(iEntityModel);
        if (((IEntityModel[])object).length == 2) {
            if (OchPortsHelper.isAddPort(object[0]) && OchPortsHelper.isOchPort((IEntityModel)object[1])) {
                return object;
            }
            if (OchPortsHelper.isOchPort((IEntityModel)object[0]) && OchPortsHelper.isAddPort((IEntityModel)object[1])) {
                return new IEntityModel[]{object[1], object[0]};
            }
            if (db.on()) {
                db.println("Found two ports connected to trunk " + iEntityModel + " but not OCH ports: " + object[0] + ", " + object[1]);
            }
        }
        return null;
    }

    public static boolean isProtectedOCHNCService(IEntityModel iEntityModel) {
        block5: {
            IEntityModel[] iEntityModelArray = OchTrailHelper.getConnectedPorts(iEntityModel);
            if (iEntityModelArray != null && iEntityModelArray.length > 0) {
                try {
                    int n = ((IOpticsChannelModel)((IPortModel)iEntityModel).getInterfaceModel()).getExpectedWaveLength();
                    if (OchncHelper.getProtectedInLinePort(n, iEntityModelArray[0]) != null) {
                        if (db.on()) {
                            db.println("Found och port " + iEntityModelArray[0] + " with wl " + n + " supporting OCHNC Splitter");
                        }
                        return true;
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block5;
                    db.println("Cannot find wlen for och port " + iEntityModelArray[0]);
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static UpgradeOchncInfo getConnectedTrunk(INetCircuitEnd var0, INetCircuitEnd var1_1) {
        block27: {
            var2_2 = var0.getEntityIndex();
            var3_3 = var1_1.getEntityIndex();
            var4_4 = Network.instance().findNetLinkFromSource(false, var0.getNetElement(), var2_2, null);
            if (var4_4 == null) {
                var4_4 = Network.instance().findNetLinkFromDestination(false, var0.getNetElement(), var2_2, null);
            }
            if ((var5_5 = Network.instance().findNetLinkFromSource(false, var1_1.getNetElement(), var3_3, null)) == null) {
                var5_5 = Network.instance().findNetLinkFromDestination(false, var1_1.getNetElement(), var3_3, null);
            }
            if (var4_4 != null && var5_5 != null) {
                if (var4_4.getSrcEntityIndex() == var2_2) {
                    var6_6 = var4_4.getDstEntityIndex();
                    var7_8 = var4_4.getDst().getNodeModel();
                } else {
                    var6_6 = var4_4.getSrcEntityIndex();
                    var7_8 = var4_4.getSrc().getNodeModel();
                }
                if (var5_5.getSrcEntityIndex() == var3_3) {
                    var8_10 = var5_5.getDstEntityIndex();
                    var9_11 = var5_5.getDst().getNodeModel();
                } else {
                    var8_10 = var5_5.getSrcEntityIndex();
                    var9_11 = var5_5.getSrc().getNodeModel();
                }
                if (var7_8.equals(var9_11) && var6_6 == var8_10) {
                    var10_13 /* !! */  = var7_8.getEntityTable();
                    try {
                        var11_15 = var10_13 /* !! */ .getEntityModelByIndex(var6_6);
                        if (OchTrailHelper.isTrunkPort(var11_15)) {
                            if (OchTrailHelper.db.on()) {
                                OchTrailHelper.db.println("Found common trunk port: " + var11_15);
                            }
                            var12_17 = new UpgradeOchncInfo(var11_15, var4_4, var5_5);
                            return var12_17;
                        }
                        if (!OchTrailHelper.db.on()) ** GOTO lbl40
                        OchTrailHelper.db.println("Found common port linking 2 OCH ports, but it is not a Trunk port: " + var11_15);
                    }
                    catch (AbstractCmsNoSuchEntityException var11_16) {
                        if (OchTrailHelper.db.on()) {
                            OchTrailHelper.db.println("Cannot find EM for common port " + var6_6 + " on node " + var7_8);
                        }
                        return null;
                    }
                } else {
                    if (OchTrailHelper.db.on()) {
                        OchTrailHelper.db.println("Found 2 VL starting from the 2 OCH ports, but they have different destinations: " + var6_6 + "/" + var7_8 + " and " + var8_10 + "/" + var9_11);
                    }
                    return null;
                }
            }
lbl40:
            // 4 sources

            if (var4_4 != null || var5_5 != null) {
                if (OchTrailHelper.db.on()) {
                    OchTrailHelper.db.println("Found only one VL starting from one of the 2 OCH ports: " + (var4_4 != null ? var4_4.prettyString() : var5_5.prettyString()));
                }
                return null;
            }
            var9_12 = var0 instanceof OchncCircuitEnd != false ? ((OchncCircuitEnd)var0).getOptChannel() : (var1_1 instanceof OchncCircuitEnd != false ? ((OchncCircuitEnd)var1_1).getOptChannel() : 0);
            try {
                var6_7 = OchTrailHelper.getColocatedTrunkPort(var0.getEntityModel(), var9_12);
                if (var6_7 != null) {
                    var7_9 = var6_7.getEntityIndex();
                    var6_7 = OchTrailHelper.getColocatedTrunkPort(var1_1.getEntityModel(), var9_12);
                    if (var6_7 != null) {
                        var8_10 = var6_7.getEntityIndex();
                        if (var8_10 == var7_9) {
                            var10_13 /* !! */  = new UpgradeOchncInfo(var6_7, var0.getEntityModel(), var1_1.getEntityModel());
                            return var10_13 /* !! */ ;
                        }
                        if (OchTrailHelper.db.on()) {
                            OchTrailHelper.db.println("Found 2 internal links starting from the OCH ports but terminating on different ports: " + Integer.toHexString(var7_9) + ", " + Integer.toHexString(var8_10));
                        }
                    } else if (OchTrailHelper.db.on()) {
                        OchTrailHelper.db.println("No colocated trunk from och port: " + var1_1.getEntityModel());
                    }
                } else if (OchTrailHelper.db.on()) {
                    OchTrailHelper.db.println("No colocated trunk from och port: " + var0.getEntityModel());
                }
            }
            catch (ObjNotFound var10_14) {
                if (!OchTrailHelper.db.on()) break block27;
                OchTrailHelper.db.println("Cannot find interal links for " + var0);
                SDebug.printStackTrace((Throwable)var10_14);
            }
        }
        return null;
    }

    public static IEntityModel[] getClientPorts(IEntityModel iEntityModel) {
        Iterator iterator;
        Object object;
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        List list = iModuleModel.getDescendantsOfEqType(122);
        if (iModuleModel.getEqType() == 293 && Feature.provides((INodeModel)iModuleModel.getNodeModel(), (Feature)Feature.OTU2_XP)) {
            object = iModuleModel.getDescendantsOfEqType(123);
            iterator = object.iterator();
            ArrayList<IPortModel> arrayList = new ArrayList<IPortModel>();
            while (iterator.hasNext()) {
                IPortModel iPortModel = (IPortModel)iterator.next();
                try {
                    if (!((IDwdmLineModel)iPortModel.getInterfaceModel()).isClient()) continue;
                    arrayList.add(iPortModel);
                }
                catch (NoSuchInterface noSuchInterface) {
                    noSuchInterface.printStackTrace();
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    wrongInterfaceType.printStackTrace();
                }
            }
            list.addAll(arrayList);
        }
        if (db.on()) {
            object = new StringBuffer("getClientPorts(" + iEntityModel + ") :\n");
            iterator = list.iterator();
            while (iterator.hasNext()) {
                ((StringBuffer)object).append("\n" + iterator.next());
            }
            db.println(((StringBuffer)object).toString());
        }
        return list.toArray(new IEntityModel[0]);
    }

    public static List getAvailOchccPorts(INodeModel iNodeModel) {
        LinkedList<IEntityModel> linkedList = new LinkedList<IEntityModel>();
        if (iNodeModel.provides(Feature.OCH_TRAIL_PROVISIONING)) {
            int[] nArray;
            IEntityTableModel iEntityTableModel;
            block9: {
                iEntityTableModel = iNodeModel.getEntityTable();
                nArray = new int[]{};
                try {
                    nArray = iNodeModel.getINodeOpticsTopologyModel().getAvailOchccPorts();
                }
                catch (Exception exception) {
                    if (!db.on()) break block9;
                    db.println("Cannot get available client ports for OCHNC: " + exception.getMessage());
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (db.on()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < nArray.length; ++i) {
                    stringBuffer.append(" ");
                    stringBuffer.append(Integer.toHexString(nArray[i]));
                }
                db.println("Node " + iNodeModel + " - ADD entities for " + ": [" + stringBuffer + "]");
            }
            for (int i = 0; nArray != null && i < nArray.length; ++i) {
                try {
                    linkedList.add(iEntityTableModel.getEntityModelByIndex(nArray[i]));
                    continue;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        } else {
            throw new FeatureNotSupported("OchTrailHelper.getAvailOchccPorts() is not supported");
        }
        return linkedList;
    }

    public static int getPayloadEqType(IEntityModel iEntityModel) {
        int n = -1;
        IEntityModel iEntityModel2 = OchTrailHelper.getPPM(iEntityModel);
        if (iEntityModel2 != null) {
            n = iEntityModel2.getEqType();
        }
        if (db.on()) {
            db.println("getPayloadEqType( " + iEntityModel + ") is : " + EqTypeHelper.eqTypeToName((TDMTerminology)iEntityModel.getNodeModel().getTDMTerminology(), (int)n));
        }
        return n;
    }

    public static IEntityModel getPPM(IEntityModel iEntityModel) {
        Iterator iterator;
        Object object2;
        IEntityModel iEntityModel2 = null;
        List list = iEntityModel.getModuleModel().getDescendantsOfEqType(150);
        IPpmModel iPpmModel = null;
        LinkedList linkedList = null;
        if (list.size() > 0) {
            if (db.on()) {
                db.println("getPayloadEqType( " + iEntityModel + ") found " + list.size() + " ppms");
            }
            linkedList = new LinkedList();
            for (Object object2 : list) {
                iPpmModel = object2;
                linkedList.addAll(object2.getContainedPorts());
                if (!db.on()) continue;
                db.println("Found " + object2.getContainedPorts().size() + " in container " + iPpmModel);
            }
        } else {
            if (db.on()) {
                db.println("getPayloadEqType( " + iEntityModel + ") cannot find PPMs");
            }
            if ((iterator = iEntityModel.getModuleModel().getDescendantsOfEqType(193)) != null && iterator.size() > 0) {
                if (db.on()) {
                    db.println("getPayloadEqType( " + iEntityModel + ") found " + iterator.size() + " MR slots");
                }
                linkedList = new LinkedList();
                object2 = iterator.iterator();
                while (object2.hasNext()) {
                    iPpmModel = (IEntityModel)object2.next();
                    linkedList.addAll(iPpmModel.getDescendantsOfClassType(7));
                    if (!db.on()) continue;
                    db.println("Found " + iPpmModel.getDescendantsOfClassType(7).size() + " in container " + iPpmModel);
                }
            } else if (db.on()) {
                db.println("getPayloadEqType( " + iEntityModel + ") cannot find MR slots");
            }
        }
        if (linkedList != null) {
            iterator = linkedList.iterator();
            object2 = ((IPortModel)iEntityModel).getPortNum();
            while (iterator.hasNext() && iEntityModel2 == null) {
                int[] nArray;
                IEntityModel iEntityModel3 = (IEntityModel)iterator.next();
                if (iEntityModel3 == null || !(iEntityModel3 instanceof IPortModel) || (nArray = ((IPortModel)iEntityModel3).getPortNum()).length <= 0 || nArray[0] != object2[0]) continue;
                iEntityModel2 = iEntityModel3;
            }
        }
        if (db.on()) {
            db.println("getPPM( " + iEntityModel + ") is : " + iEntityModel2);
        }
        return iEntityModel2;
    }

    public static INetLink findPeer2PeerLink(INetElement iNetElement, int n, INetElement iNetElement2, int n2) {
        if (db.on()) {
            db.println("Looking for peer 2 peer from " + iNetElement.getName() + "/" + Integer.toHexString(n) + " to " + iNetElement2.getName() + "/" + Integer.toHexString(n2));
        }
        INetLink iNetLink = null;
        Network network = Network.instance();
        Collection collection = network.findVirtualLinks(iNetElement, iNetElement2);
        for (INetLink iNetLink2 : collection) {
            if (iNetLink2.getSrcEntityIndex() != n || iNetLink2.getDstEntityIndex() != n2) continue;
            iNetLink = iNetLink2;
            break;
        }
        if (iNetLink == null && (iNetLink = Network.instance().findOchTrailTunnelNetLinkFromSrc(iNetElement, n)) != null && (iNetLink.getDst().getNodeId() != iNetElement2.getNodeId() || iNetLink.getDstEntityIndex() != n2)) {
            if (db.on()) {
                db.println("Peer 2 peer found but on different destination NE/port: " + iNetLink);
            }
            iNetLink = null;
        }
        if (db.on()) {
            db.println("Peer 2 peer link is: " + iNetLink);
        }
        return iNetLink;
    }

    public static IOptLinkModel[] getInternalOptLinks(IEntityModel iEntityModel) {
        IOptLinkModel[] iOptLinkModelArray;
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        int n = iEntityModel.getEntityIndex();
        if (db.on()) {
            db.println("getInternalOptLinks(" + iEntityModel + ") [" + Integer.toHexString(n) + "] on node " + iNodeModel.getName());
        }
        LinkedList<IOptLinkModel> linkedList = new LinkedList<IOptLinkModel>();
        if (iEntityModel.getNodeModel().provides(Feature.OCH_TRAIL_PROVISIONING)) {
            iOptLinkModelArray = iNodeModel.getIOpticalPatchCordModel();
            try {
                IOptLinkModel[] iOptLinkModelArray2 = iOptLinkModelArray.getIOptLinkModels();
                for (int i = 0; i < iOptLinkModelArray2.length; ++i) {
                    IOptLinkModel iOptLinkModel = iOptLinkModelArray2[i];
                    if (iOptLinkModel.getFrom() != n && iOptLinkModel.getTo() != n) continue;
                    linkedList.add(iOptLinkModel);
                }
            }
            catch (FeatureUnsupported featureUnsupported) {
                SDebug.printStackTrace((Throwable)featureUnsupported);
            }
        } else if (db.on()) {
            db.println("getInternalOptLinks(" + iEntityModel + ") Node pre 7.0 - Skipped");
        }
        iOptLinkModelArray = linkedList.toArray(new IOptLinkModel[0]);
        if (db.on()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < iOptLinkModelArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(Integer.toHexString(iOptLinkModelArray[i].getFrom()) + "<--> " + Integer.toHexString(iOptLinkModelArray[i].getTo()));
            }
            db.println("Found " + iOptLinkModelArray.length + " optical links from/to " + Integer.toHexString(n) + ": [" + stringBuffer + "]");
        }
        return iOptLinkModelArray;
    }

    private static String dumpArray(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; nArray != null && i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(nArray[i] + ": " + EqTypeHelper.eqTypeToName((TDMTerminology)TDMTerminology.getDefault(), (int)nArray[i]));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static IEntityModel[] getClientPortsForTrunk(IEntityModel iEntityModel) {
        if (OchTrailHelper.isClientPort(iEntityModel)) {
            return new IEntityModel[]{iEntityModel};
        }
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        return OchTrailHelper.getClientPortsForTrunk(iNodeModel, iEntityModel.getEntityIndex());
    }

    public static IEntityModel[] getClientPortsForTrunk(INodeModel iNodeModel, int n) {
        Object object;
        IEntityModel[] iEntityModelArray;
        block11: {
            if (db.on()) {
                db.println("Finding client ports for trunk " + n + ", node " + iNodeModel);
            }
            iEntityModelArray = new IEntityModel[]{};
            try {
                Object object2;
                object = iNodeModel.getEntityTable();
                if (iNodeModel.provides(Feature.OTU2_XP)) {
                    object2 = iNodeModel.getINodeOpticsTopologyModel().getAvailClientsForTrunk(n);
                    iEntityModelArray = new IEntityModel[((int[])object2).length];
                    for (int i = 0; i < ((int[])object2).length; ++i) {
                        iEntityModelArray[i] = object.getEntityModelByIndex(object2[i]);
                    }
                } else {
                    if (db.on()) {
                        db.println("Node does not provide OTU2_XP feature..trying withold style getClientPorts");
                    }
                    object2 = object.getEntityModelByIndex(n);
                    iEntityModelArray = OchTrailHelper.getClientPorts((IEntityModel)object2);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            catch (NoSuchEquipment noSuchEquipment) {
                if (!db.on()) break block11;
                SDebug.printStackTrace((Throwable)noSuchEquipment);
            }
        }
        if (db.on()) {
            object = new StringBuffer();
            for (int i = 0; i < iEntityModelArray.length; ++i) {
                ((StringBuffer)object).append("\n" + iEntityModelArray[i]);
            }
            db.println("Found client ports: " + object);
        }
        return iEntityModelArray;
    }

    public static boolean isValidCRSOchTrailCircuitName(String string) {
        if (string.length() > 24) {
            return false;
        }
        String string2 = "[a-zA-Z0-9\\-\\.\\_\\?\\!\\,\\=\\%\\|\\[\\]\\{\\}\\(\\)\\;]*";
        return Pattern.matches(string2, string);
    }

    public static String sanitizeCRSOchTrailCircuitName(String string) {
        String string2 = "[a-zA-Z0-9\\-\\.\\_\\?\\!\\,\\=\\%\\|\\[\\]\\{\\}\\(\\)\\;]";
        Pattern pattern = Pattern.compile(string2);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (!pattern.matcher(String.valueOf(string.charAt(i))).matches()) continue;
            stringBuffer.append(string.charAt(i));
        }
        String string3 = stringBuffer.toString();
        if (string3.length() > 24) {
            string3 = string3.substring(0, 24);
        }
        return string3;
    }

    static {
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        hashMap.put(new Integer(181), new int[]{118, 293});
        hashMap.put(new Integer(118), new int[]{181});
        hashMap.put(new Integer(293), new int[]{181});
        interOperabilityMap.put(OchccCircuitSize.SIZE_OCHCC_OC_192, hashMap);
        hashMap = new HashMap();
        hashMap.put(new Integer(181), new int[]{118, 293});
        hashMap.put(new Integer(118), new int[]{181});
        hashMap.put(new Integer(293), new int[]{181});
        interOperabilityMap.put(OchccCircuitSize.SIZE_OCHCC_STM_64, hashMap);
        hashMap = new HashMap();
        hashMap.put(new Integer(181), new int[]{118, 293, 271});
        hashMap.put(new Integer(118), new int[]{181});
        hashMap.put(new Integer(271), new int[]{181, 293});
        hashMap.put(new Integer(293), new int[]{181, 271});
        interOperabilityMap.put(OchccCircuitSize.SIZE_OCHCC_10_GE, hashMap);
        hashMap = new HashMap();
        hashMap.put(new Integer(181), new int[]{293});
        hashMap.put(new Integer(293), new int[]{181});
        interOperabilityMap.put(OchccCircuitSize.SIZE_OCHCC_10_GFC, hashMap);
    }

    public static class UpgradeOchncInfo {
        private IEntityModel trunkPort;
        private INetLink virtualLink1;
        private INetLink virtualLink2;
        private IEntityModel ochPort1;
        private IEntityModel ochPort2;

        public UpgradeOchncInfo(IEntityModel iEntityModel, INetLink iNetLink, INetLink iNetLink2) {
            this.trunkPort = iEntityModel;
            this.virtualLink1 = iNetLink;
            this.virtualLink2 = iNetLink2;
            this.ochPort1 = null;
            this.ochPort2 = null;
        }

        public UpgradeOchncInfo(IEntityModel iEntityModel, IEntityModel iEntityModel2, IEntityModel iEntityModel3) {
            this.trunkPort = iEntityModel;
            this.virtualLink1 = null;
            this.virtualLink2 = null;
            this.ochPort1 = iEntityModel2;
            this.ochPort2 = iEntityModel3;
        }

        public IEntityModel getTrunkPort() {
            return this.trunkPort;
        }

        public INetLink getVirtualLink1() {
            return this.virtualLink1;
        }

        public INetLink getVirtualLink2() {
            return this.virtualLink2;
        }

        public boolean isColocated() {
            return this.ochPort1 != null && this.ochPort2 != null;
        }
    }

    public static class OchccCircuitSize
    implements Comparable {
        public static final OchccCircuitSize SIZE_OCHCC_OC_192 = new OchccCircuitSize("OC-192", 61, 0);
        public static final OchccCircuitSize SIZE_OCHCC_OC_48 = new OchccCircuitSize("OC-48", 30, 0);
        public static final OchccCircuitSize SIZE_OCHCC_OC_12 = new OchccCircuitSize("OC-12", 29, 0);
        public static final OchccCircuitSize SIZE_OCHCC_OC_3 = new OchccCircuitSize("OC-3", 28, 0);
        public static final OchccCircuitSize SIZE_OCHCC_STM_64 = new OchccCircuitSize("STM-64", 61);
        public static final OchccCircuitSize SIZE_OCHCC_STM_16 = new OchccCircuitSize("STM-16", 30);
        public static final OchccCircuitSize SIZE_OCHCC_STM_4 = new OchccCircuitSize("STM-4", 29);
        public static final OchccCircuitSize SIZE_OCHCC_STM_1 = new OchccCircuitSize("STM-1", 28);
        public static final OchccCircuitSize SIZE_OCHCC_10_GE = new OchccCircuitSize("10GE", 168);
        public static final OchccCircuitSize SIZE_OCHCC_1_GE = new OchccCircuitSize("1GE", 167);
        public static final OchccCircuitSize SIZE_OCHCC_FE = new OchccCircuitSize("FE", 316);
        public static final OchccCircuitSize SIZE_OCHCC_10_GFC = new OchccCircuitSize("FC10G", 178);
        public static final OchccCircuitSize SIZE_OCHCC_4_GFC = new OchccCircuitSize("FC4G", 244);
        public static final OchccCircuitSize SIZE_OCHCC_2_GFC = new OchccCircuitSize("FC2G", 177);
        public static final OchccCircuitSize SIZE_OCHCC_1_GFC = new OchccCircuitSize("FC1G", 176);
        public static final OchccCircuitSize SIZE_OCHCC_4_GFICON = new OchccCircuitSize("FICON4G", 245);
        public static final OchccCircuitSize SIZE_OCHCC_2_GFICON = new OchccCircuitSize("FICON2G", 180);
        public static final OchccCircuitSize SIZE_OCHCC_1_GFICON = new OchccCircuitSize("FICON1G", 179);
        public static final OchccCircuitSize SIZE_OCHCC_ESCON = new OchccCircuitSize("ESCON", 169);
        public static final OchccCircuitSize SIZE_OCHCC_ETR_CLO = new OchccCircuitSize("ETR-CLO", 174);
        public static final OchccCircuitSize SIZE_OCHCC_ISC_PEER = new OchccCircuitSize("ISC PEER", 194);
        public static final OchccCircuitSize SIZE_OCHCC_ISC3_PEER_1G = new OchccCircuitSize("ISC3 PEER 1G", 246);
        public static final OchccCircuitSize SIZE_OCHCC_ISC3_PEER_2G = new OchccCircuitSize("ISC3 PEER 2G", 247);
        public static final OchccCircuitSize SIZE_OCHCC_ISC_COMPAT = new OchccCircuitSize("ISC COMPAT", 175);
        public static final OchccCircuitSize SIZE_OCHCC_IB_5G = new OchccCircuitSize("IB_5G", 325);
        public static final OchccCircuitSize SIZE_OCHCC_HDTV = new OchccCircuitSize("HDTV", 172);
        public static final OchccCircuitSize SIZE_OCHCC_SD1_D1 = new OchccCircuitSize("SD1/D1", 171);
        public static final OchccCircuitSize SIZE_OCHCC_DV6000 = new OchccCircuitSize("DV6000", 170);
        public static final OchccCircuitSize SIZE_OCHCC_PASSTROUGH = new OchccCircuitSize("Pass-trough", 173);
        public static final OchccCircuitSize SIZE_OCHCC_DVB_ASI = new OchccCircuitSize("DVB-ASI", 322);
        public static final OchccCircuitSize SIZE_OCHCC_ISC1 = new OchccCircuitSize("ISC1", 323);
        private static Map enumerations;
        private String label;
        private int eqType;
        private int protocolType;

        private OchccCircuitSize(String string, int n) {
            this(string, n, -1);
        }

        private OchccCircuitSize(String string, int n, int n2) {
            Integer n3;
            Object v;
            this.label = string;
            this.eqType = n;
            this.protocolType = n2;
            if (enumerations == null) {
                enumerations = new HashMap();
            }
            if ((v = enumerations.get(n3 = new Integer(n))) == null) {
                enumerations.put(n3, this);
            } else {
                LinkedList<Object> linkedList;
                if (v instanceof OchccCircuitSize) {
                    linkedList = new LinkedList<Object>();
                    linkedList.add(v);
                } else {
                    linkedList = (LinkedList<Object>)v;
                }
                linkedList.add(this);
                enumerations.put(n3, linkedList);
            }
        }

        public String toString() {
            return this.label;
        }

        public int intValue() {
            return this.eqType;
        }

        public static OchccCircuitSize fromInt(int n, int n2) {
            if (db.on()) {
                db.println("Mapping Och-Trail ckt size from eqType = " + n + ", protocolType = " + n2);
            }
            OchccCircuitSize ochccCircuitSize = null;
            Object v = enumerations.get(new Integer(n));
            if (v != null) {
                if (v instanceof OchccCircuitSize) {
                    ochccCircuitSize = (OchccCircuitSize)v;
                } else {
                    LinkedList linkedList = (LinkedList)v;
                    Iterator iterator = linkedList.iterator();
                    while (iterator.hasNext() && ochccCircuitSize == null) {
                        OchccCircuitSize ochccCircuitSize2 = (OchccCircuitSize)iterator.next();
                        if (db.on()) {
                            db.println("Trying with " + ochccCircuitSize2 + " (protocolType = " + ochccCircuitSize2.protocolType + ")");
                        }
                        if (ochccCircuitSize2.protocolType != -1) {
                            if (ochccCircuitSize2.protocolType != n2) continue;
                            ochccCircuitSize = ochccCircuitSize2;
                            continue;
                        }
                        ochccCircuitSize = ochccCircuitSize2;
                    }
                }
            }
            if (db.on()) {
                db.println("Returning " + ochccCircuitSize);
            }
            return ochccCircuitSize;
        }

        public int compareTo(Object object) {
            return this.toString().compareTo(((OchccCircuitSize)object).toString());
        }
    }
}

