/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.CmsObservable;
import cerent.cms.model.IProgressManager;
import cerent.cms.model.ProgressEvent;
import cerent.util.IPAddressTranslator;
import cerent.util.SDebug;

public class ProgressManager
extends CmsObservable
implements IProgressManager {
    private static ProgressManager instance;
    private int currentStepIndex;
    private static final SDebug db;

    public static ProgressManager instance() {
        if (instance == null) {
            instance = new ProgressManager();
        }
        return instance;
    }

    public String[] getStepList() {
        return steps;
    }

    public String getStepString(int n) {
        return steps[n];
    }

    public int getStepIndex(String string) {
        int n = 0;
        while (!string.equals(steps[n])) {
            ++n;
        }
        return n;
    }

    private void sendProgressEvent(ProgressEvent progressEvent) {
        if (db.on()) {
            db.println("sendProgressEvent( " + progressEvent + " )");
        }
        this.setChanged();
        this.notifyObservers(progressEvent);
    }

    public void startStep(String string, String string2) {
        block4: {
            if (IPAddressTranslator.instance().isVirtualMapped(string)) {
                string = IPAddressTranslator.instance().getActualAddressDisplay(string);
            }
            if (db.on()) {
                db.println("startStep( " + string + ", " + string2 + " )");
            }
            try {
                int n = this.getStepIndex(string2);
                String string3 = string != null ? string + ": " + steps[n] : steps[n];
                this.currentStepIndex = n;
                this.sendProgressEvent(new ProgressEvent(1, n, string3, null));
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void startStep(String string) {
        this.startStep(null, string);
    }

    public void addStepInfo(String string) {
        this.sendProgressEvent(new ProgressEvent(3, this.currentStepIndex, string, null));
    }

    public void addStepWarning(Exception exception) {
        this.sendProgressEvent(new ProgressEvent(2, this.currentStepIndex, steps[this.currentStepIndex], exception));
    }

    public void allCompleted(Exception exception) {
        this.sendProgressEvent(new ProgressEvent(exception == null ? 4 : 5, this.currentStepIndex, steps[this.currentStepIndex], exception));
    }

    private ProgressManager() {
    }

    static {
        db = new SDebug("ProgressManager");
    }
}

