/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.blsr;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.ConfigError;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhConnectionModels;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ITdmLineModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.blsr.BlsrNode;
import cerent.cms.model.blsr.ByteInUseException;
import cerent.cms.model.blsr.ExtensionBytesNotInSyncException;
import cerent.cms.model.blsr.NeitherExtensionByteEditableException;
import cerent.cms.model.blsr.OnlyK3Exception;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import cerent.util.UObservable;
import java.util.Observable;
import java.util.Observer;

public class BlsrSpan {
    private INetLink netLink;
    private INetLink reverseLink;
    private ITdmPortModel westProtectPort;
    private ITdmPortModel eastProtectPort;
    private ITdmLineModel sourceLine;
    private ITdmLineModel destinationLine;
    private LineModelNotifier lineNotifier;
    private Boolean extensionBytesEditable = null;
    private Boolean sourceEditable = null;
    private Boolean destinationEditable = null;
    private Integer extensionByteValue = null;
    private boolean workingSpan;
    private BlsrNode westSide = null;
    private BlsrNode eastSide = null;
    private NetLinkDeathObserver netLinkDeathObserver;
    private BlsrSpanDeathNotifier spanDeathNotifier;
    private BlsrSpanReversionNotifier reversionNotifier;
    private BlsrSpanChannelStateNotifier channelStateNotifier;
    private short currentChannelState = (short)2;
    private boolean isObserver = true;
    private static final String className = "BlsrSpan";
    private static final SDebug db = new SDebug("BlsrSpan");
    private volatile boolean isDestroyed = false;
    BlsrSpan parallelProtectSpan = null;
    String toStringValue;

    public BlsrSpan(INetLink iNetLink, boolean bl) throws InstantiationException {
        if (!this.isValidNetLink(iNetLink)) {
            throw new InstantiationException("Both sides of the link must support the BLSR wizard.");
        }
        this.netLink = iNetLink;
        this.workingSpan = true;
        this.reverseLink = this.getReverseLink();
        this.netLinkDeathObserver = new NetLinkDeathObserver();
        this.spanDeathNotifier = new BlsrSpanDeathNotifier();
        this.reversionNotifier = new BlsrSpanReversionNotifier();
        this.channelStateNotifier = new BlsrSpanChannelStateNotifier();
        this.lineNotifier = new LineModelNotifier();
        this.isObserver = bl;
        this.fetchLineModelsForWorkingBlsrSpan();
        if (bl) {
            if (db.on()) {
                db.println("BlsrSpan created, add net link Death Observer.");
            }
            UObservable.addObserver((Object)iNetLink, (Object)this.netLinkDeathObserver, (String)className);
        }
        if (db.on()) {
            db.println("BlsrSpan created (working) " + iNetLink + " (F) & " + this.reverseLink + " (R)");
        }
        this.toString();
    }

    public BlsrSpan(INetLink iNetLink) throws InstantiationException {
        this(iNetLink, true);
    }

    private BlsrSpan(BlsrNode blsrNode, BlsrNode blsrNode2, boolean bl) {
        this.workingSpan = false;
        this.eastProtectPort = blsrNode.getEastProtectPort();
        this.westProtectPort = blsrNode2.getWestProtectPort();
        this.eastSide = blsrNode;
        this.westSide = blsrNode2;
        this.isObserver = bl;
        this.lineNotifier = new LineModelNotifier();
        this.fetchLineModelsForProtectBlsrSpan();
        this.spanDeathNotifier = new BlsrSpanDeathNotifier();
        this.reversionNotifier = new BlsrSpanReversionNotifier();
        this.channelStateNotifier = new BlsrSpanChannelStateNotifier();
        if (blsrNode != null) {
            UObservable.addObserver((Object)blsrNode, (Object)this.channelStateNotifier, (String)className);
        }
        if (blsrNode2 != null) {
            UObservable.addObserver((Object)blsrNode2, (Object)this.channelStateNotifier, (String)className);
        }
        if (db.on()) {
            db.println("BlsrSpan created (protect) EastProtectPort=" + this.eastProtectPort + ", westProtectPort=" + this.westProtectPort);
        }
    }

    private BlsrSpan(BlsrNode blsrNode, BlsrNode blsrNode2) {
        this(blsrNode, blsrNode2, true);
    }

    private boolean isValidNetLink(INetLink iNetLink) {
        INodeModel iNodeModel = iNetLink.getSrc().getNodeModel();
        INodeModel iNodeModel2 = iNetLink.getDst().getNodeModel();
        return iNodeModel.provides(Feature.NET_BLSR_WIZ) && iNodeModel2.provides(Feature.NET_BLSR_WIZ);
    }

    public short getChannelState() {
        if (this.currentChannelState == 2) {
            this.currentChannelState = this.isProtectSpan() ? (this.getEastSide().getEastProtectChannelState() == 0 && this.getWestSide().getWestProtectChannelState() == 0 ? (short)0 : 1) : (this.getEastSide().getEastChannelState() == 0 && this.getWestSide().getWestChannelState() == 0 ? (short)0 : 1);
        }
        return this.currentChannelState;
    }

    public long getOspfAreaId() {
        long l = -1L;
        if (this.netLink != null) {
            l = this.netLink.getOspfAreaId();
        }
        return l;
    }

    private void setChannelState(short s) {
        short s2 = this.getChannelState();
        if (BlsrSpan.db.on) {
            db.println("originalChannelState=" + s2 + ", newChannelState=" + s);
        }
        if (s != s2) {
            this.currentChannelState = s;
            this.channelStateNotifier.notifyObservers(this);
        }
    }

    private void fetchLineModelsForProtectBlsrSpan() {
        if (this.sourceLine == null) {
            if (this.eastProtectPort == null) {
                this.eastProtectPort = this.eastSide.getEastProtectPort();
            }
            if (this.eastProtectPort != null) {
                this.sourceLine = this.eastProtectPort.getITdmLineModel();
            }
            if (this.sourceLine != null && this.isObserver) {
                ModelIndirectObservable.instance().addObserver((IObservable)this.sourceLine, this.lineNotifier);
            } else if (this.isObserver && db.on()) {
                db.println("This is the result of a race condition and it will prevent observation of K3-byte events on this span.");
            }
        }
        if (this.destinationLine == null) {
            if (this.westProtectPort == null) {
                this.westProtectPort = this.westSide.getWestProtectPort();
            }
            if (this.westProtectPort != null) {
                this.destinationLine = this.westProtectPort.getITdmLineModel();
            }
            if (this.destinationLine != null && this.isObserver) {
                ModelIndirectObservable.instance().addObserver((IObservable)this.destinationLine, this.lineNotifier);
            } else if (this.isObserver && db.on()) {
                db.println("This is the result of a race condition and it will prevent observation of K3-byte events on this span.");
            }
        }
    }

    private void fetchLineModelsForWorkingBlsrSpan() {
        ITdmPortModel iTdmPortModel;
        IEntityTableModel iEntityTableModel = null;
        if (this.sourceLine == null) {
            try {
                iEntityTableModel = this.netLink.getSrc().getNodeModel().getEntityTable();
                if (iEntityTableModel != null) {
                    iTdmPortModel = (ITdmPortModel)iEntityTableModel.getEntityModelByIndex(this.netLink.getSrcEntityIndex());
                    ITdmLineModel iTdmLineModel = this.sourceLine = iTdmPortModel != null ? iTdmPortModel.getITdmLineModel() : null;
                    if (this.sourceLine != null && this.isObserver) {
                        ModelIndirectObservable.instance().addObserver((IObservable)this.sourceLine, this.lineNotifier);
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        if (this.destinationLine == null) {
            try {
                iEntityTableModel = this.netLink.getDst().getNodeModel().getEntityTable();
                if (iEntityTableModel != null) {
                    iTdmPortModel = (ITdmPortModel)iEntityTableModel.getEntityModelByIndex(this.netLink.getDstEntityIndex());
                    ITdmLineModel iTdmLineModel = this.destinationLine = iTdmPortModel != null ? iTdmPortModel.getITdmLineModel() : null;
                    if (this.destinationLine != null && this.isObserver) {
                        ModelIndirectObservable.instance().addObserver((IObservable)this.destinationLine, this.lineNotifier);
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
    }

    public boolean isProtectSpan() {
        return !this.workingSpan;
    }

    public BlsrNode getWestSide() {
        return this.westSide;
    }

    public void setWestSide(BlsrNode blsrNode) {
        if (null != this.westSide) {
            UObservable.deleteObserver((Object)this.westSide, (Object)this.channelStateNotifier, (String)className);
        }
        this.westSide = blsrNode;
        if (null != this.westSide) {
            UObservable.addObserver((Object)this.westSide, (Object)this.channelStateNotifier, (String)className);
        }
    }

    public BlsrNode getEastSide() {
        return this.eastSide;
    }

    public void setEastSide(BlsrNode blsrNode) {
        if (null != this.eastSide) {
            UObservable.deleteObserver((Object)this.eastSide, (Object)this.channelStateNotifier, (String)className);
        }
        this.eastSide = blsrNode;
        if (null != this.eastSide) {
            UObservable.addObserver((Object)this.eastSide, (Object)this.channelStateNotifier, (String)className);
        }
    }

    public INetLink getOriginalLink() {
        INetLink iNetLink = null;
        if (this.workingSpan) {
            iNetLink = this.netLink;
        }
        return iNetLink;
    }

    public INetLink getReverseLink() {
        INetLink iNetLink = null;
        if (this.workingSpan) {
            if (this.reverseLink == null) {
                this.reverseLink = Network.instance().findReverseLink(this.netLink);
                if (this.reverseLink != null && !this.reverseLink.isSdccLink()) {
                    this.reverseLink = null;
                }
                if (db.on()) {
                    db.println("[getReverseLink] Reverse link of " + this.netLink + " is " + this.reverseLink);
                }
            }
            iNetLink = this.reverseLink;
        }
        return iNetLink;
    }

    public BlsrSpan getParallelProtectSpan() {
        if (null == this.parallelProtectSpan) {
            if (this.getEastSide().getEastProtectPort() == null || this.getWestSide().getWestProtectPort() == null) {
                throw new IllegalStateException("Not all of the protect ports have been defined!");
            }
            this.parallelProtectSpan = new BlsrSpan(this.getEastSide(), this.getWestSide(), this.isObserver);
        }
        return this.parallelProtectSpan;
    }

    public BlsrSpan getParallelProtectSpanToBe() {
        if (this.getEastSide().getEastProtectPort() == null || this.getWestSide().getWestProtectPort() == null) {
            throw new IllegalStateException("Not all of the protect ports have been defined!");
        }
        return new BlsrSpan(this.getEastSide(), this.getWestSide(), false);
    }

    public ITdmPortModel getEastProtectPort() {
        if (!this.workingSpan) {
            this.eastProtectPort = !this.getEastSide().isFourFiber() && this.isObserver ? this.eastSide.getEastPort() : this.eastSide.getEastProtectPort();
        }
        if (BlsrSpan.db.on) {
            db.println("BlsrSpan " + this + " returning eastProtectPort=" + this.eastProtectPort);
        }
        return this.eastProtectPort;
    }

    public ITdmPortModel getWestProtectPort() {
        if (!this.workingSpan) {
            this.westProtectPort = !this.getWestSide().isFourFiber() && this.isObserver ? this.westSide.getWestPort() : this.westSide.getWestProtectPort();
        }
        if (BlsrSpan.db.on) {
            db.println("BlsrSpan " + this + " returning westProtectPort=" + this.westProtectPort);
        }
        return this.westProtectPort;
    }

    public boolean isExtensionByteEditable() {
        if (this.sourceLine == null || this.destinationLine == null) {
            return false;
        }
        if (null == this.extensionBytesEditable) {
            this.extensionBytesEditable = this.isSourceLineEditable() && this.isDestinationLineEditable();
        }
        return this.extensionBytesEditable;
    }

    public boolean isLdccInUse() {
        return this.sourceLine.getNodeModel().getOhConnectionModels().isChannelInUse(this.sourceLine.getIndex(), OhChannelType.LDCC_OBJ);
    }

    private boolean isSourceLineEditable() {
        if (this.sourceLine == null) {
            return false;
        }
        if (null == this.sourceEditable) {
            this.sourceEditable = this.isLineEditable(this.sourceLine);
        }
        return this.sourceEditable;
    }

    private boolean isDestinationLineEditable() {
        if (this.destinationLine == null) {
            return false;
        }
        if (null == this.destinationEditable) {
            this.destinationEditable = this.isLineEditable(this.destinationLine);
        }
        return this.destinationEditable;
    }

    private boolean isLineEditable(ITdmLineModel iTdmLineModel) {
        try {
            iTdmLineModel.getBlsrByte();
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            if (db.on()) {
                db.println("BlsrSpan.isBlsrPortEditable(): caught WrongInterfaceType - we know this is not an OC48AS now.");
            }
            return false;
        }
        catch (NoSuchInterface noSuchInterface) {
            if (db.on()) {
                db.println("BlsrSpan.isBlsrPortEditable(): caught NoSuchInterface a normal result of a race condition.");
            }
            return false;
        }
        catch (UnsupportedOperation unsupportedOperation) {
            db.println("BlsrSpan.isBlsrPortEditable(): caught UnsupportedOperation which should not happen!");
            SDebug.printStackTrace((Throwable)unsupportedOperation);
            return false;
        }
        return true;
    }

    public boolean isExtensionByteInSync() {
        try {
            this.getExtensionByte();
        }
        catch (ExtensionBytesNotInSyncException extensionBytesNotInSyncException) {
            return false;
        }
        return true;
    }

    public int getExtensionByte() throws ExtensionBytesNotInSyncException {
        int n;
        if (this.isProtectSpan()) {
            this.fetchLineModelsForProtectBlsrSpan();
        } else {
            this.fetchLineModelsForWorkingBlsrSpan();
        }
        int n2 = this.isSourceLineEditable() && this.sourceLine != null ? this.getLineExtensionByte(this.sourceLine) : 0;
        int n3 = n = this.isDestinationLineEditable() && this.destinationLine != null ? this.getLineExtensionByte(this.destinationLine) : 0;
        if (n2 != n) {
            if (db.on()) {
                db.println("BlsrSpan.getExtensionByte throwing ExtensionBytesNotInSyncException\nSrc=" + n2 + ", Dst=" + n);
            }
            this.extensionByteValue = new Integer(-1);
            throw new ExtensionBytesNotInSyncException();
        }
        this.extensionByteValue = new Integer(n2);
        return n2;
    }

    private int getLineExtensionByte(ITdmLineModel iTdmLineModel) {
        try {
            return iTdmLineModel.getBlsrByte();
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            if (db.on()) {
                db.println("BlsrSpan.getExtensionByteForBlsrPort: caught WrongInterfaceType.");
            }
            return 0;
        }
        catch (NoSuchInterface noSuchInterface) {
            if (db.on()) {
                db.println("BlsrSpan.getExtensionByteForBlsrPort: caught NoSuchInterface a normal result of a race condition.");
            }
            return 0;
        }
        catch (UnsupportedOperation unsupportedOperation) {
            db.println("BlsrSpan has encountered an impossible scenario...");
            SDebug.printStackTrace((Throwable)unsupportedOperation);
            return 0;
        }
    }

    public void setExtensionByte(int n) throws OnlyK3Exception, ByteInUseException, NeitherExtensionByteEditableException {
        block22: {
            block21: {
                if (!this.isSourceLineEditable() && !this.isDestinationLineEditable()) {
                    if (db.on()) {
                        db.println("BlsrSpan.setExtensionByte throwing NeitherExtensionByteEditableException.");
                    }
                    throw new NeitherExtensionByteEditableException();
                }
                if (!this.isExtensionByteEditable() && n != 0) {
                    if (db.on()) {
                        db.println("BlsrSpan.setExtensionByte throwing OnlyK3Exception");
                    }
                    throw new OnlyK3Exception();
                }
                OhChannelType ohChannelType = OhChannelType.getOhChannelTypeForBlsrExtByte((int)n);
                if (ohChannelType != null) {
                    ITdmPortModel iTdmPortModel = this.getWestSide().getWestPort();
                    ITdmPortModel iTdmPortModel2 = this.getEastSide().getEastPort();
                    IOhConnectionModels iOhConnectionModels = iTdmPortModel.getNodeModel().getOhConnectionModels();
                    IOhConnectionModels iOhConnectionModels2 = iTdmPortModel2.getNodeModel().getOhConnectionModels();
                    if (iOhConnectionModels.isChannelInUse(iTdmPortModel.getEntityIndex(), ohChannelType) || iOhConnectionModels2.isChannelInUse(iTdmPortModel2.getEntityIndex(), ohChannelType)) {
                        if (db.on()) {
                            db.println("BlsrSpan.setExtensionByte throwing ByteInUseException");
                        }
                        throw new ByteInUseException();
                    }
                }
                if (this.isSourceLineEditable()) {
                    try {
                        this.sourceLine.setBlsrByte(n);
                    }
                    catch (WrongInterfaceType wrongInterfaceType) {
                        if (db.on()) {
                            db.println("BlsrSpan.setExtensionByte caught a WrongInterfaceType (east).  This is Impossible unless isBlsrPortEditable is wrong!!");
                        }
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        if (db.on()) {
                            db.println("BlsrSpan.setExtensionByte caught a NoSuchInterface (east).  Just an unfortunate race!");
                        }
                    }
                    catch (ConfigError configError) {
                        if (!db.on()) break block21;
                        db.println("BlsrSpan.setExtensionByte caught a ConfigError (east).  Just an unfortunate race!");
                    }
                }
            }
            if (this.isDestinationLineEditable()) {
                try {
                    this.destinationLine.setBlsrByte(n);
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (db.on()) {
                        db.println("BlsrSpan.setExtensionByte caught a WrongInterfaceType (west).  This is Impossible unless isBlsrPortEditable is wrong!!");
                    }
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (db.on()) {
                        db.println("BlsrSpan.setExtensionByte caught a NoSuchInterface (west).  Just an unfortunate race!");
                    }
                }
                catch (ConfigError configError) {
                    if (!db.on()) break block22;
                    db.println("BlsrSpan.setExtensionByte caught a ConfigError (west).  Just an unfortunate race!");
                }
            }
        }
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof BlsrSpan) {
            BlsrSpan blsrSpan = (BlsrSpan)object;
            bl = this.workingSpan ? (((Object)this.netLink).equals(blsrSpan.getOriginalLink()) || ((Object)this.netLink).equals(blsrSpan.getReverseLink())) && !blsrSpan.isProtectSpan() : this == blsrSpan;
        }
        return bl;
    }

    public Observable getDeathNotifier() {
        return this.spanDeathNotifier;
    }

    public Observable getChannelStateNotifier() {
        return this.channelStateNotifier;
    }

    public Observable getReversionNotifier() {
        return this.reversionNotifier;
    }

    public Observable getBlsrExtensionByteNotifier() {
        return this.lineNotifier;
    }

    protected void spanDownNotification() {
        this.spanDeathNotifier.notifyObservers(this);
    }

    void destroy() {
        if (this.isDestroyed) {
            if (db.on()) {
                db.println("Blsr disposal called on a destroyed span.  Ignored.");
            }
            return;
        }
        if (db.on()) {
            db.println("BlsrSpan disposal: " + this);
        }
        this.isDestroyed = true;
        this.spanDeathNotifier.notifyObservers(this);
        if (this.netLink != null) {
            UObservable.deleteObserver((Object)this.netLink, (Object)this.netLinkDeathObserver, (String)className);
        }
        this.spanDeathNotifier.deleteObservers();
        this.reversionNotifier.deleteObservers();
        this.channelStateNotifier.deleteObservers();
        this.lineNotifier.deleteObservers();
        if (null != this.eastSide) {
            UObservable.deleteObserver((Object)this.eastSide, (Object)this.channelStateNotifier, (String)className);
        }
        if (null != this.westSide) {
            UObservable.deleteObserver((Object)this.westSide, (Object)this.channelStateNotifier, (String)className);
        }
        if (this.sourceLine != null) {
            ModelIndirectObservable.instance().deleteObserver((IObservable)this.sourceLine, this.lineNotifier);
            this.sourceLine = null;
        }
        if (this.destinationLine != null) {
            ModelIndirectObservable.instance().deleteObserver((IObservable)this.destinationLine, this.lineNotifier);
            this.destinationLine = null;
        }
        if (this.westSide != null) {
            this.westSide.setWestMain(null);
        }
        if (this.eastSide != null) {
            this.eastSide.setEastMain(null);
        }
        if (this.parallelProtectSpan != null) {
            this.parallelProtectSpan.destroy();
        }
    }

    public int getMaxRingNameLength() {
        INodeModel[] iNodeModelArray = this.getNodeEndPoints();
        return Math.min(iNodeModelArray[0].getNodeModel().getIElementModels().getBlsrLimits().getRingNameLength(), iNodeModelArray[1].getNodeModel().getIElementModels().getBlsrLimits().getRingNameLength());
    }

    public INodeModel[] getNodeEndPoints() {
        INodeModel[] iNodeModelArray = null;
        iNodeModelArray = this.workingSpan ? new INodeModel[]{this.netLink.getSrc().getNodeModel(), this.netLink.getDst().getNodeModel()} : new INodeModel[]{this.eastProtectPort.getNodeModel(), this.westProtectPort.getNodeModel()};
        return iNodeModelArray;
    }

    void reverseDirection() {
        if (this.workingSpan) {
            INetLink iNetLink = this.netLink;
            this.netLink = this.getReverseLink();
            this.reverseLink = iNetLink;
            BlsrNode blsrNode = this.eastSide;
            this.eastSide = this.westSide;
            this.westSide = blsrNode;
            if (this.parallelProtectSpan != null) {
                this.parallelProtectSpan.reverseProtectSpan();
            }
            this.reversionNotifier.notifyObservers(this);
        }
    }

    void reverseProtectSpan() {
        if (!this.workingSpan) {
            if (db.on()) {
                db.println("reversing the protect span W/E on slots " + this.eastProtectPort.getSlot() + "/" + this.westProtectPort.getSlot());
            }
            this.getWestProtectPort();
            this.getEastProtectPort();
            this.reversionNotifier.notifyObservers(this);
            if (db.on()) {
                db.println("reversed the protect span W/E on slots " + this.eastProtectPort.getSlot() + "/" + this.westProtectPort.getSlot());
            }
        }
    }

    public String toString() {
        if (this.toStringValue == null) {
            BlsrNode blsrNode;
            IEntityTableModel iEntityTableModel;
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            INodeModel iNodeModel = null;
            ITdmPortModel iTdmPortModel = null;
            if (this.workingSpan) {
                iNodeModel = this.netLink.getSrc().getNodeModel();
                n = this.netLink.getSrcEntityIndex();
                iEntityTableModel = iNodeModel.getEntityTable();
                if (iEntityTableModel != null) {
                    try {
                        iTdmPortModel = (ITdmPortModel)iEntityTableModel.getEntityModelByIndex(n);
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                        }
                    }
                }
            } else {
                blsrNode = this.getEastSide();
                iNodeModel = null;
                if (blsrNode != null && !blsrNode.isDestroyed()) {
                    iNodeModel = blsrNode.getNodeModel();
                }
                iTdmPortModel = this.eastProtectPort;
            }
            if (iNodeModel != null && iTdmPortModel != null) {
                stringBuffer.append(iNodeModel.getName() + "/");
                stringBuffer.append("s" + iTdmPortModel.getSlot() + "/");
                stringBuffer.append("p" + PortHelper.getPortNumString((IPortModel)iTdmPortModel));
            } else {
                stringBuffer.append("unavailable");
            }
            stringBuffer.append(" <-> ");
            if (this.workingSpan) {
                iNodeModel = this.netLink.getDst().getNodeModel();
                n = this.netLink.getDstEntityIndex();
                iEntityTableModel = iNodeModel.getEntityTable();
                if (iEntityTableModel != null) {
                    try {
                        iTdmPortModel = (ITdmPortModel)iEntityTableModel.getEntityModelByIndex(n);
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                        }
                    }
                }
            } else {
                blsrNode = this.getWestSide();
                iNodeModel = null;
                if (blsrNode != null && !blsrNode.isDestroyed()) {
                    iNodeModel = blsrNode.getNodeModel();
                }
                iTdmPortModel = this.westProtectPort;
            }
            if (iNodeModel != null && iTdmPortModel != null) {
                stringBuffer.append(iNodeModel.getName() + "/");
                stringBuffer.append("s" + iTdmPortModel.getSlot() + "/");
                stringBuffer.append("p" + PortHelper.getPortNumString((IPortModel)iTdmPortModel));
            } else {
                stringBuffer.append("unavailable");
            }
            this.toStringValue = stringBuffer.toString();
        }
        return this.toStringValue;
    }

    private boolean checkForStateAgreement() {
        boolean bl = false;
        BlsrNode blsrNode = this.getEastSide();
        BlsrNode blsrNode2 = this.getWestSide();
        if (this.isProtectSpan()) {
            if (BlsrSpan.db.on) {
                db.println("it is a protect span");
            }
            if (blsrNode.getEastProtectChannelState() == blsrNode2.getWestProtectChannelState()) {
                bl = true;
            }
        } else {
            if (BlsrSpan.db.on) {
                db.println("it is a protect span");
            }
            if (blsrNode.getEastChannelState() == blsrNode2.getWestChannelState()) {
                bl = true;
            }
        }
        if (BlsrSpan.db.on) {
            db.println("checkForStateAgreement returning: " + bl);
        }
        return bl;
    }

    class BlsrSpanChannelStateNotifier
    extends UObservable
    implements Observer,
    IObserver {
        BlsrSpanChannelStateNotifier() {
        }

        public void update(Observable observable, Object object) {
            this._update(observable, object);
        }

        public void update(IObservable iObservable, Object object) {
            this._update(iObservable, object);
        }

        /*
         * Enabled aggressive block sorting
         */
        private synchronized void _update(Object object, Object object2) {
            if (db.on()) {
                db.println("[BlsrSpanChannelStateNotifier:_update] called from");
            }
            if (db.on) {
                db.finer("\n\n\n>>> update(Observable=" + object + ", Object=" + object2 + ")");
            }
            if (object instanceof BlsrNode) {
                BlsrNode blsrNode = (BlsrNode)object;
                if (db.on) {
                    db.println("this is: " + this);
                }
                if (db.on) {
                    db.println("in update() - blsrNode that sent message is:" + blsrNode);
                }
                boolean bl = false;
                if (blsrNode.equals(BlsrSpan.this.getEastSide())) {
                    if (db.on) {
                        db.println("eastOrientation = true");
                    }
                    bl = true;
                } else if (blsrNode.equals(BlsrSpan.this.getWestSide())) {
                    if (db.on) {
                        db.println("eastOrientation = false");
                    }
                    bl = false;
                } else if (db.on) {
                    db.println("update received from a node that we should not be observing for this span: " + blsrNode + ", span is:" + this.toString());
                }
                if (object2 instanceof Short) {
                    short s = (Short)object2;
                    switch (s) {
                        case 9: {
                            if (db.on) {
                                db.println("EAST_CHANNEL_STATE_CHANGED for BlsrNode:" + blsrNode);
                            }
                            if (bl && !BlsrSpan.this.isProtectSpan()) {
                                short s2 = blsrNode.getEastChannelState();
                                if (db.on) {
                                    db.println("newChannelState is:" + s2);
                                }
                                if (0 == s2) {
                                    if (db.on) {
                                        db.println("checking for state agreement...");
                                    }
                                    if (!BlsrSpan.this.checkForStateAgreement()) break;
                                    BlsrSpan.this.setChannelState(s2);
                                    break;
                                }
                                BlsrSpan.this.setChannelState(s2);
                                break;
                            }
                            if (!db.on) break;
                            db.println("wrong orientation or working/protect type - ignoring");
                            break;
                        }
                        case 11: {
                            if (db.on) {
                                db.println("WEST_CHANNEL_STATE_CHANGED for BlsrNode:" + blsrNode);
                            }
                            if (!bl && !BlsrSpan.this.isProtectSpan()) {
                                short s3 = blsrNode.getWestChannelState();
                                if (db.on) {
                                    db.println("newChannelState is:" + s3);
                                }
                                if (0 == s3) {
                                    if (db.on) {
                                        db.println("checking for state agreement...");
                                    }
                                    if (!BlsrSpan.this.checkForStateAgreement()) break;
                                    BlsrSpan.this.setChannelState(s3);
                                    break;
                                }
                                BlsrSpan.this.setChannelState(s3);
                                break;
                            }
                            if (!db.on) break;
                            db.println("wrong orientation or working/protect type - ignoring");
                            break;
                        }
                        case 10: {
                            if (db.on) {
                                db.println("EAST_PROTECT_CHANNEL_STATE_CHANGED for BlsrNode:" + blsrNode);
                            }
                            if (bl && BlsrSpan.this.isProtectSpan()) {
                                short s4 = blsrNode.getEastProtectChannelState();
                                if (db.on) {
                                    db.println("newChannelState is:" + s4);
                                }
                                if (0 == s4) {
                                    if (db.on) {
                                        db.println("checking for state agreement...");
                                    }
                                    if (!BlsrSpan.this.checkForStateAgreement()) break;
                                    BlsrSpan.this.setChannelState(s4);
                                    break;
                                }
                                BlsrSpan.this.setChannelState(s4);
                                break;
                            }
                            if (!db.on) break;
                            db.println("wrong orientation or working/protect type - ignoring");
                            break;
                        }
                        case 12: {
                            if (db.on) {
                                db.println("WEST_PROTECT_CHANNEL_STATE_CHANGED for BlsrNode:" + blsrNode);
                            }
                            if (!bl && BlsrSpan.this.isProtectSpan()) {
                                short s5 = blsrNode.getWestProtectChannelState();
                                if (db.on) {
                                    db.println("newChannelState is:" + s5);
                                }
                                if (0 == s5) {
                                    if (db.on) {
                                        db.println("checking for state agreement...");
                                    }
                                    if (!BlsrSpan.this.checkForStateAgreement()) break;
                                    BlsrSpan.this.setChannelState(s5);
                                    break;
                                }
                                BlsrSpan.this.setChannelState(s5);
                                break;
                            }
                            if (!db.on) break;
                            db.println("wrong orientation or working/protect type - ignoring");
                            break;
                        }
                        default: {
                            if (!db.on) break;
                            db.finer("not handling message type at this time: " + object2);
                            break;
                        }
                    }
                } else if (db.on) {
                    db.println("Error -- got an update from a BlsrNode, but the object was not a Short!");
                }
            }
            if (db.on) {
                db.finer("<<< update(Observable=" + object + ", Object=" + object2 + ")");
            }
        }

        public void notifyObservers(Object object) {
            if (db.on()) {
                db.println("Notify observers of a BlsrSpan channel state change: " + BlsrSpan.this);
            }
            this.setChanged();
            super.notifyObservers(object);
        }
    }

    class BlsrSpanReversionNotifier
    extends UObservable {
        BlsrSpanReversionNotifier() {
        }

        public void notifyObservers(Object object) {
            if (db.on()) {
                db.println("Notify observers of a BlsrSpan reversion: " + BlsrSpan.this);
            }
            this.setChanged();
            super.notifyObservers(object);
        }
    }

    public class LineModelNotifier
    extends UObservable
    implements Observer,
    IObserver {
        public void update(Observable observable, Object object) {
            this._update(observable, object);
        }

        public void update(IObservable iObservable, Object object) {
            this._update(iObservable, object);
        }

        private synchronized void _update(Object object, Object object2) {
            if (db.on()) {
                db.println("[LineModelNotifier:_update] called from");
            }
            if (object instanceof ITdmLineModel && object2.equals(ModelUpdateType.CHANGED)) {
                this.findChange();
            }
        }

        public void notifyObservers(Object object) {
            this.setChanged();
            super.notifyObservers(object);
        }

        public BlsrSpan getSpan() {
            return BlsrSpan.this;
        }

        private void findChange() {
            Integer n = BlsrSpan.this.extensionByteValue;
            try {
                BlsrSpan.this.getExtensionByte();
            }
            catch (ExtensionBytesNotInSyncException extensionBytesNotInSyncException) {
                // empty catch block
            }
            if (n != BlsrSpan.this.extensionByteValue) {
                this.notifyObservers(BlsrSpan.this.extensionByteValue);
            }
        }
    }

    class BlsrSpanDeathNotifier
    extends UObservable {
        BlsrSpanDeathNotifier() {
        }

        public void notifyObservers(Object object) {
            if (db.on()) {
                db.println("Notify observers of a BlsrSpan death: " + BlsrSpan.this);
                db.println("[BlsrSpanDeathNotifier:notifyObservers] called...");
            }
            this.setChanged();
            super.notifyObservers(object);
        }
    }

    class NetLinkDeathObserver
    implements Observer,
    IObserver {
        NetLinkDeathObserver() {
        }

        public void update(Observable observable, Object object) {
            this._update(observable, object);
        }

        public void update(IObservable iObservable, Object object) {
            this._update(iObservable, object);
        }

        private synchronized void _update(Object object, Object object2) {
            Integer n = (Integer)object2;
            if (db.on()) {
                db.println("[NetLinkDeathObserver:_update] called...");
            }
            if (n.equals(ModelUpdateType.DELETED)) {
                BlsrSpan.this.destroy();
                if (db.on()) {
                    db.println("[NetLinkDeathObserver] Net link removed: " + object);
                }
            }
        }
    }
}

