/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.event;

import cerent.cms.model.ENMSUpdate;
import cerent.cms.model.event.AbstractEventStore;
import cerent.cms.model.event.EventInfo;
import cerent.cms.model.event.IEventStore;
import cerent.cms.model.event.StoreObservable;
import cerent.util.Preferences;
import cerent.util.SDebug;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Observable;

public class NetworkEventStore
extends AbstractEventStore
implements PropertyChangeListener {
    private static NetworkEventStore netEventStore;
    private static String PROP_HISTORY_MAX;
    protected static final int DEFAULT_HI_WATER = 5000;
    protected int globalStoreHighWater = 5000;
    protected HashSet netChildren = null;

    public static NetworkEventStore instance() {
        if (netEventStore == null) {
            netEventStore = new NetworkEventStore("NetworkEventStore");
        }
        return netEventStore;
    }

    public void update(Observable observable, Object object) {
        if (object instanceof ArrayList) {
            this.processEvents((ArrayList)object);
            this.storeObservable.setChanged();
            this.storeObservable.notifyObservers((ArrayList)object);
        } else if (object instanceof ENMSUpdate) {
            if (this.db.on()) {
                this.db.println("ENMSUpdate received");
            }
        } else {
            observable.deleteObserver(this);
        }
    }

    public synchronized void addChild(IEventStore iEventStore) {
        if (this.netChildren == null) {
            this.netChildren = new HashSet();
        }
        this.netChildren.add(iEventStore);
    }

    public synchronized void deleteChild(IEventStore iEventStore) {
        if (this.netChildren != null) {
            this.netChildren.remove(iEventStore);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals(PROP_HISTORY_MAX)) {
            try {
                int n = Integer.parseInt(this.prefs.getProperty("ctc", PROP_HISTORY_MAX, ""));
                if (n > 0) {
                    this.globalStoreHighWater = n;
                    this.db.println("globalStoreHighWater changed to " + this.globalStoreHighWater);
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    protected void preferencesInit() {
        this.prefs = Preferences.instance();
        this.prefs.addPropertyChangeListener((PropertyChangeListener)this);
        try {
            int n = Integer.parseInt(this.prefs.getProperty("ctc", PROP_HISTORY_MAX, null));
            if (n > 0) {
                this.globalStoreHighWater = n;
            }
        }
        catch (Exception exception) {
            this.prefs.setProperty("ctc", PROP_HISTORY_MAX, String.valueOf(this.globalStoreHighWater));
        }
    }

    protected int getHighWater() {
        return this.globalStoreHighWater;
    }

    protected int getLowWater() {
        return this.globalStoreHighWater / 2;
    }

    private NetworkEventStore(String string) {
        this.name = string;
        this.db = new SDebug(this.name);
        this.storeObservable = new StoreObservable(this.name);
        this.preferencesInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processEvents(ArrayList arrayList) {
        int n = arrayList.size();
        if (n <= 0) {
            return;
        }
        int n2 = 0;
        boolean bl = false;
        NetworkEventStore networkEventStore = this;
        synchronized (networkEventStore) {
            Object object;
            int n3;
            int n4 = this.arrayList.size();
            if (this.db.on()) {
                this.db.println("processEvents(): currentCount: " + n4 + ", incomingCount: " + n + ", threshold: " + this.globalStoreHighWater + ", lowWater: " + this.getLowWater());
            }
            if (n4 + n > this.globalStoreHighWater) {
                if (n >= this.globalStoreHighWater) {
                    this.flushStore();
                    n2 = n - this.getLowWater();
                } else if (n >= this.getLowWater()) {
                    this.flushStore();
                } else {
                    int n5;
                    int n6;
                    n3 = this.getLowWater() - n;
                    object = new ArrayList();
                    for (n6 = n5 = n4 - n3; n6 < n4; ++n6) {
                        ((ArrayList)object).add(this.arrayList.get(n6));
                    }
                    this.flushStore();
                    for (n6 = 0; n6 < ((ArrayList)object).size(); ++n6) {
                        this.storeEvent((EventInfo)((ArrayList)object).get(n6));
                    }
                }
                bl = true;
                if (this.db.on()) {
                    this.db.println("clipping is going on !! startIndex " + n2);
                }
            }
            for (n3 = n2; n3 < n; ++n3) {
                object = (EventInfo)arrayList.get(n3);
                this.storeEvent((EventInfo)object);
            }
            this.updateView();
        }
        if (bl && this.netChildren != null) {
            for (IEventStore iEventStore : this.netChildren) {
                iEventStore.update(null, (Object)this.arrayList);
            }
        }
    }

    static {
        PROP_HISTORY_MAX = "history.max";
    }
}

