/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ftg;

import cerent.cms.model.Feature;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ftg.DelegatingModel;
import cerent.cms.model.ftg.FtgModelObserver;
import cerent.util.IIndirectObservable;
import cerent.util.IObservable;
import cerent.util.IObserver;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observer;

public class ModelIndirectObservable
implements IIndirectObservable {
    private static ModelIndirectObservable Me = new ModelIndirectObservable();
    private HashMap observers = new HashMap();

    private ModelIndirectObservable() {
    }

    public static ModelIndirectObservable instance() {
        return Me;
    }

    private static Pair findModelObserverPair(LinkedList linkedList, IObservable iObservable, Object object) {
        return ModelIndirectObservable.findModelObserverPair(linkedList, iObservable, object, false);
    }

    private static Pair findModelObserverPair(LinkedList linkedList, IObservable iObservable, Object object, boolean bl) {
        Iterator iterator = linkedList.iterator();
        Pair pair = null;
        while (iterator.hasNext() && pair == null) {
            pair = (Pair)iterator.next();
            if (pair.observable == iObservable && pair.modelObserver.getDelegate() == object) {
                if (!bl) continue;
                iterator.remove();
                continue;
            }
            pair = null;
        }
        return pair;
    }

    static FtgModelObserver findModelObserver(LinkedList linkedList, IObservable iObservable, Object object) {
        Pair pair = ModelIndirectObservable.findModelObserverPair(linkedList, iObservable, object);
        return ModelIndirectObservable.getModelObserver(pair);
    }

    static FtgModelObserver getModelObserver(Pair pair) {
        FtgModelObserver ftgModelObserver = pair != null ? pair.modelObserver : null;
        return ftgModelObserver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FtgModelObserver getObserver(IObservable iObservable, Observer observer) {
        LinkedList linkedList;
        FtgModelObserver ftgModelObserver = null;
        Object object = this;
        synchronized (object) {
            linkedList = (LinkedList)this.observers.get(observer);
        }
        if (linkedList != null) {
            object = linkedList;
            synchronized (object) {
                ftgModelObserver = ModelIndirectObservable.findModelObserver(linkedList, iObservable, observer);
            }
        }
        return ftgModelObserver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveObserver(IObservable iObservable, IObserver iObserver, IObserver iObserver2) {
        LinkedList<Pair> linkedList;
        boolean bl = true;
        boolean bl2 = true;
        Object object = this;
        synchronized (object) {
            linkedList = (LinkedList<Pair>)this.observers.get(iObserver);
            if (linkedList == null) {
                bl = false;
                linkedList = new LinkedList<Pair>();
                this.observers.put(iObserver, linkedList);
            }
        }
        object = linkedList;
        synchronized (object) {
            if (bl) {
                FtgModelObserver ftgModelObserver = ModelIndirectObservable.findModelObserver(linkedList, iObservable, iObserver);
                boolean bl3 = bl2 = ftgModelObserver == null;
            }
            if (bl2) {
                linkedList.add(new Pair(iObservable, (FtgModelObserver)iObserver2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObserver removeObserver(IObservable iObservable, IObserver iObserver) {
        LinkedList linkedList;
        Pair pair = null;
        FtgModelObserver ftgModelObserver = null;
        ModelIndirectObservable modelIndirectObservable = this;
        synchronized (modelIndirectObservable) {
            linkedList = (LinkedList)this.observers.get(iObserver);
        }
        if (linkedList != null) {
            boolean bl;
            Object object = linkedList;
            synchronized (object) {
                pair = ModelIndirectObservable.findModelObserverPair(linkedList, iObservable, iObserver, true);
                bl = linkedList.size() == 0;
            }
            ftgModelObserver = ModelIndirectObservable.getModelObserver(pair);
            if (bl && pair != null) {
                object = this;
                synchronized (object) {
                    this.observers.remove(iObserver);
                }
            }
        }
        return ftgModelObserver;
    }

    private boolean shouldBcHandle(IObservable iObservable) {
        boolean bl = false;
        if (iObservable instanceof DelegatingModel) {
            bl = this.shouldBcHandle(((DelegatingModel)iObservable).getIObservableDelegate());
        } else if (iObservable instanceof IModel) {
            INodeModel iNodeModel = ((IModel)iObservable).getNodeModel();
            bl = iNodeModel != null && !Feature.provides((INodeModel)iNodeModel, (Feature)Feature.FTG);
        }
        return bl;
    }

    private IObservable getDelegateObservable(IObservable iObservable) {
        IObservable iObservable2 = iObservable;
        if (iObservable instanceof DelegatingModel) {
            iObservable2 = ((DelegatingModel)iObservable).getIObservableDelegate();
        }
        return iObservable2;
    }

    public void addObserver(IObservable iObservable, Observer observer) {
        iObservable.addObserver(observer);
    }

    public void addObserver(IObservable iObservable, IObserver iObserver) {
        if (this.shouldBcHandle(iObservable)) {
            iObservable = this.getDelegateObservable(iObservable);
            FtgModelObserver ftgModelObserver = new FtgModelObserver(iObserver);
            iObservable.addObserver((IObserver)ftgModelObserver);
            this.saveObserver(iObservable, iObserver, ftgModelObserver);
        } else {
            iObservable.addObserver(iObserver);
        }
    }

    public void deleteObserver(IObservable iObservable, Observer observer) {
        iObservable.deleteObserver(observer);
    }

    public void deleteObserver(IObservable iObservable, IObserver iObserver) {
        IObservable iObservable2 = this.getDelegateObservable(iObservable);
        IObserver iObserver2 = this.removeObserver(iObservable2, iObserver);
        if (iObserver2 != null) {
            iObservable.deleteObserver(iObserver2);
        } else {
            iObservable.deleteObserver(iObserver);
        }
    }

    static class Pair {
        IObservable observable;
        FtgModelObserver modelObserver;

        Pair(IObservable iObservable, FtgModelObserver ftgModelObserver) {
            this.observable = iObservable;
            this.modelObserver = ftgModelObserver;
        }
    }
}

