/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.ConnectionHasFarendLoopback;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionInTopologyUpgrade;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.VcatMemberInvalidState;
import cerent.cms.model.VcatMemberNotOutOfGroup;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.LoTunnelNode;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeOperator;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.util.SDebug;

public class DualCircuitNodeOperator
extends NetCircuitNodeOperator {
    private static final SDebug db = new SDebug("DualCircuitNodeOperator");

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    public DualCircuitNodeOperator(DualConnectionCircuitNode dualConnectionCircuitNode) {
        super(dualConnectionCircuitNode);
    }

    private NetCircuitNode getFstCircuitNode() {
        return ((DualConnectionCircuitNode)this.node).getFstCircuitNode();
    }

    private NetCircuitNode getSecCircuitNode() {
        return ((DualConnectionCircuitNode)this.node).getSecCircuitNode();
    }

    protected void createConnection() throws CircuitProvError {
    }

    protected void tentative2Routed() throws DeletionError {
        this.getFstCircuitNode().getOperator().tentative2Routed();
        this.getSecCircuitNode().getOperator().tentative2Routed();
        this.node.setState(0);
        this.node.setCreateStage(2);
    }

    protected void deleteDropFromConnection(NetCircuitEnd netCircuitEnd) throws CTCUserException {
        if (netCircuitEnd.getStage() == 2) {
            return;
        }
        if (DualCircuitNodeOperator.dbgOn()) {
            db.println("Deleting drop from connection");
        }
        this.getSecCircuitNode().getOperator().deleteDropFromConnection(netCircuitEnd);
        this.node.setNumberOfPaths(this.node.getNumberOfPaths() - 1);
    }

    protected void deleteSpanFromConnection(NetCircuitSpan netCircuitSpan) throws CTCUserException {
        if (DualCircuitNodeOperator.dbgOn()) {
            db.println("Deleting span from connection");
        }
        this.getSecCircuitNode().getOperator().deleteSpanFromConnection(netCircuitSpan);
        this.node.setNumberOfPaths(this.node.getNumberOfPaths() - 1);
        if (netCircuitSpan.getLink().getSrc() == this.node.getNetElement()) {
            netCircuitSpan.setSrcState(0);
        } else {
            netCircuitSpan.setDstState(0);
        }
    }

    protected int biSpanUpsrCost(NetCircuitSpan netCircuitSpan) {
        if (this.getFstCircuitNode().getBiSpans().contains(netCircuitSpan)) {
            return this.getFstCircuitNode().getOperator().biSpanUpsrCost(netCircuitSpan);
        }
        if (this.getSecCircuitNode().getBiSpans().contains(netCircuitSpan)) {
            return this.getSecCircuitNode().getOperator().biSpanUpsrCost(netCircuitSpan);
        }
        return 0;
    }

    protected void modifyConnection() throws CircuitProvError {
        if (DualCircuitNodeOperator.dbgOn()) {
            db.println("modifyConnection @ Node " + this.getName());
        }
        this.modifyConnectionType();
        this.node.updateConnectionPathEnds(this.node.getConnectionPathEnds());
        int n = this.node.countNumInputs() + this.node.countNumOutputs() + this.node.countNumOmniSpans() + (this.getFstCircuitNode().onXm() ? 1 : 0) + (this.getSecCircuitNode().onXm() ? 1 : 0);
        this.node.setNumberOfPaths(n);
        this.node.setState(2);
    }

    protected boolean deleteDropCheck(INetCircuitEnd iNetCircuitEnd, boolean bl) {
        if (super.deleteDropCheck(iNetCircuitEnd, bl)) {
            return this.node.getDrops().size() != 1 || bl;
        }
        return false;
    }

    protected void destroySanityCheck() throws SanityCheckFailed {
        if (DualCircuitNodeOperator.dbgOn()) {
            db.println("destroySanityCheck at dual-node " + this.getName());
        }
        this.getFstCircuitNode().destroySanityCheck();
        this.getSecCircuitNode().destroySanityCheck();
    }

    protected void destroyCrossConnection() throws Busy, ConnectionInTestAccess, ConnectionInRoll, ConnectionInTopologyUpgrade, VcatMemberNotOutOfGroup, VcatMemberInvalidState, InvalidPath, WrongInterfaceType, ConnectionHasFarendLoopback {
        NetCircuitNode netCircuitNode = this.getFstCircuitNode();
        NetCircuitNode netCircuitNode2 = this.getSecCircuitNode();
        if (DualCircuitNodeOperator.dbgOn()) {
            db.println("destroyTdmConnection(" + this.getName() + "): destroy connection");
        }
        netCircuitNode.getOperator().destroyCrossConnection();
        netCircuitNode2.getOperator().destroyCrossConnection();
        this.node.clearConnectionPathEnds();
    }

    protected void cleanupLoAdits() {
        if (this.getFstCircuitNode() instanceof LoTunnelNode) {
            this.getFstCircuitNode().getOperator().cleanupLoAdits();
        }
        if (this.getSecCircuitNode() instanceof LoTunnelNode) {
            this.getSecCircuitNode().getOperator().cleanupLoAdits();
        }
    }
}

