/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CircuitType;
import cerent.cms.model.Feature;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.ICircuitDirection;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoPathInfo;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPathInfo;
import cerent.cms.model.IPathStateInfo;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.ISvlanCircuitModels;
import cerent.cms.model.ISvlanPathDefModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.ITdmProtocolType;
import cerent.cms.model.IVcatTermAttributes;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.OchncHelper;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SvlanCircuitHelper;
import cerent.cms.model.VcatTermAttributes;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.HoCircuitEnd;
import cerent.cms.ncp.HoCircuitNode;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.LoCircuitEnd;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.PayloadTypeCompatibility;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.util.EnumStrings;
import cerent.util.HoLoFactory;
import cerent.util.HoLoNum;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Endpoints {
    protected static Endpoints endpointsRetriever;
    private static final SDebug db;

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    public static synchronized Endpoints instance() {
        if (endpointsRetriever == null) {
            endpointsRetriever = new Endpoints();
        }
        return endpointsRetriever;
    }

    protected List getAvailSourcePorts(INodeModel iNodeModel, CircuitCreatInfo circuitCreatInfo, boolean bl) {
        LinkedList linkedList = new LinkedList();
        if (Endpoints.dbgOn()) {
            db.println("getAvailSourcePorts node is " + iNodeModel);
        }
        if (circuitCreatInfo == null) {
            return linkedList;
        }
        linkedList.addAll(this.getAvailPortEntities(iNodeModel, circuitCreatInfo, bl, null));
        return linkedList;
    }

    protected List getFirstAvailPairPPorts(INodeModel iNodeModel, CircuitCreatInfo circuitCreatInfo) {
        List list = new LinkedList();
        if (Endpoints.dbgOn()) {
            db.println("getFirstAvailPairPPorts on node " + iNodeModel);
        }
        if (circuitCreatInfo == null) {
            return list;
        }
        if (iNodeModel == null || !iNodeModel.getConnectionState()) {
            return list;
        }
        IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
        if (iEntityTableModel == null) {
            return list;
        }
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)circuitCreatInfo.type());
        ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)circuitCreatInfo.size());
        if (iCircuitType.isHoCircuitType() || iCircuitType.isLAPCircuitType()) {
            short s = iCircuitSize.size2widthOfHoCircuit();
            if (iNodeModel.provides(Feature.DS3XM12)) {
                list = iEntityTableModel.getFirstAvailPairPPorts(s);
            }
        }
        if (Endpoints.dbgOn()) {
            db.println("getFirstAvailPairPPorts(" + iNodeModel.getName() + "): returning " + list.size() + " entities");
        }
        return list;
    }

    protected List getAvailPortEntities(INodeModel iNodeModel, CircuitCreatInfo circuitCreatInfo, boolean bl, INetCircuit iNetCircuit) {
        int n = circuitCreatInfo.type();
        int n2 = circuitCreatInfo.size();
        int n3 = circuitCreatInfo.dir();
        int n4 = circuitCreatInfo.lcasMode();
        int n5 = circuitCreatInfo.forwardMembers();
        int n6 = circuitCreatInfo.reverseMembers();
        boolean bl2 = circuitCreatInfo.isDiag();
        List<Object> list = new LinkedList();
        boolean bl3 = circuitCreatInfo.isOVcat();
        if (Endpoints.dbgOn()) {
            db.println("getAvailPortEntities(" + iNodeModel.getName() + "):" + " " + EnumStrings.getString(ICircuitType.class, (int)n) + " " + EnumStrings.getString(ICircuitSize.class, (int)n2) + " " + EnumStrings.getString(ICircuitDirection.class, (int)n3) + (bl2 ? " Diagnostic Circuit" : "") + (bl ? " protectedOnly" : ""));
        }
        if (iNodeModel == null || !iNodeModel.getConnectionState()) {
            return list;
        }
        IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
        if (iEntityTableModel == null) {
            return list;
        }
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)n);
        ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)n2);
        if (iCircuitType.isLoCircuitType()) {
            short s = iCircuitSize.size2widthOfLoCircuit();
            list = iEntityTableModel.getAvailEntitiesForLo((int)s, bl);
            if (bl2) {
                this.filterDiagPorts(list);
            }
        } else if (iCircuitType.isLoVcatCircuitType()) {
            if (bl3 && iNetCircuit != null) {
                short s = iCircuitSize.size2widthOfLoCircuit();
                List list2 = iEntityTableModel.getAvailEntitiesForLo((int)s, bl);
                for (IEntityModel iEntityModel : list2) {
                    ITdmPortModel iTdmPortModel;
                    if (!(iEntityModel instanceof ITdmPortModel) || !(iTdmPortModel = (ITdmPortModel)iEntityModel).isOptical()) continue;
                    list.add(iEntityModel);
                }
            } else if (iNodeModel.provides(Feature.VCAT)) {
                VcatTermAttributes vcatTermAttributes = new VcatTermAttributes((short)n5, (short)n6, n4, n3, false);
                short s = iCircuitSize.size2widthOfLoCircuit();
                list = iEntityTableModel.getAvailEntitiesForLoVcat((int)s, (IVcatTermAttributes)vcatTermAttributes, bl);
            }
        } else if (iCircuitType.isHoVcatCircuitType()) {
            if (bl3 && iNetCircuit != null) {
                short s = iCircuitSize.size2widthOfHoCircuit();
                List list3 = iNodeModel.provides(Feature.STS_OVER_MSTP_ADM) ? (iNetCircuit != null && iNetCircuit.getPrimarySource() != null && iNetCircuit.getPrimarySource().getNodeId() == iNodeModel.getNodeId() ? iEntityTableModel.getAvailEntitiesForDstHo(iNetCircuit.getPrimarySource().getEntityIndex(), s, n3, bl) : iEntityTableModel.getAvailEntitiesForHo(s, n3, bl)) : iEntityTableModel.getAvailEntitiesForHo(s, n3, bl);
                for (IEntityModel iEntityModel : list3) {
                    ITdmPortModel iTdmPortModel;
                    if (!(iEntityModel instanceof ITdmPortModel) || !(iTdmPortModel = (ITdmPortModel)iEntityModel).isOptical()) continue;
                    list.add(iEntityModel);
                }
            } else if (iNodeModel.provides(Feature.VCAT)) {
                VcatTermAttributes vcatTermAttributes = new VcatTermAttributes((short)n5, (short)n6, n4, n3, false);
                short s = iCircuitSize.size2widthOfHoCircuit();
                list = iEntityTableModel.getAvailEntitiesForHoVcat(s, (IVcatTermAttributes)vcatTermAttributes, bl);
            }
        } else if (iCircuitType.isOchncType()) {
            if (iNetCircuit == null) {
                list = OchncHelper.getAddPortsForOchnc(iNodeModel, circuitCreatInfo);
            } else if (circuitCreatInfo.singleNodeOchnc()) {
                IEntityModel iEntityModel = null;
                try {
                    iEntityModel = iNetCircuit.getPrimarySource().getEntityModel();
                }
                catch (ObjNotFound objNotFound) {
                    // empty catch block
                }
                list = OchncHelper.getDropPortsForOchncDcn(iNodeModel, circuitCreatInfo, iEntityModel, bl);
            } else {
                list = OchncHelper.getDropPortsForOchnc(iNodeModel, circuitCreatInfo);
            }
        } else if (iCircuitType.isOchccCircuitType()) {
            List list4 = OchTrailHelper.filterNodeForOchcc(circuitCreatInfo, iNetCircuit, iNodeModel);
            if (db.on()) {
                db.println("Found " + list4.size() + "OCHCC entities for " + " node " + iNodeModel);
            }
            list.addAll(list4);
        } else if (iCircuitType.isOchTrailTunnelCircuitType()) {
            List list5 = OchTrailHelper.filterNodeForOchTrail(circuitCreatInfo, iNetCircuit, iNodeModel);
            if (db.on()) {
                db.println("Found " + list5.size() + "OCHTrail entities for " + " node " + iNodeModel);
            }
            list.addAll(list5);
        } else if (iCircuitType.isSVLANType()) {
            boolean bl4;
            ISvlanCircuitModels iSvlanCircuitModels = iNodeModel.getSvlanCircuitModels();
            boolean bl5 = bl4 = iNetCircuit != null && iNetCircuit.getState() != 0;
            if (iSvlanCircuitModels != null) {
                list = Arrays.asList(iSvlanCircuitModels.getAvailEntitiesForSvlanCkt(circuitCreatInfo.svlan(), circuitCreatInfo.isProtected(), bl4));
            }
        } else {
            short s = iCircuitSize.size2widthOfHoCircuit();
            list = iNodeModel.provides(Feature.STS_OVER_MSTP_ADM) ? (iNetCircuit != null && iNetCircuit.getPrimarySource() != null && iNetCircuit.getPrimarySource().getNodeId() == iNodeModel.getNodeId() ? iEntityTableModel.getAvailEntitiesForDstHo(iNetCircuit.getPrimarySource().getEntityIndex(), s, n3, bl) : iEntityTableModel.getAvailEntitiesForHo(s, n3, bl)) : iEntityTableModel.getAvailEntitiesForHo(s, n3, bl);
            if (iCircuitType.isLAPCircuitType()) {
                LinkedList linkedList = new LinkedList();
                iEntityTableModel.lapFilterEntities(list, linkedList);
                return linkedList;
            }
        }
        if (Endpoints.dbgOn()) {
            db.println("getAvailPortEntities(" + iNodeModel.getName() + "): returning " + list.size() + " entities");
        }
        return list;
    }

    public List getAvailSourcePoints(INodeModel iNodeModel, IEntityModel iEntityModel, CircuitCreatInfo circuitCreatInfo) {
        ArrayList arrayList = new ArrayList();
        if (Endpoints.dbgOn()) {
            db.println("getAvailSourcePoints @ " + iNodeModel);
        }
        if (circuitCreatInfo == null) {
            return arrayList;
        }
        arrayList.addAll(this.getAvailPortPaths(iNodeModel, iEntityModel, circuitCreatInfo.type(), circuitCreatInfo.size(), circuitCreatInfo.forwardMembers(), new ArrayList()));
        return arrayList;
    }

    protected List getAvailPortPaths(INodeModel iNodeModel, IEntityModel iEntityModel, int n, int n2, int n3, List list, IEntityModel iEntityModel2, List list2) {
        ArrayList arrayList = new ArrayList();
        if (iNodeModel == null || iEntityModel == null || !iNodeModel.canSupportCircuitSize(n, n2)) {
            return arrayList;
        }
        if (Endpoints.dbgOn()) {
            db.println("getAvailPortPaths(" + iNodeModel.getName() + "::" + Integer.toHexString(iEntityModel.getEntityIndex()) + ") excluded endpts=" + list.size());
        }
        if (!Feature.provides((INodeModel)iNodeModel, (Feature)Feature.PARTIAL_PCA_CIRCUITS)) {
            IPoolModel iPoolModel = iNodeModel.getPoolModels().getPoolModel(iEntityModel.getEntityIndex());
            return this.getAvailPoolPaths(iPoolModel, iNodeModel, iEntityModel, n, n2, n3, list);
        }
        IPoolModel[] iPoolModelArray = iNodeModel.getPoolModels().getPoolModels(iEntityModel.getEntityIndex());
        if (iPoolModelArray == null || iPoolModelArray.length == 0) {
            return arrayList;
        }
        for (IPoolModel iPoolModel : Arrays.asList(iPoolModelArray)) {
            arrayList.addAll(this.getAvailPoolPaths(iPoolModel, iNodeModel, iEntityModel, n, n2, n3, list, iEntityModel2, list2));
        }
        if (Endpoints.dbgOn()) {
            db.println("getAvailPortPaths(" + iNodeModel.getName() + "::" + Integer.toHexString(iEntityModel.getEntityIndex()) + ") returning " + arrayList.size() + " endpts");
        }
        return arrayList;
    }

    protected List getAvailPortPaths(INodeModel iNodeModel, IEntityModel iEntityModel, int n, int n2, int n3, List list) {
        ArrayList arrayList = new ArrayList();
        if (iNodeModel == null || iEntityModel == null || !iNodeModel.canSupportCircuitSize(n, n2)) {
            return arrayList;
        }
        if (Endpoints.dbgOn()) {
            db.println("getAvailPortPaths(" + iNodeModel.getName() + "::" + Integer.toHexString(iEntityModel.getEntityIndex()) + ") excluded endpts=" + list.size());
        }
        if (!Feature.provides((INodeModel)iNodeModel, (Feature)Feature.PARTIAL_PCA_CIRCUITS)) {
            IPoolModel iPoolModel = iNodeModel.getPoolModels().getPoolModel(iEntityModel.getEntityIndex());
            return this.getAvailPoolPaths(iPoolModel, iNodeModel, iEntityModel, n, n2, n3, list);
        }
        IPoolModel[] iPoolModelArray = iNodeModel.getPoolModels().getPoolModels(iEntityModel.getEntityIndex());
        if (iPoolModelArray == null || iPoolModelArray.length == 0) {
            return arrayList;
        }
        for (IPoolModel iPoolModel : Arrays.asList(iPoolModelArray)) {
            arrayList.addAll(this.getAvailPoolPaths(iPoolModel, iNodeModel, iEntityModel, n, n2, n3, list));
        }
        if (Endpoints.dbgOn()) {
            db.println("getAvailPortPaths(" + iNodeModel.getName() + "::" + Integer.toHexString(iEntityModel.getEntityIndex()) + ") returning " + arrayList.size() + " endpts");
        }
        return arrayList;
    }

    protected List getAvailPortPaths(INodeModel iNodeModel, IEntityModel iEntityModel, int n, int n2, int n3, List list, boolean bl, boolean bl2) {
        ArrayList arrayList = new ArrayList();
        if (iNodeModel == null || iEntityModel == null || !iNodeModel.canSupportCircuitSize(n, n2)) {
            return arrayList;
        }
        if (Endpoints.dbgOn()) {
            db.println("getAvailPortPaths(" + iNodeModel.getName() + "::" + Integer.toHexString(iEntityModel.getEntityIndex()) + ") excluded endpts=" + list.size());
        }
        if (!Feature.provides((INodeModel)iNodeModel, (Feature)Feature.PARTIAL_PCA_CIRCUITS)) {
            IPoolModel iPoolModel = iNodeModel.getPoolModels().getPoolModel(iEntityModel.getEntityIndex());
            return this.getAvailPoolPaths(iPoolModel, iNodeModel, iEntityModel, n, n2, n3, list, bl, bl2);
        }
        IPoolModel[] iPoolModelArray = iNodeModel.getPoolModels().getPoolModels(iEntityModel.getEntityIndex());
        if (iPoolModelArray == null || iPoolModelArray.length == 0) {
            return arrayList;
        }
        for (IPoolModel iPoolModel : Arrays.asList(iPoolModelArray)) {
            arrayList.addAll(this.getAvailPoolPaths(iPoolModel, iNodeModel, iEntityModel, n, n2, n3, list, bl, bl2));
        }
        if (Endpoints.dbgOn()) {
            db.println("getAvailPortPaths(" + iNodeModel.getName() + "::" + Integer.toHexString(iEntityModel.getEntityIndex()) + ") returning " + arrayList.size() + " endpts");
        }
        return arrayList;
    }

    private List getAvailPoolPaths(IPoolModel iPoolModel, INodeModel iNodeModel, IEntityModel iEntityModel, int n, int n2, int n3, List list) {
        return this.getAvailPoolPaths(iPoolModel, iNodeModel, iEntityModel, n, n2, n3, list, null, null);
    }

    private List getAvailPoolPaths(IPoolModel iPoolModel, INodeModel iNodeModel, IEntityModel iEntityModel, int n, int n2, int n3, List list, IEntityModel iEntityModel2, List list2) {
        IHoNum iHoNum;
        short s;
        IPathInfo[] iPathInfoArray;
        ArrayList arrayList = new ArrayList();
        ITdmProtocolType iTdmProtocolType = Network.instance().findNetElem(iEntityModel.getNodeModel()).getTdmProtocolTypeObj();
        if (iPoolModel == null || iNodeModel == null || iEntityModel == null) {
            return arrayList;
        }
        int n4 = NetCircuitManager.instance().calcFramingType(n, n2);
        IHoNum iHoNum2 = Feature.provides((INodeModel)iPoolModel.getNodeModel(), (Feature)Feature.SDH_AU3) ? iPoolModel.includedPath().getStartingHo(n4) : iPoolModel.includedPath().getStartingHo();
        if (Endpoints.dbgOn()) {
            db.println("getAvailPoolPaths(" + iNodeModel.getName() + "::" + Integer.toHexString(iEntityModel.getEntityIndex()) + ")" + " baseHo=" + iHoNum2 + ", excluded endpts=" + list.size());
        }
        IConnectionModels iConnectionModels = iNodeModel.getConnectionModels();
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)n);
        ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)n2);
        if (iCircuitType.isLoCircuitType() || iCircuitType.isLoVcatCircuitType()) {
            iPathInfoArray = CircuitSize.getLoTunnelSize((int)n4);
            s = iPathInfoArray.size2widthOfHoCircuit();
        } else {
            s = iCircuitSize.size2widthOfHoCircuit();
        }
        iPathInfoArray = null;
        if (!iCircuitType.isVcatCircuitType()) {
            if (Endpoints.isCe2Port(iEntityModel) && iCircuitSize.isLo(n4)) {
                iHoNum = CircuitSize.getCircuitSize((int)n2);
                short s2 = ((CircuitSize)iHoNum).size2widthOfLoCircuit();
                iPathInfoArray = iPoolModel.getAvailableVcatPathsForLO(s, (short)1, s2);
            } else {
                iPathInfoArray = iPoolModel.getAvailablePaths(s);
            }
        } else {
            iHoNum = CircuitType.getCircuitType((int)n);
            if (Endpoints.isCe2Port(iEntityModel) && iHoNum.isLoVcatCircuitType()) {
                ICircuitSize iCircuitSize2 = CircuitSize.getCircuitSize((int)n2);
                short s3 = ((CircuitSize)iCircuitSize2).size2widthOfLoCircuit();
                iPathInfoArray = iPoolModel.getAvailableVcatPathsForLO(s, (short)n3, s3);
            } else {
                iPathInfoArray = iPoolModel.getAvailableVcatPaths(s, (short)n3);
            }
        }
        if (Endpoints.dbgOn()) {
            db.println("pathInfoList size is " + iPathInfoArray.length);
        }
        if (iCircuitType.isLoCircuitType() || iCircuitType.isLoVcatCircuitType()) {
            ILoNum iLoNum;
            LoCircuitEnd loCircuitEnd;
            Object object;
            IHoNum iHoNum3;
            iHoNum = null;
            iHoNum = iConnectionModels.getLoAditsInPool(iPoolModel);
            Iterator<ILoAditModel> iterator = Arrays.asList(iHoNum).iterator();
            while (iterator.hasNext()) {
                try {
                    ILoAditModel iLoAditModel = iterator.next();
                    iHoNum3 = HoPathDefModel.physicalHo(iLoAditModel.getHo());
                    short s4 = iCircuitSize.size2widthOfLoCircuit();
                    object = iLoAditModel.getAvailableLos((int)s4);
                    for (ILoPathInfo iLoPathInfo : Arrays.asList(object)) {
                        int n5;
                        loCircuitEnd = this.getAutoAssignedLoCktEnd(iNodeModel, iEntityModel, CircuitType.getCircuitType((int)n));
                        if (loCircuitEnd != null) {
                            this.addToReturnList(iEntityModel, loCircuitEnd, arrayList, list);
                            if (Endpoints.dbgOn()) {
                                db.println("getAvailPoolPaths() returning " + arrayList.size() + " endpts");
                            }
                            return arrayList;
                        }
                        if (list2 != null) {
                            for (int i = 0; i < list2.size(); ++i) {
                                n5 = ((IEntityModel)list2.get(i)).getPositionInParent();
                                iLoNum = iLoPathInfo.getLoNum();
                                if (iLoNum.getVc3OrSts1() != n5 || !PayloadTypeCompatibility.isCompatible(iEntityModel2, (IEntityModel)list2.get(i), -1)) continue;
                                loCircuitEnd = new LoCircuitEnd(iNodeModel, iEntityModel, iHoNum3, iLoNum, false);
                                this.addToReturnList(iEntityModel, loCircuitEnd, arrayList, list);
                            }
                            continue;
                        }
                        if ((iEntityModel.getModuleModel().getEqType() == 233 || iEntityModel.getModuleModel().getEqType() == 234) && iTdmProtocolType.isSdh()) {
                            List list3 = iEntityModel.getParent().getDescendantsOfClassType(7);
                            for (n5 = 0; n5 < list3.size(); ++n5) {
                                int n6 = ((IEntityModel)list3.get(n5)).getPositionInParent();
                                if (n6 != (iLoNum = iLoPathInfo.getLoNum()).getVc3OrSts1()) continue;
                                loCircuitEnd = new LoCircuitEnd(iNodeModel, iEntityModel, iHoNum3, iLoNum, false);
                                this.addToReturnList(iEntityModel, loCircuitEnd, arrayList, list);
                            }
                            continue;
                        }
                        iLoNum = iLoPathInfo.getLoNum();
                        loCircuitEnd = new LoCircuitEnd(iNodeModel, iEntityModel, iHoNum3, iLoNum, false);
                        this.addToReturnList(iEntityModel, loCircuitEnd, arrayList, list);
                    }
                }
                catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                    SDebug.printStackTrace((Throwable)abstractCmsObjectNotExistException);
                }
            }
            for (IPathInfo iPathInfo : Arrays.asList(iPathInfoArray)) {
                int n7;
                loCircuitEnd = this.getAutoAssignedLoCktEnd(iNodeModel, iEntityModel, CircuitType.getCircuitType((int)n));
                if (loCircuitEnd != null) {
                    this.addToReturnList(iEntityModel, loCircuitEnd, arrayList, list);
                    break;
                }
                IHoNum iHoNum4 = Feature.provides((INodeModel)iPoolModel.getNodeModel(), (Feature)Feature.SDH_AU3) ? iPathInfo.getStartingHo(n4) : iPathInfo.getStartingHo();
                iHoNum3 = HoPathDefModel.physicalHo(iPoolModel, iHoNum4);
                object = HoLoFactory.getAllLoNums(iEntityModel.getMaxLo(n2), n4, n2);
                ArrayList arrayList2 = new ArrayList();
                if (list2 != null) {
                    for (n7 = 0; n7 < list2.size(); ++n7) {
                        int n8 = ((IEntityModel)list2.get(n7)).getPositionInParent();
                        iLoNum = (ILoNum)object.get(n8 - 1);
                        if (!PayloadTypeCompatibility.isCompatible(iEntityModel2, (IEntityModel)list2.get(n7), -1)) continue;
                        arrayList2.add(new HoLoNum(iHoNum3, iLoNum));
                    }
                } else if ((iEntityModel.getModuleModel().getEqType() == 233 || iEntityModel.getModuleModel().getEqType() == 234) && iTdmProtocolType.isSdh()) {
                    list2 = iEntityModel.getParent().getDescendantsOfClassType(7);
                    for (n7 = 0; n7 < list2.size(); ++n7) {
                        int n9 = ((IEntityModel)list2.get(n7)).getPositionInParent();
                        iLoNum = (ILoNum)object.get(n9 - 1);
                        arrayList2.add(new HoLoNum(iHoNum3, iLoNum));
                    }
                } else {
                    for (n7 = 0; n7 < object.size(); ++n7) {
                        iLoNum = (ILoNum)object.get(n7);
                        arrayList2.add(new HoLoNum(iHoNum3, iLoNum));
                    }
                }
                if (Endpoints.isCe2Port(iEntityModel)) {
                    this.filterOutDisallowedHoLos(arrayList2, iNodeModel, iEntityModel, n, n2);
                }
                Iterator iterator2 = arrayList2.iterator();
                while (iterator2.hasNext()) {
                    IHoLoNum iHoLoNum = (IHoLoNum)iterator2.next();
                    loCircuitEnd = new LoCircuitEnd(iNodeModel, iEntityModel, iHoLoNum.getHoNum(), iHoLoNum.getLoNum(), false);
                    this.addToReturnList(iEntityModel, loCircuitEnd, arrayList, list);
                }
            }
        } else {
            for (IPathInfo iPathInfo : Arrays.asList(iPathInfoArray)) {
                HoCircuitEnd hoCircuitEnd = this.getAutoAssignedHoCktEnd(iNodeModel, iEntityModel, CircuitType.getCircuitType((int)n));
                if (hoCircuitEnd != null) {
                    this.addToReturnList(iEntityModel, hoCircuitEnd, arrayList, list);
                    break;
                }
                iHoNum = Feature.provides((INodeModel)iPoolModel.getNodeModel(), (Feature)Feature.SDH_AU3) ? iPathInfo.getStartingHo(n4) : iPathInfo.getStartingHo();
                IHoNum iHoNum5 = HoPathDefModel.physicalHo(iPoolModel, iHoNum);
                hoCircuitEnd = new HoCircuitEnd(iNodeModel, iEntityModel, iHoNum5, null, false);
                this.addToReturnList(iEntityModel, hoCircuitEnd, arrayList, list);
            }
        }
        if (Endpoints.dbgOn()) {
            db.println("getAvailPoolPaths() returning " + arrayList.size() + " endpts");
        }
        return arrayList;
    }

    private List getAvailPoolPaths(IPoolModel iPoolModel, INodeModel iNodeModel, IEntityModel iEntityModel, int n, int n2, int n3, List list, boolean bl, boolean bl2) {
        short s;
        IPathInfo[] iPathInfoArray;
        ArrayList arrayList = new ArrayList();
        if (iPoolModel == null || iNodeModel == null || iEntityModel == null) {
            return arrayList;
        }
        int n4 = NetCircuitManager.instance().calcFramingType(n, n2);
        IHoNum iHoNum = Feature.provides((INodeModel)iPoolModel.getNodeModel(), (Feature)Feature.SDH_AU3) ? iPoolModel.includedPath().getStartingHo(n4) : iPoolModel.includedPath().getStartingHo();
        if (Endpoints.dbgOn()) {
            db.println("getAvailPoolPaths(" + iNodeModel.getName() + "::" + Integer.toHexString(iEntityModel.getEntityIndex()) + ")" + " baseHo=" + iHoNum + ", excluded endpts=" + list.size());
        }
        IConnectionModels iConnectionModels = iNodeModel.getConnectionModels();
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)n);
        ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)n2);
        if (iCircuitType.isLoCircuitType() || iCircuitType.isLoVcatCircuitType()) {
            iPathInfoArray = CircuitSize.getLoTunnelSize((int)n4);
            s = iPathInfoArray.size2widthOfHoCircuit();
        } else {
            s = iCircuitSize.size2widthOfHoCircuit();
        }
        iPathInfoArray = !iCircuitType.isVcatCircuitType() || bl ? iPoolModel.getAvailablePaths(s) : iPoolModel.getAvailableVcatPaths(s, (short)n3);
        if (Endpoints.dbgOn()) {
            db.println("pathInfoList size is " + iPathInfoArray.length);
        }
        if (iCircuitType.isLoCircuitType() || iCircuitType.isLoVcatCircuitType()) {
            ILoNum iLoNum;
            LoCircuitEnd loCircuitEnd;
            Object object;
            IHoNum iHoNum2;
            ILoAditModel[] iLoAditModelArray = null;
            iLoAditModelArray = iConnectionModels.getLoAditsInPool(iPoolModel);
            Iterator<ILoAditModel> iterator = Arrays.asList(iLoAditModelArray).iterator();
            while (iterator.hasNext()) {
                try {
                    ILoAditModel iLoAditModel = iterator.next();
                    iHoNum2 = HoPathDefModel.physicalHo(iLoAditModel.getHo());
                    short s2 = iCircuitSize.size2widthOfLoCircuit();
                    object = iLoAditModel.getAvailableLos((int)s2);
                    for (ILoPathInfo iLoPathInfo : Arrays.asList(object)) {
                        loCircuitEnd = this.getAutoAssignedLoCktEnd(iNodeModel, iEntityModel, CircuitType.getCircuitType((int)n));
                        if (loCircuitEnd != null && !bl || loCircuitEnd != null && bl && bl2) {
                            this.addToReturnList(iEntityModel, loCircuitEnd, arrayList, list);
                            if (Endpoints.dbgOn()) {
                                db.println("getAvailPoolPaths() returning " + arrayList.size() + " endpts");
                            }
                            return arrayList;
                        }
                        iLoNum = iLoPathInfo.getLoNum();
                        loCircuitEnd = new LoCircuitEnd(iNodeModel, iEntityModel, iHoNum2, iLoNum, false);
                        this.addToReturnList(iEntityModel, loCircuitEnd, arrayList, list);
                    }
                }
                catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                    SDebug.printStackTrace((Throwable)abstractCmsObjectNotExistException);
                }
            }
            for (IPathInfo iPathInfo : Arrays.asList(iPathInfoArray)) {
                loCircuitEnd = this.getAutoAssignedLoCktEnd(iNodeModel, iEntityModel, CircuitType.getCircuitType((int)n));
                if (loCircuitEnd != null && !bl || loCircuitEnd != null && bl && bl2) {
                    this.addToReturnList(iEntityModel, loCircuitEnd, arrayList, list);
                    break;
                }
                IHoNum iHoNum3 = Feature.provides((INodeModel)iPoolModel.getNodeModel(), (Feature)Feature.SDH_AU3) ? iPathInfo.getStartingHo(n4) : iPathInfo.getStartingHo();
                iHoNum2 = HoPathDefModel.physicalHo(iPoolModel, iHoNum3);
                object = HoLoFactory.getAllLoNums(iEntityModel.getMaxLo(n2), n4, n2);
                ArrayList arrayList2 = new ArrayList();
                for (int i = 0; i < object.size(); ++i) {
                    iLoNum = (ILoNum)object.get(i);
                    arrayList2.add(new HoLoNum(iHoNum2, iLoNum));
                }
                if (Endpoints.isCe2Port(iEntityModel)) {
                    this.filterOutDisallowedHoLos(arrayList2, iNodeModel, iEntityModel, n, n2);
                }
                Iterator iterator2 = arrayList2.iterator();
                while (iterator2.hasNext()) {
                    IHoLoNum iHoLoNum = (IHoLoNum)iterator2.next();
                    loCircuitEnd = new LoCircuitEnd(iNodeModel, iEntityModel, iHoLoNum.getHoNum(), iHoLoNum.getLoNum(), false);
                    this.addToReturnList(iEntityModel, loCircuitEnd, arrayList, list);
                }
            }
        } else {
            for (IPathInfo iPathInfo : Arrays.asList(iPathInfoArray)) {
                HoCircuitEnd hoCircuitEnd = this.getAutoAssignedHoCktEnd(iNodeModel, iEntityModel, CircuitType.getCircuitType((int)n));
                if (hoCircuitEnd != null && !bl || hoCircuitEnd != null && bl && bl2) {
                    this.addToReturnList(iEntityModel, hoCircuitEnd, arrayList, list);
                    break;
                }
                IHoNum iHoNum4 = Feature.provides((INodeModel)iPoolModel.getNodeModel(), (Feature)Feature.SDH_AU3) ? iPathInfo.getStartingHo(n4) : iPathInfo.getStartingHo();
                IHoNum iHoNum5 = HoPathDefModel.physicalHo(iPoolModel, iHoNum4);
                hoCircuitEnd = new HoCircuitEnd(iNodeModel, iEntityModel, iHoNum5, null, false);
                this.addToReturnList(iEntityModel, hoCircuitEnd, arrayList, list);
            }
        }
        if (Endpoints.dbgOn()) {
            db.println("getAvailPoolPaths() returning " + arrayList.size() + " endpts");
        }
        return arrayList;
    }

    private void addToReturnListWithSharedPool(NetCircuitEnd netCircuitEnd, List list, List list2) {
        boolean bl = false;
        if (netCircuitEnd.getHoNum() == null) {
            bl = list2.contains(netCircuitEnd);
        } else {
            Iterator iterator = list2.iterator();
            while (iterator.hasNext() && !bl) {
                NetCircuitEnd netCircuitEnd2 = (NetCircuitEnd)iterator.next();
                if (!NetCircuitEnd.areNodeIdAndSlotAndHoLoEqual(netCircuitEnd, netCircuitEnd2)) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            list.add(netCircuitEnd);
        }
    }

    private void addToReturnList(IEntityModel iEntityModel, NetCircuitEnd netCircuitEnd, List list, List list2) {
        if (iEntityModel.getPayloadType() == 19) {
            this.addToReturnListWithSharedPool(netCircuitEnd, list, list2);
        } else if (!list2.contains(netCircuitEnd)) {
            list.add(netCircuitEnd);
        }
    }

    public LoCircuitEnd getAutoAssignedLoCktEnd(INodeModel iNodeModel, IEntityModel iEntityModel, ICircuitType iCircuitType) {
        LoCircuitEnd loCircuitEnd = null;
        if (LoCircuitEnd.autoAssignCheck(iEntityModel) || iCircuitType.isVcatCircuitType()) {
            IHoNum iHoNum = null;
            ILoNum iLoNum = null;
            loCircuitEnd = new LoCircuitEnd(iNodeModel, iEntityModel, iHoNum, iLoNum, false);
        }
        return loCircuitEnd;
    }

    public HoCircuitEnd getAutoAssignedHoCktEnd(INodeModel iNodeModel, IEntityModel iEntityModel, ICircuitType iCircuitType) {
        HoCircuitEnd hoCircuitEnd = null;
        if (HoCircuitEnd.autoAssignCheck(iEntityModel) || iCircuitType.isVcatCircuitType()) {
            IHoNum iHoNum = null;
            ILoNum iLoNum = null;
            hoCircuitEnd = new HoCircuitEnd(iNodeModel, iEntityModel, iHoNum, iLoNum, false);
        }
        return hoCircuitEnd;
    }

    private void filterDiagPorts(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel = (IEntityModel)iterator.next();
            if (iEntityModel.getPayloadType() == 1) continue;
            if (Endpoints.dbgOn()) {
                db.println("Found an non OCN entity to remove" + iEntityModel);
            }
            iterator.remove();
        }
    }

    protected List getAvailDropPorts(INodeModel iNodeModel, CircuitCreatInfo circuitCreatInfo, NetCircuit netCircuit, boolean bl) {
        IEntityModel iEntityModel;
        Object object;
        Object object2;
        int n2;
        LinkedList<IEntityModel> linkedList;
        Object object3;
        ITdmProtocolType iTdmProtocolType;
        IEntityModel iEntityModel2;
        if (Endpoints.dbgOn()) {
            db.println("getAvailDropPorts() at " + iNodeModel.getName());
        }
        List list = this.getAvailPortEntities(iNodeModel, circuitCreatInfo, bl, netCircuit);
        if (Endpoints.dbgOn()) {
            db.println("entityList1 has " + list.size() + " entities");
        }
        try {
            iEntityModel2 = netCircuit.getPrimarySource().getEntityModel();
        }
        catch (ObjNotFound objNotFound) {
            iEntityModel2 = null;
        }
        boolean bl2 = false;
        if (iEntityModel2 != null) {
            boolean bl3 = bl2 = iEntityModel2.getModuleModel().getEqType() == 233 || iEntityModel2.getModuleModel().getEqType() == 234;
        }
        if ((iTdmProtocolType = iNodeModel.getTdmProtocolTypeObj()).isSdh() && netCircuit.getCircuitSize() == 11 && bl2) {
            object3 = netCircuit.getPrimarySource().getLoNum();
            short s = object3.getVc3OrSts1();
            linkedList = iEntityModel2.getParent().getDescendantsOfClassType(7);
            for (n2 = 0; n2 < linkedList.size(); ++n2) {
                if (((IEntityModel)linkedList.get(n2)).getPositionInParent() != s) continue;
                iEntityModel2 = (IEntityModel)linkedList.get(n2);
            }
        }
        object3 = new LinkedList();
        ICircuitType iCircuitType = netCircuit.getCircuitTypeObj();
        if (iCircuitType.isOchncType() || iCircuitType.isOchccCircuitType() || iCircuitType.isOchTrailTunnelCircuitType()) {
            return list;
        }
        if (iCircuitType.isEthernetCircuitType() || iCircuitType.isTunnelCircuitType()) {
            if (netCircuit.getState() != 0) {
                object3 = this.additionFilter(list);
            }
        } else {
            if (iCircuitType.isSVLANType()) {
                if (circuitCreatInfo.isProtected() && netCircuit.getState() == 0) {
                    linkedList = netCircuit.getCktSources().iterator();
                    NetCircuitEnd netCircuitEnd = null;
                    while (linkedList.hasNext()) {
                        netCircuitEnd = (NetCircuitEnd)linkedList.next();
                        if (netCircuitEnd == null) continue;
                        try {
                            object3.add(netCircuitEnd.getEntityModel());
                        }
                        catch (ObjNotFound objNotFound) {
                            if (Endpoints.dbgOn()) {
                                SDebug.printStackTrace((Throwable)objNotFound);
                            }
                            break;
                        }
                    }
                } else if (netCircuit.getState() == 5 || netCircuit.getState() == 6) {
                    linkedList = netCircuit.getCircuitNodes();
                    n2 = 0;
                    for (NetCircuitNode netCircuitNode : linkedList) {
                        if (netCircuitNode.getNodeModel().getNodeId() != iNodeModel.getNodeId()) continue;
                        n2 = 1;
                        List object4 = netCircuitNode.getPathList();
                        if (object4 == null || object4.size() <= 0) continue;
                        ISvlanPathDefModel iEntityModel3 = (ISvlanPathDefModel)object4.get(0);
                        int list3 = iEntityModel3.getPortEntityIdx();
                        for (IEntityModel iEntityModel4 : list) {
                            if (!SvlanCircuitHelper.arePortsCoLocatedForL2Ckt(iNodeModel, list3, iEntityModel4.getIndex(), true)) continue;
                            object3.add(iEntityModel4);
                        }
                    }
                    if (n2 == 0) {
                        object3.addAll(list);
                    }
                } else {
                    object3.addAll(list);
                }
                if (Endpoints.dbgOn()) {
                    db.println("entityList2 has " + object3.size() + " entities - SVLAN Prot");
                }
                return object3;
            }
            if (iEntityModel2 != null) {
                object3 = this.filterAvailDropEntities(iEntityModel2, list, iCircuitType, netCircuit.getCircuitDir());
            }
        }
        if (Endpoints.dbgOn()) {
            db.println("entityList2 has " + object3.size() + " entities");
        }
        linkedList = object3;
        if (netCircuit.getState() == 0 && netCircuit.isBidirectional()) {
            linkedList = new LinkedList<IEntityModel>();
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                object2 = (IEntityModel)iterator.next();
                if (object2 == null) continue;
                boolean n = false;
                object = null;
                iEntityModel = netCircuit.getCktSources().iterator();
                while (iEntityModel.hasNext() && !n) {
                    object = (NetCircuitEnd)iEntityModel.next();
                    if (object == null || ((NetCircuitEnd)object).getNodeId() != object2.getNodeModel().getNodeId() || ((NetCircuitEnd)object).getEntityIndex() != object2.getIndex()) continue;
                    n = true;
                }
                if (n) {
                    List list2;
                    if (object2.getPayloadType() == 19 && object2.getSlot() == ((NetCircuitEnd)object).getSlotNumber() || (list2 = this.getAvailPortPaths(iNodeModel, (IEntityModel)object2, netCircuit.getCircuitType(), netCircuit.getCircuitSize(), netCircuit.getConfiguredForwardMemberSize(), netCircuit.getCktSources())) == null || list2.isEmpty()) continue;
                    linkedList.add((IEntityModel)object2);
                    continue;
                }
                linkedList.add((IEntityModel)object2);
            }
        } else if (netCircuit.getState() == 1 && !netCircuit.isBidirectional() && !netCircuit.isMonitorCircuit() && netCircuit.getPrimarySource().getNodeModel() == iNodeModel && netCircuit.getSecondarySource() == null) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)netCircuit.getPrimarySource();
            object2 = new NetCircuitDropInfo(netCircuitEnd, 0);
            if (!netCircuit.getCktDrops().contains(object2) && iEntityModel2 != null && !linkedList.contains(iEntityModel2)) {
                linkedList.add(iEntityModel2);
            }
        }
        if (!netCircuit.isBidirectional()) {
            INetCircuitEnd iNetCircuitEnd = null;
            if (netCircuit.getSources() != null) {
                iNetCircuitEnd = (INetCircuitEnd)netCircuit.getSources().get(0);
            }
            try {
                if (iNetCircuitEnd != null && Endpoints.isCe2Port(iNetCircuitEnd.getEntityModel())) {
                    int n4 = iNetCircuitEnd.getEntityIndex();
                    int n = iNetCircuitEnd.getNodeId();
                    object = linkedList.iterator();
                    while (object.hasNext()) {
                        iEntityModel = (IEntityModel)object.next();
                        if (iEntityModel.getEntityIndex() != n4 || iEntityModel.getNodeModel().getNodeId() != n) continue;
                        object.remove();
                    }
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (Endpoints.dbgOn()) {
            db.println("entityList3 has " + linkedList.size() + " entities");
        }
        if (iCircuitType.isVcatCircuitType()) {
            this.filterOnVcatRestrictions(iEntityModel2, linkedList, circuitCreatInfo.lcasMode());
        }
        if (iEntityModel2 != null) {
            int n5 = iEntityModel2.getModuleModel().getEqType();
            if (Endpoints.dbgOn()) {
                db.println("getAvailDropPorts() ML2 check for srcEqType " + n5);
            }
            if (this.isDataCard(n5)) {
                if (Endpoints.dbgOn()) {
                    db.println("getAvailDropPorts() has " + linkedList.size() + " entities before ML2 check");
                }
                this.filterMLPorts(iEntityModel2, linkedList);
            }
            if (Endpoints.isCe2Port(iEntityModel2)) {
                this.filterCe2Ports(iNodeModel, iEntityModel2, circuitCreatInfo, linkedList);
            }
        }
        if (Endpoints.dbgOn()) {
            db.println("getAvailDropPorts() returning " + linkedList.size() + " entities");
        }
        return linkedList;
    }

    private void filterMLPorts(IEntityModel iEntityModel, List list) {
        int n = iEntityModel.getPort();
        if (!Feature.provides((INodeModel)iEntityModel.getNodeModel(), (Feature)Feature.RPR_802_17)) {
            if (Endpoints.dbgOn()) {
                db.println("East-west enforcement is not supported for NE version:" + iEntityModel.getNodeModel().getSwVersion());
            }
            return;
        }
        boolean bl = iEntityModel.inRPRMode();
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        boolean bl2 = Feature.provides((INodeModel)iEntityModel.getNodeModel(), (Feature)Feature.POS_ON_MLMR) && iModuleModel.getEqType() == 285;
        Iterator iterator = list.iterator();
        boolean bl3 = false;
        while (iterator.hasNext()) {
            IEntityModel iEntityModel2 = (IEntityModel)iterator.next();
            IModuleModel iModuleModel2 = iEntityModel2.getModuleModel();
            int n2 = iModuleModel2.getEqType();
            int n3 = iEntityModel2.getPort();
            if (!Feature.provides((INodeModel)iEntityModel2.getNodeModel(), (Feature)Feature.RPR_802_17)) {
                if (!Endpoints.dbgOn()) continue;
                db.println("East-west enforcement is not supported for NE version:" + iEntityModel2.getNodeModel().getSwVersion());
                continue;
            }
            if (!this.isDataCard(n2)) continue;
            if (bl ^ iEntityModel2.inRPRMode()) {
                iterator.remove();
                continue;
            }
            boolean bl4 = bl3 = Feature.provides((INodeModel)iEntityModel2.getNodeModel(), (Feature)Feature.POS_ON_MLMR) && iModuleModel2.getEqType() == 285;
            if (bl2 && !bl3) {
                if (!bl || (n != iModuleModel.getRPREastPort() || n3 != 0) && (n != iModuleModel.getRPRWestPort() || n3 != 1)) continue;
                iterator.remove();
                continue;
            }
            if (!bl2 && bl3) {
                if (!bl || (n != 0 || n3 != iModuleModel2.getRPREastPort()) && (n != 1 || n3 != iModuleModel2.getRPRWestPort())) continue;
                iterator.remove();
                continue;
            }
            if (!bl || n != n3) continue;
            iterator.remove();
        }
    }

    private void filterCe2Ports(INodeModel iNodeModel, IEntityModel iEntityModel, CircuitCreatInfo circuitCreatInfo, List list) {
        IHoLoNum[] iHoLoNumArray;
        if (!CircuitType.getCircuitType((int)circuitCreatInfo.type()).isVcatCircuitType()) {
            return;
        }
        if (iNodeModel.getNodeId() != iEntityModel.getNodeModel().getNodeId()) {
            return;
        }
        IHoLoNum[] iHoLoNumArray2 = circuitCreatInfo.getMemberSrcHoLoNums();
        if (iHoLoNumArray2 == null || iHoLoNumArray2.length == 0) {
            return;
        }
        boolean bl = false;
        try {
            iHoLoNumArray = this.getAutoSelectVcatPaths(iEntityModel.getNodeModel(), iEntityModel, circuitCreatInfo.type(), circuitCreatInfo.size(), circuitCreatInfo.forwardMembers(), iHoLoNumArray2);
            if (iHoLoNumArray.length == circuitCreatInfo.forwardMembers()) {
                bl = true;
            }
        }
        catch (ProvisionError provisionError) {
            SDebug.printStackTrace((Throwable)provisionError);
        }
        if (!bl) {
            iHoLoNumArray = iEntityModel.getModuleModel();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IEntityModel iEntityModel2 = (IEntityModel)iterator.next();
                if (!iHoLoNumArray.equals(iEntityModel2.getModuleModel())) continue;
                iterator.remove();
            }
        }
    }

    private boolean isDataCard(int n) {
        switch (n) {
            case 62: 
            case 102: 
            case 103: 
            case 163: 
            case 164: 
            case 187: 
            case 221: 
            case 229: 
            case 283: 
            case 284: 
            case 285: {
                return true;
            }
        }
        return false;
    }

    protected static boolean isCe2Port(IEntityModel iEntityModel) {
        switch (iEntityModel.getModuleModel().getEqType()) {
            case 283: 
            case 284: 
            case 285: {
                return true;
            }
        }
        return false;
    }

    protected List getAvailDropPoints(INodeModel iNodeModel, IEntityModel iEntityModel, NetCircuit netCircuit) {
        Object object;
        ITdmProtocolType iTdmProtocolType;
        List list;
        if (Endpoints.dbgOn()) {
            db.println("getAvailDropPoints() for " + netCircuit.getCircuitName());
        }
        if (netCircuit instanceof NetVcatCircuit && ((NetVcatCircuit)netCircuit).isOpenEndedVcatCircuit()) {
            list = ((NetVcatCircuit)netCircuit).getState() != 0 ? (NetCircuit.isBackHaulVcatCircuit(netCircuit) && iEntityModel.getModuleModel().getEqType() == 285 ? this.getAvailPortPaths(iNodeModel, iEntityModel, netCircuit.getCircuitType(), netCircuit.getCircuitSize(), netCircuit.getConfiguredForwardMemberSize(), netCircuit.getCktSources(), true, true) : this.getAvailPortPaths(iNodeModel, iEntityModel, netCircuit.getCircuitType(), netCircuit.getCircuitSize(), netCircuit.getConfiguredForwardMemberSize(), netCircuit.getCktSources(), true, false)) : this.getAvailPortPaths(iNodeModel, iEntityModel, netCircuit.getCircuitType(), netCircuit.getCircuitSize(), netCircuit.getConfiguredForwardMemberSize(), netCircuit.getCktSources(), true, false);
        } else {
            iTdmProtocolType = Network.instance().findNetElem(iEntityModel.getNodeModel()).getTdmProtocolTypeObj();
            try {
                object = netCircuit.getPrimarySource().getEntityModel();
            }
            catch (ObjNotFound objNotFound) {
                object = null;
            }
            boolean bl = iEntityModel.getModuleModel().getEqType() == 233 || iEntityModel.getModuleModel().getEqType() == 234;
            boolean bl2 = false;
            if (object != null) {
                boolean bl3 = bl2 = object.getModuleModel().getEqType() == 233 || object.getModuleModel().getEqType() == 234;
            }
            if (bl && iTdmProtocolType.isSdh() && netCircuit.getCircuitSize() == 11 && bl2) {
                IEntityModel iEntityModel2 = null;
                ILoNum iLoNum = netCircuit.getPrimarySource().getLoNum();
                short s = iLoNum.getVc3OrSts1();
                List list2 = object.getParent().getDescendantsOfClassType(7);
                for (int i = 0; i < list2.size(); ++i) {
                    if (((IEntityModel)list2.get(i)).getPositionInParent() != s) continue;
                    iEntityModel2 = (IEntityModel)list2.get(i);
                }
                List list3 = iEntityModel.getParent().getDescendantsOfClassType(7);
                list = this.getAvailPortPaths(iNodeModel, iEntityModel, netCircuit.getCircuitType(), netCircuit.getCircuitSize(), netCircuit.getConfiguredForwardMemberSize(), netCircuit.getCktSources(), iEntityModel2, list3);
            } else if (bl && iTdmProtocolType.isSdh() && netCircuit.getCircuitSize() == 11) {
                List list4 = iEntityModel.getParent().getDescendantsOfClassType(7);
                list = this.getAvailPortPaths(iNodeModel, iEntityModel, netCircuit.getCircuitType(), netCircuit.getCircuitSize(), netCircuit.getConfiguredForwardMemberSize(), netCircuit.getCktSources(), (IEntityModel)object, list4);
            } else {
                list = this.getAvailPortPaths(iNodeModel, iEntityModel, netCircuit.getCircuitType(), netCircuit.getCircuitSize(), netCircuit.getConfiguredForwardMemberSize(), netCircuit.getCktSources());
            }
        }
        try {
            iTdmProtocolType = netCircuit.getPrimarySource().getEntityModel();
        }
        catch (ObjNotFound objNotFound) {
            iTdmProtocolType = null;
        }
        if (!netCircuit.isBidirectional() && !netCircuit.isMonitorCircuit() && netCircuit.getPrimarySource() != null && netCircuit.getPrimarySource().getNodeModel() == iNodeModel && iTdmProtocolType != null && iTdmProtocolType == iEntityModel && netCircuit.getSecondarySource() == null) {
            object = (NetCircuitEnd)netCircuit.getPrimarySource();
            NetCircuitDropInfo netCircuitDropInfo = new NetCircuitDropInfo((NetCircuitEnd)object, 0);
            if (!netCircuit.getCktDrops().contains(netCircuitDropInfo)) {
                list.add(object);
            }
        }
        if (Endpoints.dbgOn()) {
            db.println("getAvailDropPoints() returning " + list.size() + " points");
        }
        return list;
    }

    protected List filterAvailDropEntities(IEntityModel iEntityModel, List list, ICircuitType iCircuitType, int n) {
        ITdmProtocolType iTdmProtocolType;
        if (iCircuitType.isLoCircuitType() || iCircuitType.isLoVcatCircuitType() ? !(iTdmProtocolType = Network.instance().findNetElem(iEntityModel.getNodeModel()).getTdmProtocolTypeObj()).isSonet() : iCircuitType.isHoCircuitType() || iCircuitType.isHoVcatCircuitType()) {
            return this.filterOnPayloadType(iEntityModel, list, n);
        }
        return list;
    }

    private List filterOnPayloadType(IEntityModel iEntityModel, List list, int n) {
        LinkedList<IEntityModel> linkedList = new LinkedList<IEntityModel>();
        Iterator iterator = list.iterator();
        ITdmProtocolType iTdmProtocolType = Network.instance().findNetElem(iEntityModel.getNodeModel()).getTdmProtocolTypeObj();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel2 = (IEntityModel)iterator.next();
            if ((iEntityModel2.getModuleModel().getEqType() == 233 || iEntityModel2.getModuleModel().getEqType() == 234) && iTdmProtocolType.isSdh()) {
                List list2 = iEntityModel2.getParent().getDescendantsOfClassType(7);
                for (int i = 0; i < list2.size(); ++i) {
                    if (!PayloadTypeCompatibility.isCompatible(iEntityModel, (IEntityModel)list2.get(i), n)) continue;
                    linkedList.add(iEntityModel2);
                }
            }
            if (!PayloadTypeCompatibility.isCompatible(iEntityModel, iEntityModel2, n)) continue;
            linkedList.add(iEntityModel2);
        }
        return linkedList;
    }

    private void filterOnVcatRestrictions(IEntityModel iEntityModel, List list, int n) {
        if (n != 1) {
            return;
        }
        int n2 = iEntityModel.getPayloadType();
        int n3 = iEntityModel.getModuleModel().getEqType();
        if (n2 != 18 && n2 != 19 || n3 == 164 || n3 == 229) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel2 = (IEntityModel)iterator.next();
            int n4 = iEntityModel2.getEqType();
            int n5 = iEntityModel.getEqType();
            int n6 = iEntityModel2.getModuleModel().getEqType();
            if (n5 != 165 || n4 != 165 || n6 == 164) continue;
            iterator.remove();
        }
    }

    private List additionFilter(List list) {
        LinkedList<IEntityModel> linkedList = new LinkedList<IEntityModel>();
        for (IEntityModel iEntityModel : list) {
            int n = iEntityModel.getPayloadType();
            ITdmProtocolType iTdmProtocolType = Network.instance().findNetElem(iEntityModel.getNodeModel()).getTdmProtocolTypeObj();
            if ((n != 1 && n != 7 && n != 2 || !iTdmProtocolType.isSonet()) && (n != 9 || !iTdmProtocolType.isSdh())) continue;
            linkedList.add(iEntityModel);
        }
        return linkedList;
    }

    public static List getAvailEntitiesForDstHo(NetCircuitNode netCircuitNode, int n) {
        if (!(netCircuitNode instanceof HoCircuitNode)) {
            return new ArrayList();
        }
        INodeModel iNodeModel = netCircuitNode.getNodeModel();
        IEntityTableModel iEntityTableModel = null;
        if (iNodeModel != null) {
            iEntityTableModel = iNodeModel.getEntityTable();
        }
        if (iEntityTableModel == null) {
            return new ArrayList();
        }
        return iEntityTableModel.getAvailEntitiesForDstHo(n, netCircuitNode.getPathWidth(), netCircuitNode.getCircuit().getCircuitDir(), false);
    }

    public static List getAvailEntitiesForSecHo(NetCircuitNode netCircuitNode, int n) {
        INodeModel iNodeModel = netCircuitNode.getNodeModel();
        IEntityTableModel iEntityTableModel = null;
        if (iNodeModel != null) {
            iEntityTableModel = iNodeModel.getEntityTable();
        }
        if (iEntityTableModel == null) {
            return new ArrayList();
        }
        return iEntityTableModel.getAvailEntitiesForSecHo(n, netCircuitNode.getPathWidth(), netCircuitNode.getCircuit().getCircuitDir(), false);
    }

    public static IEntityModel getEntityModelForPath(NetCircuitNode netCircuitNode, Object object) {
        IEntityModel iEntityModel = null;
        try {
            if (object instanceof NetCircuitEnd) {
                iEntityModel = ((NetCircuitEnd)object).getEntityModel();
            } else if (object instanceof NetCircuitSpan) {
                INetElement iNetElement = netCircuitNode.getNetElement();
                iEntityModel = ((NetCircuitSpan)object).getEntityModel(iNetElement);
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            iEntityModel = null;
        }
        catch (ObjNotFound objNotFound) {
            iEntityModel = null;
        }
        return iEntityModel;
    }

    public IHoLoNum[] getSourceAutoSelectVcatPaths(INodeModel iNodeModel, IEntityModel iEntityModel, CircuitCreatInfo circuitCreatInfo) throws ProvisionError {
        if (Endpoints.dbgOn()) {
            db.println("getSourceAutoSelectVcatPaths @ " + iNodeModel);
        }
        if (circuitCreatInfo == null) {
            return new IHoLoNum[0];
        }
        return this.getAutoSelectVcatPaths(iNodeModel, iEntityModel, circuitCreatInfo.type(), circuitCreatInfo.size(), circuitCreatInfo.forwardMembers(), new IHoLoNum[0]);
    }

    public IHoLoNum[] getAutoSelectVcatPaths(INodeModel iNodeModel, IEntityModel iEntityModel, int n, int n2, int n3, IHoLoNum[] iHoLoNumArray) throws ProvisionError {
        IHoLoNum[] iHoLoNumArray2 = new IHoLoNum[]{};
        if (iNodeModel == null || iEntityModel == null) {
            return iHoLoNumArray2;
        }
        if (Endpoints.dbgOn()) {
            db.println("getAutoSelectVcatPaths(" + iNodeModel.getName() + "::" + Integer.toHexString(iEntityModel.getEntityIndex()) + ") excluded paths=" + iHoLoNumArray.length);
        }
        if (!Feature.provides((INodeModel)iNodeModel, (Feature)Feature.CE2_MANUAL_VCAT)) {
            return iHoLoNumArray2;
        }
        if (!Endpoints.isCe2Port(iEntityModel)) {
            return iHoLoNumArray2;
        }
        IPoolModel[] iPoolModelArray = iNodeModel.getPoolModels().getPoolModels(iEntityModel.getEntityIndex());
        if (iPoolModelArray == null || iPoolModelArray.length == 0) {
            return iHoLoNumArray2;
        }
        IPoolModel iPoolModel = iPoolModelArray[0];
        iHoLoNumArray2 = iPoolModel.getAutoSelectVcatPaths(n, n2, (short)n3, iHoLoNumArray);
        if (Endpoints.dbgOn()) {
            db.println("getAutoSelectVcatPaths(" + iNodeModel.getName() + "::" + Integer.toHexString(iEntityModel.getEntityIndex()) + ") returning " + iHoLoNumArray2.length + " paths");
            for (int i = 0; i < iHoLoNumArray2.length; ++i) {
                db.println("Ho: " + iHoLoNumArray2[i].getHoNum() + ", Lo: " + iHoLoNumArray2[i].getLoNum());
            }
        }
        return iHoLoNumArray2;
    }

    public IPathStateInfo[] getAllPathStateInfo(INodeModel iNodeModel, IEntityModel iEntityModel, int n, int n2) throws ProvisionError {
        IPathStateInfo[] iPathStateInfoArray = new IPathStateInfo[]{};
        if (iNodeModel == null || iEntityModel == null) {
            return iPathStateInfoArray;
        }
        if (Endpoints.dbgOn()) {
            db.println("getAllPathStateInfo(" + iNodeModel.getName() + "::" + Integer.toHexString(iEntityModel.getEntityIndex()));
        }
        if (!Feature.provides((INodeModel)iNodeModel, (Feature)Feature.CE2_MANUAL_VCAT)) {
            return iPathStateInfoArray;
        }
        if (!Endpoints.isCe2Port(iEntityModel)) {
            return iPathStateInfoArray;
        }
        IPoolModel[] iPoolModelArray = iNodeModel.getPoolModels().getPoolModels(iEntityModel.getEntityIndex());
        if (iPoolModelArray == null || iPoolModelArray.length == 0) {
            return iPathStateInfoArray;
        }
        IPoolModel iPoolModel = iPoolModelArray[0];
        iPathStateInfoArray = iPoolModel.getAllPathStateInfo(n, n2);
        if (Endpoints.dbgOn()) {
            db.println("getAllPathStateInfo(" + iNodeModel.getName() + "::" + Integer.toHexString(iEntityModel.getEntityIndex()) + ") returning " + iPathStateInfoArray.length + " paths");
        }
        return iPathStateInfoArray;
    }

    private Set<IHoLoNum> getCe2CandidateHoLoNums(INodeModel iNodeModel, IEntityModel iEntityModel, int n, int n2) {
        HashSet<IHoLoNum> hashSet = new HashSet<IHoLoNum>();
        IPathStateInfo[] iPathStateInfoArray = new IPathStateInfo[]{};
        try {
            iPathStateInfoArray = this.getAllPathStateInfo(iNodeModel, iEntityModel, n, n2);
        }
        catch (ProvisionError provisionError) {
            SDebug.printStackTrace((Throwable)provisionError);
        }
        for (int i = 0; i < iPathStateInfoArray.length; ++i) {
            hashSet.add(new HoLoNum(iPathStateInfoArray[i].getHoNum(), iPathStateInfoArray[i].getLoNum()));
        }
        if (Endpoints.dbgOn()) {
            db.println("getCe2CandidateHoNums() returns " + hashSet.size() + "holo numbers: " + hashSet);
        }
        return hashSet;
    }

    private void filterOutDisallowedHoLos(List<IHoLoNum> list, INodeModel iNodeModel, IEntityModel iEntityModel, int n, int n2) {
        if (Endpoints.dbgOn()) {
            db.println("Before filter, " + list.size() + " items");
        }
        Set<IHoLoNum> set = this.getCe2CandidateHoLoNums(iNodeModel, iEntityModel, n, n2);
        Iterator<IHoLoNum> iterator = list.iterator();
        while (iterator.hasNext()) {
            IHoLoNum iHoLoNum = iterator.next();
            if (set.contains(iHoLoNum)) continue;
            iterator.remove();
        }
        if (Endpoints.dbgOn()) {
            db.println("After filter, " + list.size() + " items");
        }
    }

    static {
        db = new SDebug("Endpoints");
    }
}

