/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.Busy;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.Feature;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.ILoPathInfo;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.LoDefModel;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.topo.INetElement;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import java.util.List;

public class LoCircuitEnd
extends NetCircuitEnd {
    private static SDebug db = new SDebug("LoCircuitEnd");
    private IHoNum aditHoNum;
    private boolean isTl1LapCktEnd;

    public LoCircuitEnd(INodeModel iNodeModel, ICircuitEnd iCircuitEnd) {
        super(iNodeModel, iCircuitEnd);
        this.aditHoNum = null;
        this.isTl1LapCktEnd = false;
    }

    public LoCircuitEnd(INodeModel iNodeModel, IEntityModel iEntityModel, IHoNum iHoNum, ILoNum iLoNum, boolean bl) {
        super(iNodeModel, iEntityModel, iHoNum, iLoNum, bl);
        this.aditHoNum = null;
        this.isTl1LapCktEnd = false;
    }

    public LoCircuitEnd(int n, int n2, IHoNum iHoNum, ILoNum iLoNum, boolean bl) {
        super(n, n2, iHoNum, iLoNum, bl);
        this.aditHoNum = null;
        this.isTl1LapCktEnd = false;
    }

    public LoCircuitEnd(INodeModel iNodeModel, IEntityModel iEntityModel, IHoLoNum iHoLoNum, boolean bl) {
        super(iNodeModel, iEntityModel, iHoLoNum, bl);
        this.aditHoNum = null;
        this.isTl1LapCktEnd = false;
    }

    public LoCircuitEnd(INetElement iNetElement, Object object) {
        IEntityModel iEntityModel;
        IHoNum iHoNum = null;
        ILoNum iLoNum = null;
        IHoNum iHoNum2 = null;
        this.isTl1LapCktEnd = false;
        int n = 0;
        INodeModel iNodeModel = iNetElement.getNodeModel();
        int n2 = 0;
        int n3 = 0;
        if (object instanceof ILoDefModel) {
            ILoDefModel iLoDefModel = (ILoDefModel)object;
            n = NetCircuitNode.getEntityIndexFromLoDef(iNodeModel, iLoDefModel);
            iHoNum = LoDefModel.physicalHo(iLoDefModel);
            iLoNum = iLoDefModel.getLoNum();
            n2 = 4;
            iHoNum2 = iHoNum;
            n3 = Feature.provides((INodeModel)iNodeModel, (Feature)Feature.VCAT) ? (int)iLoDefModel.getPathIdentifier() : 0;
        } else if (this.dbgOn()) {
            this.debug("Warning! LoCircuitEnd constructor unknown object type");
        }
        this.setCircuitEnd(new CircuitEnd(iNodeModel.getNodeId(), n, iHoNum, iLoNum, false, n3));
        try {
            iEntityModel = this.getEntityModel(n);
        }
        catch (ObjNotFound objNotFound) {
            iEntityModel = null;
        }
        if (iEntityModel != null && LoCircuitEnd.autoAssignCheck(iEntityModel)) {
            this.setHoNum(null);
            this.setLoNum(null);
        }
        this.setStage(n2);
        this.setAditHoNum(iHoNum2);
    }

    public LoCircuitEnd(INetCircuitEnd iNetCircuitEnd) {
        super(iNetCircuitEnd);
        if (iNetCircuitEnd instanceof LoCircuitEnd) {
            this.setAditHoNum(((LoCircuitEnd)iNetCircuitEnd).aditHoNum);
        } else {
            this.aditHoNum = null;
        }
        this.isTl1LapCktEnd = false;
    }

    public void cleanupLoAditIfOldNe() {
        if (!this.getNodeModel().provides(Feature.TCCU)) {
            this.cleanupLoAdit();
        }
    }

    public void cleanupLoAdit() {
        block12: {
            if (this.getHoNum() != null && this.getLoNum() == null) {
                if (this.dbgOn()) {
                    this.debug("cleanupLoAdit: ERROR-Not an LoCircuitEnd");
                }
                return;
            }
            IPoolModel iPoolModel = this.getHoPool();
            if (iPoolModel == null) {
                if (this.dbgOn()) {
                    this.debug("cleanupLoAdit: ERROR-Pool not found");
                }
                return;
            }
            ILoAditModel iLoAditModel = this.findLoAdit(iPoolModel, this.aditHoNum);
            if (iLoAditModel == null) {
                if (this.dbgOn()) {
                    this.debug("cleanupLoAdit: LoAdit not found for aditHoNum=" + this.aditHoNum + "; Assume deleted");
                }
                return;
            }
            try {
                ICircuitId iCircuitId = iLoAditModel.getCircuitId();
                if (iCircuitId.getUniquePart().getUniqueId() != 0) {
                    return;
                }
                if (this.dbgOn()) {
                    this.debug("Destroying LoAdit on LoCircuitEnd; aditHoNum = " + this.aditHoNum);
                }
                iLoAditModel.localDestroy();
            }
            catch (Busy busy) {
                if (this.dbgOn()) {
                    this.debug("cleaunupLoAdit: LoAdit in use");
                }
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                if (!this.dbgOn()) break block12;
                this.debug("cleanupLoAdit: LoAdit object does not exist; Assume deleted");
            }
        }
    }

    public Object getPathDef(short s) throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo {
        return this.getPathDef(s, null);
    }

    public Object getPathDef(short s, List list) throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo {
        IPoolModel iPoolModel = this.getHoPool();
        if (iPoolModel == null) {
            throw new ObjNotFound("not found hoPool");
        }
        ILoAditModel iLoAditModel = this.getLoAdit(iPoolModel, s, list);
        if (iLoAditModel == null) {
            try {
                iLoAditModel = this.createLoAdit(null, iPoolModel);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.dbgOn()) {
                    this.debug("Unable to create LoAdit, Cms IO exception");
                }
                throw new ObjNotFound("Unable to create LoAdit, Cms IO exception");
            }
            if (iLoAditModel == null) {
                if (this.dbgOn()) {
                    this.debug("Unable to create LoAdit");
                }
                throw new ObjNotFound("Unable to creat LoAdit");
            }
        }
        this.setAditHoNum(HoPathDefModel.physicalHo(iLoAditModel.getHo()));
        return new LoDefModel(this.getNodeModel(), iLoAditModel, this.getLoNum(), s, (short)this.getPathIdentifier(), this.getEntityIndex());
    }

    private ILoAditModel getLoAdit(IPoolModel iPoolModel, short s, List list) {
        if (this.getHoNum() != null) {
            return this.findLoAdit(iPoolModel, this.getHoNum());
        }
        INodeModel iNodeModel = this.getNodeModel();
        if (iNodeModel == null) {
            return null;
        }
        ILoAditModel[] iLoAditModelArray = iNodeModel.getConnectionModels().getLoAditsInPool(iPoolModel);
        if (iLoAditModelArray != null) {
            if (this.dbgOn()) {
                this.debug("getLoAdit(): " + iLoAditModelArray.length + " adits in pool for hoNum=" + this.getHoNum());
            }
            for (int i = 0; i < iLoAditModelArray.length; ++i) {
                try {
                    int n;
                    ILoAditModel iLoAditModel = iLoAditModelArray[i];
                    if (iLoAditModel == null) continue;
                    ILoPathInfo[] iLoPathInfoArray = iLoAditModel.getAvailableLos((int)s);
                    int n2 = n = this.aditInExcludedDefs(list, iLoAditModel) ? 2 : 1;
                    if (iLoPathInfoArray.length < n) continue;
                    if (this.dbgOn()) {
                        IHoNum iHoNum = HoPathDefModel.physicalHo(iLoAditModel.getHo());
                        this.debug("getLoAdit(): Returning adit for HO number " + iHoNum);
                    }
                    return iLoAditModel;
                }
                catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                    SDebug.printStackTrace((Throwable)abstractCmsObjectNotExistException);
                }
            }
        }
        return null;
    }

    private boolean aditInExcludedDefs(List list, ILoAditModel iLoAditModel) {
        if (list == null) {
            return false;
        }
        for (Object e : list) {
            if (!iLoAditModel.equals(((ILoDefModel)e).getLoAdit())) continue;
            return true;
        }
        return false;
    }

    protected void setTl1LapCktEnd() {
        this.isTl1LapCktEnd = true;
    }

    protected boolean isTl1LapCktEnd() {
        return this.isTl1LapCktEnd;
    }

    private void setAditHoNum(IHoNum iHoNum) {
        if (this.dbgOn()) {
            this.debug("Setting aditHoNum to " + iHoNum);
        }
        this.aditHoNum = iHoNum;
    }

    public boolean roughlyEquals(LoCircuitEnd loCircuitEnd) {
        int n = loCircuitEnd.getCircuitEnd().getPortNum() - this.getCircuitEnd().getPortNum();
        return loCircuitEnd.getCircuitEnd().getNodeId() == this.getCircuitEnd().getNodeId() && (n == 0 || n == 1 || n == -1) && LoCircuitEnd.areHoLoNumsEqual(loCircuitEnd.getCircuitEnd().getHoLoNum(), this.getCircuitEnd().getHoLoNum());
    }

    public boolean isPreVcatDaytonaCircuitEnd() {
        INodeModel iNodeModel = this.getNodeModel();
        if (iNodeModel != null) {
            if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.VCAT)) {
                return false;
            }
            IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
            if (iEntityTableModel != null) {
                IEntityModel iEntityModel;
                try {
                    iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(this.getEntityIndex());
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    iEntityModel = null;
                }
                if (iEntityModel != null) {
                    return iEntityModel.getPayloadType() == 14;
                }
            }
        }
        return false;
    }

    public static boolean autoAssignCheck(IEntityModel iEntityModel) {
        IModuleModel iModuleModel;
        boolean bl = false;
        int n = iEntityModel.getPayloadType();
        if (n == 14 || n == 17 || n == 18) {
            bl = true;
        } else if (n == 19 && Feature.provides((INodeModel)iEntityModel.getNodeModel(), (Feature)Feature.HOLO_ETHER_PROVISION_MODE) && (iModuleModel = iEntityModel.getModuleModel()) != null && iModuleModel.isAutoProvisionMode()) {
            bl = true;
        }
        db.fine("autoAssign=" + bl);
        return bl;
    }

    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    protected void debug(String string) {
        db.println(string);
    }
}

