/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.ICircuitId;
import cerent.cms.model.INodeModel;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitRepairer;
import cerent.cms.ncp.NetCircuitWatchDog;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.util.SDebug;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class NetCcatCircuitRepairer
extends NetCircuitRepairer {
    private static NetCcatCircuit ccatCircuit;
    private static final SDebug db;

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    protected NetCcatCircuitRepairer(NetCircuit netCircuit) {
        ccatCircuit = (NetCcatCircuit)netCircuit;
    }

    protected NetCircuit getCircuit() {
        return ccatCircuit;
    }

    protected Set getAffectedNodes(int n, int n2) {
        Object object;
        HashSet<INodeModel> hashSet = new HashSet<INodeModel>();
        ICircuitId iCircuitId = ccatCircuit.getCircuitId();
        Network network = Network.instance();
        if (NetCcatCircuit.isNullCircuitId(iCircuitId)) {
            return hashSet;
        }
        if (iCircuitId.getNodeId() == n) {
            INetElement iNetElement;
            for (NetCircuitEnd netCircuitEnd : ccatCircuit.getSources()) {
                if (netCircuitEnd.getCircuitEnd().getNodeId() == n) {
                    iNetElement = network.findNetElem(n2);
                    if (iNetElement == null) {
                        if (NetCcatCircuitRepairer.dbgOn()) {
                            db.println("getAffectedNodes: NE not found for node " + Integer.toHexString(n2));
                        }
                        return hashSet;
                    }
                    hashSet.add(iNetElement.getNodeModel());
                    continue;
                }
                if (!NetCcatCircuitRepairer.dbgOn()) continue;
                db.println("getAffectedNodes: Source Matched with old node id: " + Integer.toHexString(netCircuitEnd.getCircuitEnd().getNodeId()));
            }
            for (NetCircuitDropInfo netCircuitDropInfo : ccatCircuit.getDrops()) {
                if (netCircuitDropInfo.getNetCktEnd().getCircuitEnd().getNodeId() != n) continue;
                iNetElement = network.findNetElem(n2);
                if (iNetElement == null) {
                    if (NetCcatCircuitRepairer.dbgOn()) {
                        db.println("getAffectedNodes: NE not found for node " + n2);
                    }
                    return hashSet;
                }
                hashSet.add(iNetElement.getNodeModel());
            }
            for (NetCircuitNode netCircuitNode : ccatCircuit.getCircuitNodes()) {
                hashSet.add(netCircuitNode.getNodeModel());
            }
            return hashSet;
        }
        if (NetCcatCircuitRepairer.dbgOn()) {
            db.println("getAffectedNodes(" + ccatCircuit.getCircuitName() + ", " + NetCcatCircuit.prettyString(iCircuitId) + ")" + ": Checking drops to see if they have old NodeId");
        }
        for (NetCircuitDropInfo netCircuitDropInfo : ccatCircuit.getDrops()) {
            if (netCircuitDropInfo.getNetCktEnd().getCircuitEnd().getNodeId() != n) continue;
            object = network.findNetElem(n2);
            if (object == null) {
                if (NetCcatCircuitRepairer.dbgOn()) {
                    db.println("getAffectedNodes: NE not found for node " + n2);
                }
                return hashSet;
            }
            hashSet.add(object.getNodeModel());
        }
        for (NetCircuitEnd netCircuitEnd : ccatCircuit.getSources()) {
            if (netCircuitEnd.getCircuitEnd().getNodeId() == n) {
                object = network.findNetElem(n2);
                if (object == null) {
                    if (NetCcatCircuitRepairer.dbgOn()) {
                        db.println("getAffectedNodes: NE not found for node " + n2);
                    }
                    return hashSet;
                }
                hashSet.add(object.getNodeModel());
                continue;
            }
            object = ccatCircuit.getCircuitNodeFromCktEnd(netCircuitEnd);
            if (object == null) {
                if (NetCcatCircuitRepairer.dbgOn()) {
                    db.println("getAffectedNodes: Circuit node not found ");
                }
                return hashSet;
            }
            hashSet.add(ccatCircuit.getCircuitNodeFromCktEnd(netCircuitEnd).getNodeModel());
        }
        return hashSet;
    }

    protected boolean isRepairable() {
        if (ccatCircuit.isStitchedEthernet()) {
            if (NetCcatCircuitRepairer.dbgOn()) {
                db.println("Stitched Ethernet Circuit cannot be repaired");
            }
            return false;
        }
        return super.isRepairable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeCircuitId(ICircuitId iCircuitId) {
        if (NetCcatCircuitRepairer.dbgOn()) {
            db.println("Changing CircuitId from " + NetCcatCircuit.prettyString(ccatCircuit.getCircuitId()) + " to " + NetCcatCircuit.prettyString(iCircuitId) + " for " + ccatCircuit.getCircuitName());
        }
        Iterator iterator = ccatCircuit.getCircuitNodes().iterator();
        NetCcatCircuit netCcatCircuit = ccatCircuit;
        synchronized (netCcatCircuit) {
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
                netCircuitNode.setConnectionCircuitId(iCircuitId);
                ccatCircuit.disposeConnection(netCircuitNode, false);
                NetCircuitWatchDog.instance().reloadConnections(netCircuitNode.getNetElement());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCktId(ICircuitId iCircuitId, int n) {
        if (NetCcatCircuitRepairer.dbgOn()) {
            db.println("Changing CircuitId from " + NetCcatCircuit.prettyString(ccatCircuit.getCircuitId()) + " to " + NetCcatCircuit.prettyString(iCircuitId) + " for " + ccatCircuit.getCircuitName());
        }
        Iterator iterator = ccatCircuit.getCircuitNodes().iterator();
        NetCcatCircuit netCcatCircuit = ccatCircuit;
        synchronized (netCcatCircuit) {
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
                if (netCircuitNode.getNodeModel().getNodeId() != n) continue;
                netCircuitNode.setConnectionCircuitId(iCircuitId);
            }
        }
    }

    static {
        db = new SDebug("NetCcatCircuitRepairer");
    }
}

