/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.FramingType;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IDriNodeType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IFramingType;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.LinkModel;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.ConnTypeUnsupported;
import cerent.cms.ncp.Connection;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.MissingLinks;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeFactory;
import cerent.cms.ncp.NetCircuitNodeUtil;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSpanFactory;
import cerent.cms.ncp.NetCircuitSplicer;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.SpliceLinkIndex;
import cerent.cms.ncp.SpliceListener;
import cerent.cms.ncp.SpliceListenerEntry;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.NetLinkFactory;
import cerent.cms.topo.Network;
import cerent.cms.topo.OchTrailTunnelNetLink;
import cerent.cms.topo.OchncFilterManager;
import cerent.cms.topo.OscNetLink;
import cerent.cms.topo.VirtualNetLink;
import cerent.cms.ui.Wavelength;
import cerent.util.AnnotatedException;
import cerent.util.EnumStrings;
import cerent.util.ILabel;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Observer;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetCircuitHealOperator
extends NetCircuitSplicer {
    private NetCircuitSplicer splicer = NetCircuitSplicer.instance();
    private static SDebug db = new SDebug("NetCircuitHealOperator");
    private LinkedList<SplicingInfo> biDirAToBSplicingInfo = new LinkedList();
    private LinkedList<SplicingInfo> biDirBToASplicingInfo = new LinkedList();
    private LinkedList<SplicingInfo> uniDirSplicingInfo = new LinkedList();
    private HashMap<Integer, Integer> uniWavelengthToSkipMap = new HashMap();
    private HashMap<Integer, Integer> bidiWavelengthToSkipMap = new HashMap();
    private ArrayList<String> wavelengthNotFixed = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addNeToRing(INetElement iNetElement, Observer observer) throws MissingLinks, AnnotatedException {
        if (this.net == null) {
            this.net = Network.instance();
            if (this.net == null) {
                NetCircuitHealOperator.debug("addNeToRing failed: Couldn't get network object");
                return 0;
            }
        }
        int n = 0;
        float f = 0.0f;
        NetCircuitSplicer netCircuitSplicer = this.splicer;
        synchronized (netCircuitSplicer) {
            Object object;
            Object object2;
            Object object3;
            this.splicer.synchronizeSpliceListeners();
            this.splicer.synchronizeCallbackLinks();
            LinkedList linkedList = (LinkedList)this.net.findAllNetLinksWithSource(iNetElement);
            if (linkedList == null) {
                throw new MissingLinks("Netlink list null");
            }
            Iterator iterator = linkedList.iterator();
            LinkedList<Object> linkedList2 = new LinkedList<Object>();
            while (iterator.hasNext()) {
                object3 = (INetLink)iterator.next();
                if (object3 instanceof DwdmNetLink) {
                    linkedList2.add(object3);
                    object2 = OchncFilterManager.findLinkForReversePath((INetLink)object3, db);
                    if (object2 == null) {
                        if (NetCircuitHealOperator.dbgOn()) {
                            NetCircuitHealOperator.debug("processAddNe: No DWDM opposite link for " + iNetElement.getName());
                        }
                        throw new MissingLinks("No DWDM oppositeLink link!");
                    }
                    linkedList2.add(object2);
                    iterator.remove();
                    continue;
                }
                if (object3 instanceof VirtualNetLink) {
                    object2 = (VirtualNetLink)object3;
                    try {
                        if (((VirtualNetLink)object2).isBetweenOtsPorts()) {
                            object = this.net.findReverseLink((INetLink)object2);
                            if (object == null) {
                                if (NetCircuitHealOperator.dbgOn()) {
                                    NetCircuitHealOperator.debug("processAddNe: No DWDM reverse link for " + iNetElement.getName());
                                }
                                throw new MissingLinks("No DWDM reverseLink link!");
                            }
                            linkedList2.add(object2);
                        }
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                    iterator.remove();
                    continue;
                }
                if (!(object3 instanceof OscNetLink) && !(object3 instanceof OchTrailTunnelNetLink)) continue;
                iterator.remove();
            }
            iterator = linkedList.iterator();
            object3 = new LinkedList();
            while (iterator.hasNext()) {
                object2 = this.net.findReverseLink((INetLink)iterator.next());
                if (object2 == null) {
                    if (NetCircuitHealOperator.dbgOn()) {
                        NetCircuitHealOperator.debug("processAddNe: No reverse link for " + iNetElement.getName());
                    }
                    throw new MissingLinks("No reverse link!");
                }
                ((LinkedList)object3).add(object2);
            }
            object2 = ((LinkedList)object3).listIterator(0);
            n = this.findSpliceLinkMatching(false, (ListIterator)object2, (LinkedList)object3, iNetElement, observer, n, ((LinkedList)object3).size());
            object = linkedList2.listIterator();
            n = this.findSpliceLinkMatching(true, (ListIterator)object, linkedList2, iNetElement, observer, n, linkedList2.size());
        }
        this.dispose();
        return n;
    }

    private int findSpliceLinkMatching(boolean bl, ListIterator listIterator, LinkedList linkedList, INetElement iNetElement, Observer observer, int n, float f) throws AnnotatedException {
        int n2 = 0;
        while (listIterator.hasNext()) {
            ListIterator listIterator2;
            try {
                listIterator2 = linkedList.listIterator(n2 + 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!NetCircuitHealOperator.dbgOn()) break;
                NetCircuitHealOperator.debug("addNodeToNetwork: Done processing");
                break;
            }
            INetLink iNetLink = (INetLink)listIterator.next();
            while (listIterator2.hasNext()) {
                INetLink iNetLink2 = (INetLink)listIterator2.next();
                if (bl) {
                    this.lookingForSpliceDwdmConnForMatchedListeners(iNetLink, iNetLink2);
                    continue;
                }
                n += this.spliceConnForMatchedListeners(iNetElement, iNetLink, iNetLink2);
            }
            if (!bl && observer != null) {
                float f2 = (float)n2 / f * 100.0f;
                observer.update(null, new Integer((int)Math.floor(f2)));
            }
            ++n2;
        }
        if (bl) {
            this.searchWavelengthToSkip();
            n += this.spliceUniDirectionalDwdmConnForMatchedListeners(iNetElement, observer, f -= (float)this.wavelengthNotFixed.size());
            n += this.spliceBiDirectionalDwdmConnForMatchedListeners(iNetElement, observer, f);
        }
        if (observer != null) {
            observer.update(null, new Integer(100));
        }
        return n;
    }

    private void searchWavelengthToSkip() {
        int n;
        Iterator<Integer> iterator;
        ListIterator listIterator = this.uniDirSplicingInfo.listIterator();
        while (listIterator.hasNext()) {
            iterator = (SplicingInfo)listIterator.next();
            if (((SplicingInfo)((Object)iterator)).isCTCCircuit) continue;
            int n2 = 0;
            if (this.uniWavelengthToSkipMap.containsKey(((SplicingInfo)((Object)iterator)).optChannel)) {
                n2 = this.uniWavelengthToSkipMap.get(((SplicingInfo)((Object)iterator)).optChannel);
            }
            this.uniWavelengthToSkipMap.put(((SplicingInfo)((Object)iterator)).optChannel, ++n2);
        }
        for (Integer n3 : this.uniWavelengthToSkipMap.keySet()) {
            if (this.uniWavelengthToSkipMap.get(n3) != 1) continue;
            this.uniWavelengthToSkipMap.remove(n3);
        }
        listIterator = this.biDirAToBSplicingInfo.listIterator();
        while (listIterator.hasNext()) {
            SplicingInfo splicingInfo = (SplicingInfo)listIterator.next();
            if (splicingInfo.isCTCCircuit) continue;
            n = 0;
            if (this.bidiWavelengthToSkipMap.containsKey(splicingInfo.optChannel)) {
                n = this.bidiWavelengthToSkipMap.get(splicingInfo.optChannel);
            }
            this.bidiWavelengthToSkipMap.put(splicingInfo.optChannel, ++n);
        }
        for (Integer n4 : this.bidiWavelengthToSkipMap.keySet()) {
            if (this.bidiWavelengthToSkipMap.get(n4) != 1) continue;
            this.bidiWavelengthToSkipMap.remove(n4);
        }
        listIterator = this.biDirBToASplicingInfo.listIterator();
        while (listIterator.hasNext()) {
            SplicingInfo splicingInfo = (SplicingInfo)listIterator.next();
            if (splicingInfo.isCTCCircuit) continue;
            n = 0;
            if (this.bidiWavelengthToSkipMap.containsKey(splicingInfo.optChannel)) {
                n = this.bidiWavelengthToSkipMap.get(splicingInfo.optChannel);
            }
            this.bidiWavelengthToSkipMap.put(splicingInfo.optChannel, ++n);
        }
        for (Integer n5 : this.bidiWavelengthToSkipMap.keySet()) {
            if (this.bidiWavelengthToSkipMap.get(n5) != 1) continue;
            this.bidiWavelengthToSkipMap.remove(n5);
        }
        if (this.uniWavelengthToSkipMap.size() > 0 || this.bidiWavelengthToSkipMap.size() > 0) {
            iterator = this.uniWavelengthToSkipMap.keySet().iterator();
            while (iterator.hasNext()) {
                this.wavelengthNotFixed.add(Wavelength.getWlAttribute(iterator.next()).getKey());
            }
            for (Integer n6 : this.bidiWavelengthToSkipMap.keySet()) {
                if (this.uniWavelengthToSkipMap.containsKey(n6)) continue;
                this.wavelengthNotFixed.add(Wavelength.getWlAttribute(n6).getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int spliceUniDirectionalDwdmConnForMatchedListeners(INetElement iNetElement, Observer observer, float f) {
        int n = 0;
        if (this.uniDirSplicingInfo.size() > 0) {
            if (NetCircuitHealOperator.dbgOn()) {
                db.println(this.uniDirSplicingInfo.size() + " uni-directional dwdm circuts found, direction from A to B or from B to A");
            }
            for (int i = 0; i < this.uniDirSplicingInfo.size(); ++i) {
                SplicingInfo splicingInfo = this.uniDirSplicingInfo.get(i);
                if (splicingInfo != null) {
                    if (this.uniWavelengthToSkipMap.containsKey(splicingInfo.optChannel)) continue;
                    if (NetCircuitHealOperator.dbgOn()) {
                        db.println("Updating dwdm circut, optical channel is " + splicingInfo.optChannel);
                    }
                    NetCcatCircuit netCcatCircuit = (NetCcatCircuit)splicingInfo.origSpliceListener.node.getCircuit();
                    NetCcatCircuit netCcatCircuit2 = (NetCcatCircuit)splicingInfo.termSpliceListener.node.getCircuit();
                    NetCcatCircuit netCcatCircuit3 = netCcatCircuit;
                    synchronized (netCcatCircuit3) {
                        if (!netCcatCircuit.isCircuitRefValid()) {
                            if (NetCircuitHealOperator.dbgOn()) {
                                NetCircuitHealOperator.debug("spliceNode: circuit got destroyed unexpectedly");
                            }
                            continue;
                        }
                        try {
                            this.addNeForAddNode(netCcatCircuit, iNetElement);
                        }
                        catch (IncorrectCircuitState incorrectCircuitState) {
                            if (NetCircuitHealOperator.dbgOn()) {
                                NetCircuitHealOperator.debug("spliceNode: Cannot add NodeImpl. unexpected");
                            }
                            continue;
                        }
                        NetCircuitNode netCircuitNode = null;
                        List list = netCcatCircuit.getCircuitNodeFromNE(iNetElement);
                        if (list != null) {
                            if (list.size() > 1) {
                                if (NetCircuitHealOperator.dbgOn()) {
                                    NetCircuitHealOperator.debug("spliceNode: Error !! This will result in MXPN");
                                }
                                break;
                            }
                            netCircuitNode = (NetCircuitNode)list.get(0);
                        }
                        if (netCircuitNode == null) {
                            if (NetCircuitHealOperator.dbgOn()) {
                                NetCircuitHealOperator.debug("spliceNode: added node disappeared!");
                            }
                            continue;
                        }
                        NetLinkSpan netLinkSpan = new NetLinkSpan(splicingInfo.sourceLink, null);
                        NetCircuitSpan netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan((NetCcatCircuit)splicingInfo.origSpliceListener.node.getCircuit(), netLinkSpan, splicingInfo.origSpliceListener.node, netCircuitNode);
                        netCircuitSpan.setSrcState(4);
                        netCircuitSpan.setDstState(2);
                        if (NetCircuitHealOperator.dbgOn()) {
                            NetCircuitHealOperator.debug("NetCircuitSpan: A -> ne: " + netCircuitSpan.prettyString());
                        }
                        NetLinkSpan netLinkSpan2 = new NetLinkSpan(splicingInfo.termLink, null);
                        NetCircuitSpan netCircuitSpan2 = NetCircuitSpanFactory.createCircuitSpan((NetCcatCircuit)splicingInfo.termSpliceListener.node.getCircuit(), netLinkSpan2, netCircuitNode, splicingInfo.termSpliceListener.node);
                        netCircuitSpan2.setSrcState(2);
                        netCircuitSpan2.setDstState(4);
                        if (NetCircuitHealOperator.dbgOn()) {
                            NetCircuitHealOperator.debug("NetCircuitSpan: ne -> T: " + netCircuitSpan2.prettyString());
                        }
                        netCircuitNode.addRoutedSpan(netCircuitSpan, eSpanDirection.TERMINATING);
                        netCircuitNode.addRoutedSpan(netCircuitSpan2, eSpanDirection.ORIGINATING);
                        try {
                            netCircuitNode.activate();
                        }
                        catch (CircuitProvError circuitProvError) {
                            if (NetCircuitHealOperator.dbgOn()) {
                                NetCircuitHealOperator.debug("spliceNode:Unable to activate cktnode");
                            }
                            netCcatCircuit.removeCktNode(netCircuitNode);
                            continue;
                        }
                        netCircuitNode.tentative2Active();
                        if (NetCircuitHealOperator.dbgOn()) {
                            NetCircuitHealOperator.debug("spliceUnidiNode: A->Z ORIGINATING addActiveSpan: " + netCircuitSpan.prettyString() + "to node: " + splicingInfo.origSpliceListener.node.getName());
                            NetCircuitHealOperator.debug("spliceUnidiNode: Z->B TERMINATING addActiveSpan: " + netCircuitSpan2.prettyString() + "to node: " + splicingInfo.termSpliceListener.node.getName());
                        }
                        splicingInfo.origSpliceListener.node.addActiveSpan(netCircuitSpan, eSpanDirection.ORIGINATING);
                        splicingInfo.termSpliceListener.node.addActiveSpan(netCircuitSpan2, eSpanDirection.TERMINATING);
                        if (NetCircuitHealOperator.dbgOn()) {
                            NetCircuitHealOperator.debug("spliceNodeListeners: check circuit's completeness");
                        }
                        boolean bl = netCcatCircuit == netCcatCircuit2 ? (!netCcatCircuit.circuitInfoActive() ? netCcatCircuit.tl1CircuitCompleteCheck() : netCcatCircuit.completeCheck()) : netCcatCircuit.unify(netCcatCircuit2);
                        if (!bl) {
                            if (NetCircuitHealOperator.dbgOn()) {
                                NetCircuitHealOperator.debug("spliceNode: Circuit failure!");
                            }
                            continue;
                        }
                        splicingInfo.origTree.remove(splicingInfo.origSpliceListener);
                        splicingInfo.origSpliceListener.node.removeSpliceListener(new SpliceListenerEntry(splicingInfo.sourceIndex, splicingInfo.origSpliceListener));
                        splicingInfo.termTree.remove(splicingInfo.termSpliceListener);
                        splicingInfo.termSpliceListener.node.removeSpliceListener(new SpliceListenerEntry(splicingInfo.termIndex, splicingInfo.termSpliceListener));
                        ++n;
                        netCcatCircuit.notifyChanged();
                    }
                    if (netCcatCircuit != netCcatCircuit2) {
                        netCcatCircuit2.notifyDeleted();
                    }
                }
                if (observer == null) continue;
                float f2 = (float)i / f * 100.0f;
                observer.update(null, new Integer((int)Math.floor(f2)));
            }
            if (NetCircuitHealOperator.dbgOn()) {
                db.println("Updating dwdm circuits end.");
            }
        } else if (NetCircuitHealOperator.dbgOn()) {
            db.println("Dwdm links not found to add node to any circuits.");
        }
        if (observer != null) {
            float f3 = (float)this.uniDirSplicingInfo.size() / f * 100.0f;
            observer.update(null, new Integer((int)Math.floor(f3)));
        }
        this.uniDirSplicingInfo.clear();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int spliceBiDirectionalDwdmConnForMatchedListeners(INetElement iNetElement, Observer observer, float f) {
        int n = 0;
        float f2 = this.uniDirSplicingInfo.size();
        if (this.biDirAToBSplicingInfo.size() > 0) {
            String string;
            SplicingInfo splicingInfo;
            int n2;
            if (NetCircuitHealOperator.dbgOn()) {
                db.println(this.biDirAToBSplicingInfo.size() + " bi-directional dwdm circuts found, direction from A to B");
                db.println(this.biDirBToASplicingInfo.size() + " bi-directional dwdm circuts found, direction from B to A");
            }
            HashMap<String, SplicingInfo> hashMap = new HashMap<String, SplicingInfo>();
            for (n2 = 0; n2 < this.biDirAToBSplicingInfo.size(); ++n2) {
                splicingInfo = this.biDirAToBSplicingInfo.get(n2);
                if (this.bidiWavelengthToSkipMap.containsKey(splicingInfo.optChannel)) continue;
                string = splicingInfo.optChannel + "_" + splicingInfo.origSpliceListener.node.getCircuit().getCircuitId();
                hashMap.put(string, splicingInfo);
            }
            for (n2 = 0; n2 < this.biDirBToASplicingInfo.size(); ++n2) {
                float f3;
                splicingInfo = this.biDirBToASplicingInfo.get(n2);
                string = splicingInfo.optChannel + "_" + splicingInfo.origSpliceListener.node.getCircuit().getCircuitId();
                SplicingInfo splicingInfo2 = (SplicingInfo)hashMap.get(string);
                if (splicingInfo2 == null) continue;
                if (NetCircuitHealOperator.dbgOn()) {
                    db.println("Updating dwdm circut, optical channel is " + splicingInfo2.optChannel);
                }
                NetCcatCircuit netCcatCircuit = (NetCcatCircuit)splicingInfo.origSpliceListener.node.getCircuit();
                NetCcatCircuit netCcatCircuit2 = (NetCcatCircuit)splicingInfo2.origSpliceListener.node.getCircuit();
                if (netCcatCircuit.getCircuitId().equals(netCcatCircuit2.getCircuitId())) {
                    if (netCcatCircuit.getCircuitTypeObj().isOchccCircuitType()) {
                        if (observer != null) {
                            f3 = ((float)n2 + f2) / f * 100.0f;
                            observer.update(null, new Integer((int)Math.floor(f3)));
                        }
                        if (!NetCircuitHealOperator.dbgOn()) continue;
                        db.println("Ochcc dwdm circut, updating stopped ");
                        continue;
                    }
                    NetCcatCircuit netCcatCircuit3 = netCcatCircuit;
                    synchronized (netCcatCircuit3) {
                        if (!netCcatCircuit.isCircuitRefValid() || !netCcatCircuit2.isCircuitRefValid()) {
                            if (NetCircuitHealOperator.dbgOn()) {
                                NetCircuitHealOperator.debug("spliceNode: circuit got destroyed unexpectedly");
                            }
                            continue;
                        }
                        try {
                            this.addNeForAddNode(netCcatCircuit, iNetElement);
                        }
                        catch (IncorrectCircuitState incorrectCircuitState) {
                            if (NetCircuitHealOperator.dbgOn()) {
                                NetCircuitHealOperator.debug("spliceNode: Cannot add NodeImpl. unexpected");
                            }
                            continue;
                        }
                        NetCircuitNode netCircuitNode = null;
                        List list = netCcatCircuit.getCircuitNodeFromNE(iNetElement);
                        if (list != null) {
                            if (list.size() > 1) {
                                if (NetCircuitHealOperator.dbgOn()) {
                                    NetCircuitHealOperator.debug("spliceNode: Error !! This will result in MXPN");
                                }
                                break;
                            }
                            netCircuitNode = (NetCircuitNode)list.get(0);
                        }
                        if (netCircuitNode == null) {
                            if (NetCircuitHealOperator.dbgOn()) {
                                NetCircuitHealOperator.debug("spliceNode: added node disappeared!");
                            }
                            continue;
                        }
                        NetLinkSpan netLinkSpan = new NetLinkSpan(splicingInfo2.sourceLink, null);
                        NetCircuitSpan netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan((NetCcatCircuit)splicingInfo2.origSpliceListener.node.getCircuit(), netLinkSpan, splicingInfo2.origSpliceListener.node, netCircuitNode);
                        netCircuitSpan.setSrcState(4);
                        netCircuitSpan.setDstState(2);
                        if (NetCircuitHealOperator.dbgOn()) {
                            NetCircuitHealOperator.debug("NetCircuitSpan: A -> ne: " + netCircuitSpan.prettyString());
                        }
                        NetLinkSpan netLinkSpan2 = new NetLinkSpan(splicingInfo2.termLink, null);
                        NetCircuitSpan netCircuitSpan2 = NetCircuitSpanFactory.createCircuitSpan((NetCcatCircuit)splicingInfo2.termSpliceListener.node.getCircuit(), netLinkSpan2, netCircuitNode, splicingInfo2.termSpliceListener.node);
                        netCircuitSpan2.setSrcState(2);
                        netCircuitSpan2.setDstState(4);
                        if (NetCircuitHealOperator.dbgOn()) {
                            NetCircuitHealOperator.debug("NetCircuitSpan: ne -> B: " + netCircuitSpan2.prettyString());
                        }
                        NetLinkSpan netLinkSpan3 = new NetLinkSpan(splicingInfo.sourceLink, null);
                        NetCircuitSpan netCircuitSpan3 = NetCircuitSpanFactory.createCircuitSpan((NetCcatCircuit)splicingInfo.origSpliceListener.node.getCircuit(), netLinkSpan3, splicingInfo.origSpliceListener.node, netCircuitNode);
                        netCircuitSpan3.setSrcState(4);
                        netCircuitSpan3.setDstState(2);
                        NetLinkSpan netLinkSpan4 = new NetLinkSpan(splicingInfo.termLink, null);
                        NetCircuitSpan netCircuitSpan4 = NetCircuitSpanFactory.createCircuitSpan((NetCcatCircuit)splicingInfo.termSpliceListener.node.getCircuit(), netLinkSpan4, netCircuitNode, splicingInfo.termSpliceListener.node);
                        netCircuitSpan4.setSrcState(2);
                        netCircuitSpan4.setDstState(4);
                        netCircuitNode.addRoutedSpan(netCircuitSpan, eSpanDirection.TERMINATING);
                        netCircuitNode.addRoutedSpan(netCircuitSpan2, eSpanDirection.ORIGINATING);
                        netCircuitNode.addRoutedSpan(netCircuitSpan3, eSpanDirection.TERMINATING);
                        netCircuitNode.addRoutedSpan(netCircuitSpan4, eSpanDirection.ORIGINATING);
                        try {
                            netCircuitNode.activate();
                        }
                        catch (CircuitProvError circuitProvError) {
                            if (NetCircuitHealOperator.dbgOn()) {
                                NetCircuitHealOperator.debug("spliceNode:Unable to activate cktnode");
                            }
                            netCcatCircuit.removeCktNode(netCircuitNode);
                            continue;
                        }
                        netCircuitNode.tentative2Active();
                        if (NetCircuitHealOperator.dbgOn()) {
                            NetCircuitHealOperator.debug("spliceBidiDwdmNode: A->Z ORIGINATING addActiveSpan: " + netCircuitSpan.prettyString() + "to node: " + splicingInfo2.origSpliceListener.node.getName());
                            NetCircuitHealOperator.debug("spliceBidiDwdmNode: Z->B TERMINATING addActiveSpan: " + netCircuitSpan2.prettyString() + "to node: " + splicingInfo2.termSpliceListener.node.getName());
                            NetCircuitHealOperator.debug("spliceBidiDwdmNode: B->Z ORIGINATING addActiveSpan: " + netCircuitSpan.prettyString() + "to node: " + splicingInfo2.origSpliceListener.node.getName());
                            NetCircuitHealOperator.debug("spliceBidiDwdmNode: Z->A TERMINATING addActiveSpan: " + netCircuitSpan2.prettyString() + "to node: " + splicingInfo2.termSpliceListener.node.getName());
                        }
                        splicingInfo2.origSpliceListener.node.addActiveSpan(netCircuitSpan, eSpanDirection.ORIGINATING);
                        splicingInfo2.termSpliceListener.node.addActiveSpan(netCircuitSpan2, eSpanDirection.TERMINATING);
                        splicingInfo.origSpliceListener.node.addActiveSpan(netCircuitSpan3, eSpanDirection.ORIGINATING);
                        splicingInfo.termSpliceListener.node.addActiveSpan(netCircuitSpan4, eSpanDirection.TERMINATING);
                        if (NetCircuitHealOperator.dbgOn()) {
                            NetCircuitHealOperator.debug("spliceNodeListeners: check circuit's completeness");
                        }
                        boolean bl = netCcatCircuit == netCcatCircuit2 ? (!netCcatCircuit.circuitInfoActive() ? netCcatCircuit.tl1CircuitCompleteCheck() : netCcatCircuit.completeCheck()) : netCcatCircuit.unify(netCcatCircuit2);
                        if (!bl) {
                            if (NetCircuitHealOperator.dbgOn()) {
                                NetCircuitHealOperator.debug("spliceNode: Circuit failure!");
                            }
                            continue;
                        }
                        splicingInfo2.origTree.remove(splicingInfo2.origSpliceListener);
                        splicingInfo2.origSpliceListener.node.removeSpliceListener(new SpliceListenerEntry(splicingInfo2.sourceIndex, splicingInfo2.origSpliceListener));
                        splicingInfo2.termTree.remove(splicingInfo2.termSpliceListener);
                        splicingInfo2.termSpliceListener.node.removeSpliceListener(new SpliceListenerEntry(splicingInfo2.termIndex, splicingInfo2.termSpliceListener));
                        splicingInfo.origTree.remove(splicingInfo.origSpliceListener);
                        splicingInfo.origSpliceListener.node.removeSpliceListener(new SpliceListenerEntry(splicingInfo.sourceIndex, splicingInfo.origSpliceListener));
                        splicingInfo.termTree.remove(splicingInfo.termSpliceListener);
                        splicingInfo.termSpliceListener.node.removeSpliceListener(new SpliceListenerEntry(splicingInfo.termIndex, splicingInfo.termSpliceListener));
                        ++n;
                        netCcatCircuit.notifyChanged();
                    }
                }
                if (netCcatCircuit != netCcatCircuit2) {
                    netCcatCircuit2.notifyDeleted();
                }
                if (observer == null) continue;
                f3 = ((float)n2 + f2) / f * 100.0f;
                observer.update(null, new Integer((int)Math.floor(f3)));
            }
            if (NetCircuitHealOperator.dbgOn()) {
                db.println("Updating dwdm circuits end.");
            }
        } else if (NetCircuitHealOperator.dbgOn()) {
            db.println("Dwdm links not found to add node to any circuits.");
        }
        this.biDirAToBSplicingInfo.clear();
        this.biDirBToASplicingInfo.clear();
        return n;
    }

    public int addNeToOnePlusOne(INetElement iNetElement, IEntityModel iEntityModel, IEntityModel iEntityModel2, INetElement iNetElement2, IEntityModel iEntityModel3, INetElement iNetElement3, IEntityModel iEntityModel4, Observer observer) throws MissingLinks, AnnotatedException {
        return this.addNeToOnePlusOne(iNetElement, iEntityModel.getEntityIndex(), iEntityModel2.getEntityIndex(), iNetElement2, iEntityModel3.getEntityIndex(), iNetElement3, iEntityModel4.getEntityIndex(), observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addNeToOnePlusOne(INetElement iNetElement, int n, int n2, INetElement iNetElement2, int n3, INetElement iNetElement3, int n4, Observer observer) throws MissingLinks, AnnotatedException {
        Object object;
        INetLink iNetLink;
        INetLink iNetLink2;
        if (this.net == null) {
            this.net = Network.instance();
            if (this.net == null) {
                NetCircuitHealOperator.debug("addNeToOnePlusOne failed: Couldn't get network object");
                return 0;
            }
        }
        int n5 = 0;
        if (NetCircuitHealOperator.dbgOn()) {
            NetCircuitHealOperator.debug("addNeToOnePlusOne(C=" + iNetElement.getName() + " CtoA=" + Integer.toHexString(n) + " CtoB=" + Integer.toHexString(n2) + " A=" + iNetElement2.getName() + " AtoC=" + Integer.toHexString(n3) + " B=" + iNetElement3.getName() + " BtoC=" + Integer.toHexString(n4));
        }
        if (this.ncMgr == null) {
            this.ncMgr = NetCircuitManager.instance();
            if (this.ncMgr == null) {
                NetCircuitHealOperator.debug("addNeToRing failed: Couldn't get NetCircuitManager object");
                return 0;
            }
        }
        if ((iNetLink2 = this.net.findNetLink(iNetElement2, n3, null, iNetElement3, n4, null, true, 1)) == null) {
            if (NetCircuitHealOperator.dbgOn()) {
                NetCircuitHealOperator.debug("addNeToOnePlusOne: No A-->B link found");
            }
            throw new MissingLinks("Missing link from " + iNetElement2.getName() + " to " + iNetElement3.getName());
        }
        if (NetCircuitHealOperator.dbgOn()) {
            NetCircuitHealOperator.debug("addNeToOnePlusOne: link A-->B = " + iNetLink2.prettyString());
        }
        if ((iNetLink = this.net.findReverseLink(iNetLink2)) == null) {
            if (NetCircuitHealOperator.dbgOn()) {
                NetCircuitHealOperator.debug("addNeToOnePlusOne: No A<--B link found");
            }
            throw new MissingLinks("No reverse link");
        }
        if (NetCircuitHealOperator.dbgOn()) {
            NetCircuitHealOperator.debug("addNeToOnePlusOne: link A<--B = " + iNetLink.prettyString());
        }
        for (NetCircuit netCircuit : this.ncMgr.getCircuits()) {
            if (netCircuit instanceof NetVcatCircuit) {
                object = (NetVcatCircuit)netCircuit;
                for (CmsObservable cmsObservable : ((NetVcatCircuit)object).getAllMemberCircuits()) {
                    this.updateDeleted((NetCircuit)cmsObservable, iNetLink2, iNetLink);
                }
                continue;
            }
            this.updateDeleted(netCircuit, iNetLink2, iNetLink);
        }
        object = this.splicer;
        synchronized (object) {
            CmsObservable cmsObservable;
            this.splicer.synchronizeSpliceListeners();
            this.splicer.synchronizeCallbackLinks();
            NetLink netLink = this.createLocalNetLink(iNetLink2, iNetElement2, n3, iNetElement, n);
            cmsObservable = this.createLocalNetLink(iNetLink2, iNetElement, n, iNetElement2, n3);
            if (NetCircuitHealOperator.dbgOn()) {
                NetCircuitHealOperator.debug("addNeToOnePlusOne: Created temp link A-->C");
                NetCircuitHealOperator.debug("  " + netLink.prettyString());
            }
            NetLink netLink2 = this.createLocalNetLink(iNetLink2, iNetElement3, n4, iNetElement, n2);
            NetLink netLink3 = this.createLocalNetLink(iNetLink2, iNetElement, n2, iNetElement3, n4);
            if (NetCircuitHealOperator.dbgOn()) {
                NetCircuitHealOperator.debug("addNeToOnePlusOne: Created temp link B-->C");
                NetCircuitHealOperator.debug("  " + netLink2.prettyString());
            }
            n5 = this.spliceConnForMatchedListeners(iNetElement, netLink, (INetLink)((Object)cmsObservable), netLink2, netLink3);
            netLink.dispose();
            ((NetLink)cmsObservable).dispose();
            netLink2.dispose();
            netLink3.dispose();
            if (NetCircuitHealOperator.dbgOn()) {
                NetCircuitHealOperator.debug("addNeToOnePlusOne: updated " + n5 + " circuits");
            }
        }
        this.dispose();
        return n5;
    }

    private void updateDeleted(NetCircuit netCircuit, INetLink iNetLink, INetLink iNetLink2) {
        INetCircuitSpan iNetCircuitSpan = netCircuit.getCircuitSpanFromNetLink(iNetLink);
        if (iNetCircuitSpan == null) {
            iNetCircuitSpan = netCircuit.getCircuitSpanFromNetLink(iNetLink2);
        }
        if (iNetCircuitSpan != null) {
            ((NetCircuitSpan)iNetCircuitSpan).updateDeleted();
        }
    }

    protected void updateBlsrDriNodeType(NetCircuitNode netCircuitNode) {
        if (netCircuitNode.connections.size() > 2 || NetCircuitNodeUtil.isBlsrDriType(netCircuitNode.getDriNodeType())) {
            return;
        }
        Connection connection2 = null;
        for (Connection connection2 : netCircuitNode.connections) {
            if (connection2.isOneway()) continue;
            return;
        }
        NetCircuitSpan netCircuitSpan = connection2.inPuts.get(0) instanceof NetCircuitSpan ? (NetCircuitSpan)connection2.inPuts.get(0) : null;
        NetCircuitSpan netCircuitSpan2 = connection2.outPuts.get(0) instanceof NetCircuitSpan ? (NetCircuitSpan)connection2.outPuts.get(0) : null;
        NetCircuitNode netCircuitNode2 = netCircuitNode.spanGetPeer(netCircuitSpan2);
        NetCircuitNode netCircuitNode3 = netCircuitNode.spanGetPeer(netCircuitSpan);
        if (netCircuitNode3 == null || netCircuitNode2 == null) {
            return;
        }
        if (NetCircuitNodeUtil.isBlsrDriType(netCircuitNode3.getDriNodeType()) && NetCircuitNodeUtil.isBlsrDriType(netCircuitNode2.getDriNodeType()) && netCircuitSpan.getLink().inBLSR() && netCircuitSpan2.getLink().inBLSR()) {
            netCircuitNode.driNodeType = 3;
            if (NetCircuitHealOperator.dbgOn()) {
                db.println("updateBlsrDriNodeType: updated " + netCircuitNode.getName() + " driNodeType to " + EnumStrings.getString(IDriNodeType.class, (int)netCircuitNode.driNodeType));
            }
        }
    }

    private NetLink createLocalNetLink(INetLink iNetLink, INetElement iNetElement, int n, INetElement iNetElement2, int n2) {
        ILinkModel iLinkModel = iNetLink.getLinkModel();
        INodeModel iNodeModel = iNetElement.getNodeModel();
        INodeModel iNodeModel2 = iNetElement2.getNodeModel();
        LinkModel linkModel = new LinkModel(iNodeModel, n, null, iNodeModel2, n2, null, iLinkModel.linkType(), iLinkModel.physicalType(), iLinkModel.physicalLinkType(), true, true, -1, -1, iLinkModel.protectionType(), "", 0, iLinkModel.protectionGroup(), iLinkModel.protectionRole(), iLinkModel.cost(), 0, 0);
        NetLink netLink = (NetLink)NetLinkFactory.createNetLink(this.net, (ILinkModel)linkModel, iNetElement, iNetElement2, iNetElement.getTopology(), false, false);
        return netLink;
    }

    private int spliceConnForMatchedListeners(INetElement iNetElement, INetLink iNetLink, INetLink iNetLink2) throws AnnotatedException {
        INetLink iNetLink3 = this.net.findReverseLink(iNetLink);
        INetLink iNetLink4 = this.net.findReverseLink(iNetLink2);
        return this.spliceConnForMatchedListeners(iNetElement, iNetLink, iNetLink3, iNetLink2, iNetLink4);
    }

    private void lookingForSpliceDwdmConnForMatchedListeners(INetLink iNetLink, INetLink iNetLink2) throws AnnotatedException {
        NetCcatCircuit netCcatCircuit;
        long l;
        long l2;
        SplicingInfo splicingInfo;
        Iterator iterator;
        Object object;
        if (iNetLink.getDst().equals(iNetLink2.getDst())) {
            if (NetCircuitHealOperator.dbgOn()) {
                NetCircuitHealOperator.debug("spliceDwdmConnForMatchedListeners: skipping link pair (same dst)");
            }
            return;
        }
        boolean bl = false;
        Map map = this.splicer.getLinkEntries();
        if (NetCircuitHealOperator.dbgOn()) {
            NetCircuitHealOperator.debug("spliceConnForMatchedListeners: considering links: ");
            NetCircuitHealOperator.debug("  " + iNetLink.prettyString());
            NetCircuitHealOperator.debug("  " + iNetLink2.prettyString());
        }
        INetLink iNetLink3 = null;
        INetLink iNetLink4 = null;
        if (iNetLink instanceof VirtualNetLink) {
            object = (VirtualNetLink)iNetLink;
            iNetLink3 = this.net.findReverseLink((INetLink)object);
        } else {
            object = (DwdmNetLink)iNetLink;
            iNetLink3 = OchncFilterManager.findLinkForReversePath((INetLink)object, db);
        }
        iNetLink4 = iNetLink2;
        SpliceLinkIndex spliceLinkIndex = new SpliceLinkIndex(iNetLink3.getSrc(), iNetLink3.getSrcEntityIndex(), eSpanDirection.ORIGINATING);
        Map map2 = (Map)map.get(spliceLinkIndex);
        SpliceLinkIndex spliceLinkIndex2 = new SpliceLinkIndex(iNetLink4.getDst(), iNetLink4.getDstEntityIndex(), eSpanDirection.TERMINATING);
        Map map3 = (Map)map.get(spliceLinkIndex2);
        if (map2 != null && map3 != null) {
            object = new SplicingInfo();
            ((SplicingInfo)object).sourceLink = iNetLink3;
            ((SplicingInfo)object).termLink = iNetLink4;
            ((SplicingInfo)object).origTree = map2;
            ((SplicingInfo)object).sourceIndex = spliceLinkIndex;
            ((SplicingInfo)object).termTree = map3;
            ((SplicingInfo)object).termIndex = spliceLinkIndex2;
            ((SplicingInfo)object).circuitIdMatchListener = this.findCktIdMatchedListeners(map2, map3);
            iterator = ((SplicingInfo)object).circuitIdMatchListener.iterator();
            while (iterator.hasNext()) {
                splicingInfo = ((SplicingInfo)object).clone();
                splicingInfo.origSpliceListener = (SpliceListener)iterator.next();
                splicingInfo.termSpliceListener = (SpliceListener)iterator.next();
                splicingInfo.optChannel = splicingInfo.origSpliceListener.optChannel;
                l2 = splicingInfo.origSpliceListener.node.getCircuit().getCircuitId().longValue();
                l = splicingInfo.termSpliceListener.node.getCircuit().getCircuitId().longValue();
                splicingInfo.isCTCCircuit = l2 != 0L && l != 0L;
                netCcatCircuit = (NetCcatCircuit)splicingInfo.origSpliceListener.node.getCircuit();
                if (netCcatCircuit.isBidirectional()) {
                    this.biDirAToBSplicingInfo.add(splicingInfo);
                    continue;
                }
                this.uniDirSplicingInfo.add(splicingInfo);
            }
        }
        if (iNetLink2 instanceof VirtualNetLink) {
            object = (VirtualNetLink)iNetLink2;
            iNetLink4 = this.net.findReverseLink((INetLink)object);
        } else {
            object = (DwdmNetLink)iNetLink2;
            iNetLink4 = OchncFilterManager.findLinkForReversePath((INetLink)object, db);
        }
        iNetLink3 = iNetLink;
        spliceLinkIndex = new SpliceLinkIndex(iNetLink4.getSrc(), iNetLink4.getSrcEntityIndex(), eSpanDirection.ORIGINATING);
        map2 = (Map)map.get(spliceLinkIndex);
        spliceLinkIndex2 = new SpliceLinkIndex(iNetLink3.getDst(), iNetLink3.getDstEntityIndex(), eSpanDirection.TERMINATING);
        map3 = (Map)map.get(spliceLinkIndex2);
        if (map2 != null && map3 != null) {
            object = new SplicingInfo();
            ((SplicingInfo)object).sourceLink = iNetLink4;
            ((SplicingInfo)object).termLink = iNetLink3;
            ((SplicingInfo)object).origTree = map2;
            ((SplicingInfo)object).sourceIndex = spliceLinkIndex;
            ((SplicingInfo)object).termTree = map3;
            ((SplicingInfo)object).termIndex = spliceLinkIndex2;
            ((SplicingInfo)object).circuitIdMatchListener = this.findCktIdMatchedListeners(map2, map3);
            iterator = ((SplicingInfo)object).circuitIdMatchListener.iterator();
            while (iterator.hasNext()) {
                splicingInfo = ((SplicingInfo)object).clone();
                splicingInfo.origSpliceListener = (SpliceListener)iterator.next();
                splicingInfo.termSpliceListener = (SpliceListener)iterator.next();
                splicingInfo.optChannel = splicingInfo.origSpliceListener.optChannel;
                l2 = splicingInfo.origSpliceListener.node.getCircuit().getCircuitId().longValue();
                l = splicingInfo.termSpliceListener.node.getCircuit().getCircuitId().longValue();
                splicingInfo.isCTCCircuit = l2 != 0L && l != 0L;
                netCcatCircuit = (NetCcatCircuit)splicingInfo.origSpliceListener.node.getCircuit();
                if (netCcatCircuit.isBidirectional()) {
                    this.biDirBToASplicingInfo.add(splicingInfo);
                    continue;
                }
                this.uniDirSplicingInfo.add(splicingInfo);
            }
        }
    }

    private int spliceConnForMatchedListeners(INetElement iNetElement, INetLink iNetLink, INetLink iNetLink2, INetLink iNetLink3, INetLink iNetLink4) throws AnnotatedException {
        int n = 0;
        LinkedList linkedList = new LinkedList();
        if (NetCircuitHealOperator.dbgOn()) {
            NetCircuitHealOperator.debug("spliceConnForMatchedListeners: considering links: ");
            NetCircuitHealOperator.debug("  " + iNetLink.prettyString());
            NetCircuitHealOperator.debug("  " + iNetLink3.prettyString());
        }
        if (iNetLink.getSrc().equals(iNetLink3.getSrc())) {
            if (NetCircuitHealOperator.dbgOn()) {
                NetCircuitHealOperator.debug("spliceConnForMatchedListeners: skipping link pair (same src)");
            }
            return 0;
        }
        Map map = this.splicer.getLinkEntries();
        SpliceLinkIndex spliceLinkIndex = new SpliceLinkIndex(iNetLink.getSrc(), iNetLink.getSrcEntityIndex(), eSpanDirection.ORIGINATING);
        Map map2 = (Map)map.get(spliceLinkIndex);
        SpliceLinkIndex spliceLinkIndex2 = new SpliceLinkIndex(iNetLink3.getSrc(), iNetLink3.getSrcEntityIndex(), eSpanDirection.TERMINATING);
        Map map3 = (Map)map.get(spliceLinkIndex2);
        SpliceLinkIndex spliceLinkIndex3 = new SpliceLinkIndex(iNetLink.getSrc(), iNetLink.getSrcEntityIndex(), eSpanDirection.BIDIRECTIONAL);
        Map map4 = (Map)map.get(spliceLinkIndex3);
        SpliceLinkIndex spliceLinkIndex4 = new SpliceLinkIndex(iNetLink3.getSrc(), iNetLink3.getSrcEntityIndex(), eSpanDirection.BIDIRECTIONAL);
        Map map5 = (Map)map.get(spliceLinkIndex4);
        if (map2 != null && map3 != null) {
            linkedList.addAll(this.findCktIdMatchedListeners(map2, map3));
            n += this.spliceNode(iNetElement, iNetLink, iNetLink2, iNetLink3, iNetLink4, eSpanDirection.ORIGINATING, eSpanDirection.TERMINATING, map2, map3, spliceLinkIndex, spliceLinkIndex2, linkedList);
        }
        linkedList.clear();
        if (map4 != null && map5 != null) {
            linkedList.addAll(this.findCktIdMatchedListeners(map4, map5));
            n += this.spliceNode(iNetElement, iNetLink, iNetLink2, iNetLink3, iNetLink4, eSpanDirection.BIDIRECTIONAL, eSpanDirection.BIDIRECTIONAL, map4, map5, spliceLinkIndex3, spliceLinkIndex4, linkedList);
        }
        linkedList.clear();
        if (map2 != null && map5 != null) {
            linkedList.addAll(this.findCktIdMatchedListeners(map2, map5));
            n += this.spliceNode(iNetElement, iNetLink, iNetLink2, iNetLink3, iNetLink4, eSpanDirection.ORIGINATING, eSpanDirection.BIDIRECTIONAL, map2, map5, spliceLinkIndex, spliceLinkIndex4, linkedList);
        }
        spliceLinkIndex = new SpliceLinkIndex(iNetLink3.getSrc(), iNetLink3.getSrcEntityIndex(), eSpanDirection.ORIGINATING);
        map2 = (Map)map.get(spliceLinkIndex);
        spliceLinkIndex2 = new SpliceLinkIndex(iNetLink.getSrc(), iNetLink.getSrcEntityIndex(), eSpanDirection.TERMINATING);
        map3 = (Map)map.get(spliceLinkIndex2);
        spliceLinkIndex3 = new SpliceLinkIndex(iNetLink3.getSrc(), iNetLink3.getSrcEntityIndex(), eSpanDirection.BIDIRECTIONAL);
        map4 = (Map)map.get(spliceLinkIndex3);
        spliceLinkIndex4 = new SpliceLinkIndex(iNetLink.getSrc(), iNetLink.getSrcEntityIndex(), eSpanDirection.BIDIRECTIONAL);
        map5 = (Map)map.get(spliceLinkIndex4);
        linkedList.clear();
        if (map2 != null && map3 != null) {
            linkedList.addAll(this.findCktIdMatchedListeners(map2, map3));
            n += this.spliceNode(iNetElement, iNetLink3, iNetLink4, iNetLink, iNetLink2, eSpanDirection.ORIGINATING, eSpanDirection.TERMINATING, map2, map3, spliceLinkIndex, spliceLinkIndex2, linkedList);
        }
        linkedList.clear();
        if (map2 != null && map5 != null) {
            linkedList.addAll(this.findCktIdMatchedListeners(map2, map5));
            n += this.spliceNode(iNetElement, iNetLink3, iNetLink4, iNetLink, iNetLink2, eSpanDirection.ORIGINATING, eSpanDirection.BIDIRECTIONAL, map2, map5, spliceLinkIndex, spliceLinkIndex4, linkedList);
        }
        return n;
    }

    private LinkedList findCktIdMatchedListeners(Map map, Map map2) {
        if (map == null || map2 == null) {
            return null;
        }
        Iterator iterator = map.values().iterator();
        LinkedList<SpliceListener> linkedList = new LinkedList<SpliceListener>();
        TreeMap treeMap = this.createTreeMapWithListenerComparator();
        while (iterator.hasNext()) {
            SpliceListener spliceListener;
            treeMap.clear();
            SpliceListener spliceListener2 = (SpliceListener)iterator.next();
            SpliceListener spliceListener3 = new SpliceListener(spliceListener2.hoNum, spliceListener2.loNum, 0, null, false);
            while ((spliceListener = (SpliceListener)this.findNextMatch(map2, treeMap, spliceListener3)) != null && !this.spliceCheck(spliceListener2, spliceListener, false)) {
                treeMap.put(spliceListener, spliceListener);
            }
            if (spliceListener == null) continue;
            if (NetCircuitHealOperator.dbgOn()) {
                NetCircuitHealOperator.debug("findCktIdMatchedListeners: matched " + spliceListener2.prettyString());
            }
            linkedList.add(spliceListener2);
            linkedList.add(spliceListener);
        }
        return linkedList;
    }

    private int spliceNode(INetElement iNetElement, INetLink iNetLink, INetLink iNetLink2, INetLink iNetLink3, INetLink iNetLink4, eSpanDirection eSpanDirection2, eSpanDirection eSpanDirection3, Map map, Map map2, SpliceLinkIndex spliceLinkIndex, SpliceLinkIndex spliceLinkIndex2, LinkedList linkedList) throws AnnotatedException {
        SpliceListener spliceListener;
        SpliceListener spliceListener2;
        int n = 0;
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            spliceListener2 = (SpliceListener)iterator.next();
            spliceListener = (SpliceListener)iterator.next();
            if (spliceListener2.loNum != null || !this.spliceNodeListeners(iNetElement, spliceListener2, spliceListener, iNetLink, iNetLink2, iNetLink3, iNetLink4, eSpanDirection2, eSpanDirection3, map, map2, spliceLinkIndex, spliceLinkIndex2)) continue;
            ++n;
        }
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            spliceListener2 = (SpliceListener)iterator.next();
            spliceListener = (SpliceListener)iterator.next();
            if (spliceListener2.loNum == null || !this.spliceNodeListeners(iNetElement, spliceListener2, spliceListener, iNetLink, iNetLink2, iNetLink3, iNetLink4, eSpanDirection2, eSpanDirection3, map, map2, spliceLinkIndex, spliceLinkIndex2)) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean spliceNodeListeners(INetElement iNetElement, SpliceListener spliceListener, SpliceListener spliceListener2, INetLink iNetLink, INetLink iNetLink2, INetLink iNetLink3, INetLink iNetLink4, eSpanDirection eSpanDirection2, eSpanDirection eSpanDirection3, Map map, Map map2, SpliceLinkIndex spliceLinkIndex, SpliceLinkIndex spliceLinkIndex2) throws AnnotatedException {
        Object object;
        Object object2;
        boolean bl;
        NetCircuitNode netCircuitNode = null;
        ICircuitId iCircuitId = spliceListener.node.getCircuit().getCircuitId();
        if (!iCircuitId.equals(spliceListener2.node.getCircuit().getCircuitId())) {
            if (NetCircuitHealOperator.dbgOn()) {
                NetCircuitHealOperator.debug("spliceNode: Circuit Id mismatch unexpected");
            }
            return false;
        }
        if (!iNetLink.isValidSrcHoNumber(spliceListener.hoNum) || !iNetLink3.isValidSrcHoNumber(spliceListener2.hoNum)) {
            if (NetCircuitHealOperator.dbgOn()) {
                NetCircuitHealOperator.debug("spliceNode: link does not support listener HO");
            }
            return false;
        }
        if (spliceListener.loNum != null) {
            boolean bl2 = false;
            bl = false;
            object2 = this.net.findNetLink(iNetLink.getSrc(), spliceLinkIndex.entityIndex, spliceListener.hoNum, iNetLink3.getSrc(), spliceLinkIndex2.entityIndex, spliceListener2.hoNum, false, 2);
            if (object2 != null) {
                bl2 = object2.getLinkType() == 2;
            }
            object = this.net.findNetLink(iNetLink3.getSrc(), spliceLinkIndex2.entityIndex, spliceListener2.hoNum, iNetLink.getSrc(), spliceLinkIndex.entityIndex, spliceListener.hoNum, false, 2);
            if (object2 != null) {
                boolean bl3 = bl = object.getLinkType() == 2;
            }
            if (bl2 && bl) {
                if (NetCircuitHealOperator.dbgOn()) {
                    NetCircuitHealOperator.debug("spliceNode: Found existing LOT");
                }
                return true;
            }
            if (!iNetElement.loXCon()) {
                return this.createLoTunnelForSpliceNode(iNetElement, spliceListener, spliceListener2, iNetLink, iNetLink3, iNetLink2, iNetLink4);
            }
        }
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)spliceListener.node.getCircuit();
        NetCcatCircuit netCcatCircuit2 = (NetCcatCircuit)spliceListener2.node.getCircuit();
        object2 = netCcatCircuit;
        synchronized (object2) {
            object = netCcatCircuit2;
            synchronized (object) {
                NetCircuitSpan netCircuitSpan;
                NetCircuitSpan netCircuitSpan2;
                if (!netCcatCircuit.isCircuitRefValid() || !netCcatCircuit2.isCircuitRefValid()) {
                    if (NetCircuitHealOperator.dbgOn()) {
                        NetCircuitHealOperator.debug("spliceNode: circuit got destroyed unexpectedly");
                    }
                    return false;
                }
                try {
                    this.addNeForAddNode(netCcatCircuit, iNetElement);
                }
                catch (IncorrectCircuitState incorrectCircuitState) {
                    if (NetCircuitHealOperator.dbgOn()) {
                        NetCircuitHealOperator.debug("spliceNode: Cannot add NodeImpl. unexpected");
                    }
                    return false;
                }
                List list = netCcatCircuit.getCircuitNodeFromNE(iNetElement);
                if (list != null) {
                    if (list.size() > 1) {
                        if (NetCircuitHealOperator.dbgOn()) {
                            NetCircuitHealOperator.debug("spliceNode: Error !! This will result in MXPN");
                        }
                        return false;
                    }
                    netCircuitNode = (NetCircuitNode)list.get(0);
                }
                if (netCircuitNode == null) {
                    if (NetCircuitHealOperator.dbgOn()) {
                        NetCircuitHealOperator.debug("spliceNode: added node disappeared!");
                    }
                    return false;
                }
                if (eSpanDirection2 != eSpanDirection.TERMINATING) {
                    NetLinkSpan netLinkSpan = new NetLinkSpan(iNetLink, iNetLink2, spliceListener.hoNum, spliceListener.hoNum, spliceListener.loNum);
                    netCircuitSpan2 = NetCircuitSpanFactory.createCircuitSpan((NetCcatCircuit)spliceListener.node.getCircuit(), netLinkSpan, spliceListener.node, netCircuitNode);
                    netCircuitSpan2.setSrcState(4);
                    netCircuitSpan2.setDstState(2);
                } else {
                    NetLinkSpan netLinkSpan = new NetLinkSpan(iNetLink2, iNetLink, spliceListener.hoNum, spliceListener.hoNum, spliceListener.loNum);
                    netCircuitSpan2 = NetCircuitSpanFactory.createCircuitSpan((NetCcatCircuit)spliceListener.node.getCircuit(), netLinkSpan, netCircuitNode, spliceListener.node);
                    netCircuitSpan2.setSrcState(2);
                    netCircuitSpan2.setDstState(4);
                }
                if (eSpanDirection3 == eSpanDirection.ORIGINATING) {
                    NetLinkSpan netLinkSpan = new NetLinkSpan(iNetLink3, iNetLink4, spliceListener2.hoNum, spliceListener2.hoNum, spliceListener2.loNum);
                    netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan((NetCcatCircuit)spliceListener2.node.getCircuit(), netLinkSpan, spliceListener2.node, netCircuitNode);
                    netCircuitSpan.setSrcState(4);
                    netCircuitSpan.setDstState(2);
                } else {
                    NetLinkSpan netLinkSpan = new NetLinkSpan(iNetLink4, iNetLink3, spliceListener2.hoNum, spliceListener2.hoNum, spliceListener2.loNum);
                    netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan((NetCcatCircuit)spliceListener2.node.getCircuit(), netLinkSpan, netCircuitNode, spliceListener2.node);
                    netCircuitSpan.setSrcState(2);
                    netCircuitSpan.setDstState(4);
                }
                eSpanDirection eSpanDirection4 = eSpanDirection2 == eSpanDirection.BIDIRECTIONAL ? eSpanDirection.BIDIRECTIONAL : eSpanDirection3;
                netCircuitNode.addRoutedSpan(netCircuitSpan2, eSpanDirection4);
                eSpanDirection4 = eSpanDirection3 == eSpanDirection.BIDIRECTIONAL ? eSpanDirection.BIDIRECTIONAL : eSpanDirection2;
                netCircuitNode.addRoutedSpan(netCircuitSpan, eSpanDirection4);
                netCircuitNode.setupConnListOnCreation(netCircuitNode.findConnType());
                this.updateBlsrDriNodeType(netCircuitNode);
                try {
                    netCircuitNode.activate();
                }
                catch (CircuitProvError circuitProvError) {
                    if (NetCircuitHealOperator.dbgOn()) {
                        NetCircuitHealOperator.debug("spliceNode:Unable to activate cktnode");
                    }
                    netCcatCircuit.removeCktNode(netCircuitNode);
                    return false;
                }
                netCircuitNode.tentative2Active();
                spliceListener.node.addActiveSpan(netCircuitSpan2, eSpanDirection2);
                spliceListener2.node.addActiveSpan(netCircuitSpan, eSpanDirection3);
                if (NetCircuitHealOperator.dbgOn()) {
                    NetCircuitHealOperator.debug("spliceNodeListeners: check circuit's completeness");
                }
                bl = netCcatCircuit == netCcatCircuit2 ? (!netCcatCircuit.circuitInfoActive() ? netCcatCircuit.tl1CircuitCompleteCheck() : netCcatCircuit.completeCheck()) : netCcatCircuit.unify(netCcatCircuit2);
                if (!bl) {
                    if (NetCircuitHealOperator.dbgOn()) {
                        NetCircuitHealOperator.debug("spliceNode: Circuit failure!");
                    }
                    return false;
                }
                if (NetCircuitHealOperator.dbgOn()) {
                    NetCircuitHealOperator.debug("spliceNode: Added circuit" + NetCcatCircuit.prettyString(iCircuitId));
                }
                map.remove(spliceListener);
                spliceListener.node.removeSpliceListener(new SpliceListenerEntry(spliceLinkIndex, spliceListener));
                map2.remove(spliceListener2);
                spliceListener2.node.removeSpliceListener(new SpliceListenerEntry(spliceLinkIndex2, spliceListener2));
            }
        }
        netCcatCircuit.notifyChanged();
        if (netCcatCircuit != netCcatCircuit2) {
            netCcatCircuit2.notifyDeleted();
        }
        return true;
    }

    private void addNeForAddNode(NetCcatCircuit netCcatCircuit, INetElement iNetElement) throws IncorrectCircuitState {
        NetCircuitNode netCircuitNode = null;
        int n = netCcatCircuit.getState();
        if (NetCircuitHealOperator.dbgOn()) {
            db.println("Adding a Network Element to circuit");
        }
        if (n != 4 && n != 5 && n != 6) {
            throw new IncorrectCircuitState("Invalid circuit state for addition of new node");
        }
        List list = netCcatCircuit.getCircuitNodeFromNE(iNetElement);
        if (list != null) {
            netCircuitNode = (NetCircuitNode)list.get(0);
        }
        if (netCircuitNode == null) {
            netCircuitNode = NetCircuitNodeFactory.newNodeForAddSpan(iNetElement, netCcatCircuit);
            if (netCircuitNode.getAdminState() == 4) {
                netCircuitNode.setAdminState(2);
            }
        } else {
            throw new IncorrectCircuitState("Circuit node already in circuit");
        }
        netCcatCircuit.insertCktNode(netCircuitNode);
    }

    private boolean createLoTunnelForSpliceNode(INetElement iNetElement, SpliceListener spliceListener, SpliceListener spliceListener2, INetLink iNetLink, INetLink iNetLink2, INetLink iNetLink3, INetLink iNetLink4) throws AnnotatedException {
        int n;
        boolean bl = false;
        NetCcatCircuit netCcatCircuit = null;
        try {
            n = spliceListener.hoNum.getFramingType();
            IFramingType iFramingType = FramingType.getFramingType((int)n);
            int n2 = iFramingType.getTunnelCircuitType();
            int n3 = iFramingType.getLoTunnelSize();
            CircuitCreatInfo circuitCreatInfo = new CircuitCreatInfo(n2, n3, 1);
            netCcatCircuit = (NetCcatCircuit)NetCircuitFactory.newCircuit(circuitCreatInfo, spliceListener.node.getNetElement());
            if (netCcatCircuit == null) {
                bl = true;
            } else {
                netCcatCircuit.addNetElement(spliceListener2.node.getNetElement(), new RoutePrefs());
                netCcatCircuit.addCircuitSpan(new NetLinkSpan(iNetLink, iNetLink3, (ILabel)spliceListener.hoNum, (ILabel)spliceListener.hoNum));
                netCcatCircuit.addCircuitSpan(new NetLinkSpan(iNetLink4, iNetLink2, (ILabel)spliceListener2.hoNum, (ILabel)spliceListener2.hoNum));
                netCcatCircuit.sanityCheck();
            }
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            bl = true;
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
            bl = true;
        }
        catch (NoRoute noRoute) {
            bl = true;
        }
        if (bl) {
            if (NetCircuitHealOperator.dbgOn()) {
                NetCircuitHealOperator.debug("createLoTunnelForSpliceNode: LOT creation failed!");
            }
            if (netCcatCircuit != null) {
                this.destroyCktCatchExceptions(netCcatCircuit);
            }
            return false;
        }
        netCcatCircuit.lotReuseLoAdits(true);
        n = 0;
        try {
            netCcatCircuit.provision();
        }
        catch (NoRoute noRoute) {
            n = 1;
        }
        catch (ConnTypeUnsupported connTypeUnsupported) {
            n = 1;
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            n = 1;
        }
        catch (CircuitProvError circuitProvError) {
            n = 1;
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            n = 1;
        }
        if (n != 0) {
            if (NetCircuitHealOperator.dbgOn()) {
                NetCircuitHealOperator.debug("createLoTunnelForSpliceNode: LOT creation failed!");
            }
            this.destroyCktCatchExceptions(netCcatCircuit);
            return false;
        }
        netCcatCircuit.lotReuseLoAdits(false);
        if (NetCircuitHealOperator.dbgOn()) {
            NetCircuitHealOperator.debug("createLoTunnelForSpliceNode: LOT created successfully");
        }
        return true;
    }

    private boolean destroyCktCatchExceptions(NetCcatCircuit netCcatCircuit) {
        boolean bl = false;
        try {
            netCcatCircuit.destroyCircuit();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            bl = true;
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
            bl = true;
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            bl = true;
        }
        catch (DeletionError deletionError) {
            bl = true;
        }
        if (bl && NetCircuitHealOperator.dbgOn()) {
            NetCircuitHealOperator.debug("Circuit destroy failure due to exception");
        }
        return bl;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public ArrayList<String> getWavelengthNotFixed() {
        return this.wavelengthNotFixed;
    }

    class SplicingInfo {
        int optChannel;
        boolean isCTCCircuit;
        INetLink sourceLink;
        INetLink termLink;
        SpliceLinkIndex sourceIndex;
        SpliceLinkIndex termIndex;
        Map origTree;
        Map termTree;
        LinkedList circuitIdMatchListener;
        SpliceListener origSpliceListener;
        SpliceListener termSpliceListener;

        SplicingInfo() {
        }

        public SplicingInfo clone() {
            SplicingInfo splicingInfo = new SplicingInfo();
            splicingInfo.sourceLink = this.sourceLink;
            splicingInfo.termLink = this.termLink;
            splicingInfo.sourceIndex = this.sourceIndex;
            splicingInfo.termIndex = this.termIndex;
            splicingInfo.origTree = this.origTree;
            splicingInfo.termTree = this.termTree;
            splicingInfo.circuitIdMatchListener = this.circuitIdMatchListener;
            return splicingInfo;
        }

        public boolean equals(Object object) {
            return object == this;
        }
    }
}

