/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConnectionHasFarendLoopback;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionInTopologyUpgrade;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.Feature;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.HoUpsrAttributes;
import cerent.cms.model.IAdminState;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnectionConversionModel;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.IDriNodeType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.IHoUpsrAttributes;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchccConnectionModel;
import cerent.cms.model.IOchncConnectionModel;
import cerent.cms.model.IPathDefModel;
import cerent.cms.model.IRollModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.ISvlanConnectionModel;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidState;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NoSuchDefault;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.TestAccessActive;
import cerent.cms.model.VcatMemberInvalidState;
import cerent.cms.model.VcatMemberNotOutOfGroup;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.BridgeConnection;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.Connection;
import cerent.cms.ncp.ConnectionPathNotFound;
import cerent.cms.ncp.ConnectionValidator;
import cerent.cms.ncp.ConnectionsFactory;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.EtherNodeDropCircuitEnd;
import cerent.cms.ncp.HoCcatCircuit;
import cerent.cms.ncp.HoCircuitEnd;
import cerent.cms.ncp.HoCircuitNode;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitProvState;
import cerent.cms.ncp.IUpsrOps;
import cerent.cms.ncp.IUpsrSpanState;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.LoCcatCircuit;
import cerent.cms.ncp.LoCircuitEnd;
import cerent.cms.ncp.LoCircuitNode;
import cerent.cms.ncp.LoYCircuitNode;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNodeOperator;
import cerent.cms.ncp.NetCircuitNodeUtil;
import cerent.cms.ncp.NetCircuitRollOperator;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSplicer;
import cerent.cms.ncp.NetCircuitWatchDog;
import cerent.cms.ncp.NetUpsrOps;
import cerent.cms.ncp.NodeRoutingDirection;
import cerent.cms.ncp.OchTrailTunnelNode;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ncp.OchncCircuitNode;
import cerent.cms.ncp.OnewayConnection;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.SelectorConnection;
import cerent.cms.ncp.SpliceLinkIndex;
import cerent.cms.ncp.SpliceListener;
import cerent.cms.ncp.SpliceListenerEntry;
import cerent.cms.ncp.TL1ObjectManager;
import cerent.cms.ncp.UpdateEventCollector;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.util.EnumStrings;
import cerent.util.HoLoComparator;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class NetCircuitNode
extends CmsObservable
implements INetCircuitNode,
IObserver {
    private static final SDebug db = new SDebug("NetCircuitNode");
    protected INetElement ne;
    private INodeModel node;
    protected NetCcatCircuit circuit;
    protected LinkedList spliceListeners;
    protected LinkedList sources;
    protected LinkedList drops;
    protected NetCircuitEnd nodeDrop;
    private boolean isNodeRefValid;
    protected LinkedList inSpans;
    protected LinkedList outSpans;
    protected LinkedList biSpans;
    public int yState;
    private List workingEntities;
    private List protectEntities;
    private List activeEntities;
    protected IUpsrOps upsrOps = null;
    protected int protectionOp = -1;
    protected int reverseProtectionOp = -1;
    protected List connections = null;
    protected Object entitiesLockObject;
    protected int state;
    protected int connType;
    protected String connName;
    protected ICircuitId cktId;
    protected int numberOfPaths;
    private boolean registeredNullCircuitConnection;
    private List connectionPathEnds;
    private boolean currConversionStatus = false;
    private boolean loopFlag = false;
    private boolean dri = false;
    protected int adminState;
    protected int serviceState;
    protected short pathWidth;
    protected NodeRoutingDirection nodeRoutingDir;
    protected NetCircuitNodeUtil nodeUtil;
    protected int driNodeType = 0;
    protected boolean currRollStatus = false;
    protected boolean rollHasCompleted = false;
    protected static final String node_disconnected = "Node is disconnected ";
    protected static final String connection_missing = "Connection is missing ";
    protected static final String pre_odin = "Full state model is not supported on this node ";
    protected static final String node_rejection = "Node does not allow this state transition; check for loopbacks, test access, state range ";
    protected boolean allowUpsrOver1Plus1 = false;
    private UpdateEvent updateEvent;

    public NetCircuitNode(INetElement iNetElement) {
        if (this.dbgOn()) {
            db.println("Creating " + this.getClass().getName() + " at " + iNetElement.getName());
        }
        this.ne = iNetElement;
        this.node = this.ne.getNodeModel();
        this.spliceListeners = new LinkedList();
        this.drops = new LinkedList();
        this.sources = new LinkedList();
        this.nodeDrop = null;
        this.inSpans = new LinkedList();
        this.outSpans = new LinkedList();
        this.biSpans = new LinkedList();
        this.connType = 22;
        this.setConn(null);
        this.entitiesLockObject = new Object();
        this.workingEntities = null;
        this.protectEntities = null;
        this.activeEntities = null;
        this.isNodeRefValid = true;
        this.updateEvent = new UpdateEvent();
        this.initState(0);
        this.numberOfPaths = 0;
        this.registeredNullCircuitConnection = false;
        this.connections = new LinkedList();
        this.connectionPathEnds = new LinkedList();
        this.nodeRoutingDir = new NodeRoutingDirection(this);
        this.nodeUtil = new NetCircuitNodeUtil(this);
        this.setUpsrOver1Plus1Flag();
    }

    public NetCircuitNode(INetElement iNetElement, NetCcatCircuit netCcatCircuit) {
        this(iNetElement);
        this.setCircuit(netCcatCircuit);
        if (netCcatCircuit.getAdminState() != 0 && !iNetElement.getNodeModel().provides(Feature.ENHANCED_STATE_MODEL)) {
            db.info("PreOdin node" + this.getName() + " does not support admin state provisioning");
        }
        this.setAdminState(netCcatCircuit.getAdminState());
    }

    public NetCircuitNode(INetElement iNetElement, NetCcatCircuit netCcatCircuit, Object object) throws AbstractCmsObjectNotExistException {
        this(iNetElement, netCcatCircuit);
        this.setConnection(object);
        this.cktId = this.getConnectionCircuitId();
        if (object != null && NetCircuit.isNullCircuitId(this.cktId)) {
            this.registerNullCircuitConnection(iNetElement, object);
        }
        this.setAdminState(this.getAdminStateFromNE());
        this.setServiceState(this.getServiceStateFromNE());
        this.currRollStatus = this.inRoll();
    }

    protected void setUpsrOver1Plus1Flag() {
        try {
            String string = this.node.getDefaultValue("NODE.circuits.upsr.AllowUpsrOverOnePlusOne");
            this.allowUpsrOver1Plus1 = string.equalsIgnoreCase("true");
            if (this.dbgOn()) {
                this.debug("setUpsrOver1Plus1Flag to " + string + " " + this.allowUpsrOver1Plus1 + " at Node " + this.node.getName());
            }
            db.fine("Setting AllowUpsrOverOnePlusOne to " + string + " at Node " + this.node.getName());
        }
        catch (NoSuchDefault noSuchDefault) {
            if (this.dbgOn()) {
                this.debug("setUpsrOver1Plus1Flag not supported on " + this.node.getName());
            }
            db.severe("NODE.circuits.upsr.AllowUpsrOverOnePlusOne not supported on " + this.node.getName());
        }
    }

    public boolean isUpsrOver1Plus1Enabled() {
        return this.allowUpsrOver1Plus1;
    }

    public boolean isUpsrOverOnePluOne() {
        if (this.isUpsrOver1Plus1Enabled()) {
            ConnectionValidator connectionValidator = ConnectionValidator.instance();
            if (this.sources.size() > 1) {
                return connectionValidator.validateUpsrOverOnePlusOne(this.sources);
            }
            if (this.drops.size() > 1) {
                return connectionValidator.validateUpsrOverOnePlusOne(this.drops);
            }
        }
        return false;
    }

    private boolean checkListenerOnSamePort(NetCircuitEnd netCircuitEnd) {
        if (this.dbgOn()) {
            this.debug("Checking for sameSpan listener for cktEnd " + this.getName());
        }
        if (!this.isUpsrOver1Plus1Enabled()) {
            if (this.dbgOn()) {
                this.debug(" UPSRover1Plus1 is not Enabled on this node. ");
            }
            return false;
        }
        if (this.dbgOn()) {
            this.debug("UPSR:1+1 Node: #sources= " + this.sources.size() + " #drops= " + this.drops.size() + " #paths= " + this.numberOfPaths);
        }
        for (SpliceListenerEntry spliceListenerEntry : this.spliceListeners) {
            NetCircuitEnd netCircuitEnd2 = this.getSpliceListenerEndpoint(spliceListenerEntry);
            if (netCircuitEnd2.getNodeId() != netCircuitEnd.getNodeId() || netCircuitEnd2.getEntityIndex() != netCircuitEnd.getEntityIndex()) continue;
            this.deleteSpliceListener(spliceListenerEntry);
            return true;
        }
        return false;
    }

    protected void setConnection(Object object) {
        if (this.getState() != 0) {
            return;
        }
        this.setConn((IConnectionModel)object);
        this.addConnectionObserver();
        try {
            this.sanityCheckConnModel();
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            this.deleteConnectionObserver();
            throw abstractCmsObjectNotExistException;
        }
        this.conformToConnection();
        this.updateConnectionPathEnds();
        this.initState(2);
        this.initYState();
    }

    protected void conformToConnection() {
        this.conformToConnection(NetCircuitSplicer.instance());
    }

    protected void conformToConnection(NetCircuitSplicer netCircuitSplicer) {
        if (this.dbgOn()) {
            this.debug("conformToConnection() at " + this.getName());
        }
        this.disposeSpans();
        this.cleanupSpliceListeners();
        this.drops = new LinkedList();
        this.sources = new LinkedList();
        this.setCircuitInfoNodeDrop();
        this.setConnectionType(this.getConnTypeFromConnModel());
        this.conformToPaths(this.getPathsFromConnModel(), netCircuitSplicer);
        this.setupConnListOnDiscovery();
    }

    protected void conformToPaths(Object[] objectArray, NetCircuitSplicer netCircuitSplicer) {
        if (objectArray == null) {
            return;
        }
        this.numberOfPaths = objectArray.length;
        Iterator<Object> iterator = Arrays.asList(objectArray).iterator();
        if (this.dbgOn()) {
            db.println("conformToPaths: " + this.getName() + " connType: " + EnumStrings.getString(IConnectionType.class, (int)this.connType) + " no. of paths:" + this.numberOfPaths);
        }
        this.nodeRoutingDir.setNodeRoutingDirToForward();
        if (this.isBidirectionalConnType()) {
            if (this.connType == 1 || this.connType == 18) {
                if (this.numberOfPaths == 2) {
                    Object object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                } else if (this.dbgOn()) {
                    db.println("conformToPath: invalid TWOWAY");
                }
            } else if (this.connType == 2) {
                if (this.numberOfPaths == 3) {
                    Object object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                } else if (this.dbgOn()) {
                    db.println("conformToPath: invalid UPSR");
                }
            } else if (this.connType == 3) {
                if (this.numberOfPaths == 4) {
                    Object object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                } else if (this.dbgOn()) {
                    db.println("conformToPath: invalid UPSR_UPSR");
                }
            } else if (this.connType == 12) {
                if (this.numberOfPaths == 4) {
                    Object object = iterator.next();
                    this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                } else if (this.dbgOn()) {
                    db.println("conformToPath: invalid OCHNC_TWOWAY");
                }
            } else if (this.connType == 8) {
                eSpanDirection eSpanDirection2 = eSpanDirection.TERMINATING;
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection2, netCircuitSplicer);
                    eSpanDirection2 = NodeRoutingDirection.getOppositeRoutingDir(eSpanDirection2);
                }
            } else if (this.connType == 21) {
                if (this.numberOfPaths >= 1) {
                    Object object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                    }
                }
            } else if (this.connType == 10) {
                if (this.numberOfPaths == 3) {
                    Object object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.BIDIRECTIONAL, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                } else if (this.dbgOn()) {
                    db.println("conformToPath: invalid no. of paths " + this.numberOfPaths + " for UPSR_DRI");
                }
            } else if (this.connType == 11) {
                if (this.numberOfPaths == 4) {
                    Object object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.BIDIRECTIONAL, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.BIDIRECTIONAL, netCircuitSplicer);
                } else if (this.dbgOn()) {
                    db.println("conformToPath: invalid no. of paths " + this.numberOfPaths + " for UPSR_IDRI");
                }
            } else if (this.connType == 13) {
                if (this.numberOfPaths == 4) {
                    Object object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                } else if (this.dbgOn()) {
                    db.println("conformToPath: invalid no. of paths " + this.numberOfPaths + " for BLSR_IDRI");
                }
            } else if (this.connType == 14) {
                if (this.numberOfPaths == 4) {
                    Object object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.BIDIRECTIONAL, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                } else if (this.dbgOn()) {
                    db.println("conformToPath: invalid no. of paths " + this.numberOfPaths + " for UPSR_BLSR_IDRI");
                }
            } else if (this.connType == 20) {
                if (this.numberOfPaths == 6) {
                    Object object = iterator.next();
                    this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                } else if (this.dbgOn()) {
                    db.println("conformToPath: invalid OCHNC_TWOWAY_SPLITTER");
                }
            } else if (this.dbgOn()) {
                db.println("conformToPath: Unsupported BIDIRECTIONAL connType");
            }
            return;
        }
        if (this.connType == 0 || this.connType == 9) {
            if (this.numberOfPaths >= 2) {
                Object object = iterator.next();
                this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, this.connType == 0 ? netCircuitSplicer : null);
                while (iterator.hasNext()) {
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                }
            } else if (this.dbgOn()) {
                db.println("conformToPath: invalid 1Way/Monitor connection");
            }
        } else if (this.connType == 4) {
            if (this.numberOfPaths >= 3) {
                Object object = iterator.next();
                this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
                while (iterator.hasNext()) {
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                }
            }
        } else if (this.connType == 17) {
            if (this.numberOfPaths >= 3) {
                Object object = iterator.next();
                this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.BIDIRECTIONAL, netCircuitSplicer);
                while (iterator.hasNext()) {
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                }
            } else if (this.dbgOn()) {
                db.println("conformToPath: invalid UPSR_HEAD_3");
            }
        } else if (this.connType == 6) {
            if (this.numberOfPaths >= 2) {
                Object object = iterator.next();
                this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                while (iterator.hasNext()) {
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                }
            } else if (this.dbgOn()) {
                db.println("conformToPath: invalid UPSR_DC");
            }
        } else if (this.connType == 5) {
            if (this.numberOfPaths >= 2) {
                Object object = iterator.next();
                this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
                while (iterator.hasNext()) {
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                }
            } else if (this.dbgOn()) {
                db.println("conformToPath: invalid UPSR_DROP");
            }
        } else if (this.connType == 7) {
            if (this.numberOfPaths >= 2) {
                Object object = iterator.next();
                this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                while (iterator.hasNext()) {
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                }
            } else if (this.dbgOn()) {
                db.println("conformToPath: invalid UPSR_EN");
            }
        } else if (this.connType == 15) {
            if (this.numberOfPaths >= 4) {
                Object object = iterator.next();
                this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
                while (iterator.hasNext()) {
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                }
            } else if (this.dbgOn()) {
                db.println("conformToPath: Invalid BLSR_DC");
            }
        } else if (this.connType == 16) {
            if (this.numberOfPaths >= 4) {
                Object object = iterator.next();
                this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.BIDIRECTIONAL, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
                while (iterator.hasNext()) {
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                }
            } else if (this.dbgOn()) {
                db.println("conformToPath: Invalid UPSR_BLSR_DC");
            }
        } else if (this.dbgOn()) {
            db.println("conformToPath: Unsupported UNIDIRECTIONAL connType");
        }
    }

    protected void integratePath(Object object, eSpanDirection eSpanDirection2, eSpanDirection eSpanDirection3, NetCircuitSplicer netCircuitSplicer) {
        NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), object);
        if (this.isCircuitInfoSourceOrDrop(netCircuitEnd)) {
            return;
        }
        if (netCircuitSplicer != null) {
            this.createSpliceListener(netCircuitSplicer, netCircuitEnd, eSpanDirection2);
        }
        if (!this.circuit.circuitInfoActive()) {
            this.assumeSourceOrDrop(eSpanDirection3, netCircuitEnd);
        }
    }

    protected IUpsrOps getUpsrOps(NetCircuitSpan netCircuitSpan) {
        return this.getUpsrOps();
    }

    public IUpsrOps getUpsrOps() {
        return this.upsrOps;
    }

    protected void setUpsrOps(IUpsrOps iUpsrOps) {
        this.upsrOps = iUpsrOps;
    }

    public List getUpsrOpsList() {
        LinkedList<IUpsrOps> linkedList = new LinkedList<IUpsrOps>();
        if (this.isUpsrSelector()) {
            linkedList.add(this.getUpsrOps());
        }
        return linkedList;
    }

    protected IHoUpsrAttributes getUpsrAttributes() throws ConnectionTypeError {
        IHoUpsrAttributes iHoUpsrAttributes = this.circuit.getUpsrAttributes();
        if (iHoUpsrAttributes == null) {
            IUpsrOps iUpsrOps = this.getUpsrOps();
            if (iUpsrOps == null) {
                return null;
            }
            iHoUpsrAttributes = new HoUpsrAttributes(iUpsrOps.getUpsrSfBerLevel(), iUpsrOps.getUpsrSdBerLevel(), iUpsrOps.getUpsrReversion(), iUpsrOps.getUpsrSwitchOnPdiP());
        }
        return iHoUpsrAttributes;
    }

    protected void setConnAdminState(int n) throws AdminStateProvisioningError {
        if (this.dbgOn()) {
            this.debug("setConnAdminState() called");
        }
        if (!this.ne.getNodeModel().provides(Feature.ENHANCED_STATE_MODEL) && n != 0) {
            db.info("PreOdin node" + this.getName() + " called for admin state " + NetCircuitNode.translateAdminState(n));
            throw new AdminStateProvisioningError("The node " + this.getName() + " does not support the circuit state " + NetCircuitNode.translateAdminState(n) + ". Use the circuit state " + NetCircuitNode.translateAdminState(0) + " instead.");
        }
        this.preCheckSetConnAdminState();
        if (this.getConn() != null) {
            try {
                this.getConn().setAdminState(n);
            }
            catch (ConnectionInLoopback connectionInLoopback) {
                SDebug.printStackTrace((Throwable)connectionInLoopback);
                throw new AdminStateProvisioningError(this.getName() + ": " + "One of the " + NetCircuitNode.getTDMTerminology(this.getNodeModel()).getGeneralTerms(0) + " is in XC Loopback.\n" + "The XC Loopback must be removed before the circuit state can be changed.");
            }
            catch (TestAccessActive testAccessActive) {
                SDebug.printStackTrace((Throwable)testAccessActive);
                throw new AdminStateProvisioningError(this.getName() + ": " + "One of the " + NetCircuitNode.getTDMTerminology(this.getNodeModel()).getGeneralTerms(0) + " is in test access.\n" + "The test access must be removed before the circuit state can be changed.");
            }
            catch (InvalidState invalidState) {
                SDebug.printStackTrace((Throwable)invalidState);
                throw new AdminStateProvisioningError(this.getName() + ": " + "The state transition is invalid.");
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                throw new AdminStateProvisioningError(this.getName() + ": " + exception.getMessage());
            }
        } else {
            throw new AdminStateProvisioningError("The connection object on " + this.getName() + " was null.");
        }
        this.setState(3);
    }

    protected boolean isConnPartofBlsrDri() {
        LinkedList linkedList = new LinkedList();
        NetCircuitSpan netCircuitSpan2 = null;
        switch (this.findConnType()) {
            case 10: {
                linkedList.addAll(this.getTermSpans());
                linkedList.addAll(this.getOrigSpans());
                for (NetCircuitSpan netCircuitSpan2 : linkedList) {
                    if (!netCircuitSpan2.getBlsrDriInterConnect()) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    protected String validateConnAdminState(int n) {
        try {
            if (this.state != 2) {
                throw new AdminStateProvisioningError("The circuit state on the node " + this.getName() + " cannot be changed because it is not DISCOVERED.");
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return node_disconnected;
        }
        if (!this.ne.getNodeModel().provides(Feature.ENHANCED_STATE_MODEL)) {
            if (this.getAdminState() == 0) {
                return null;
            }
            return pre_odin;
        }
        if (this.getConn() != null) {
            try {
                if (!this.getConn().validateNewAdminState(n)) {
                    return node_rejection;
                }
                return null;
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                return node_rejection;
            }
        }
        return connection_missing;
    }

    public void setConnName(String string) throws CircuitProvError {
        try {
            if (this.ne.getNodeModel().provides(Feature.TCCU) && this.getConn() != null) {
                db.info("TCCU : For CircuitName " + this.circuit.getCircuitName() + "Connection name : " + string + "being set at node " + this.getName());
                this.getConn().setConnectionName(string);
                this.connName = string;
            }
        }
        catch (InvalidCircuitName invalidCircuitName) {
            throw new CircuitProvError("The connection name is invalid.");
        }
    }

    public String getConnName() {
        if (this.isNodeDrop() && this.nodeDrop instanceof EtherNodeDropCircuitEnd) {
            return "";
        }
        return this.connName;
    }

    public ICircuitId getCircuitId() {
        return this.cktId;
    }

    public String getConnNameFromNE() {
        if (this.ne.getNodeModel().provides(Feature.TCCU) && this.getConn() != null) {
            try {
                String string = this.getConn().getConnectionName();
                db.info("TCCU : For CircuitName " + this.circuit.getCircuitName() + "Connection name is : " + string + " at node " + this.getName());
                return string;
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.dbgOn()) {
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
                return "";
            }
        }
        return "";
    }

    protected void revertAdminState() throws AdminStateProvisioningError {
        if (this.dbgOn()) {
            db.println("revertAdminState at " + this.getName());
        }
        if (this.getConn() != null) {
            try {
                this.getConn().setAdminState(this.getAdminState());
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                throw new AdminStateProvisioningError(this.getName() + ": " + exception.getMessage());
            }
        } else {
            throw new AdminStateProvisioningError("The connection object on " + this.getName() + " is null.");
        }
        this.setState(2);
    }

    protected void setCircuit(NetCcatCircuit netCcatCircuit) {
        this.circuit = netCcatCircuit;
        LinkedList linkedList = (LinkedList)this.inSpans.clone();
        linkedList.addAll((Collection)this.outSpans.clone());
        linkedList.addAll((Collection)this.biSpans.clone());
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            ((NetCircuitSpan)iterator.next()).setCircuit(netCcatCircuit);
        }
    }

    public int getDriNodeType() {
        return this.getState() == 0 ? this.driNodeType : this.getDriNodeTypeFromModelLayer();
    }

    void resetDriNodeType() {
        this.driNodeType = 0;
    }

    protected int getDriNodeTypeFromModelLayer() {
        if (this.ne.getNodeModel().provides(Feature.BLSR_UPSR_DRI) && this.getConn() instanceof IHoConnectionModel) {
            return ((IHoConnectionModel)this.getConn()).getDriNodeType();
        }
        return 0;
    }

    public String getName() {
        return this.ne.getName();
    }

    public String getNameAndClass() {
        return this.getName() + "(" + this.getClass().getName() + ")";
    }

    protected void preCheckSetConnAdminState() throws AdminStateProvisioningError {
        if (this.state != 2) {
            throw new AdminStateProvisioningError("The circuit state on the node " + this.getName() + " cannot be changed because it is not DISCOVERED.");
        }
    }

    protected boolean updateNumberOfPaths() {
        Object[] objectArray = this.getPathsFromConnModel();
        int n = objectArray.length;
        if (n != this.numberOfPaths) {
            if (this.dbgOn()) {
                db.println(" updateNumberOfPaths: " + this.numberOfPaths + " -> " + n);
            }
            this.numberOfPaths = n;
            return true;
        }
        return false;
    }

    protected abstract NetCircuitNodeOperator getOperator();

    protected abstract void sanityCheckConnModel();

    protected abstract int getConnTypeFromConnModel();

    protected void setConnTypeInConnModel(int n) throws ConnectionTypeError, ConnectionInTopologyUpgrade, ConnectionInLoopback, ConnectionInTestAccess, ConnectionInRoll {
    }

    protected void addOutputToConnModel(NetCircuitEnd netCircuitEnd) throws CTCUserException {
    }

    protected void addOutputToConnModel(NetCircuitSpan netCircuitSpan) throws CTCUserException {
    }

    protected void removeOutputFromConnModel(NetCircuitEnd netCircuitEnd) throws CTCUserException {
    }

    protected void removeOutputFromConnModel(NetCircuitSpan netCircuitSpan) throws CTCUserException {
    }

    protected abstract Object[] getPathsFromConnModel();

    protected Object[] getConnectionPathDefs() {
        return this.getPathsFromConnModel();
    }

    protected abstract Object[] getActivePathsFromConnModel();

    protected abstract int getProtectionOpFromConnModel();

    protected abstract int getReverseProtectionOpFromConnModel();

    protected IRollModel getRoll() {
        return null;
    }

    protected Object getRollFromPath(IRollModel iRollModel) {
        return null;
    }

    protected Object getRollToPath(IRollModel iRollModel) {
        return null;
    }

    public int getConnectionType() {
        return this.connType;
    }

    protected void setConnectionType(int n) {
        this.connType = n;
        if (this.dbgOn()) {
            db.println("setConnectionType(" + this.getName() + "): connType = " + EnumStrings.getString(IConnectionType.class, (int)this.connType));
        }
    }

    protected int getConnDir() {
        return NetCircuitNode.getConnDir(this.getConnectionType());
    }

    public static int getConnDir(int n) {
        if (n == 22) {
            return -1;
        }
        if (NetCircuitNodeUtil.isUnidirectionalConnType(n)) {
            return 0;
        }
        if (NetCircuitNodeUtil.isBidirectionalConnType(n)) {
            return 1;
        }
        return -1;
    }

    protected boolean isBidirectionalConnType() {
        return NetCircuitNodeUtil.isBidirectionalConnType(this.getConnectionType());
    }

    protected boolean isUnidirectionalConnType() {
        return NetCircuitNodeUtil.isUnidirectionalConnType(this.getConnectionType());
    }

    protected boolean is1wayUpsrConnType() {
        return this.nodeUtil.is1wayUpsrConnType(this.getConnectionType());
    }

    public boolean isOchTrailTunnelNode() {
        return false;
    }

    public boolean isOchccCircuitNode() {
        return false;
    }

    public boolean isOchncCircuitNode() {
        return false;
    }

    protected int getEntityIndexFromPathDef(Object object) {
        if (object instanceof IHoPathDefModel) {
            IHoPathDefModel iHoPathDefModel = (IHoPathDefModel)object;
            return iHoPathDefModel.getPool().getEntityIndex();
        }
        if (object instanceof ILoDefModel) {
            ILoDefModel iLoDefModel = (ILoDefModel)object;
            return NetCircuitNode.getEntityIndexFromLoDef(this.node, iLoDefModel);
        }
        return 0;
    }

    protected static int getEntityIndexFromLoDef(INodeModel iNodeModel, ILoDefModel iLoDefModel) {
        if (iNodeModel.provides(Feature.VCAT)) {
            return iLoDefModel.getPortIndex();
        }
        if (iLoDefModel.getLoAdit() != null) {
            return iLoDefModel.getLoAdit().getHo().getPool().getEntityIndex();
        }
        return 0;
    }

    protected IHoNum getHoNumFromPathDef(Object object) {
        if (object instanceof IHoPathDefModel) {
            IHoPathDefModel iHoPathDefModel = (IHoPathDefModel)object;
            return HoPathDefModel.physicalHo(iHoPathDefModel);
        }
        if (object instanceof ILoDefModel) {
            ILoDefModel iLoDefModel = (ILoDefModel)object;
            return HoPathDefModel.physicalHo(iLoDefModel.getLoAdit().getHo());
        }
        return null;
    }

    private ILoNum getLoNumFromPathDef(Object object) {
        if (object instanceof ILoDefModel) {
            ILoDefModel iLoDefModel = (ILoDefModel)object;
            return iLoDefModel.getLoNum();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getConnectionPathEnds() {
        LinkedList linkedList;
        List list = this.connectionPathEnds;
        synchronized (list) {
            linkedList = new LinkedList(this.connectionPathEnds);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetCircuitEnd getConnectionPathEnd(int n) {
        NetCircuitEnd netCircuitEnd;
        List list = this.connectionPathEnds;
        synchronized (list) {
            netCircuitEnd = (NetCircuitEnd)this.connectionPathEnds.get(n);
        }
        return netCircuitEnd;
    }

    protected List getPathEndsFromPathDefs(Object[] objectArray) {
        LinkedList<NetCircuitEnd> linkedList = new LinkedList<NetCircuitEnd>();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), objectArray[i]);
            linkedList.add(netCircuitEnd);
        }
        return linkedList;
    }

    protected void clearConnectionPathEnds() {
        this.connectionPathEnds.clear();
        if (this.dbgOn()) {
            this.debug("clearConnectionPathEnds: at node " + this.getName());
        }
    }

    protected boolean updateConnectionPathEnds(List list) {
        if (!((Object)this.connectionPathEnds).equals(list)) {
            this.connectionPathEnds = list;
            if (this.dbgOn()) {
                this.debug("updateConnectionPathEnds: path ends changed for " + this.getName() + ", count = " + this.connectionPathEnds.size());
            }
            return true;
        }
        return false;
    }

    protected boolean updateConnectionPathEnds() {
        if (this.dbgOn()) {
            this.debug("updateConnectionPathEnds: updating connection paths from CM for " + this.getName());
        }
        List list = this.getPathEndsFromPathDefs(this.getConnectionPathDefs());
        return this.updateConnectionPathEnds(list);
    }

    protected void addConnectionPathEnd(NetCircuitEnd netCircuitEnd) {
        if (this.dbgOn()) {
            this.debug("Adding connection path end: " + netCircuitEnd.prettyString());
        }
        this.connectionPathEnds.add(netCircuitEnd);
        try {
            if (this.circuit.isTl1Ckt()) {
                this.createSpliceListener(netCircuitEnd);
            }
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
            // empty catch block
        }
    }

    protected void addConnectionPathEnd(NetCircuitSpan netCircuitSpan) {
        this.addConnectionPathEnd(this.getSpanEndpoint(netCircuitSpan));
    }

    protected int getConnectionPathIndex(NetCircuitSpan netCircuitSpan) throws ConnectionPathNotFound {
        return this.getConnectionPathIndex(this.getSpanEndpoint(netCircuitSpan));
    }

    protected int getConnectionPathIndex(NetCircuitEnd netCircuitEnd) throws ConnectionPathNotFound {
        NetCircuitEnd netCircuitEnd2 = NetCircuitEndFactory.convertCircuitEnd(this, netCircuitEnd);
        int n = 0;
        for (NetCircuitEnd netCircuitEnd3 : this.getConnectionPathEnds()) {
            if (netCircuitEnd2.equals(netCircuitEnd3)) {
                return n;
            }
            ++n;
        }
        if (this.dbgOn()) {
            this.debug("getConnectionPathIndex: ERROR! Could not find path:");
            this.debug("  " + netCircuitEnd.prettyString());
            this.debug(" which was converted to: " + netCircuitEnd2.prettyString());
            this.debug(" " + netCircuitEnd2.prettyString());
            this.debug(" Connection Paths: ");
            for (NetCircuitEnd netCircuitEnd3 : this.getConnectionPathEnds()) {
                this.debug("  " + netCircuitEnd3.prettyString());
            }
        }
        throw new ConnectionPathNotFound("The connection path endpoint was not found on the node " + this.getName() + ".");
    }

    protected boolean hasConnectionPath(NetCircuitSpan netCircuitSpan) {
        return this.hasConnectionPath(this.getSpanEndpoint(netCircuitSpan));
    }

    protected boolean hasConnectionPath(NetCircuitEnd netCircuitEnd) {
        NetCircuitEnd netCircuitEnd2 = NetCircuitEndFactory.convertCircuitEnd(this, netCircuitEnd);
        for (NetCircuitEnd netCircuitEnd3 : this.getConnectionPathEnds()) {
            if (!netCircuitEnd2.equals(netCircuitEnd3)) continue;
            return true;
        }
        return false;
    }

    protected IConnectionConversionModel getConnectionConversionModel() {
        IConnectionConversionModel iConnectionConversionModel = null;
        if (this.inConnectionConversion()) {
            try {
                iConnectionConversionModel = this.getConn().getConnectionConversionModel();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                iConnectionConversionModel = null;
            }
        }
        return iConnectionConversionModel;
    }

    protected int getConversionOp() {
        int n;
        if (this.inConnectionConversion()) {
            return -1;
        }
        try {
            n = this.getConnectionConversionModel().getUpgradeOperation();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            n = -1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateConnection() throws AbstractCmsObjectNotExistException {
        Object object;
        if (this.dbgOn()) {
            this.debug("updateConnection() at " + this.getName());
        }
        NetCircuitNode netCircuitNode = null;
        List list = this.circuit.getCircuitNodeFromNE(this.ne);
        if (list != null) {
            if (list.size() > 1) {
                object = list.iterator();
                NetCircuitNode netCircuitNode2 = null;
                boolean bl = false;
                while (object.hasNext()) {
                    DualConnectionCircuitNode dualConnectionCircuitNode;
                    netCircuitNode2 = (NetCircuitNode)object.next();
                    if (!netCircuitNode2.hasDualConnections() || !(dualConnectionCircuitNode = (DualConnectionCircuitNode)netCircuitNode2).getFstCircuitNode().equals(this) && !dualConnectionCircuitNode.getSecCircuitNode().equals(this)) continue;
                    bl = true;
                    break;
                }
                netCircuitNode = bl ? netCircuitNode2 : this;
            } else {
                netCircuitNode = (NetCircuitNode)list.get(0);
            }
        }
        netCircuitNode.conformToConnection();
        this.setState(2);
        object = this.entitiesLockObject;
        synchronized (object) {
            this.updateUpsrEntities(true);
        }
        if (!this.circuit.circuitInfoActive()) {
            if (!this.circuit.tl1CircuitCompleteCheck()) {
                this.circuit.checkAndUpdateCircuit();
            }
        } else if (!this.circuit.completeCheck()) {
            this.circuit.checkAndUpdateCircuit();
        }
    }

    public boolean isNodeDrop() {
        return this.nodeDrop != null;
    }

    public boolean eligibleForEtherHoDropAdd() {
        return false;
    }

    protected boolean isCircuitInfoSourceOrDrop(NetCircuitEnd netCircuitEnd) {
        if (!this.circuit.circuitInfoActive()) {
            return false;
        }
        boolean bl = false;
        if (this.circuit.isSource(netCircuitEnd)) {
            if (!this.sources.contains(netCircuitEnd)) {
                if (this.dbgOn()) {
                    db.println("adding circuit end as source");
                }
                this.insertSource(netCircuitEnd);
            }
            bl = true;
        }
        if (this.circuit.isDrop(netCircuitEnd)) {
            if (!this.drops.contains(netCircuitEnd)) {
                if (this.dbgOn()) {
                    db.println("adding circuit end as drop");
                }
                this.insertDrop(netCircuitEnd);
                for (NetCircuitDropInfo netCircuitDropInfo : this.circuit.getDrops()) {
                    NetCircuitEnd netCircuitEnd2 = netCircuitDropInfo.getNetCktEnd();
                    if (!netCircuitEnd2.equals(netCircuitEnd) || netCircuitEnd2 == netCircuitEnd) continue;
                    this.circuit.removeDrop(netCircuitDropInfo);
                    this.circuit.insertDrop(new NetCircuitDropInfo(netCircuitEnd, netCircuitDropInfo.getPathProt()));
                }
            }
            bl = true;
        }
        return bl;
    }

    protected void assumeSourceOrDrop(eSpanDirection eSpanDirection2, NetCircuitEnd netCircuitEnd) {
        if (eSpanDirection2 == eSpanDirection.TERMINATING) {
            if (this.dbgOn()) {
                db.println("adding active source");
            }
            this.insertSource(netCircuitEnd);
        } else {
            if (this.dbgOn()) {
                db.println("adding active drop");
            }
            this.insertDrop(netCircuitEnd);
        }
    }

    public INetElement getNetElement() {
        return this.ne;
    }

    public INodeModel getNodeModel() {
        return this.node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSources() {
        LinkedList linkedList;
        LinkedList linkedList2 = this.sources;
        synchronized (linkedList2) {
            linkedList = new LinkedList(this.sources);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDrops() {
        LinkedList linkedList;
        LinkedList linkedList2 = this.drops;
        synchronized (linkedList2) {
            linkedList = new LinkedList(this.drops);
        }
        return linkedList;
    }

    protected List getRoutedDrops() {
        List list = this.getDrops();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (netCircuitEnd.getStage() == 2) continue;
            iterator.remove();
        }
        return list;
    }

    public int totalSpans() {
        return this.inSpans.size() + this.outSpans.size() + this.biSpans.size();
    }

    protected LinkedList getInSpans() {
        return new LinkedList(this.inSpans);
    }

    protected LinkedList getOutSpans() {
        return new LinkedList(this.outSpans);
    }

    protected LinkedList getBiSpans() {
        return new LinkedList(this.biSpans);
    }

    protected LinkedList getTermSpans() {
        LinkedList<NetCircuitSpan> linkedList = new LinkedList<NetCircuitSpan>();
        Iterator iterator = this.inSpans.iterator();
        while (iterator.hasNext()) {
            linkedList.add((NetCircuitSpan)iterator.next());
        }
        for (NetCircuitSpan netCircuitSpan : this.biSpans) {
            if (this.findRoutingDir(netCircuitSpan) != eSpanDirection.TERMINATING) continue;
            linkedList.add(netCircuitSpan);
        }
        return linkedList;
    }

    protected LinkedList getOrigSpans() {
        LinkedList<NetCircuitSpan> linkedList = new LinkedList<NetCircuitSpan>();
        Iterator iterator = this.outSpans.iterator();
        while (iterator.hasNext()) {
            linkedList.add((NetCircuitSpan)iterator.next());
        }
        for (NetCircuitSpan netCircuitSpan : this.biSpans) {
            if (this.findRoutingDir(netCircuitSpan) != eSpanDirection.ORIGINATING) continue;
            linkedList.add(netCircuitSpan);
        }
        return linkedList;
    }

    protected LinkedList getRoutedOrigSpans() {
        LinkedList linkedList = this.getOrigSpans();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan.getSrcState() == 2) continue;
            iterator.remove();
        }
        return linkedList;
    }

    protected LinkedList getOmniSpans() {
        LinkedList<NetCircuitSpan> linkedList = new LinkedList<NetCircuitSpan>();
        for (NetCircuitSpan netCircuitSpan : this.biSpans) {
            if (!netCircuitSpan.getNetLinkSpan().getOmni()) continue;
            linkedList.add(netCircuitSpan);
        }
        return linkedList;
    }

    protected int countNumTermSpans() {
        return this.getTermSpans().size();
    }

    protected int countNumOrigSpans() {
        return this.getOrigSpans().size();
    }

    protected int countNumInputs() {
        return this.sources.size() + this.countNumTermSpans();
    }

    protected int countNumOutputs() {
        return this.drops.size() + this.countNumOrigSpans();
    }

    public int countRoutedOrigSpans() {
        int n = 0;
        for (NetCircuitSpan netCircuitSpan : this.getOrigSpans()) {
            if (netCircuitSpan.getSrcState() != 2) continue;
            ++n;
        }
        return n;
    }

    public int countRoutedTermSpans() {
        int n = 0;
        for (NetCircuitSpan netCircuitSpan : this.getTermSpans()) {
            if (netCircuitSpan.getDstState() != 2) continue;
            ++n;
        }
        return n;
    }

    protected int countNumOmniSpans() {
        int n = 0;
        return n += this.getOmniSpans().size();
    }

    protected int countRoutedSources() {
        int n = 0;
        for (NetCircuitEnd netCircuitEnd : this.sources) {
            if (netCircuitEnd.getStage() != 2) continue;
            ++n;
        }
        return n;
    }

    protected int countRoutedDrops() {
        int n = 0;
        for (NetCircuitEnd netCircuitEnd : this.drops) {
            if (netCircuitEnd.getStage() != 2) continue;
            ++n;
        }
        return n;
    }

    protected int countRoutedOutputs() {
        return this.countRoutedDrops() + this.countRoutedOrigSpans();
    }

    protected int countRoutedInputs() {
        return this.countRoutedSources() + this.countRoutedTermSpans();
    }

    protected int countActiveInputs() {
        int n = 0;
        for (NetCircuitEnd netCircuitEnd : this.sources) {
            if (netCircuitEnd.getStage() != 4) continue;
            ++n;
        }
        for (NetCircuitSpan netCircuitSpan : this.getTermSpans()) {
            if (netCircuitSpan.getDstState() != 4) continue;
            ++n;
        }
        return n;
    }

    protected int countActiveOutputs() {
        int n = 0;
        for (NetCircuitEnd netCircuitEnd : this.drops) {
            if (netCircuitEnd.getStage() != 4) continue;
            ++n;
        }
        for (NetCircuitSpan netCircuitSpan : this.getOrigSpans()) {
            if (netCircuitSpan.getSrcState() != 4) continue;
            ++n;
        }
        return n;
    }

    protected List getConnections() {
        return this.connections;
    }

    protected void setConnections(List list) {
        this.connections = list;
    }

    protected int calculateConnectionType() {
        return this.nodeUtil.calculateConnectionType();
    }

    protected int findUpgradedConnType() {
        return this.nodeUtil.findUpgradedConnType();
    }

    protected int findDowngradedConnType() {
        return this.nodeUtil.findDowngradedConnType();
    }

    protected int findConnType() {
        return this.nodeUtil.findConnType();
    }

    protected int getTotalInOuts() {
        int n = this.countNumInputs() + this.countNumOutputs() + this.countNumOmniSpans();
        return n;
    }

    protected eSpanDirection findDir(NetCircuitSpan netCircuitSpan) {
        if (this.inSpans.contains(netCircuitSpan)) {
            return eSpanDirection.TERMINATING;
        }
        if (this.outSpans.contains(netCircuitSpan)) {
            return eSpanDirection.ORIGINATING;
        }
        if (this.biSpans.contains(netCircuitSpan)) {
            return eSpanDirection.BIDIRECTIONAL;
        }
        if (this.dbgOn()) {
            db.println("findDir: Span not found at " + this.getName());
        }
        return null;
    }

    protected eSpanDirection findRoutingDir(NetCircuitSpan netCircuitSpan) {
        if (this.findDir(netCircuitSpan) == eSpanDirection.BIDIRECTIONAL) {
            return netCircuitSpan.biSpanDir(this.ne);
        }
        return this.findDir(netCircuitSpan);
    }

    protected eSpanDirection findRoutingDir(INetLink iNetLink) {
        eSpanDirection eSpanDirection2 = eSpanDirection.TERMINATING;
        if (this.ne == iNetLink.getSrc()) {
            eSpanDirection2 = eSpanDirection.ORIGINATING;
        } else if (this.ne == iNetLink.getDst()) {
            eSpanDirection2 = eSpanDirection.TERMINATING;
        } else if (this.dbgOn()) {
            this.debug("findRoutingDir: ERROR! Link does not touch node " + this.getName());
        }
        return eSpanDirection2;
    }

    protected void deleteConnectionObserver() {
        if (this.getConn() != null) {
            if (this.dbgOn()) {
                db.println("deleteConnectionObserver at " + this.getNameAndClass());
            }
            try {
                ModelIndirectObservable.instance().deleteObserver((IObservable)this.getConn(), this);
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                // empty catch block
            }
            this.updateEvent.init();
        }
    }

    protected void addConnectionObserver() {
        if (this.getConn() != null) {
            if (this.dbgOn()) {
                db.println("addConnectionObserver at " + this.getNameAndClass());
            }
            this.updateEvent.init();
            ModelIndirectObservable.instance().addObserver((IObservable)this.getConn(), this);
        }
    }

    protected void destroyConnection() throws Busy, ConnectionInTestAccess, ConnectionInRoll, ConnectionInTopologyUpgrade, VcatMemberNotOutOfGroup, VcatMemberInvalidState, DeletionError, InvalidPath, WrongInterfaceType, ConnectionHasFarendLoopback {
        this.getOperator().destroyConnection();
    }

    protected int getTunnelEntityIndex() throws SanityCheckFailed {
        return -1;
    }

    protected boolean hasAggregation() {
        return false;
    }

    public IHoNum getLotHo() throws SanityCheckFailed {
        return null;
    }

    protected IConnectionConversionModel getConnConvModel() {
        return this.getConnectionConversionModel();
    }

    protected void prettyPrint(SDebug sDebug) {
        NetCircuitEnd netCircuitEnd;
        if (!sDebug.on()) {
            return;
        }
        sDebug.println(" NODE " + this.getName() + " (" + this.getClass().getName() + ")");
        sDebug.print("   State=" + EnumStrings.getString(INetCircuitProvState.class, (int)this.state));
        sDebug.print("   XC Y-State=" + this.yState + " Net Y-State" + this.getYState());
        sDebug.print(" | CktId=" + NetCircuit.prettyString(this.cktId));
        sDebug.println(" | ConnType=" + (this.connType == 22 ? "Unknown" : EnumStrings.getString(IConnectionType.class, (int)this.connType)));
        sDebug.print("    dri = " + (this.dri ? " true " : " false "));
        sDebug.print("    nodeType = " + EnumStrings.getString(IDriNodeType.class, (int)this.driNodeType));
        sDebug.println("    inRoll = " + this.currRollStatus);
        sDebug.print("   ConnName=\"" + this.connName + "\"");
        sDebug.print(" | AdminState= " + NetCircuitNode.translateAdminState(this.adminState));
        sDebug.print(" | ServiceState= " + NetCircuitNode.translateServiceState(this.serviceState));
        sDebug.print(" | UpdateEventState: DELETE=" + this.updateEvent.deleted + "; CHANGED=" + this.updateEvent.changed);
        sDebug.println(this.inConnectionConversion() ? " | inConnectionConversion" : "");
        sDebug.print("   Src " + this.sources.size());
        sDebug.print(" | Drp " + this.drops.size());
        if (this.nodeDrop != null) {
            sDebug.print(" (Node Drop)");
        }
        sDebug.print(" | Term " + this.inSpans.size());
        sDebug.print(" | Orig " + this.outSpans.size());
        sDebug.print(" | Bi " + this.biSpans.size());
        sDebug.print(" | Path " + this.numberOfPaths);
        sDebug.print(" | Spl " + this.spliceListeners.size());
        sDebug.println(this.getUpsrOps() != null ? " | UPSR" : "");
        Iterator iterator = this.sources.iterator();
        sDebug.println(" Sources: ");
        while (iterator.hasNext()) {
            netCircuitEnd = (NetCircuitEnd)iterator.next();
            sDebug.println("  " + netCircuitEnd.prettyString());
        }
        iterator = this.drops.iterator();
        sDebug.println(" Drops: ");
        while (iterator.hasNext()) {
            netCircuitEnd = (NetCircuitEnd)iterator.next();
            sDebug.println("  " + netCircuitEnd.prettyString());
        }
        if (this.nodeDrop != null) {
            sDebug.println(" NodeDrop: ");
            sDebug.println("  " + this.nodeDrop.prettyString());
        }
        List list = this.getWorkingSpans();
        List list2 = this.getProtectSpans();
        if (list.size() != 0) {
            sDebug.println(" WorkingSpan(s):");
            for (NetCircuitSpan netCircuitSpan : list) {
                sDebug.println("  " + netCircuitSpan.availSpan.prettyString());
                sDebug.println("  " + netCircuitSpan.prettyStringSpanState());
            }
        }
        if (list2.size() != 0) {
            sDebug.println(" ProtectSpan(s):");
            for (NetCircuitSpan netCircuitSpan : list2) {
                sDebug.println("  " + netCircuitSpan.availSpan.prettyString());
                sDebug.println("  " + netCircuitSpan.prettyStringSpanState());
            }
        }
        if (this.hasUnprotectedSelector()) {
            sDebug.println(" Unprotected Selector");
        }
        if (this.hasUnprotectedDrop()) {
            sDebug.println(" Unprotected Drop");
        }
        if (this.nodeRoutingDir != null) {
            this.nodeRoutingDir.prettyPrint(sDebug);
        }
        ConnectionsFactory.prettyPrintConnectionList(sDebug, this.getConnectionType(), this.connections, this.getName());
    }

    protected void lotReuseLoAdit(boolean bl) {
    }

    public INetCircuit getCircuit() {
        return this.circuit;
    }

    public List getMonitorSourcePoints() throws SanityCheckFailed {
        Object[] objectArray = this.getPathsFromConnModel();
        int n = this.getConnTypeFromConnModel();
        return this.getOperator().getMonitorSourcePoints(objectArray, n);
    }

    protected void addDropInfo(NetCircuitDropInfo netCircuitDropInfo) {
        NetCircuitEnd netCircuitEnd = netCircuitDropInfo.getNetCktEnd();
        this.insertDrop(netCircuitEnd);
        netCircuitEnd.setStage(2);
        if (this.getState() != 0) {
            this.setState(3);
        }
    }

    protected void addSource(NetCircuitEnd netCircuitEnd) {
        if (this.hasConnection()) {
            if (this.dbgOn()) {
                db.println("Warning! attempt to add source to active node");
            }
            return;
        }
        netCircuitEnd.setStage(2);
        this.insertSource(netCircuitEnd);
    }

    protected void insertSource(NetCircuitEnd netCircuitEnd) {
        if (this.dbgOn()) {
            this.debug("sources.add(" + netCircuitEnd.prettyString() + ") at " + this.getName());
        }
        if (!this.sources.contains(netCircuitEnd)) {
            this.sources.add(netCircuitEnd);
        }
    }

    protected void insertDrop(NetCircuitEnd netCircuitEnd) {
        if (netCircuitEnd.isNodeDrop()) {
            if (this.dbgOn()) {
                this.debug("Adding nodeDrop " + netCircuitEnd.prettyString() + " at " + this.getName());
            }
            this.nodeDrop = netCircuitEnd;
        } else {
            if (this.dbgOn()) {
                this.debug("drops.add(" + netCircuitEnd.prettyString() + ") at " + this.getName());
            }
            if (!this.drops.contains(netCircuitEnd)) {
                this.drops.add(netCircuitEnd);
            }
        }
    }

    protected void removeSource(NetCircuitEnd netCircuitEnd) {
        if (this.dbgOn()) {
            this.debug("sources.remove(" + netCircuitEnd.prettyString() + ") at " + this.getName());
        }
        this.sources.remove(netCircuitEnd);
    }

    protected void removeDrop(NetCircuitEnd netCircuitEnd) {
        if (netCircuitEnd.isNodeDrop()) {
            if (this.dbgOn()) {
                this.debug("Removing nodeDrop " + netCircuitEnd.prettyString() + " at " + this.getName());
            }
            this.nodeDrop = null;
        } else {
            if (this.dbgOn()) {
                this.debug("drops.remove(" + netCircuitEnd.prettyString() + ") at " + this.getName());
            }
            this.drops.remove(netCircuitEnd);
        }
    }

    protected void changeSourceToDrop(NetCircuitEnd netCircuitEnd) {
        if (this.dbgOn()) {
            this.debug("changeSourceToDrop(" + netCircuitEnd.prettyString() + ") at " + this.getName());
        }
        this.removeSource(netCircuitEnd);
        this.insertDrop(netCircuitEnd);
    }

    protected void changeDropToSource(NetCircuitEnd netCircuitEnd) {
        if (this.dbgOn()) {
            this.debug("changeDropToSource(" + netCircuitEnd.prettyString() + ") at " + this.getName());
        }
        this.removeDrop(netCircuitEnd);
        this.insertSource(netCircuitEnd);
    }

    protected boolean hasMonitor() {
        return this.getOperator().hasMonitor();
    }

    protected void destroySanityCheck() throws SanityCheckFailed {
        if (this.getOperator() != null) {
            this.getOperator().destroySanityCheck();
        }
    }

    public void destroy() {
        if (this.dbgOn()) {
            db.println("Destroy node " + this.getName() + " object on exit of CTC");
        }
        super.destroy();
        this.disposeSpans();
        this.dispose(true);
    }

    public void deactivate() throws DeletionError {
        if (this.dbgOn()) {
            db.println("Deactivating circuit node " + this.getName());
        }
        if (this.state != 0) {
            if (this.inConnectionConversion()) {
                IConnectionConversionModel iConnectionConversionModel;
                if (this.dbgOn()) {
                    db.println("deactivate: NCN in Conn Conv state");
                }
                if ((iConnectionConversionModel = this.getConnectionConversionModel()) != null) {
                    if (this.dbgOn()) {
                        db.println("deactivate: destroying Conn Conv object");
                    }
                    iConnectionConversionModel.destroy();
                }
            }
            try {
                this.destroyConnection();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.dbgOn()) {
                    db.println("i/o exception trying to destroy connection at " + this.getName());
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
                throw new DeletionError("An I/O error occurred on the node " + this.getName() + ".\n        " + abstractCmsIOException.toString());
            }
            catch (Busy busy) {
                if (this.dbgOn()) {
                    db.println("Busy exception trying to destroy connection at " + this.getName());
                    SDebug.printStackTrace((Throwable)busy);
                }
                throw new DeletionError("The connection supports a monitor circuit and cannot be deleted at this time.");
            }
            catch (ConnectionInTestAccess connectionInTestAccess) {
                if (this.dbgOn()) {
                    db.println("ConnectionInTestAccess exception trying to destroy connection at " + this.getName());
                    SDebug.printStackTrace((Throwable)connectionInTestAccess);
                }
                throw new DeletionError("The connection is in test access and cannot be deleted  at this time.");
            }
            catch (ConnectionInRoll connectionInRoll) {
                if (this.dbgOn()) {
                    db.println("ConnectionInRoll exception trying to destroy connection at " + this.getName());
                    SDebug.printStackTrace((Throwable)connectionInRoll);
                }
                throw new DeletionError("The connection is in a roll and cannot be deleted at this time.");
            }
            catch (ConnectionInTopologyUpgrade connectionInTopologyUpgrade) {
                if (this.dbgOn()) {
                    db.println("ConnectionInTopologyUpgrade exception trying to destroy connection at " + this.getName());
                    SDebug.printStackTrace((Throwable)connectionInTopologyUpgrade);
                }
                throw new DeletionError("The connection is in a topology upgrade and cannot be deleted at this time.");
            }
            catch (VcatMemberNotOutOfGroup vcatMemberNotOutOfGroup) {
                if (this.dbgOn()) {
                    db.println("VcatMemberNotOutOfGroup exception trying to destroy connection at " + this.getName());
                    SDebug.printStackTrace((Throwable)vcatMemberNotOutOfGroup);
                }
                throw new DeletionError("The connection is not out of group and cannot be deleted at this time.");
            }
            catch (ConnectionHasFarendLoopback connectionHasFarendLoopback) {
                if (this.dbgOn()) {
                    db.println("ConnectionHasFarendLoopback exception trying to destroy connection at " + this.getName());
                    SDebug.printStackTrace((Throwable)connectionHasFarendLoopback);
                }
                throw new DeletionError("The connection has Far-end alarm and control (FEAC) line loop code detection enabled and cannot be deleted at this time.");
            }
            catch (VcatMemberInvalidState vcatMemberInvalidState) {
                if (this.dbgOn()) {
                    db.println("VcatMemberInvalidState exception trying to destroy connection at " + this.getName());
                    SDebug.printStackTrace((Throwable)vcatMemberInvalidState);
                }
                throw new DeletionError("The connection is not in a valid state and cannot be deleted at this time.");
            }
            catch (InvalidPath invalidPath) {
                if (this.dbgOn()) {
                    db.println("InvalidPath exception trying to destroy connection at " + this.getName());
                    SDebug.printStackTrace((Throwable)invalidPath);
                }
                throw new DeletionError("The connection is not in a valid state and cannot be deleted at this time.");
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (this.dbgOn()) {
                    db.println("WrongInterfaceType exception trying to destroy connection at " + this.getName());
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
                throw new DeletionError("The connection is not in a valid state and cannot be deleted at this time.");
            }
        }
        this.circuit.disposeConnection(this, true);
    }

    protected void cleanupSpliceListeners() {
        NetCircuitSplicer netCircuitSplicer = NetCircuitSplicer.instance();
        if (this.dbgOn()) {
            db.println("cleanupSpliceListeners at " + this.getName());
        }
        Iterator iterator = this.spliceListeners.iterator();
        while (iterator.hasNext()) {
            SpliceListenerEntry spliceListenerEntry = (SpliceListenerEntry)iterator.next();
            if (this.dbgOn()) {
                this.debug("removeSpliceListener(" + spliceListenerEntry.prettyString() + ") at " + this.getName());
            }
            netCircuitSplicer.cancelCallback(spliceListenerEntry);
            iterator.remove();
        }
    }

    protected boolean aditListenerPresent(SpliceListenerEntry spliceListenerEntry) {
        NetCircuitSplicer netCircuitSplicer = NetCircuitSplicer.instance();
        if (netCircuitSplicer.findListener(spliceListenerEntry.spliceLinkIndex.ne, spliceListenerEntry.spliceLinkIndex.entityIndex, spliceListenerEntry.spliceLinkIndex.direction, spliceListenerEntry.spliceListener.hoNum, spliceListenerEntry.spliceListener.loNum, true) != null) {
            if (this.dbgOn()) {
                this.debug("Pre-existing loAditSpliceListener(" + spliceListenerEntry.prettyString() + ") found at " + this.getName());
            }
            return true;
        }
        if (netCircuitSplicer.findListener(spliceListenerEntry.spliceLinkIndex.ne, spliceListenerEntry.spliceLinkIndex.entityIndex, spliceListenerEntry.spliceLinkIndex.direction, spliceListenerEntry.spliceListener.hoNum, spliceListenerEntry.spliceListener.loNum, false) != null) {
            if (this.dbgOn()) {
                this.debug("Pre-existing HO spliceListener found for loAdit(" + spliceListenerEntry.prettyString() + ") found at " + this.getName());
            }
            return true;
        }
        return false;
    }

    protected void addSpliceListener(SpliceListenerEntry spliceListenerEntry) {
        NetCircuitSplicer netCircuitSplicer = NetCircuitSplicer.instance();
        if (this.dbgOn()) {
            this.debug("addSpliceListener(" + spliceListenerEntry.prettyString() + ") at " + this.getName());
        }
        this.spliceListeners.add(spliceListenerEntry);
        if (spliceListenerEntry.spliceListener.loNum != null && !(this instanceof LoYCircuitNode)) {
            SpliceLinkIndex spliceLinkIndex = new SpliceLinkIndex(spliceListenerEntry.spliceLinkIndex.ne, spliceListenerEntry.spliceLinkIndex.entityIndex, eSpanDirection.BIDIRECTIONAL);
            SpliceListener spliceListener = new SpliceListener(spliceListenerEntry.spliceListener.hoNum, null, 0, this, true);
            SpliceListenerEntry spliceListenerEntry2 = new SpliceListenerEntry(spliceLinkIndex, spliceListener);
            this.addAditListener(spliceListenerEntry2);
        }
    }

    protected void addAditListener(SpliceListenerEntry spliceListenerEntry) {
        NetCircuitSplicer netCircuitSplicer = NetCircuitSplicer.instance();
        if (!this.aditListenerPresent(spliceListenerEntry)) {
            netCircuitSplicer.registerCallback(spliceListenerEntry.spliceLinkIndex.ne, spliceListenerEntry.spliceLinkIndex.entityIndex, spliceListenerEntry.spliceLinkIndex.direction, spliceListenerEntry.spliceListener.hoNum, spliceListenerEntry.spliceListener.loNum, spliceListenerEntry.spliceListener.optChannel, spliceListenerEntry.spliceListener.node, spliceListenerEntry.spliceListener.loAdit);
            this.spliceListeners.add(spliceListenerEntry);
            if (this.dbgOn()) {
                this.debug("Added loAditSpliceListener(" + spliceListenerEntry.prettyString() + ") at " + this.getName());
            }
        }
    }

    protected void removeSpliceListener(SpliceListenerEntry spliceListenerEntry) {
        SpliceListener spliceListener;
        SpliceListenerEntry spliceListenerEntry2;
        boolean bl;
        NetCircuitSplicer netCircuitSplicer = NetCircuitSplicer.instance();
        if (this.dbgOn()) {
            this.debug("removeSpliceListener(" + spliceListenerEntry.prettyString() + ") at " + this.getName());
        }
        if (!(bl = this.spliceListeners.remove(spliceListenerEntry)) && this.dbgOn()) {
            this.debug("WARNING! spliceListener not found in list");
        }
        if (spliceListenerEntry.spliceListener.loNum != null && (bl = this.spliceListeners.remove(spliceListenerEntry2 = new SpliceListenerEntry(spliceListenerEntry.spliceLinkIndex, spliceListener = new SpliceListener(spliceListenerEntry.spliceListener.hoNum, null, 0, this, true))))) {
            netCircuitSplicer.cancelCallback(spliceListenerEntry2);
            if (this.dbgOn()) {
                this.debug("Removed loAditSpliceListener(" + spliceListenerEntry2.prettyString() + ") at " + this.getName());
            }
        }
    }

    protected boolean connEndsPartOfCktEnd(LinkedList linkedList) {
        if (this.dbgOn()) {
            this.debug("Called connEndsPartOfCktEnd for " + this.getNetElement().getName());
        }
        for (NetCircuitEnd netCircuitEnd : this.connectionPathEnds) {
            if (!linkedList.contains(netCircuitEnd)) continue;
            if (this.dbgOn()) {
                this.debug("Connection EndPoint" + netCircuitEnd.prettyString() + " is part of CircuitInfo");
            }
            return true;
        }
        return false;
    }

    private void createSpliceListener(NetCircuitSplicer netCircuitSplicer, INetElement iNetElement, int n, eSpanDirection eSpanDirection2, IHoNum iHoNum, ILoNum iLoNum, NetCircuitNode netCircuitNode, boolean bl) {
        LinkedList linkedList;
        NetCircuitEnd netCircuitEnd = new NetCircuitEnd(iNetElement.getNodeId(), n, iHoNum, iLoNum, false);
        if ((this.circuit.circuitInfoActive() || this.circuit.getCircuitTypeObj().isSVLANType()) && (linkedList = this.circuit.getCktInfoEndPoints()).contains(netCircuitEnd) && this.circuit.getCircuitType() != 15) {
            if (this.dbgOn()) {
                this.debug("Not creating SpliceListener at " + this.getName() + "for cktInfo EndPoint" + netCircuitEnd.prettyString());
            }
            return;
        }
        if (this.isUpsrOver1Plus1Enabled() && this.checkListenerOnSamePort(netCircuitEnd)) {
            if (this.dbgOn()) {
                this.debug("Removed matching spliceListener for cktEnd " + netCircuitEnd.prettyString());
            }
            return;
        }
        SpliceListenerEntry spliceListenerEntry = netCircuitSplicer.registerCallback(iNetElement, n, eSpanDirection2, iHoNum, iLoNum, 0, netCircuitNode, bl);
        this.addSpliceListener(spliceListenerEntry);
    }

    protected void createSpliceListener(INetElement iNetElement, int n, eSpanDirection eSpanDirection2, IHoNum iHoNum, ILoNum iLoNum, NetCircuitNode netCircuitNode, boolean bl) {
        this.createSpliceListener(NetCircuitSplicer.instance(), iNetElement, n, eSpanDirection2, iHoNum, iLoNum, netCircuitNode, bl);
    }

    protected void createSpliceListener(NetCircuitSplicer netCircuitSplicer, NetCircuitEnd netCircuitEnd, eSpanDirection eSpanDirection2) {
        this.createSpliceListener(netCircuitSplicer, this.getNetElement(), netCircuitEnd.getEntityIndex(), eSpanDirection2, netCircuitEnd.getHoNum(), netCircuitEnd.getLoNum(), this, false);
    }

    protected void createSpliceListener(NetCircuitEnd netCircuitEnd) {
        int n;
        NetCircuitSplicer netCircuitSplicer = NetCircuitSplicer.instance();
        if (!this.hasConnectionPath(netCircuitEnd)) {
            if (this.dbgOn()) {
                this.debug("createSpliceListener: cktEnd has no connection path " + Integer.toHexString(netCircuitEnd.getEntityIndex()));
            }
            return;
        }
        try {
            n = this.getConnectionPathIndex(netCircuitEnd);
        }
        catch (ConnectionPathNotFound connectionPathNotFound) {
            if (this.dbgOn()) {
                this.debug("createSpliceListener: cktEnd has no connection path index" + Integer.toHexString(netCircuitEnd.getEntityIndex()));
            }
            return;
        }
        eSpanDirection eSpanDirection2 = this.nodeRoutingDir.getPathSpliceDir(n);
        if (this.dbgOn()) {
            this.debug("createSpliceListener: creating splice listener for " + Integer.toHexString(netCircuitEnd.getEntityIndex()) + " spliceDir: " + eSpanDirection2);
        }
        this.createSpliceListener(netCircuitSplicer, netCircuitEnd, eSpanDirection2);
    }

    protected void deleteSpliceListener(SpliceListenerEntry spliceListenerEntry) {
        NetCircuitSplicer netCircuitSplicer = NetCircuitSplicer.instance();
        netCircuitSplicer.cancelCallback(spliceListenerEntry);
        this.removeSpliceListener(spliceListenerEntry);
    }

    protected void disposeCircuitInfo() {
        block2: {
            try {
                this.createSpliceListenersForSourcesAndDrops();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!this.dbgOn()) break block2;
                this.debug("disposeCircuitInfo() createSpliceListenersForSourcesAndDrops failed but dispose continues: " + abstractCmsIOException.getMessage());
            }
        }
    }

    protected void createSpliceListenersForSourcesAndDrops() {
        if (this.dbgOn()) {
            this.debug("Creating splice listeners for srcs/drops at " + this.getName());
        }
        Iterator iterator = this.sources.iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
                this.createSpliceListener(netCircuitEnd);
            }
            iterator = this.drops.iterator();
        }
    }

    public void dispose(boolean bl) {
        this.disposeConnection(bl);
        this.deleteConnectionObserver();
        this.finalDispose();
    }

    protected void disposeConnection(boolean bl) {
        if (this.dbgOn()) {
            db.println("disposeConnection called at " + this.getName());
        }
        if (this.getConn() != null) {
            this.deregisterNullCircuitConnection(this.getNetElement(), this.getConn());
        }
        if (bl) {
            this.cleanupSpliceListeners();
        }
    }

    protected void finalDispose() {
        if (this.dbgOn()) {
            db.println("finalDispose at " + this.getName());
        }
        this.isNodeRefValid = false;
        if ((this.inSpans.size() != 0 || this.outSpans.size() != 0 || this.biSpans.size() != 0) && this.dbgOn()) {
            db.println("Warning! finalDispose: all spans not disposed: " + this.inSpans.size() + "," + this.outSpans.size() + "," + this.biSpans.size());
        }
        this.inSpans.clear();
        this.outSpans.clear();
        this.biSpans.clear();
        if (this.spliceListeners.size() != 0 && this.dbgOn()) {
            db.println("Warning! finalDispose: all spliceListeners not disposed: " + this.spliceListeners.size());
        }
        this.spliceListeners.clear();
        this.setConn(null);
    }

    protected void disposeSpans() {
        if (this.dbgOn()) {
            db.println("disposeSpans at node " + this.getName());
        }
        LinkedList linkedList = (LinkedList)this.inSpans.clone();
        linkedList.addAll((Collection)this.outSpans.clone());
        linkedList.addAll((Collection)this.biSpans.clone());
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            ((NetCircuitSpan)iterator.next()).dispose(false);
        }
    }

    public int getState() {
        return this.state;
    }

    public boolean getDri() {
        return this.dri;
    }

    protected void setDri(boolean bl) {
        if (this.dbgOn() && bl) {
            db.println("setDri: " + bl + " on node " + this.getName());
        }
        this.dri = bl;
    }

    protected void initState(int n) {
        if (this.dbgOn()) {
            db.println("Node " + this.getName() + " init state: " + EnumStrings.getString(INetCircuitProvState.class, (int)n));
        }
        this.state = n;
    }

    protected void setState(int n) {
        if (n == this.state) {
            return;
        }
        if (this.dbgOn()) {
            db.println("Node " + this.getName() + " state change: " + EnumStrings.getString(INetCircuitProvState.class, (int)this.state) + "->" + EnumStrings.getString(INetCircuitProvState.class, (int)n));
        }
        this.state = n;
    }

    protected boolean hasConnection() {
        return this.state == 2 || this.state == 3 || this.state == 4;
    }

    protected void activate() throws CircuitProvError {
        if (this.state == 0) {
            this.setConnectionType(this.findConnType());
            if (this.getConnectionType() == 22) {
                if (this.dbgOn()) {
                    db.println("Warning! createConnection at " + this.getName() + " connection type is unknown");
                }
                throw new CircuitProvError("An invalid connection type exists on the node " + this.getName() + ".");
            }
            this.cktId = this.circuit.getCircuitId();
            this.connName = this.circuit.getCircuitName();
        }
        this.getOperator().activate();
        if (this.state == 0) {
            this.addConnectionObserver();
            this.updateConnectionPathEnds(this.getPathEndsFromPathDefs(this.getConnectionPathDefs()));
            this.setServiceState(this.getServiceStateFromNE());
            if (this.circuit.tl1Compatible() && !this.circuit.isMemberOfVcat()) {
                this.createSpliceListenersForSourcesAndDrops();
            }
            this.setState(1);
            this.setCreateStage(3);
            this.initYState();
        } else if (this.state == 3) {
            this.setState(2);
        }
        this.numberOfPaths = this.countNumInputs() + this.countNumOutputs() + this.countNumOmniSpans();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupUpsrEntities() {
        Object object = this.entitiesLockObject;
        synchronized (object) {
            this.workingEntities = null;
            this.protectEntities = null;
            this.activeEntities = null;
        }
    }

    protected int getAdminStateFromNE() {
        if (!this.ne.getNodeModel().provides(Feature.ENHANCED_STATE_MODEL)) {
            return 0;
        }
        if (this.getConn() != null) {
            return this.getConn().getAdminState();
        }
        return -1;
    }

    public int getAdminState() {
        return this.adminState;
    }

    protected void setAdminState(int n) {
        if (this.dbgOn()) {
            this.debug("setAdminState(" + this.getName() + "): " + NetCircuitNode.translateAdminState(this.adminState) + " --> " + NetCircuitNode.translateAdminState(n));
        }
        this.adminState = n;
    }

    protected int getServiceStateFromNE() {
        if (Feature.provides((INodeModel)this.getNodeModel(), (Feature)Feature.EXTENDED_ESM)) {
            if (this.getConn() != null) {
                return this.getConn().getServiceState();
            }
            return -2;
        }
        return -2;
    }

    public int getServiceState() {
        return this.serviceState;
    }

    protected void setServiceState(int n) {
        if (this.dbgOn()) {
            this.debug("setServiceState(" + this.getName() + "): " + NetCircuitNode.translateServiceState(this.serviceState) + " --> " + NetCircuitNode.translateServiceState(n));
        }
        this.serviceState = n;
    }

    protected int numRoutedPaths() {
        int n = 0;
        for (NetCircuitEnd netCircuitEnd : this.sources) {
            if (netCircuitEnd.getStage() != 2) continue;
            ++n;
        }
        for (NetCircuitEnd netCircuitEnd : this.drops) {
            if (netCircuitEnd.getStage() != 2) continue;
            ++n;
        }
        if (this.nodeDrop != null && this.nodeDrop.getStage() == 2) {
            ++n;
        }
        for (NetCircuitSpan netCircuitSpan : this.inSpans) {
            if (netCircuitSpan.getDstState() != 2) continue;
            ++n;
        }
        for (NetCircuitSpan netCircuitSpan : this.outSpans) {
            if (netCircuitSpan.getSrcState() != 2) continue;
            ++n;
        }
        for (NetCircuitSpan netCircuitSpan : this.biSpans) {
            if (netCircuitSpan.getLink().getSrc() == this.ne) {
                if (netCircuitSpan.getSrcState() != 2) continue;
                ++n;
                continue;
            }
            if (netCircuitSpan.getDstState() != 2) continue;
            ++n;
        }
        return n;
    }

    protected void setCreateStage(int n) {
        for (NetCircuitEnd netCircuitEnd : this.sources) {
            netCircuitEnd.setStage(n);
        }
        for (NetCircuitEnd netCircuitEnd : this.drops) {
            netCircuitEnd.setStage(n);
        }
        if (this.nodeDrop != null) {
            this.nodeDrop.setStage(n);
        }
        for (NetCircuitSpan netCircuitSpan : this.inSpans) {
            netCircuitSpan.setDstState(n);
        }
        for (NetCircuitSpan netCircuitSpan : this.outSpans) {
            netCircuitSpan.setSrcState(n);
        }
        for (NetCircuitSpan netCircuitSpan : this.biSpans) {
            if (netCircuitSpan.isInternalSpan() && this.getCircuit().getCircuitTypeObj().isSVLANType()) {
                netCircuitSpan.setState(this, n);
                continue;
            }
            if (netCircuitSpan.getLink().getSrc() == this.ne) {
                netCircuitSpan.setSrcState(n);
                continue;
            }
            netCircuitSpan.setDstState(n);
        }
    }

    protected void tentative2Active() {
        if (this.dbgOn()) {
            db.println("tentative2Active at node " + this.getName());
        }
        if (this.state == 0) {
            if (this.dbgOn()) {
                db.println("node is inactive");
            }
            return;
        }
        this.setCreateStage(4);
        this.setState(2);
    }

    protected boolean feedsNoDrops(Object object) {
        boolean bl = true;
        if (this.loopFlag) {
            if (this.dbgOn()) {
                db.println("feedsNoDrops: loop detected at " + this.getName());
            }
            this.loopFlag = false;
            return true;
        }
        this.loopFlag = true;
        if (!(this.drops.size() <= 0 || this.drops.size() == 1 && object != null && this.drops.contains(object))) {
            if (this.dbgOn()) {
                db.println("feedsNoDrops: drop found on " + this.getName());
            }
            this.loopFlag = false;
            return false;
        }
        for (NetCircuitSpan netCircuitSpan : this.getOrigSpans()) {
            NetCircuitNode netCircuitNode = this.spanGetPeer(netCircuitSpan);
            if (netCircuitNode.feedsNoDrops(object)) continue;
            this.loopFlag = false;
            return false;
        }
        this.loopFlag = false;
        return true;
    }

    protected NetCircuitNode spanGetPeer(NetCircuitSpan netCircuitSpan) {
        if (netCircuitSpan == null) {
            if (this.dbgOn()) {
                this.debug("spanGetPeer: null span");
            }
            return null;
        }
        if (this.ne == netCircuitSpan.getLink().getDst()) {
            return (NetCircuitNode)netCircuitSpan.getSrcNCN();
        }
        return (NetCircuitNode)netCircuitSpan.getDstNCN();
    }

    protected NetCircuitSpan findAlternateBiSpan(NetCircuitSpan netCircuitSpan) {
        for (NetCircuitSpan netCircuitSpan2 : this.biSpans) {
            if (netCircuitSpan2 == netCircuitSpan || netCircuitSpan2.getNetLinkSpan().getOmni()) continue;
            return netCircuitSpan2;
        }
        return null;
    }

    protected NetCircuitSpan findAlternateBiOrOmniSpan(NetCircuitSpan netCircuitSpan) {
        for (NetCircuitSpan netCircuitSpan2 : this.biSpans) {
            if (netCircuitSpan2 == netCircuitSpan) continue;
            return netCircuitSpan2;
        }
        return null;
    }

    protected NetCircuitSpan findNextBiSpanOnRoute(IEntityModel[] iEntityModelArray, NetCircuitSpan netCircuitSpan) {
        int n = netCircuitSpan.getEntityIndex(this.ne);
        if (iEntityModelArray == null) {
            return null;
        }
        Iterator<Object> iterator = Arrays.asList(iEntityModelArray).iterator();
        boolean bl = false;
        int n2 = 0;
        while (iterator.hasNext()) {
            int n3 = iterator.next().getEntityIndex();
            if (n3 == n) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl || n2 >= 4) {
            return null;
        }
        int n4 = -1;
        if (this.connType == 1 || this.connType == 8) {
            if (n2 == 0) {
                n4 = 1;
            } else if (n2 == 1) {
                n4 = 0;
            }
        }
        if (this.connType == 2) {
            if (n2 == 0 || n2 == 1) {
                n4 = 2;
            } else if (n2 == 2) {
                n4 = 0;
            }
        }
        if (this.connType == 3) {
            if (n2 == 0 || n2 == 1) {
                n4 = 2;
            } else if (n2 == 2 || n2 == 3) {
                n4 = 0;
            }
        }
        if (n4 == -1 || iEntityModelArray.length <= n4) {
            return null;
        }
        iterator = this.biSpans.iterator();
        int n5 = iEntityModelArray[n4].getEntityIndex();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan2 = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan2.getEntityIndex(this.ne) != n5) continue;
            return netCircuitSpan2;
        }
        return null;
    }

    public void removeRoutedDrop(NetCircuitEnd netCircuitEnd) throws SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("Removing ROUTED drop at " + this.getName());
        }
        this.removeDrop(netCircuitEnd);
        if (this.state == 3 && this.numRoutedPaths() == 0) {
            this.setState(2);
        }
        this.setupConnListOnCreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteDrop(INetCircuitEnd iNetCircuitEnd) throws DeletionError, SanityCheckFailed {
        this.getOperator().deleteDrop(iNetCircuitEnd);
        if (this.state == 3 && this.numRoutedPaths() == 0) {
            this.setState(2);
            Object object = this.entitiesLockObject;
            synchronized (object) {
                this.updateUpsrEntities(true);
            }
        }
    }

    protected void addRoutedSpan(NetCircuitSpan netCircuitSpan, eSpanDirection eSpanDirection2) {
        this.addSpan(netCircuitSpan, eSpanDirection2);
        if (this.state != 0) {
            this.setState(3);
        }
    }

    protected int removeRoutedSpan(NetCircuitSpan netCircuitSpan, eSpanDirection eSpanDirection2) {
        this.removeSpan(netCircuitSpan, eSpanDirection2);
        if (this.state == 3 && this.numRoutedPaths() == 0) {
            this.setState(2);
        }
        this.setupConnListOnCreation();
        return this.countNumInputs() + this.countNumOutputs() + this.countNumOmniSpans() + (this.nodeDrop != null ? 1 : 0);
    }

    protected void addActiveSpan(NetCircuitSpan netCircuitSpan, eSpanDirection eSpanDirection2) {
        NetCircuitNode netCircuitNode = null;
        List list = this.circuit.getCircuitNodeFromNE(this.getNetElement());
        if (list != null) {
            if (list.size() > 1) {
                Iterator iterator = list.iterator();
                NetCircuitNode netCircuitNode2 = null;
                boolean bl = false;
                while (iterator.hasNext()) {
                    DualConnectionCircuitNode dualConnectionCircuitNode;
                    netCircuitNode2 = (NetCircuitNode)iterator.next();
                    if (!netCircuitNode2.hasDualConnections() || !(dualConnectionCircuitNode = (DualConnectionCircuitNode)netCircuitNode2).getFstCircuitNode().equals(this) && !dualConnectionCircuitNode.getSecCircuitNode().equals(this)) continue;
                    bl = true;
                    break;
                }
                netCircuitNode = bl ? netCircuitNode2 : this;
            } else {
                netCircuitNode = (NetCircuitNode)list.get(0);
            }
        }
        if (netCircuitNode != null && netCircuitNode.hasDualConnections()) {
            netCircuitNode.addActiveSpan(netCircuitSpan, eSpanDirection2);
            return;
        }
        if (this.dbgOn()) {
            db.println("Adding active span for circuit " + this.circuit.getCircuitName() + " " + NetCircuit.prettyString(this.circuit.getCircuitId()) + " at node " + this.getNameAndClass());
        }
        this.addSpan(netCircuitSpan, eSpanDirection2);
        this.circuit.addActiveSpan(netCircuitSpan);
        this.removeActiveEndpoint(netCircuitSpan);
        this.setupConnListOnDiscovery();
    }

    protected void removeActiveEndpoint(NetCircuitSpan netCircuitSpan) {
        int n = netCircuitSpan.getEntityIndex(this.ne);
        if (netCircuitSpan.isInternalSpan()) {
            n = netCircuitSpan.getInternalEntityIndex(this);
        }
        IHoNum iHoNum = netCircuitSpan.getHoNum(this.ne);
        ILoNum iLoNum = netCircuitSpan.getLoNum();
        HoLoComparator hoLoComparator = HoLoComparator.instance();
        Iterator iterator = this.sources.iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
                if (netCircuitEnd.getEntityIndex() != n || iHoNum != null && !hoLoComparator.isEqual(iHoNum, netCircuitEnd.getHoNum()) || iLoNum != null && !hoLoComparator.isEqual(iLoNum, netCircuitEnd.getLoNum())) continue;
                if (netCircuitEnd.isTl1LapCktEnd()) {
                    if (!this.dbgOn()) continue;
                    db.println("Skipping LAP ckt end " + netCircuitEnd.prettyString());
                    continue;
                }
                if (this.dbgOn()) {
                    db.println("Removing active ckt end " + netCircuitEnd.prettyString());
                }
                iterator.remove();
                return;
            }
            iterator = this.drops.iterator();
        }
    }

    protected void disposeActiveSpan(NetCircuitSpan netCircuitSpan) {
        this.disposeActiveSpan(netCircuitSpan, false);
        this.circuit.disposeActiveSpan(netCircuitSpan);
    }

    protected void disposeActiveSpan(NetCircuitSpan netCircuitSpan, boolean bl) {
        block7: {
            eSpanDirection eSpanDirection2;
            if (this.dbgOn()) {
                db.println("disposeActiveSpan at " + this.getName());
            }
            if ((eSpanDirection2 = this.findDir(netCircuitSpan)) == null) {
                if (this.dbgOn()) {
                    db.println("disposeActiveSpan: span not found at " + this.getName());
                }
                return;
            }
            this.removeSpan(netCircuitSpan, eSpanDirection2);
            if (this.circuit.getState() == 2 || bl) {
                return;
            }
            NetCircuitEnd netCircuitEnd = this.getSpanEndpoint(netCircuitSpan);
            if (this.dbgOn()) {
                db.println("disposeActiveSpan: spanEnd entityIdx = " + Integer.toHexString(netCircuitEnd.getEntityIndex()));
            }
            try {
                this.createSpliceListener(netCircuitEnd, eSpanDirection2);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!this.dbgOn()) break block7;
                this.debug("disposeActiveSpan() createSpliceListener failed but dispose continues: " + abstractCmsIOException.getMessage());
            }
        }
    }

    protected void createSpliceListener(NetCircuitEnd netCircuitEnd, eSpanDirection eSpanDirection2) {
        this.createSpliceListener(netCircuitEnd);
    }

    public NetCircuitEnd getSpanEndpoint(NetCircuitSpan netCircuitSpan) {
        NetCircuitEnd netCircuitEnd = null;
        netCircuitEnd = netCircuitSpan.isInternalSpan() ? new NetCircuitEnd(this.ne.getNodeId(), netCircuitSpan.getInternalEntityIndex(this), netCircuitSpan.getInternalHoNum(this), netCircuitSpan.getLoNum(), false) : new NetCircuitEnd(this.ne.getNodeId(), netCircuitSpan.getEntityIndex(this.ne), netCircuitSpan.getHoNum(this.ne), netCircuitSpan.getLoNum(), false);
        NetCircuitEnd netCircuitEnd2 = this.getConnectionPathEnd(netCircuitEnd = NetCircuitEndFactory.convertCircuitEnd(this, netCircuitEnd));
        if (netCircuitEnd2 != null) {
            return netCircuitEnd2;
        }
        return netCircuitEnd;
    }

    protected NetCircuitEnd getSpliceListenerEndpoint(SpliceListenerEntry spliceListenerEntry) {
        NetCircuitEnd netCircuitEnd = new NetCircuitEnd(spliceListenerEntry.spliceLinkIndex.ne.getNodeId(), spliceListenerEntry.spliceLinkIndex.entityIndex, spliceListenerEntry.spliceListener.hoNum, spliceListenerEntry.spliceListener.loNum, false);
        NetCircuitEnd netCircuitEnd2 = this.getConnectionPathEnd(netCircuitEnd = NetCircuitEndFactory.convertCircuitEnd(this, netCircuitEnd));
        if (netCircuitEnd2 != null) {
            return netCircuitEnd2;
        }
        if (this.dbgOn()) {
            this.debug("WARNING: Could not find connection path end for spliceListener");
        }
        return netCircuitEnd;
    }

    protected NetCircuitEnd getConnectionPathEnd(NetCircuitEnd netCircuitEnd) {
        NetCircuitEnd netCircuitEnd22 = null;
        int n = netCircuitEnd.getPathIdentifier();
        List list = this.getConnectionPathEnds();
        boolean bl = false;
        for (NetCircuitEnd netCircuitEnd22 : list) {
            netCircuitEnd.setPathIdentifier(netCircuitEnd22.getPathIdentifier());
            if (!netCircuitEnd22.equals(netCircuitEnd)) continue;
            bl = true;
            break;
        }
        netCircuitEnd.setPathIdentifier(n);
        if (bl) {
            return netCircuitEnd22;
        }
        return null;
    }

    protected void addSpan(NetCircuitSpan netCircuitSpan, eSpanDirection eSpanDirection2) {
        if (this.dbgOn()) {
            db.print("addSpan: adding " + netCircuitSpan.prettyString() + " to " + this.getName());
        }
        if (eSpanDirection2 == eSpanDirection.TERMINATING) {
            if (!this.inSpans.contains(netCircuitSpan)) {
                this.inSpans.add(netCircuitSpan);
            }
            if (this.dbgOn()) {
                db.println(", inSpanSize = " + this.inSpans.size());
            }
        } else if (eSpanDirection2 == eSpanDirection.ORIGINATING) {
            if (!this.outSpans.contains(netCircuitSpan)) {
                this.outSpans.add(netCircuitSpan);
            }
            if (this.dbgOn()) {
                db.println(", outSpanSize = " + this.outSpans.size());
            }
        } else if (eSpanDirection2 == eSpanDirection.BIDIRECTIONAL) {
            if (!this.biSpans.contains(netCircuitSpan)) {
                this.biSpans.add(netCircuitSpan);
            }
            if (this.dbgOn()) {
                db.println(", biSpanSize = " + this.biSpans.size());
            }
        } else if (this.dbgOn()) {
            db.println(", FAILURE!!: unknown span direction");
        }
    }

    protected void removeSpan(NetCircuitSpan netCircuitSpan, eSpanDirection eSpanDirection2) {
        if (this.dbgOn()) {
            db.print("removeSpan: removing " + netCircuitSpan.prettyString() + " from " + this.getName());
        }
        if (eSpanDirection2 == eSpanDirection.TERMINATING) {
            this.inSpans.remove(netCircuitSpan);
            if (this.dbgOn()) {
                db.println(", inSpanSize = " + this.inSpans.size());
            }
        } else if (eSpanDirection2 == eSpanDirection.ORIGINATING) {
            this.outSpans.remove(netCircuitSpan);
            if (this.dbgOn()) {
                db.println(", outSpanSize = " + this.outSpans.size());
            }
        } else if (eSpanDirection2 == eSpanDirection.BIDIRECTIONAL) {
            this.biSpans.remove(netCircuitSpan);
            if (this.dbgOn()) {
                db.println(", biSpanSize = " + this.biSpans.size());
            }
        } else if (this.dbgOn()) {
            db.println(", FAILURE!!: unknown span direction");
        }
    }

    protected void conformToCircuitInfo() {
        Object[] objectArray;
        if (this.dbgOn()) {
            db.println("conformToCircuitInfo @ Node " + this.getName());
        }
        if (this.getConn() == null) {
            return;
        }
        try {
            objectArray = this.getPathsFromConnModel();
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            return;
        }
        this.sources.clear();
        this.drops.clear();
        for (int i = 0; i < objectArray.length; ++i) {
            NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), objectArray[i]);
            this.isCircuitInfoSourceOrDrop(netCircuitEnd);
        }
        this.setCircuitInfoNodeDrop();
        this.setupConnListOnDiscovery();
    }

    public abstract void setConnectionCircuitId(ICircuitId var1);

    public abstract ICircuitId getConnectionCircuitId();

    protected boolean completeCheck() {
        int n = this.countNumInputs() + this.countNumOutputs() + this.countNumOmniSpans();
        if (this.dbgOn()) {
            db.println("completeCheck for ckt " + NetCircuit.prettyString(this.circuit.getCircuitId()) + " at node " + this.getName() + " in = " + this.countNumInputs() + " out = " + this.countNumOutputs() + " omni = " + this.countNumOmniSpans() + ": In+Out+Omni=" + n + ", numberOfPaths=" + this.numberOfPaths);
        }
        if (n == this.numberOfPaths) {
            if (this.dbgOn()) {
                db.println("completeCheck passed");
            }
            return true;
        }
        return false;
    }

    protected int sanityCheck() throws SanityCheckFailed {
        return this.getOperator().sanityCheck();
    }

    protected boolean isOpenEndedSelector() {
        return this.isUpsrSelectorConn() && (this.circuit.isBidirectional() && this.drops.size() == 2 || this.sources.size() == 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getWorkingSpans() {
        List list = null;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        if (!this.hasConnection()) {
            return linkedList;
        }
        if (!this.isUpsrSelector()) {
            return linkedList;
        }
        Object object2 = this.entitiesLockObject;
        synchronized (object2) {
            if (this.workingEntities == null || this.circuit.getState() == 11) {
                this.updateUpsrEntities(false);
            }
            list = this.workingEntities;
        }
        for (Object object2 : this.getAllSpans().keySet()) {
            if (!list.contains(new Integer(((NetCircuitSpan)object2).getEntityIndex(this.ne)))) continue;
            linkedList.add(object2);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getProtectSpans() {
        List list = null;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        if (!this.hasConnection()) {
            return linkedList;
        }
        if (!this.isUpsrSelector()) {
            return linkedList;
        }
        Object object2 = this.entitiesLockObject;
        synchronized (object2) {
            if (this.protectEntities == null || this.circuit.getState() == 11) {
                this.updateUpsrEntities(false);
            }
            list = this.protectEntities;
        }
        for (Object object2 : this.getAllSpans().keySet()) {
            if (!list.contains(new Integer(((NetCircuitSpan)object2).getEntityIndex(this.ne)))) continue;
            linkedList.add(object2);
        }
        return linkedList;
    }

    public List getActiveSpans() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isUpsrSpanActive(NetCircuitSpan netCircuitSpan) {
        Object object;
        List list = null;
        if (!this.hasConnection()) {
            return false;
        }
        if (!this.isNodeRefValid) {
            return false;
        }
        Object object2 = this.entitiesLockObject;
        synchronized (object2) {
            if (this.activeEntities == null) {
                this.updateUpsrActiveEntities();
            }
            list = this.activeEntities;
        }
        if (list != null && list.contains(new Integer(netCircuitSpan.getEntityIndex(this.ne)))) {
            return true;
        }
        if (NetCircuitNodeUtil.isUpsrBridgeConnType(this.connType, this.countNumOutputs())) {
            return false;
        }
        if (this.connType == 6) {
            object2 = this.getWorkingSpans();
            object = this.getProtectSpans();
            if (!object2.contains(netCircuitSpan) && !object.contains(netCircuitSpan)) {
                return false;
            }
        }
        object2 = null;
        object = this.findAlternateBiSpan(netCircuitSpan);
        if (object != null) {
            object2 = this.spanGetPeer((NetCircuitSpan)object);
        }
        if (object2 == null) {
            if (this.dbgOn()) {
                db.println("Warning! isUpsrSpanActive: peer Node not found");
            }
            return true;
        }
        if (this.dbgOn()) {
            db.println("peernode " + ((NetCircuitNode)object2).getName());
        }
        return ((NetCircuitNode)object2).isUpsrSpanActive((NetCircuitSpan)object);
    }

    protected boolean isAnyChangeInUpsrSelector() {
        if (this.dbgOn()) {
            db.println("isAnyChangeInUpsrSelector: circuit = " + this.circuit.getCircuitName() + " at " + this.getName());
        }
        if (!this.hasConnection()) {
            return false;
        }
        if (!this.isUpsrSelector()) {
            return false;
        }
        int n = -1;
        Object[] objectArray = this.getActivePathsFromConnModel();
        int n2 = this.getProtectionOpFromConnModel();
        if (this.connType == 3 || this.connType == 11 || this.connType == 13) {
            n = this.getReverseProtectionOpFromConnModel();
        }
        return this.isAnyChangeInUpsrSelector(objectArray, n2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAnyChangeInUpsrSelector(Object[] objectArray, int n, int n2) {
        boolean bl = false;
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        if (this.dbgOn()) {
            db.println("newProtectionOp =" + n + " oldProtectionOp =" + this.protectionOp + " newReverseProtectionOp =" + n2 + " oldReverseProtectionOp =" + this.reverseProtectionOp);
        }
        if (this.dbgOn()) {
            db.println("Checking for active paths");
        }
        Iterator<Object> iterator = Arrays.asList(objectArray).iterator();
        while (iterator.hasNext()) {
            int n3 = this.getEntityIndexFromPathDef(iterator.next());
            linkedList.add(new Integer(n3));
            if (!this.dbgOn()) continue;
            db.println("  active path: " + Integer.toHexString(n3));
        }
        boolean bl2 = false;
        Object object = this.entitiesLockObject;
        synchronized (object) {
            if (this.activeEntities == null) {
                this.activeEntities = linkedList;
                bl2 = true;
            }
            if (this.protectionOp != n) {
                this.protectionOp = n;
                if (!bl2) {
                    bl2 = true;
                }
            }
            if (this.reverseProtectionOp != n2) {
                this.reverseProtectionOp = n2;
                if (!bl2) {
                    bl2 = true;
                }
            }
            LinkedList linkedList2 = new LinkedList();
            linkedList2.addAll(this.activeEntities);
            if (linkedList.size() != linkedList2.size()) {
                if (this.dbgOn()) {
                    db.println("active entities have changed: " + linkedList2.size() + " -> " + linkedList.size());
                }
                bl2 = true;
                bl = true;
            } else {
                for (int i = 0; i < linkedList.size(); ++i) {
                    if (((Integer)linkedList.get(i)).compareTo((Integer)linkedList2.get(i)) == 0) continue;
                    bl2 = true;
                    bl = true;
                    if (!this.dbgOn()) continue;
                    db.println("active entity changed: " + Integer.toHexString((Integer)linkedList2.get(i)) + " -> " + Integer.toHexString((Integer)linkedList.get(i)));
                }
            }
        }
        if (bl2) {
            if (this.dbgOn()) {
                db.println("isAnyChangeInUpsrSelector: Circuit Changed");
            }
            this.circuit.setChanged();
            if (bl) {
                object = this.entitiesLockObject;
                synchronized (object) {
                    this.activeEntities = (LinkedList)linkedList.clone();
                }
            }
            return bl;
        }
        if (this.dbgOn()) {
            db.println("isAnyChangeInUpsrSelector: Nothing changed, returning false");
        }
        return false;
    }

    protected boolean isAnyChangeInEtherStpState() {
        return false;
    }

    protected void updateUpsrActiveEntities() {
        if (!this.hasConnection()) {
            return;
        }
        if (!this.isUpsrSelector()) {
            return;
        }
        if (this.dbgOn()) {
            db.println("Updating the active entities at " + this.getName());
        }
        if (this.getConn() != null) {
            Object[] objectArray = this.getActivePathsFromConnModel();
            this.updateUpsrActiveEntities(objectArray);
        } else if (this.dbgOn()) {
            db.println("Connection object not found");
        }
    }

    private void updateUpsrActiveEntities(Object[] objectArray) {
        this.activeEntities = new LinkedList();
        Iterator<Object> iterator = Arrays.asList(objectArray).iterator();
        while (iterator.hasNext()) {
            int n = this.getEntityIndexFromPathDef(iterator.next());
            this.activeEntities.add(new Integer(n));
            if (!this.dbgOn()) continue;
            db.println("  active path: " + Integer.toHexString(n));
        }
    }

    protected void updateUpsrEntities(boolean bl) {
        if (!this.hasConnection()) {
            return;
        }
        if (!this.isUpsrSelector()) {
            return;
        }
        if (this.dbgOn()) {
            // empty if block
        }
        Object[] objectArray = this.getPathsFromConnModel();
        this.updateUpsrEntities(objectArray, bl);
    }

    private void updateUpsrEntities(Object[] objectArray, boolean bl) {
        this.workingEntities = new LinkedList();
        this.protectEntities = new LinkedList();
        if (objectArray.length == 0) {
            if (this.dbgOn()) {
                db.println("paths array is null");
            }
            return;
        }
        switch (this.connType) {
            case 2: 
            case 5: 
            case 6: {
                this.workingEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[0])));
                this.protectEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[1])));
                break;
            }
            case 3: {
                this.workingEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[0])));
                this.protectEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[1])));
                this.workingEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[2])));
                this.protectEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[3])));
                break;
            }
            case 10: {
                this.workingEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[0])));
                this.protectEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[1])));
                break;
            }
            case 11: {
                this.workingEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[0])));
                this.protectEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[1])));
                this.workingEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[2])));
                this.protectEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[3])));
                break;
            }
            case 13: {
                this.protectEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[1])));
                this.protectEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[3])));
                break;
            }
            case 16: {
                this.workingEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[0])));
                this.protectEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[3])));
                break;
            }
            case 15: {
                this.protectEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[3])));
                break;
            }
            case 14: {
                this.workingEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[0])));
                this.protectEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[3])));
                break;
            }
        }
        if (bl) {
            this.updateUpsrActiveEntities();
        }
    }

    protected boolean isOpenEndedOnewayBlsrDriSecondaryDrop() {
        if (this.connections.size() != 1) {
            return false;
        }
        Connection connection = (Connection)this.connections.get(0);
        return connection.isOpenEndedOnewayBlsrDriSecondaryDrop();
    }

    protected boolean hasBlsrDriSelector() {
        Iterator iterator = this.getSelectors().iterator();
        while (iterator.hasNext()) {
            if (!((SelectorConnection)iterator.next()).isBlsrDriSelector()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasInvalidBlsrDriSelector() {
        List list = this.getSelectors();
        for (SelectorConnection selectorConnection : list) {
            if (!selectorConnection.isBlsrDriSelector() || selectorConnection.isValidBlsrDriSelector()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasInvalidOpenEndedOnewayBlsrDri() {
        if (!this.isOpenEndedOnewayBlsrDriSecondaryDrop()) {
            return false;
        }
        if (this.connections.size() != 1) {
            return false;
        }
        Connection connection = (Connection)this.connections.get(0);
        return !connection.isValidOpenEndedOnewayBlsrDriSecondaryDrop();
    }

    protected void findUpsrHeads() {
        List list = this.getSelectors();
        for (SelectorConnection selectorConnection : list) {
            selectorConnection.findUpsrHead();
        }
    }

    private boolean isOnSameBlsrRing(NetCircuitSpan netCircuitSpan, NetCircuitSpan netCircuitSpan2) {
        return netCircuitSpan2 != null && netCircuitSpan != null && netCircuitSpan.availSpan != null && netCircuitSpan2.availSpan != null && netCircuitSpan.getLink().inBLSR() && netCircuitSpan2.getLink().inBLSR() && netCircuitSpan.getLink().blsrRingName(this.getNetElement()).equals(netCircuitSpan2.getLink().blsrRingName(this.getNetElement()));
    }

    protected Connection findConnectionWithOutput(Object object) {
        for (Connection connection : this.connections) {
            Iterator iterator = connection.outPuts.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().equals(object)) continue;
                return connection;
            }
        }
        return null;
    }

    protected Connection findConnectionWithInput(Object object) {
        for (Connection connection : this.connections) {
            Iterator iterator = connection.inPuts.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().equals(object)) continue;
                return connection;
            }
        }
        return null;
    }

    protected SelectorConnection findSelectorWithInput(Object object) {
        for (SelectorConnection selectorConnection : this.getSelectors()) {
            if (!selectorConnection.isInput(object) && !selectorConnection.isExternalInput(object)) continue;
            return selectorConnection;
        }
        return null;
    }

    protected boolean hasSelector() {
        for (Connection connection : this.connections) {
            if (!(connection instanceof SelectorConnection)) continue;
            return true;
        }
        return false;
    }

    protected List getSelectors() {
        LinkedList<Connection> linkedList = new LinkedList<Connection>();
        for (Connection connection : this.connections) {
            if (!connection.isSelector()) continue;
            linkedList.add(connection);
        }
        return linkedList;
    }

    protected boolean hasUnprotectedSelector() {
        Iterator iterator = this.getSelectors().iterator();
        while (iterator.hasNext()) {
            if (((SelectorConnection)iterator.next()).isProtected) continue;
            if (this.dbgOn()) {
                db.println("hasUnprotectedSelectors: unprotected selector found on node " + this.getName());
            }
            return true;
        }
        return false;
    }

    protected boolean hasUnprotectedDrop() {
        Iterator iterator = this.getDrops().iterator();
        if (this.circuit.getCircuitNodes().size() == 1) {
            return false;
        }
        while (iterator.hasNext()) {
            List list;
            NetCircuitSpan netCircuitSpan;
            Connection connection = this.findConnectionWithOutput(iterator.next());
            if (connection == null) {
                if (this.dbgOn()) {
                    db.println("hasUnprotectedDrop: no connection with output on node " + this.getName());
                }
                return true;
            }
            if (connection instanceof SelectorConnection || this.circuit.hasOpenEndedSelector() || connection.isInputLineProtected(netCircuitSpan = (list = connection.getInSpans()).size() == 0 ? null : (NetCircuitSpan)list.get(0))) continue;
            if (this.dbgOn()) {
                db.println("hasUnprotectedDrop: unprotected drop found on node " + this.getName());
            }
            return true;
        }
        return false;
    }

    private ConnectionsFactory getConnectionsFactory() {
        return new ConnectionsFactory(this);
    }

    protected void setupConnListOnCreation() {
        if (this.state == 2) {
            this.setupConnListOnCreation(this.connType);
        } else {
            int n = this.findConnType();
            this.setConnectionType(n);
            this.setupConnListOnCreation(n);
        }
    }

    protected void setupConnListOnCreation(int n) {
        this.connections = this.getConnectionsFactory().setupConnListOnCreation(n);
    }

    protected void setupConnListOnDiscovery() {
        this.connections = this.getConnectionsFactory().setupConnListOnDiscovery(this.getConnectionType());
    }

    protected void addRoutedOutputsToConnList(int n) {
        this.connections = this.getConnectionsFactory().addRoutedOutputsToConnList(n);
    }

    protected void createUpsrOps() {
        this.upsrOps = new NetUpsrOps(this);
    }

    protected NetCircuitSpan findAltSpanForOneway(NetCircuitSpan netCircuitSpan) {
        Object onewayConnection2 = null;
        LinkedList<Connection> linkedList = new LinkedList<Connection>();
        for (Connection connection : this.connections) {
            if (!(connection instanceof OnewayConnection)) continue;
            linkedList.add(connection);
        }
        if (this.dbgOn()) {
            db.println("findAltSpanForOneway found " + linkedList.size() + " oneways on " + this.getName());
        }
        List list = new LinkedList();
        for (OnewayConnection onewayConnection : linkedList) {
            list = onewayConnection.getInSpans();
            for (NetCircuitSpan netCircuitSpan2 : list) {
                if (!netCircuitSpan.equals(netCircuitSpan2)) continue;
                if (this.dbgOn()) {
                    db.println("found matching inspan " + netCircuitSpan2.availSpan.prettyString());
                }
                if (onewayConnection.getOutSpans().size() == 1) {
                    return (NetCircuitSpan)onewayConnection.getOutSpans().get(0);
                }
                if (this.dbgOn()) {
                    db.println("findAltSpanForOneway: returning null");
                }
                return null;
            }
            list = onewayConnection.getOutSpans();
            for (NetCircuitSpan netCircuitSpan2 : list) {
                if (!netCircuitSpan.equals(netCircuitSpan2)) continue;
                if (onewayConnection.getInSpans().size() == 1) {
                    return (NetCircuitSpan)onewayConnection.getInSpans().get(0);
                }
                return null;
            }
        }
        return null;
    }

    protected boolean isInputOfSelector(NetCircuitSpan netCircuitSpan) {
        SelectorConnection selectorConnection = this.findSelectConnForInspan(netCircuitSpan);
        return selectorConnection != null;
    }

    protected SelectorConnection findSelectConnForInspan(NetCircuitSpan netCircuitSpan) {
        Object selectorConnection2 = null;
        LinkedList<Connection> linkedList = new LinkedList<Connection>();
        for (Connection connection : this.connections) {
            if (!(connection instanceof SelectorConnection)) continue;
            linkedList.add(connection);
        }
        List list = new LinkedList();
        for (SelectorConnection selectorConnection : linkedList) {
            list = selectorConnection.getInSpans();
            for (NetCircuitSpan netCircuitSpan2 : list) {
                if (!netCircuitSpan.equals(netCircuitSpan2)) continue;
                return selectorConnection;
            }
        }
        return null;
    }

    protected boolean isInputOfBridge(NetCircuitSpan netCircuitSpan) {
        BridgeConnection bridgeConnection = this.findBridgeConnForInspan(netCircuitSpan);
        return bridgeConnection != null;
    }

    /*
     * WARNING - void declaration
     */
    protected BridgeConnection findBridgeConnForInspan(NetCircuitSpan netCircuitSpan) {
        void var2_3;
        Object bridgeConnection2 = null;
        LinkedList<Connection> linkedList = new LinkedList<Connection>();
        for (Connection connection : this.connections) {
            if (!(connection instanceof BridgeConnection)) continue;
            linkedList.add(connection);
        }
        List list = new LinkedList();
        for (BridgeConnection bridgeConnection : linkedList) {
            list = bridgeConnection.getInSpans();
            for (NetCircuitSpan netCircuitSpan2 : list) {
                if (!netCircuitSpan.equals(netCircuitSpan2)) continue;
                return bridgeConnection;
            }
            Object var2_5 = null;
        }
        return var2_3;
    }

    protected static ICircuitId getConnCircuitId(Object object) {
        if (object instanceof IConnectionModel) {
            return ((IConnectionModel)object).getCircuitId();
        }
        return null;
    }

    public int getConnObjIndex() {
        return this.getConn().getIndex();
    }

    public abstract IConnectionModel getConn();

    protected abstract void setConn(IConnectionModel var1);

    public boolean isUpsr() {
        return this.getUpsrOps() != null;
    }

    public boolean isUpsrSelector() {
        return this.hasConnection() && NetCircuitNodeUtil.isUpsrSelectorConnType(this.connType);
    }

    public boolean isUpsrBridge() {
        return this.hasConnection() && NetCircuitNodeUtil.isUpsrBridgeConnType(this.connType, this.countNumOutputs());
    }

    protected boolean isUpsrSelectorConn() {
        return NetCircuitNodeUtil.isUpsrSelectorConnType(this.findConnType());
    }

    protected boolean isUpsrBridgeConn() {
        return NetCircuitNodeUtil.isUpsrBridgeConnType(this.findConnType(), this.countNumOutputs());
    }

    public boolean upsrBridgeOrSelector() {
        if (this.isUpsrSelector()) {
            return true;
        }
        return this.isUpsrBridge();
    }

    public boolean isNodeRefValid() {
        return this.isNodeRefValid;
    }

    public boolean doesCircuitNodeUseConn(IConnectionModel iConnectionModel) {
        IConnectionModel iConnectionModel2 = this.getConn();
        return iConnectionModel == iConnectionModel2 || iConnectionModel2 != null && iConnectionModel2.equals(iConnectionModel);
    }

    protected boolean isForwardingSpan(NetCircuitSpan netCircuitSpan, NetCircuitNode netCircuitNode) {
        return false;
    }

    protected void handleTl1LoAditDeletion() {
    }

    public void update(IObservable iObservable, Object object) {
        String string = "Unknown";
        if (iObservable instanceof IHoConnectionModel || iObservable instanceof ILoConnectionModel || iObservable instanceof ILoAditModel || iObservable instanceof IOchncConnectionModel || iObservable instanceof IOchccConnectionModel || iObservable instanceof IOchTrailAditModel || iObservable instanceof ISvlanConnectionModel) {
            if (this.dbgOn()) {
                if (iObservable instanceof IHoConnectionModel) {
                    string = "IHoConnectionModel";
                } else if (iObservable instanceof ILoConnectionModel) {
                    string = "ILoConnectionModel";
                } else if (iObservable instanceof ILoAditModel) {
                    string = "ILoAditModel";
                } else if (iObservable instanceof IOchncConnectionModel) {
                    string = "IOchncConnectionModel";
                } else if (iObservable instanceof IOchccConnectionModel) {
                    string = "IOchccConnectionModel";
                } else if (iObservable instanceof IOchTrailAditModel) {
                    string = "IOchTrailAditModel";
                } else if (iObservable instanceof ISvlanConnectionModel) {
                    string = "ISvlanConnectionModel";
                }
            }
            if (((Integer)object).equals(ModelUpdateType.DELETED)) {
                if (this.dbgOn()) {
                    db.println("node.update: type = DELETED (" + string + ") at " + this.getNameAndClass());
                }
                this.updateEvent.deleted = true;
                NetCircuitWatchDog.instance().queueCircuitUpdate(this.circuit, this, "deleted");
                this.printObservers();
                this.notifyObservers(ModelUpdateType.DELETED);
            } else if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
                if (this.dbgOn()) {
                    db.println("node.update: type = CHANGED (" + string + ") at " + this.getNameAndClass());
                }
                this.updateEvent.changed = true;
                NetCircuitWatchDog.instance().queueCircuitUpdate(this.circuit, this, "deleted");
                this.printObservers();
                this.notifyObservers(ModelUpdateType.CHANGED);
            }
        }
    }

    protected void runUpdate() {
        if (!this.isNodeRefValid) {
            return;
        }
        if (this.updateEvent.deleted) {
            if (NetCircuitWatchDog.instance().dumpDb.isEventLogEnabled()) {
                UpdateEventCollector.instance().LogEvent(" NCN: " + this.getName() + " runUpdate  deleted");
            }
            if (this.dbgOn()) {
                db.println("node.runUpdate: type = DELETED at " + this.getNameAndClass() + " for " + this.circuit.getCircuitName());
            }
            this.updateDeleted();
            this.updateEvent.deleted = false;
            this.updateYDeleted();
        } else if (this.updateEvent.changed) {
            if (NetCircuitWatchDog.instance().dumpDb.isEventLogEnabled()) {
                UpdateEventCollector.instance().LogEvent(" NCN: " + this.getName() + " runUpdate changed");
            }
            if (this.dbgOn()) {
                db.println("node.runUpdate: type = CHANGED at " + this.getNameAndClass() + " for " + this.circuit.getCircuitName());
            }
            this.updateChanged();
            this.updateEvent.changed = false;
        }
    }

    protected void updateDeleted() {
        if (this.dbgOn()) {
            db.println("updateDeleted() at " + this.getNameAndClass());
        }
        if (!this.circuit.circuitInfoActive()) {
            if (this.circuit.getCircuitTypeObj().isLAPCircuitType() || this.circuit.getCircuitTypeObj().isTunnelCircuitType()) {
                if (this.dbgOn()) {
                    db.println("TCCU: CktNode " + this.getName() + "DELETED for cktType" + this.circuit.getCircuitType());
                }
                ((HoCcatCircuit)this.circuit).deleteLoTunnelNetLink();
                ((HoCcatCircuit)this.circuit).deleteLAPNetLink();
            } else if (this.circuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
                if (this.dbgOn()) {
                    db.println("CktNode " + this.getName() + "DELETED for cktType" + this.circuit.getCircuitType());
                }
                ((OchncCircuit)this.circuit).deleteOchTrailTunnelNetLink();
            }
            this.handleTl1LoAditDeletion();
        }
        if (NetCcatCircuit.isNullCircuitId(this.getCircuitId()) && this.circuit.isCircuitRefValid()) {
            this.circuit.preserveDeletedConnectionPathEnds(this.getNetElement(), this.getConnectionPathEnds());
        }
        if (this.state == 2 || this.state == 3 || this.state == 4) {
            this.circuit.disposeConnection(this, true);
        } else if (this.state == 1) {
            this.deleteConnectionObserver();
            this.setConn(null);
            this.numberOfPaths = 0;
            this.setState(0);
        } else if (this.state == 0) {
            this.deleteConnectionObserver();
            if (this.getConn() != null) {
                this.deregisterNullCircuitConnection(this.getNetElement(), this.getConn());
            }
            this.setConn(null);
            this.numberOfPaths = 0;
        }
    }

    private void updateChanged() {
        int n;
        int n2;
        if (this.circuit.getState() == 2 || this.circuit.getState() == 0) {
            return;
        }
        if (this.dbgOn()) {
            db.println("Calling NetCircuitNode::updateChanged() to update the Cross Connection");
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.rollHasCompleted;
        try {
            bl = this.updateNumberOfPaths();
            bl2 = this.updateConnectionPathEnds();
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            return;
        }
        ICircuitId iCircuitId = this.getConnectionCircuitId();
        if (this.cktId != null && iCircuitId != null && (this.cktId.getNodeId() != iCircuitId.getNodeId() || this.cktId.getUniquePart().getUniqueId() != iCircuitId.getUniquePart().getUniqueId())) {
            this.cktId = iCircuitId;
            if (this.dbgOn()) {
                this.debug("handleChanges(" + this.getName() + "):" + " cktId changed");
            }
            this.circuit.disposeConnection(this, true);
            NetCircuitWatchDog.instance().reloadConnections(this.ne);
            return;
        }
        this.isAnyChangeInUpsrSelector();
        int n3 = this.getAdminStateFromNE();
        if (this.getAdminState() != n3) {
            if (this.dbgOn()) {
                this.debug("handleChanges(" + this.getName() + "):" + " adminState changed");
            }
            this.setAdminState(n3);
            this.circuit.setChanged();
        }
        if (this.serviceState != (n2 = this.getServiceStateFromNE())) {
            if (this.dbgOn()) {
                this.debug("handleChanges(" + this.getName() + "):" + " serviceState changed");
            }
            this.setServiceState(n2);
            this.circuit.setChanged();
        }
        String string = this.getConnNameFromNE();
        boolean bl4 = false;
        if (this.connName == null && string != null) {
            bl4 = true;
        } else if (!this.connName.equals(string)) {
            bl4 = true;
        }
        if (bl4) {
            String string2;
            String string3 = this.circuit.getCircuitNameFromSrcNode();
            this.connName = string;
            if (this.dbgOn()) {
                this.debug("handleChanges(" + this.getName() + "):" + " connName changed");
            }
            if (!(string2 = this.circuit.getCircuitNameFromSrcNode()).equals(string3)) {
                this.circuit.updateCircuitName(string2);
            }
            this.circuit.setChanged();
        }
        if (this.rollStatusChanged()) {
            if (this.dbgOn()) {
                this.debug("handleChanges(" + this.getName() + "):" + " inRoll flag changed");
            }
            this.updateConnection();
            return;
        }
        if (this.inRoll() && bl3 != this.rollHasCompleted) {
            if (this.dbgOn()) {
                this.debug("handleChanges(" + this.getName() + "):" + " roll has completed");
            }
            this.circuit.setChanged();
        }
        if (this.circuit.getState() == 5 || this.circuit.getState() == 6) {
            if (this.conversionStatusChanged()) {
                this.updateConnection();
                return;
            }
        } else if (this.conversionStatusChanged()) {
            this.setInConnectionConversion(this.inConnectionConversion());
        }
        if (this.connType != (n = this.getConnTypeFromConnModel())) {
            if (this.dbgOn()) {
                this.debug("handleChanges(" + this.getName() + "):" + " connType changed");
            }
            this.updateConnection();
            return;
        }
        if (bl) {
            if (this.dbgOn()) {
                this.debug("handleChanges(" + this.getName() + "):" + " numPaths changed");
            }
            this.updateConnection();
            return;
        }
        if (bl2) {
            if (this.dbgOn()) {
                this.debug("handleChanges(" + this.getName() + "):" + " pathsList changed");
            }
            this.updateConnection();
            return;
        }
        if (this.isAnyChangeInEtherStpState()) {
            this.circuit.setChanged();
        }
    }

    private boolean rollStatusChanged() {
        boolean bl = this.inRoll();
        if (this.currRollStatus != bl) {
            if (this.dbgOn()) {
                db.println("rollStatus changed from " + this.currRollStatus + " to " + bl);
            }
            this.currRollStatus = bl;
            if (!this.currRollStatus) {
                this.rollHasCompleted = false;
            }
            return true;
        }
        return false;
    }

    protected void setCurrRollStatus(boolean bl) {
        this.currRollStatus = bl;
    }

    protected boolean deletedEventPending() {
        return this.updateEvent.deleted;
    }

    protected boolean inRoll() {
        if (this.getConn() != null) {
            boolean bl = false;
            try {
                bl = this.getConn().inRoll();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                return false;
            }
            catch (AbstractMethodError abstractMethodError) {
                return false;
            }
            if (this.dbgOn()) {
                db.println("inRoll: NCN " + this.getName() + " state => " + bl);
            }
            return bl;
        }
        return false;
    }

    protected boolean inConnectionConversion() {
        if (this.node.provides(Feature.ISTU) && this.getConn() != null) {
            boolean bl = false;
            try {
                bl = this.getConn().inConnectionConversion();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                return false;
            }
            catch (AbstractMethodError abstractMethodError) {
                return false;
            }
            if (this.dbgOn()) {
                db.println("inConnectionConversion: NCN " + this.getName() + "state => " + bl);
            }
            return bl;
        }
        return false;
    }

    private boolean conversionStatusChanged() {
        boolean bl = this.inConnectionConversion();
        if (this.currConversionStatus != bl) {
            if (this.dbgOn()) {
                db.println("conversionStatusChanged: old connConv state => " + this.currConversionStatus + ", new connConv " + "state => " + bl);
            }
            this.currConversionStatus = bl;
            return true;
        }
        return false;
    }

    protected void setCurrConversionStatus(boolean bl) {
        this.currConversionStatus = bl;
    }

    protected void setInConnectionConversion(boolean bl) {
        if (bl) {
            this.setState(4);
        } else {
            this.setState(2);
        }
        if (this.dbgOn()) {
            db.println("setInConnectionConversion: state => " + bl);
        }
        this.circuit.setInConnectionConversion(bl);
    }

    protected void setCircuitInfoNodeDrop() {
        NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createNodeDrop(this.circuit.getCircuitType(), this.getNetElement());
        if (this.circuit.isDrop(netCircuitEnd) || this.circuit.isSource(netCircuitEnd)) {
            netCircuitEnd.setStage(4);
            this.insertDrop(netCircuitEnd);
        } else {
            this.nodeDrop = null;
        }
        if (this.getConnTypeFromConnModel() == 18) {
            this.circuit.isDiag(true);
        }
    }

    protected int getDirection(NetCircuitSpan netCircuitSpan) {
        if (this.inSpans.contains(netCircuitSpan) || this.outSpans.contains(netCircuitSpan)) {
            return 0;
        }
        return 1;
    }

    protected boolean myPeerHasDrops(NetCircuitSpan netCircuitSpan) {
        if (this.connType == 2 || this.connType == 4 || this.connType == 0 || this.connType == 3) {
            return false;
        }
        NetCircuitNode netCircuitNode = null;
        NetCircuitSpan netCircuitSpan2 = this.findAlternateBiSpan(netCircuitSpan);
        if (netCircuitSpan2 != null) {
            netCircuitNode = this.spanGetPeer(netCircuitSpan2);
        }
        if (netCircuitNode == null) {
            if (this.dbgOn()) {
                db.println("Warning! getUpsrSpanActive: peer Node not found");
            }
            return false;
        }
        if (netCircuitNode.getDrops().size() != 0) {
            return true;
        }
        return netCircuitNode.myPeerHasDrops(netCircuitSpan2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getUpsrSpanState(NetCircuitSpan netCircuitSpan, int n) {
        if (this.dbgOn()) {
            db.println("getUpsrSpanState called at node " + this.getName() + " with spanState = " + EnumStrings.getString(IUpsrSpanState.class, (int)n));
        }
        int n2 = -1;
        List list = null;
        if (!this.hasConnection()) {
            return 1;
        }
        if (!this.isNodeRefValid) {
            return 1;
        }
        Object object = this.entitiesLockObject;
        synchronized (object) {
            if (this.activeEntities == null) {
                this.updateUpsrActiveEntities();
            }
            list = this.activeEntities;
        }
        object = this.getWorkingSpans();
        List list2 = this.getProtectSpans();
        if (list != null) {
            if (list.contains(new Integer(netCircuitSpan.getEntityIndex(this.ne)))) {
                n2 = 0;
            } else if (object.contains(netCircuitSpan) || list2.contains(netCircuitSpan)) {
                n2 = 1;
            }
        }
        if (n != -1 && n2 != -1 && n2 != n) {
            return 2;
        }
        if (this.connType == 6 && !object.contains(netCircuitSpan) && !list2.contains(netCircuitSpan)) {
            if (n != -1) {
                return n;
            }
            if (n2 != -1) {
                return n2;
            }
            return 3;
        }
        NetCircuitNode netCircuitNode = null;
        NetCircuitSpan netCircuitSpan2 = null;
        BridgeConnection bridgeConnection = this.findBridgeConnForInspan(netCircuitSpan);
        if (bridgeConnection != null) {
            Iterator iterator = bridgeConnection.getOutSpans().iterator();
            while (iterator.hasNext() && (netCircuitSpan2 = (NetCircuitSpan)iterator.next()).isInternalSpan()) {
                netCircuitSpan2 = null;
            }
        } else {
            netCircuitSpan2 = this.findAltSpanForOneway(netCircuitSpan);
        }
        if (netCircuitSpan2 != null) {
            if (this.dbgOn()) {
                db.println("altSpan = " + netCircuitSpan2.availSpan.prettyString());
            }
            netCircuitNode = this.spanGetPeer(netCircuitSpan2);
        } else if (this.dbgOn()) {
            db.println("Warning! getUpsrSpanState: altSpan is null");
        }
        if (netCircuitNode == null) {
            if (this.dbgOn()) {
                db.println("Warning! getUpsrSpanState: peer Node not found");
            }
            if (n != -1) {
                return n;
            }
            if (n2 != -1) {
                return n2;
            }
            if (this.upsrBridgeOrSelector()) {
                if (this.dbgOn()) {
                    db.println("returning UNUSED");
                }
                return 3;
            }
            if (!this.circuit.isBidirectional() && !this.sources.isEmpty()) {
                return 3;
            }
            return 0;
        }
        if (n2 != -1) {
            return netCircuitNode.getUpsrSpanState(netCircuitSpan2, n2);
        }
        return netCircuitNode.getUpsrSpanState(netCircuitSpan2, n);
    }

    protected NetCircuitSpan getSpanFromPathDef(IPathDefModel iPathDefModel) {
        int n = this.getEntityIndexFromPathDef(iPathDefModel);
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.biSpans);
        linkedList.addAll(this.inSpans);
        linkedList.addAll(this.outSpans);
        Iterator iterator = linkedList.iterator();
        NetCircuitSpan netCircuitSpan = null;
        while (iterator.hasNext()) {
            netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (n != netCircuitSpan.getEntityIndex(this.getNetElement())) continue;
            if (this.dbgOn()) {
                db.println("found span corresponding to path : " + netCircuitSpan.prettyString());
            }
            return netCircuitSpan;
        }
        return null;
    }

    public NetCircuitSpan getSpanFromCktEnd(NetCircuitEnd netCircuitEnd) {
        HoLoComparator hoLoComparator = HoLoComparator.instance();
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.biSpans);
        linkedList.addAll(this.inSpans);
        linkedList.addAll(this.outSpans);
        for (NetCircuitSpan netCircuitSpan : linkedList) {
            if (netCircuitEnd.getEntityIndex() != netCircuitSpan.getEntityIndex(this.getNetElement()) || !hoLoComparator.isEqual(netCircuitEnd.getHoNum(), netCircuitSpan.getHoNum(this.getNetElement())) || !hoLoComparator.isEqual(netCircuitEnd.getLoNum(), netCircuitSpan.getLoNum())) continue;
            return netCircuitSpan;
        }
        return null;
    }

    public NetCircuitSpan getInternalSpanFromCktEnd(NetCircuitEnd netCircuitEnd) {
        HoLoComparator hoLoComparator = HoLoComparator.instance();
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.biSpans);
        linkedList.addAll(this.inSpans);
        linkedList.addAll(this.outSpans);
        for (NetCircuitSpan netCircuitSpan : linkedList) {
            if (netCircuitEnd.getEntityIndex() != netCircuitSpan.getInternalEntityIndex(this) || !hoLoComparator.isEqual(netCircuitEnd.getHoNum(), netCircuitSpan.getInternalHoNum(this)) || !hoLoComparator.isEqual(netCircuitEnd.getLoNum(), netCircuitSpan.getLoNum())) continue;
            return netCircuitSpan;
        }
        return null;
    }

    protected NetCircuitSpan findAltSpanForUpsrDri(NetCircuitSpan netCircuitSpan) {
        Object var2_2 = null;
        NetCircuitSpan netCircuitSpan2 = null;
        Object[] objectArray = this.getPathsFromConnModel();
        int n = this.getPathDefIndexFromSpan(netCircuitSpan);
        if (this.connType == 10) {
            switch (n) {
                case 0: {
                    netCircuitSpan2 = this.getSpanFromPathDef((IPathDefModel)objectArray[1]);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    netCircuitSpan2 = this.getSpanFromPathDef((IPathDefModel)objectArray[0]);
                    break;
                }
                default: {
                    if (this.dbgOn()) {
                        db.println("Unknown path index " + n);
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (this.connType == 11) {
            switch (n) {
                case 0: {
                    netCircuitSpan2 = this.getSpanFromPathDef((IPathDefModel)objectArray[1]);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    netCircuitSpan2 = this.getSpanFromPathDef((IPathDefModel)objectArray[3]);
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    if (this.dbgOn()) {
                        db.println("Unknown path index " + n);
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (this.connType == 6) {
            switch (n) {
                case 0: {
                    netCircuitSpan2 = this.getSpanFromPathDef((IPathDefModel)objectArray[1]);
                    break;
                }
                case 1: {
                    netCircuitSpan2 = this.getSpanFromPathDef((IPathDefModel)objectArray[0]);
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    if (!this.dbgOn()) break;
                    db.println("Unknown path index " + n);
                }
            }
        }
        if (this.dbgOn()) {
            db.println("findAltSpanForUpsrDri - " + this.node.getName());
            if (netCircuitSpan2 != null) {
                db.println("span = " + netCircuitSpan2.prettyString());
            } else {
                db.println("span = null");
            }
        }
        return netCircuitSpan2;
    }

    protected int getPathDefIndexFromSpan(NetCircuitSpan netCircuitSpan) {
        Object[] objectArray = this.getPathsFromConnModel();
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            n2 = this.getEntityIndexFromPathDef(objectArray[i]);
            if (n2 == 0 || n2 != netCircuitSpan.getEntityIndex(this.getNetElement()) || netCircuitSpan.getLink().isLOTunnel() && !HoLoComparator.instance().isEqual(this.getHoNumFromPathDef(objectArray[i]), netCircuitSpan.getHoNum(this.getNetElement()))) continue;
            n = i;
            break;
        }
        return n;
    }

    protected int getPathDefIndexFromCktEnd(INetCircuitEnd iNetCircuitEnd) {
        Object[] objectArray = this.getPathsFromConnModel();
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            n2 = this.getEntityIndexFromPathDef(objectArray[i]);
            IHoNum iHoNum = this.getHoNumFromPathDef(objectArray[i]);
            ILoNum iLoNum = this.getLoNumFromPathDef(objectArray[i]);
            if (n2 == 0 || n2 != iNetCircuitEnd.getEntityIndex() || !HoLoComparator.instance().isEqual(iHoNum, iNetCircuitEnd.getHoNum()) || !HoLoComparator.instance().isEqual(iLoNum, iNetCircuitEnd.getLoNum())) continue;
            n = i;
            break;
        }
        return n;
    }

    protected int getUpsrReversionMode() {
        return -1;
    }

    public List getActivePathList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.isUpsrSelector()) {
            Object[] objectArray = this.getActivePathsFromConnModel();
            arrayList.addAll(Arrays.asList(objectArray));
        }
        return arrayList;
    }

    public List getPathList() {
        ArrayList<Object> arrayList;
        block3: {
            arrayList = new ArrayList<Object>();
            if (this.hasConnection()) {
                try {
                    Object[] objectArray = this.getPathsFromConnModel();
                    arrayList.addAll(Arrays.asList(objectArray));
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (!this.dbgOn()) break block3;
                    this.debug("getPathList() getPathsFromConnModel failed: " + abstractCmsIOException.getMessage());
                }
            }
        }
        return arrayList;
    }

    public int getNumberOfPaths() {
        return this.numberOfPaths;
    }

    protected void setNumberOfPaths(int n) {
        this.numberOfPaths = n;
    }

    public boolean getCktNodeStpEnabled() {
        return true;
    }

    protected int countOrigBiSpans() {
        int n = 0;
        for (NetCircuitSpan netCircuitSpan : this.biSpans) {
            if (this.findRoutingDir(netCircuitSpan) != eSpanDirection.ORIGINATING) continue;
            ++n;
        }
        return n;
    }

    protected boolean isUpsrDriConn() {
        return NetCircuitNodeUtil.isUpsrDriConn(this.findConnType());
    }

    public boolean containsCktEnd(NetCircuitEnd netCircuitEnd) {
        List list = this.getPathList();
        Iterator iterator = list.iterator();
        NetCircuitEnd netCircuitEnd2 = null;
        while (iterator.hasNext()) {
            netCircuitEnd2 = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), iterator.next());
            if (!netCircuitEnd2.equals(netCircuitEnd)) continue;
            return true;
        }
        return false;
    }

    public boolean containsCktEndInSourcesOrDrops(NetCircuitEnd netCircuitEnd) {
        LinkedList linkedList = this.sources;
        Iterator iterator = linkedList.iterator();
        NetCircuitEnd netCircuitEnd22 = null;
        while (iterator.hasNext()) {
            netCircuitEnd22 = (NetCircuitEnd)iterator.next();
            if (!netCircuitEnd22.equals(netCircuitEnd)) continue;
            return true;
        }
        linkedList = this.drops;
        for (NetCircuitEnd netCircuitEnd22 : linkedList) {
            if (!netCircuitEnd22.equals(netCircuitEnd)) continue;
            return true;
        }
        return false;
    }

    protected boolean isEgressPoint(NetCircuitEnd netCircuitEnd) {
        List list = this.getEgressPoints();
        if (list.contains(netCircuitEnd)) {
            if (this.dbgOn()) {
                db.println("isEgressPoint returns true for " + netCircuitEnd.prettyString());
            }
            return true;
        }
        if (this.dbgOn()) {
            db.println("isEgressPoint returns false for " + netCircuitEnd.prettyString());
        }
        return false;
    }

    protected boolean isIngressPoint(NetCircuitEnd netCircuitEnd) {
        List list = this.getIngressPoints();
        if (list.contains(netCircuitEnd)) {
            if (this.dbgOn()) {
                db.println("isIngressPoint returns true for " + netCircuitEnd.prettyString());
            }
            return true;
        }
        if (this.dbgOn()) {
            db.println("isIngressPoint returns false for " + netCircuitEnd.prettyString());
        }
        return false;
    }

    public synchronized List getIngressPoints() {
        NetCircuitEnd netCircuitEnd2;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LinkedList linkedList2 = new LinkedList();
        linkedList2.addAll(this.biSpans);
        linkedList2.addAll(this.inSpans);
        NetCircuitSpan netCircuitSpan2 = null;
        INetLink iNetLink = null;
        for (NetCircuitSpan netCircuitSpan2 : linkedList2) {
            Object object;
            iNetLink = netCircuitSpan2.getLink();
            if (iNetLink.getDst() == this.getNetElement()) {
                try {
                    netCircuitEnd2 = iNetLink.getDst().getNodeModel();
                    object = new NetCircuitEnd((INodeModel)netCircuitEnd2, netCircuitEnd2.getEntityTable().getEntityModelByIndex(iNetLink.getDstEntityIndex()), netCircuitSpan2.getDstHoNum(), netCircuitSpan2.getLoNum(), false);
                    if (linkedList.contains(object)) continue;
                    linkedList.add(object);
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                continue;
            }
            if (iNetLink.getSrc() != this.getNetElement() || !NetCircuitRollOperator.isDriSpan(this, netCircuitSpan2)) continue;
            try {
                netCircuitEnd2 = iNetLink.getSrc().getNodeModel();
                object = new NetCircuitEnd((INodeModel)netCircuitEnd2, netCircuitEnd2.getEntityTable().getEntityModelByIndex(iNetLink.getSrcEntityIndex()), netCircuitSpan2.getSrcHoNum(), netCircuitSpan2.getLoNum(), false);
                if (linkedList.contains(object)) continue;
                linkedList.add(object);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        netCircuitEnd2 = null;
        for (NetCircuitEnd netCircuitEnd2 : this.sources) {
            if (linkedList.contains(netCircuitEnd2)) continue;
            linkedList.add(netCircuitEnd2);
        }
        if (this.dbgOn()) {
            db.println("getIngressPoints @ " + this.getName() + " returns: " + linkedList);
        }
        return linkedList;
    }

    public synchronized List getEgressPoints() {
        NetCircuitEnd netCircuitEnd2;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LinkedList linkedList2 = new LinkedList();
        linkedList2.addAll(this.biSpans);
        linkedList2.addAll(this.outSpans);
        NetCircuitSpan netCircuitSpan2 = null;
        INetLink iNetLink = null;
        for (NetCircuitSpan netCircuitSpan2 : linkedList2) {
            Object object;
            iNetLink = netCircuitSpan2.getLink();
            if (iNetLink.getSrc() == this.getNetElement()) {
                try {
                    netCircuitEnd2 = iNetLink.getSrc().getNodeModel();
                    object = new NetCircuitEnd((INodeModel)netCircuitEnd2, netCircuitEnd2.getEntityTable().getEntityModelByIndex(iNetLink.getSrcEntityIndex()), netCircuitSpan2.getSrcHoNum(), netCircuitSpan2.getLoNum(), false);
                    if (linkedList.contains(object)) continue;
                    linkedList.add(object);
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                continue;
            }
            if (iNetLink.getDst() != this.getNetElement() || !NetCircuitRollOperator.isDriSpan(this, netCircuitSpan2)) continue;
            try {
                netCircuitEnd2 = iNetLink.getDst().getNodeModel();
                object = new NetCircuitEnd((INodeModel)netCircuitEnd2, netCircuitEnd2.getEntityTable().getEntityModelByIndex(iNetLink.getDstEntityIndex()), netCircuitSpan2.getDstHoNum(), netCircuitSpan2.getLoNum(), false);
                if (linkedList.contains(object)) continue;
                linkedList.add(object);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        netCircuitEnd2 = null;
        for (NetCircuitEnd netCircuitEnd2 : this.drops) {
            if (linkedList.contains(netCircuitEnd2)) continue;
            linkedList.add(netCircuitEnd2);
        }
        if (this.dbgOn()) {
            db.println("getEgressPoints @ " + this.getName() + " returns: " + linkedList);
        }
        return linkedList;
    }

    protected HashMap getAllSpans() {
        HashMap<NetCircuitSpan, eSpanDirection> hashMap = new HashMap<NetCircuitSpan, eSpanDirection>();
        Iterator iterator = this.inSpans.iterator();
        while (iterator.hasNext()) {
            hashMap.put((NetCircuitSpan)iterator.next(), eSpanDirection.TERMINATING);
        }
        iterator = this.outSpans.iterator();
        while (iterator.hasNext()) {
            hashMap.put((NetCircuitSpan)iterator.next(), eSpanDirection.ORIGINATING);
        }
        iterator = this.biSpans.iterator();
        while (iterator.hasNext()) {
            hashMap.put((NetCircuitSpan)iterator.next(), eSpanDirection.BIDIRECTIONAL);
        }
        return hashMap;
    }

    public List getAllSpansList() {
        LinkedList<NetCircuitSpan> linkedList = new LinkedList<NetCircuitSpan>();
        Iterator iterator = this.inSpans.iterator();
        while (iterator.hasNext()) {
            linkedList.add((NetCircuitSpan)iterator.next());
        }
        iterator = this.outSpans.iterator();
        while (iterator.hasNext()) {
            linkedList.add((NetCircuitSpan)iterator.next());
        }
        iterator = this.biSpans.iterator();
        while (iterator.hasNext()) {
            linkedList.add((NetCircuitSpan)iterator.next());
        }
        return linkedList;
    }

    protected HashMap getSpansRoutingDirMap() {
        HashMap<NetCircuitSpan, eSpanDirection> hashMap = new HashMap<NetCircuitSpan, eSpanDirection>();
        for (NetCircuitSpan netCircuitSpan : this.inSpans) {
            hashMap.put(netCircuitSpan, eSpanDirection.TERMINATING);
        }
        for (NetCircuitSpan netCircuitSpan : this.outSpans) {
            hashMap.put(netCircuitSpan, eSpanDirection.ORIGINATING);
        }
        for (NetCircuitSpan netCircuitSpan : this.biSpans) {
            hashMap.put(netCircuitSpan, this.findRoutingDir(netCircuitSpan));
        }
        return hashMap;
    }

    public boolean involvedInUpsr(INetCircuitEnd iNetCircuitEnd) {
        NetCircuitSpan netCircuitSpan = this.getSpanFromCktEnd((NetCircuitEnd)iNetCircuitEnd);
        return netCircuitSpan != null && netCircuitSpan.isUpsr();
    }

    protected short getPathWidth() {
        return this.pathWidth;
    }

    public boolean hasLoopback() {
        boolean bl = false;
        if (this.getConn() != null && this.getNodeModel().provides(Feature.HASLPBK_IFACE)) {
            bl = this.getConn().hasLoopback();
        }
        return bl;
    }

    public boolean hasXcLoopback() {
        return false;
    }

    protected void registerNullCircuitConnection(INetElement iNetElement, Object object) {
        if (!this.registeredNullCircuitConnection) {
            TL1ObjectManager.instance().registerTL1Object(iNetElement, object, this);
            this.registeredNullCircuitConnection = true;
        }
    }

    protected void deregisterNullCircuitConnection(INetElement iNetElement, Object object) {
        if (this.registeredNullCircuitConnection) {
            TL1ObjectManager.instance().deregisterTL1Object(iNetElement, object);
            this.registeredNullCircuitConnection = false;
        }
    }

    public boolean areNodesEqual(INetCircuitNode iNetCircuitNode) {
        if (!this.getCircuit().equals(iNetCircuitNode.getCircuit())) {
            return false;
        }
        return this.getNetElement().equals(iNetCircuitNode.getNetElement());
    }

    protected NetCircuitEnd getLinkEndpoint(INetLink iNetLink) {
        NetCircuitEnd netCircuitEnd = null;
        for (SpliceListenerEntry spliceListenerEntry : this.spliceListeners) {
            IEntityModel iEntityModel;
            SpliceLinkIndex spliceLinkIndex = spliceListenerEntry.spliceLinkIndex;
            SpliceListener spliceListener = spliceListenerEntry.spliceListener;
            if ((spliceLinkIndex.ne.getNodeId() != iNetLink.getSrc().getNodeId() || spliceLinkIndex.entityIndex != iNetLink.getSrcEntityIndex() || (iNetLink.isLOTunnel() || iNetLink.isLAP()) && !HoLoComparator.instance().isEqual(spliceListener.hoNum, iNetLink.getSrcHo())) && (spliceLinkIndex.ne.getNodeId() != iNetLink.getDst().getNodeId() || spliceLinkIndex.entityIndex != iNetLink.getDstEntityIndex() || (iNetLink.isLOTunnel() || iNetLink.isLAP()) && !HoLoComparator.instance().isEqual(spliceListener.hoNum, iNetLink.getDstHo()))) continue;
            INodeModel iNodeModel = this.getNodeModel();
            if (iNodeModel == null) {
                if (!this.dbgOn()) continue;
                db.println("getSpliceListener: the reference to node model of " + this.getName() + " is null!?");
                continue;
            }
            try {
                iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(spliceLinkIndex.entityIndex);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                iEntityModel = null;
            }
            if (iEntityModel == null) continue;
            netCircuitEnd = spliceListener.loNum == null ? new HoCircuitEnd(iNodeModel, iEntityModel, spliceListener.hoNum, null, false) : new LoCircuitEnd(iNodeModel, iEntityModel, spliceListener.hoNum, spliceListener.loNum, false);
            return netCircuitEnd;
        }
        return netCircuitEnd;
    }

    protected SpliceListenerEntry getSpliceListener(INetCircuitEnd iNetCircuitEnd, boolean bl) {
        for (SpliceListenerEntry spliceListenerEntry : this.spliceListeners) {
            NetCircuitEnd netCircuitEnd = this.getSpliceListenerEndpoint(spliceListenerEntry);
            if (!netCircuitEnd.equals(iNetCircuitEnd) || spliceListenerEntry.spliceListener.loAdit != bl || !this.getConnectionPathEnds().contains(iNetCircuitEnd)) continue;
            return spliceListenerEntry;
        }
        return null;
    }

    protected boolean isIngressOnXm() {
        return false;
    }

    protected boolean hasDualConnections() {
        return false;
    }

    public List getUpsrConns() {
        LinkedList<IConnectionModel> linkedList = new LinkedList<IConnectionModel>();
        if (this.isUpsrSelector()) {
            linkedList.add(this.getConn());
        }
        return linkedList;
    }

    protected boolean onXm() {
        return false;
    }

    protected boolean onXm(int n) {
        block4: {
            if (Feature.provides((INodeModel)this.getNodeModel(), (Feature)Feature.DS3XM12)) {
                try {
                    if (this.getEntityModel(n).onPortlessPort()) {
                        return true;
                    }
                }
                catch (ObjNotFound objNotFound) {
                    if (!db.isFinestEnabled()) break block4;
                    SDebug.printStackTrace((Throwable)objNotFound);
                }
            }
        }
        return false;
    }

    protected int getPairedPortlessPort(int n) {
        if (n % 2 == 0) {
            return n + 1;
        }
        return n - 1;
    }

    protected IEntityModel getEntityModel(int n) throws ObjNotFound {
        IEntityModel iEntityModel;
        block4: {
            iEntityModel = null;
            IEntityTableModel iEntityTableModel = null;
            INodeModel iNodeModel = this.getNodeModel();
            if (iNodeModel != null && (iEntityTableModel = this.node.getEntityTable()) != null && n != 0) {
                try {
                    iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.isFinestEnabled()) break block4;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        if (iEntityModel == null) {
            throw new ObjNotFound("The index " + Integer.toHexString(n) + " did not resolve to an entity model.");
        }
        return iEntityModel;
    }

    protected boolean isSrcCoLocatedCktNode() {
        return false;
    }

    protected boolean isDstCoLocatedCktNode() {
        return false;
    }

    protected List getSrcCoLocatedCktEnds() {
        return new LinkedList();
    }

    protected List getDstCoLocatedCktEnds() {
        return new LinkedList();
    }

    public void setInternalSpliceLinkEnds() {
    }

    public void disposeActiveInternalSpliceLink(DualConnectionCircuitNode dualConnectionCircuitNode) {
        if (!this.hasConnection()) {
            return;
        }
        if (this.dbgOn()) {
            this.debug("disposeActiveInternalSpliceLink() at " + this.getNameAndClass());
        }
        for (NetCircuitEnd netCircuitEnd : this.getConnectionPathEnds()) {
            int n;
            block7: {
                if (!netCircuitEnd.onXm() && !dualConnectionCircuitNode.onInternalSpliceLink(netCircuitEnd)) continue;
                try {
                    this.createSpliceListener(netCircuitEnd);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (!this.dbgOn()) break block7;
                    this.debug("disposeActiveInternalSpliceLink() createSpliceListener failed but dispose continues: " + abstractCmsIOException.getMessage());
                }
            }
            if (this.circuit.circuitInfoActive()) continue;
            try {
                n = this.getConnectionPathIndex(netCircuitEnd);
            }
            catch (ConnectionPathNotFound connectionPathNotFound) {
                return;
            }
            eSpanDirection eSpanDirection2 = this.nodeRoutingDir.getPathRoutingDir(n);
            this.assumeSourceOrDrop(eSpanDirection2, netCircuitEnd);
        }
    }

    public void disposeActiveInternalSpliceLink() {
        if (!this.hasConnection()) {
            return;
        }
        if (this.dbgOn()) {
            this.debug("disposeActiveInternalSpliceLink() at " + this.getNameAndClass());
        }
        List list = new LinkedList();
        list = this.getOttInternalSpliceLinkEnds(this);
        for (NetCircuitEnd netCircuitEnd : this.getConnectionPathEnds()) {
            int n;
            if (this.circuit.circuitInfoActive() || !list.contains(netCircuitEnd)) continue;
            try {
                n = this.getConnectionPathIndex(netCircuitEnd);
            }
            catch (ConnectionPathNotFound connectionPathNotFound) {
                return;
            }
            eSpanDirection eSpanDirection2 = this.nodeRoutingDir.getPathRoutingDir(n);
            this.assumeSourceOrDrop(eSpanDirection2, netCircuitEnd);
        }
    }

    private List getOttInternalSpliceLinkEnds(NetCircuitNode netCircuitNode) {
        NetCircuitEnd netCircuitEnd;
        LinkedList<NetCircuitEnd> linkedList = new LinkedList<NetCircuitEnd>();
        Object[] objectArray = netCircuitNode.getPathsFromConnModel();
        if (netCircuitNode instanceof OchncCircuitNode) {
            for (int i = 0; i < objectArray.length; ++i) {
                try {
                    NetCircuitEnd netCircuitEnd2 = NetCircuitEndFactory.createCircuitEndFromConn(netCircuitNode.getNetElement(), objectArray[i]);
                    if (netCircuitEnd2 == null || !OchPortsHelper.isOchPort(netCircuitEnd2.getEntityModel())) continue;
                    linkedList.add(netCircuitEnd2);
                    continue;
                }
                catch (ObjNotFound objNotFound) {
                    if (!db.on()) continue;
                    SDebug.printStackTrace((Throwable)objNotFound);
                }
            }
        } else if (netCircuitNode instanceof OchTrailTunnelNode && objectArray.length > 0 && (netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(netCircuitNode.getNetElement(), objectArray[0])) != null) {
            linkedList.add(netCircuitEnd);
        }
        if (this.dbgOn()) {
            this.debug("getOttInternalSpliceLinkEnds() for " + netCircuitNode.getClass().getName() + " at " + netCircuitNode.getName() + " returning " + linkedList.size() + " int splice link ends");
        }
        return linkedList;
    }

    protected NetCircuitEnd getNodeDrop() {
        return this.nodeDrop;
    }

    protected NetCircuitEnd convertSpliceListenerToSourceOrDrop(eSpanDirection eSpanDirection2) {
        NetCircuitEnd netCircuitEnd = null;
        for (SpliceListenerEntry spliceListenerEntry : this.spliceListeners) {
            block6: {
                eSpanDirection eSpanDirection3;
                if (spliceListenerEntry.spliceListener.loAdit || (eSpanDirection3 = spliceListenerEntry.spliceLinkIndex.direction) != eSpanDirection2 && eSpanDirection3 != eSpanDirection.BIDIRECTIONAL) continue;
                netCircuitEnd = this.getSpliceListenerEndpoint(spliceListenerEntry);
                if (eSpanDirection3 == eSpanDirection.BIDIRECTIONAL) {
                    try {
                        int n = this.getConnectionPathIndex(netCircuitEnd);
                        eSpanDirection eSpanDirection4 = this.nodeRoutingDir.getPathRoutingDir(n);
                        if (eSpanDirection4 != eSpanDirection2 && eSpanDirection4 != eSpanDirection.BIDIRECTIONAL) {
                        }
                        break block6;
                    }
                    catch (ConnectionPathNotFound connectionPathNotFound) {
                        if (!this.dbgOn()) continue;
                        this.debug("convertSpliceListenerToSourceOrDrop(" + this.getName() + "): Path not found");
                    }
                    continue;
                }
            }
            if (this.getInternalSpanFromCktEnd(netCircuitEnd) != null) {
                if (!this.dbgOn()) continue;
                this.debug("convertSpliceListenerToSourceOrDrop:span found for " + netCircuitEnd.prettyString() + " avoiding the same");
                continue;
            }
            netCircuitEnd.setStage(4);
            this.assumeSourceOrDrop(eSpanDirection2, netCircuitEnd);
            this.setupConnListOnDiscovery();
            return netCircuitEnd;
        }
        return null;
    }

    protected static String translateAdminState(int n) {
        return EnumStrings.getString(IAdminState.class, (int)(n + 1));
    }

    protected static String translateServiceState(int n) {
        return EnumStrings.getString(IServiceState.class, (int)(n + 2));
    }

    protected static TDMTerminology getTDMTerminology(INodeModel iNodeModel) {
        TDMTerminology tDMTerminology = null;
        tDMTerminology = iNodeModel != null ? iNodeModel.getTDMTerminology() : NetworkModel.instance().getCmsHostModel().getNodeModel().getTDMTerminology();
        return tDMTerminology;
    }

    public boolean connectionless() {
        return this.getConn() == null;
    }

    public boolean isDriCktEnd(INetCircuitEnd iNetCircuitEnd) {
        return NetCircuitRollOperator.isDriCktEnd(this, iNetCircuitEnd);
    }

    protected boolean isCompletedRollToPath(Object object, IRollModel iRollModel) {
        return false;
    }

    protected boolean dbgOn() {
        return (db.on() || NetCircuitManager.pkgDbgOn()) && !NetCircuitManager.pkgDbgSuppressed();
    }

    protected void debug(String string) {
        db.println(string);
    }

    public void updateYDeleted() {
        if (!(this instanceof HoCircuitNode) && this instanceof LoCircuitNode) {
            ((LoCcatCircuit)this.getCircuit()).updateYCircuit(true);
        }
    }

    private void initYState() {
        this.yState = (this instanceof HoCircuitNode || this instanceof LoCircuitNode) && this.isBidirectionalConnType() && this.isUpsrSelectorConn() && !this.isUpsrDriConn() ? 1 : 0;
    }

    public int getYState() {
        if (this.yState == 0) {
            return this.yState;
        }
        for (Connection connection : this.getSelectors()) {
            if (connection.getSelectorHead() != null) continue;
            return this.yState;
        }
        return 0;
    }

    public void setYState(int n) {
        if (this.yState == 0) {
            return;
        }
        this.yState = n;
    }

    public String toString() {
        return "Node: " + this.getName() + " Conn: " + this.getConnectionType() + "/" + this.getConnName() + " sources : " + this.getSources().size() + " drops : " + this.getDrops().size() + " InSpans :" + this.getInSpans().size() + " OutSpans :" + this.getOutSpans().size();
    }

    private class UpdateEvent {
        public boolean changed;
        public boolean deleted;

        public UpdateEvent() {
            this.init();
        }

        public void init() {
            this.changed = false;
            this.deleted = false;
        }
    }

    public static class NetCircuitNodeByNodeNameComparator
    implements Comparator {
        private static NetCircuitNodeByNodeNameComparator inst = new NetCircuitNodeByNodeNameComparator();

        public static NetCircuitNodeByNodeNameComparator instance() {
            return inst;
        }

        public int compare(Object object, Object object2) {
            int n;
            if (object == null ^ object2 == null) {
                n = object == null ? -1 : 1;
            } else if (object == null && object2 == null) {
                n = 0;
            } else {
                if (!(object instanceof NetCircuitNode)) {
                    n = 1;
                }
                if (!(object2 instanceof NetCircuitNode)) {
                    n = -1;
                }
                String string = ((NetCircuitNode)object).getName();
                String string2 = ((NetCircuitNode)object2).getName();
                n = string == null ? (string2 == null ? 0 : 1) : string.compareTo(string2);
            }
            return n;
        }

        public boolean equals(Object object) {
            return this == object;
        }
    }
}

