/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.ConnectionHasFarendLoopback;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionInTopologyUpgrade;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.DropsExceedMax;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPathDefModel;
import cerent.cms.model.InsufficientBandwidth;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidState;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.model.VcatMemberInvalidState;
import cerent.cms.model.VcatMemberNotOutOfGroup;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.Connection;
import cerent.cms.ncp.ConnectionValidator;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitProvState;
import cerent.cms.ncp.LoTunnelNode;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeUtil;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.PathDefsHolder;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.SelectorConnection;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.route.MemberPrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.ui.NetworkDefaults;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class NetCircuitNodeOperator {
    protected NetCircuitNode node;
    private static final SDebug db = new SDebug("NetCircuitNodeOperator");

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    public NetCircuitNodeOperator(NetCircuitNode netCircuitNode) {
        this.node = netCircuitNode;
    }

    protected abstract void createConnection() throws CircuitProvError;

    protected void createConn(ICircuitId iCircuitId, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, int n, int n2, ArrayList arrayList4, ArrayList arrayList5) throws CircuitProvError, InvalidPath, PathInUse, CTCUserException, InsufficientBandwidth, NoMoreLoCapableHo, ConnectionTypeError, ObjNotFound, InvalidState, AdminStateProvisioningError {
    }

    protected void connLocalDestroy(boolean bl) throws Busy, ConnectionInTestAccess, ConnectionInRoll, ConnectionInTopologyUpgrade, VcatMemberNotOutOfGroup, VcatMemberInvalidState, InvalidPath, WrongInterfaceType, ConnectionHasFarendLoopback {
    }

    protected String getName() {
        return this.node.getName();
    }

    protected NetCcatCircuit getCircuit() {
        return (NetCcatCircuit)this.node.getCircuit();
    }

    protected IConnectionModel getConn() {
        return this.node.getConn();
    }

    protected void cleanupLoAdits() {
    }

    protected void sanityCheckVlan(int n) throws SanityCheckFailed {
    }

    protected int sanityCheck() throws SanityCheckFailed {
        if (NetCircuitNodeOperator.dbgOn()) {
            db.println("sanityCheck: checking node " + this.getName());
        }
        NetCcatCircuit netCcatCircuit = this.getCircuit();
        int n = this.sanityCheckGetConnType();
        boolean bl = false;
        MemberPrefs memberPrefs = netCcatCircuit.getMemberPrefs();
        if (memberPrefs != null && memberPrefs.getDriNodePrefs().size() != 0 && memberPrefs.isBlsrDriNode(this.node.getNetElement())) {
            switch (n) {
                case 0: 
                case 2: 
                case 4: 
                case 6: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    bl = true;
                    if (this.node.getNodeModel().provides(Feature.BLSR_UPSR_DRI)) break;
                    throw new SanityCheckFailed("The node " + this.getName() + " is not capable of BLSR DRI " + "connections.");
                }
            }
        }
        if (netCcatCircuit.getState() == 0 && netCcatCircuit.getDrops().size() == 2 && ((NetCircuitDropInfo)netCcatCircuit.getDrops().get(0)).getNodeId() != ((NetCircuitDropInfo)netCcatCircuit.getDrops().get(1)).getNodeId() && !netCcatCircuit.hasOmniSpans() && !bl) {
            netCcatCircuit.getMarker().markRoutedUpsrRingFromBridge(this.node);
        } else if (netCcatCircuit.getCircuitTypeObj().isLAPCircuitType()) {
            netCcatCircuit.getMarker().markRoutedUpsrRingFromBridge(this.node);
        } else if (NetCircuitNodeUtil.isUpsrSelectorConnType(n)) {
            netCcatCircuit.getMarker().markRoutedUpsrRing(this.node);
        }
        return n;
    }

    protected boolean isDropLinkEndpoint() {
        INetElement iNetElement = this.node.getNetElement();
        Iterator iterator = this.node.getSources().iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
                List list = this.node.getCircuit().getCircuitNodeFromNE(iNetElement);
                if (list == null) continue;
                for (NetCircuitNode netCircuitNode : list) {
                    for (NetCircuitSpan netCircuitSpan : netCircuitNode.getAllSpans().keySet()) {
                        if (netCircuitEnd.getEntityIndex() != netCircuitSpan.getEntityIndex(iNetElement)) continue;
                        return true;
                    }
                }
            }
            iterator = this.node.getDrops().iterator();
        }
        return false;
    }

    protected boolean sanityCheckSelectorDropProtection() {
        for (Connection connection : this.node.connections) {
            if (!(connection instanceof SelectorConnection)) continue;
            SelectorConnection selectorConnection = (SelectorConnection)connection;
            this.getCircuit().getMarker().markSelectorInputPaths(this.node);
            if (selectorConnection.isProtected) continue;
            return false;
        }
        return true;
    }

    protected int sanityCheckGetConnType() throws SanityCheckFailed {
        int n = this.node.getState();
        int n2 = this.node.getConnectionType();
        String string = this.getName();
        NetCcatCircuit netCcatCircuit = this.getCircuit();
        INodeModel iNodeModel = this.node.getNodeModel();
        ConnectionValidator connectionValidator = ConnectionValidator.instance();
        if (NetCircuitNodeOperator.dbgOn()) {
            db.println("sanityCheckGetConnType: finding connection type for node " + string);
        }
        if (n == 2) {
            if (NetCircuitNodeOperator.dbgOn()) {
                db.println("sanityCheck: " + EnumStrings.getString(IConnectionType.class, (int)n2) + " node already active");
            }
            return n2;
        }
        int n3 = n == 1 || n == 3 ? (netCcatCircuit.getCktOperation() == 5 ? this.node.calculateConnectionType() : this.node.findUpgradedConnType()) : this.node.findConnType();
        if (n3 == 22) {
            throw new SanityCheckFailed("The connection type on the node " + string + " is invalid.");
        }
        if (n == 0 && this.node.isOpenEndedSelector()) {
            List list = this.node.getSources();
            List list2 = this.node.getDrops();
            if (list.size() == 2 && !connectionValidator.validateCircuitEndsUnProt(this.node, list)) {
                throw new SanityCheckFailed("The connection on the node " + string + " is invalid.");
            }
            if (list2.size() == 2 && !connectionValidator.validateCircuitEndsUnProt(this.node, list2)) {
                throw new SanityCheckFailed("The connection on the node " + string + " is invalid.");
            }
        }
        if (!netCcatCircuit.isMonitorCircuit()) {
            if (this.isDropLinkEndpoint()) {
                throw new SanityCheckFailed("The source/drop is an endpoint of a network link.");
            }
            if ((netCcatCircuit.getCktNodeListSize() == 1 && netCcatCircuit.getState() == 0 || this.node.countRoutedDrops() > 0 && netCcatCircuit.getState() == 3) && !connectionValidator.validateBLSRTimeSlots(this.node)) {
                throw new SanityCheckFailed("The " + NetCircuitNode.getTDMTerminology(iNodeModel).getRingTerms(1) + " same time slot requirement on the node " + string + " is invalid.");
            }
        }
        this.sanityCheckVlan(n3);
        if (!(n3 != 10 && n3 != 11 || iNodeModel.provides(Feature.UPSR_DRI))) {
            throw new SanityCheckFailed("The node " + string + " is not capable of DRI " + "connections.");
        }
        return n3;
    }

    protected void activate() throws CircuitProvError {
        int n = this.node.getState();
        if (n == 2) {
            return;
        }
        if (NetCircuitNodeOperator.dbgOn()) {
            db.println("Circuit Node Activate. Node " + this.getName());
        }
        if (n == 0) {
            this.createConnection();
        } else {
            this.modifyConnection();
        }
    }

    protected NetCircuitNode getUpsrPeerNode(NetCircuitSpan netCircuitSpan) {
        NetCircuitNode netCircuitNode;
        NetCircuitSpan netCircuitSpan2 = netCircuitSpan;
        if (!NetCircuitNodeUtil.isUpsrSelectorConnType(this.node.findConnType())) {
            return null;
        }
        for (netCircuitNode = this.node.spanGetPeer(netCircuitSpan2); netCircuitNode != null && (!netCircuitNode.isUpsrSelectorConn() || netCircuitNode.isUpsrDriConn()); netCircuitNode = netCircuitNode.spanGetPeer(netCircuitSpan2)) {
            if ((netCircuitSpan2 = netCircuitNode.findAlternateBiSpan(netCircuitSpan2)) != null) {
                continue;
            }
            return null;
        }
        return netCircuitNode;
    }

    protected NetCircuitSpan getUpsrPeerSpan(NetCircuitSpan netCircuitSpan) {
        NetCircuitSpan netCircuitSpan2 = netCircuitSpan;
        if (!NetCircuitNodeUtil.isUpsrSelectorConnType(this.node.findConnType())) {
            return null;
        }
        for (NetCircuitNode netCircuitNode = this.node.spanGetPeer(netCircuitSpan2); netCircuitNode != null && (!netCircuitNode.isUpsrSelectorConn() || netCircuitNode.isUpsrDriConn()); netCircuitNode = netCircuitNode.spanGetPeer(netCircuitSpan2)) {
            if ((netCircuitSpan2 = netCircuitNode.findAlternateBiSpan(netCircuitSpan2)) != null) {
                continue;
            }
            return null;
        }
        return netCircuitSpan2;
    }

    protected void createConnection(ICircuitId iCircuitId) throws CircuitProvError, InvalidPath, PathInUse, CTCUserException, InsufficientBandwidth, NoMoreLoCapableHo, ConnectionTypeError, ObjNotFound, InvalidState, AdminStateProvisioningError {
        int n = this.node.getConnectionType();
        int n2 = this.node.countNumInputs();
        int n3 = this.node.countNumOutputs();
        int n4 = this.node.countNumOmniSpans();
        PathDefsHolder pathDefsHolder = new PathDefsHolder();
        short s = this.node.getPathWidth();
        NetCcatCircuit netCcatCircuit = this.getCircuit();
        List list = this.node.getSources();
        List list2 = this.node.getDrops();
        if (NetCircuitNodeOperator.dbgOn()) {
            db.println("createConnection(" + this.getName() + ") " + "inCount=" + n2 + " outCount=" + n3 + " omniCount " + n4 + " pathWidth " + s);
        }
        if (netCcatCircuit.isBidirectional() && netCcatCircuit.getCircuitNodes().size() == 1 && netCcatCircuit.isDriMemberPref()) {
            NetCircuitEnd netCircuitEnd;
            if (NetCircuitNodeOperator.dbgOn()) {
                db.println("Single node (I)DRI connection at " + this.getName());
            }
            if (list.size() != 2) {
                if (NetCircuitNodeOperator.dbgOn()) {
                    db.println("Need exactly two sources, got " + list.size());
                }
                throw new CircuitProvError("Exactly two sources are required, but " + list.size() + " were returned.");
            }
            NetCircuitEnd netCircuitEnd2 = (NetCircuitEnd)netCcatCircuit.getPrimarySource();
            pathDefsHolder.inPathDefs.add(netCircuitEnd2.getPathDef(s));
            netCircuitEnd2 = (NetCircuitEnd)netCcatCircuit.getSecondarySource();
            pathDefsHolder.omniPathDefs.add(netCircuitEnd2.getPathDef(s));
            pathDefsHolder.omniSpanPos.add(true);
            if (list2.size() > 2 || list2.size() < 1) {
                if (NetCircuitNodeOperator.dbgOn()) {
                    db.println("Invalid number of drops, got " + list2.size());
                }
                throw new CircuitProvError(list2.size() + " drops are not valid.");
            }
            Iterator iterator = list2.iterator();
            if (iterator.hasNext()) {
                netCircuitEnd = (NetCircuitEnd)iterator.next();
                pathDefsHolder.outPathDefs.add(netCircuitEnd.getPathDef(s));
            }
            if (iterator.hasNext()) {
                netCircuitEnd = (NetCircuitEnd)iterator.next();
                pathDefsHolder.omniPathDefs.add(netCircuitEnd.getPathDef(s));
                pathDefsHolder.omniSpanPos.add(false);
                this.node.setConnectionType(11);
            } else {
                this.node.setConnectionType(10);
            }
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && n != 18) {
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
                pathDefsHolder.inPathDefs.add(netCircuitEnd.getPathDef(s));
            }
            for (NetCircuitEnd netCircuitEnd : list2) {
                pathDefsHolder.outPathDefs.add(netCircuitEnd.getPathDef(s, pathDefsHolder.inPathDefs));
            }
        }
        this.fillInPathDefs(pathDefsHolder, netCcatCircuit.getTrafficDir());
        int n5 = pathDefsHolder.inPathDefs.size();
        int n6 = pathDefsHolder.outPathDefs.size();
        int n7 = pathDefsHolder.omniPathDefs.size();
        if (n5 > 2 && NetCircuitNodeOperator.dbgOn()) {
            db.println("Warning! createConnection: inputs > 2");
        }
        this.createConn(iCircuitId, pathDefsHolder.inPathDefs, pathDefsHolder.outPathDefs, pathDefsHolder.omniPathDefs, n5, n6, pathDefsHolder.inUpsrCost, pathDefsHolder.omniSpanPos);
    }

    protected void fillInPathDefs(PathDefsHolder pathDefsHolder, boolean bl) throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo {
        Object object;
        Object object22;
        short s = this.node.getPathWidth();
        NetCcatCircuit netCcatCircuit = this.getCircuit();
        INetElement iNetElement = this.node.getNetElement();
        LinkedList linkedList = this.node.getBiSpans();
        LinkedList linkedList2 = this.node.getOutSpans();
        LinkedList linkedList3 = this.node.getInSpans();
        List list = this.node.getDrops();
        for (Object object22 : linkedList) {
            if (this.node.findRoutingDir((NetCircuitSpan)object22) == eSpanDirection.ORIGINATING) {
                if (this.node.isUpsrSelectorConn() && netCcatCircuit.isBidirectional() && this.node.countOrigBiSpans() == 2 && !this.node.hasBlsrDriSelector() && !netCcatCircuit.getCircuitTypeObj().isLAPCircuitType()) {
                    if (NetCircuitNodeOperator.dbgOn()) {
                        db.println("start on selector node " + this.getName() + " which has 2 outgoing spans");
                    }
                    object = this.getUpsrPeerNode((NetCircuitSpan)object22);
                    NetCircuitSpan netCircuitSpan = this.getUpsrPeerSpan((NetCircuitSpan)object22);
                    if (object != null && netCircuitSpan != null) {
                        LinkedList<NetCircuitSpan> linkedList4 = new LinkedList<NetCircuitSpan>();
                        for (NetCircuitSpan netCircuitSpan2 : ((NetCircuitNode)object).getTermSpans()) {
                            linkedList4.add(netCircuitSpan2);
                        }
                        if (NetCircuitNodeOperator.dbgOn()) {
                            db.println("find the peer selector node " + ((NetCircuitNode)object).getName() + " which has " + linkedList4.size() + " incoming in spans");
                        }
                        int n = linkedList4.indexOf(netCircuitSpan);
                        pathDefsHolder.outPathDefs.ensureCapacity(2);
                        if (pathDefsHolder.outPathDefs.size() == 0) {
                            pathDefsHolder.outPathDefs.add(((NetCircuitSpan)object22).getPathDef(iNetElement, s));
                            pathDefsHolder.outPathDefs.add(((NetCircuitSpan)object22).getPathDef(iNetElement, s));
                        }
                        if (bl) {
                            if (n == 0) {
                                pathDefsHolder.outPathDefs.set(0, ((NetCircuitSpan)object22).getPathDef(iNetElement, s));
                                continue;
                            }
                            if (n != 1) continue;
                            pathDefsHolder.outPathDefs.set(1, ((NetCircuitSpan)object22).getPathDef(iNetElement, s));
                            continue;
                        }
                        if (n == 0) {
                            pathDefsHolder.outPathDefs.set(1, ((NetCircuitSpan)object22).getPathDef(iNetElement, s));
                            continue;
                        }
                        if (n != 1) continue;
                        pathDefsHolder.outPathDefs.set(0, ((NetCircuitSpan)object22).getPathDef(iNetElement, s));
                        continue;
                    }
                    pathDefsHolder.outPathDefs.add(((NetCircuitSpan)object22).getPathDef(iNetElement, s));
                    pathDefsHolder.outUpsrCost.add(new Integer(this.biSpanUpsrCost((NetCircuitSpan)object22)));
                    continue;
                }
                if (((NetCircuitSpan)object22).isInternalSpan() && this.node.getCircuit().getCircuitTypeObj().isSVLANType()) {
                    pathDefsHolder.outPathDefs.add(((NetCircuitSpan)object22).getPathDef(this.node, s));
                    continue;
                }
                pathDefsHolder.outPathDefs.add(((NetCircuitSpan)object22).getPathDef(iNetElement, s));
                continue;
            }
            if (this.node.findRoutingDir((NetCircuitSpan)object22) == eSpanDirection.TERMINATING) {
                if (((NetCircuitSpan)object22).isInternalSpan() && this.node.getCircuit().getCircuitTypeObj().isSVLANType()) {
                    pathDefsHolder.inPathDefs.add(((NetCircuitSpan)object22).getPathDef(this.node, s));
                    continue;
                }
                pathDefsHolder.inPathDefs.add(((NetCircuitSpan)object22).getPathDef(iNetElement, s));
                continue;
            }
            if (this.node.findRoutingDir((NetCircuitSpan)object22) == eSpanDirection.BIDIRECTIONAL) {
                pathDefsHolder.omniPathDefs.add(((NetCircuitSpan)object22).getPathDef(iNetElement, s));
                pathDefsHolder.omniSpanPos.add(((NetCircuitSpan)object22).getNetLinkSpan().getSourceRing());
                continue;
            }
            if (!NetCircuitNodeOperator.dbgOn()) continue;
            db.println("Unknown routing dir on " + this.getName() + " for " + ((NetCircuitSpan)object22).prettyString());
        }
        for (NetCircuitSpan netCircuitSpan : linkedList3) {
            pathDefsHolder.inPathDefs.add(netCircuitSpan.getPathDef(iNetElement, s));
        }
        for (NetCircuitSpan netCircuitSpan : linkedList2) {
            pathDefsHolder.outPathDefs.add(netCircuitSpan.getPathDef(iNetElement, s));
        }
        object22 = netCcatCircuit.getXmCircuitEnds();
        if (!object22.isEmpty() && this.node.getNodeModel().getNodeId() == ((INetCircuitEnd)object22.get(0)).getNodeId()) {
            if (NetCircuitNodeOperator.dbgOn()) {
                db.println("createConnection looking at ds3xm");
            }
            if ((object22.get(0) == null || object22.get(1) == null) && NetCircuitNodeOperator.dbgOn()) {
                db.println("ds3xmCktEnds are null");
            }
            if (this.node.isIngressOnXm()) {
                if (NetCircuitNodeOperator.dbgOn()) {
                    db.println("adding to outPathDefs");
                }
                if ((object = ((NetCircuitEnd)object22.get(0)).getPathDef(s)) == null && NetCircuitNodeOperator.dbgOn()) {
                    db.println("pathDef is null");
                }
                pathDefsHolder.outPathDefs.add(((NetCircuitEnd)object22.get(0)).getPathDef(s));
            } else {
                if (NetCircuitNodeOperator.dbgOn()) {
                    db.println("adding to inPathDefs");
                }
                pathDefsHolder.inPathDefs.add(((NetCircuitEnd)object22.get(1)).getPathDef(s));
            }
        }
    }

    protected int biSpanUpsrCost(NetCircuitSpan netCircuitSpan) {
        if (!netCircuitSpan.isUpsr()) {
            return 0;
        }
        if (!NetCircuitNodeUtil.isUpsrSelectorConnType(this.node.getConnectionType())) {
            return 0;
        }
        NetCircuitNode netCircuitNode = this.node.spanGetPeer(netCircuitSpan);
        if (netCircuitNode == null) {
            if (NetCircuitNodeOperator.dbgOn()) {
                db.println("biSpanUpsrCost:  peer not found");
            }
            return 0;
        }
        return netCircuitNode.getOperator().biSpanUpsrRecursiveCost(netCircuitSpan);
    }

    protected int biSpanUpsrRecursiveCost(NetCircuitSpan netCircuitSpan) {
        if (!netCircuitSpan.isUpsr()) {
            return 0;
        }
        int n = netCircuitSpan.getLink().getCost();
        int n2 = this.node.findConnType();
        if (n2 != 1) {
            return n;
        }
        NetCircuitNode netCircuitNode = null;
        NetCircuitSpan netCircuitSpan2 = this.node.findAlternateBiSpan(netCircuitSpan);
        if (netCircuitSpan2 != null) {
            netCircuitNode = this.node.spanGetPeer(netCircuitSpan2);
        }
        if (netCircuitNode == null) {
            if (NetCircuitNodeOperator.dbgOn()) {
                db.println("Warning! biSpanUpsRecursiveCost: peer Node not found");
            }
            return n;
        }
        return n + netCircuitNode.getOperator().biSpanUpsrRecursiveCost(netCircuitSpan2);
    }

    protected void arrangePathDefsForBlsrDri(IPathDefModel[] iPathDefModelArray) throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo {
        short s = this.node.getPathWidth();
        int n = this.node.getConnectionType();
        switch (n) {
            case 2: 
            case 6: {
                NetCircuitSpan netCircuitSpan;
                if (iPathDefModelArray.length != 2 || (netCircuitSpan = this.node.getSpanFromPathDef(iPathDefModelArray[0])) == null || !netCircuitSpan.isSecondaryCircuit()) break;
                IPathDefModel iPathDefModel = iPathDefModelArray[0];
                iPathDefModelArray[0] = iPathDefModelArray[1];
                iPathDefModelArray[1] = iPathDefModel;
                break;
            }
        }
    }

    protected void tentative2Routed() throws DeletionError {
        int n = this.node.getState();
        if (NetCircuitNodeOperator.dbgOn()) {
            db.println("tentative2Routed: state " + EnumStrings.getString(INetCircuitProvState.class, (int)n) + " node " + this.getName());
        }
        if (n == 1) {
            block39: {
                if (NetCircuitNodeOperator.dbgOn()) {
                    db.println("tentative2Routed: destroying the connection");
                }
                try {
                    this.destroyConnection();
                }
                catch (Busy busy) {
                    if (NetCircuitNodeOperator.dbgOn()) {
                        db.println("Busy destroying a connection in tentative2Routed.");
                        SDebug.printStackTrace((Throwable)busy);
                    }
                }
                catch (ConnectionInTestAccess connectionInTestAccess) {
                    if (NetCircuitNodeOperator.dbgOn()) {
                        db.println("ConectionInTestAccess destroying a connection in tentative2Routed.");
                        SDebug.printStackTrace((Throwable)connectionInTestAccess);
                    }
                }
                catch (ConnectionInRoll connectionInRoll) {
                    if (NetCircuitNodeOperator.dbgOn()) {
                        db.println("ConnectionInRoll destroying a connection in tentative2Routed.");
                        SDebug.printStackTrace((Throwable)connectionInRoll);
                    }
                }
                catch (ConnectionHasFarendLoopback connectionHasFarendLoopback) {
                    if (NetCircuitNodeOperator.dbgOn()) {
                        db.println("ConnectionHasFarendLoopback destroying a connection in tentative2Routed.");
                        SDebug.printStackTrace((Throwable)connectionHasFarendLoopback);
                    }
                }
                catch (ConnectionInTopologyUpgrade connectionInTopologyUpgrade) {
                    if (NetCircuitNodeOperator.dbgOn()) {
                        db.println("ConnectionInTopologyUpgrade destroying a connection in tentative2Routed.");
                        SDebug.printStackTrace((Throwable)connectionInTopologyUpgrade);
                    }
                }
                catch (VcatMemberNotOutOfGroup vcatMemberNotOutOfGroup) {
                    if (NetCircuitNodeOperator.dbgOn()) {
                        db.println("VcatMemberNotOutOfGroup destroying a connection in tentative2Routed.");
                        SDebug.printStackTrace((Throwable)vcatMemberNotOutOfGroup);
                    }
                }
                catch (VcatMemberInvalidState vcatMemberInvalidState) {
                    if (NetCircuitNodeOperator.dbgOn()) {
                        db.println("VcatMemberInvalidState destroying a connection in tentative2Routed.");
                        SDebug.printStackTrace((Throwable)vcatMemberInvalidState);
                    }
                }
                catch (InvalidPath invalidPath) {
                    if (NetCircuitNodeOperator.dbgOn()) {
                        db.println("InvalidPath destroying a SVLAN connection in tentative2Routed.");
                        SDebug.printStackTrace((Throwable)invalidPath);
                    }
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (!NetCircuitNodeOperator.dbgOn()) break block39;
                    db.println("WrongInterfaceType destroying a SVLAN connection in tentative2Routed.");
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            this.node.setState(0);
            this.node.setCreateStage(2);
        } else if (n == 3) {
            for (NetCircuitSpan netCircuitSpan : this.node.getOutSpans()) {
                if (netCircuitSpan.getSrcState() != 3) continue;
                if (NetCircuitNodeOperator.dbgOn()) {
                    db.println("tentative2Routed: deleting tentative span " + netCircuitSpan.prettyString() + " from connection");
                }
                try {
                    this.deleteSpanFromConnection(netCircuitSpan);
                }
                catch (CTCUserException cTCUserException) {
                    if (NetCircuitNodeOperator.dbgOn()) {
                        db.println("tentative2Routed: Warning! attempt to delete span from connection failed");
                    }
                    String string = "The span from the connection on the node " + this.getName() + " could not be deleted.";
                    if (cTCUserException instanceof InvalidPath) {
                        string = string + "\nThe path is invalid. ";
                    } else if (cTCUserException instanceof ConnectionTypeError) {
                        string = string + "\nAn error occurred with the connection type. ";
                    }
                    throw new DeletionError(string);
                }
                netCircuitSpan.setSrcState(2);
            }
            for (NetCircuitEnd netCircuitEnd : this.node.getDrops()) {
                if (netCircuitEnd.getStage() != 3) continue;
                if (NetCircuitNodeOperator.dbgOn()) {
                    db.println("deleting tentative drop " + netCircuitEnd.prettyString() + " from connection");
                }
                try {
                    this.deleteDropFromConnection(netCircuitEnd);
                }
                catch (CTCUserException cTCUserException) {
                    if (NetCircuitNodeOperator.dbgOn()) {
                        db.println("tentative2Routed: Warning! attempt to delete drop from connection failed");
                    }
                    String string = "The drop from the connection on the node " + this.getName() + " cannot be deleted.";
                    if (cTCUserException instanceof InvalidPath) {
                        string = string + "\nThe path is invalid. ";
                    } else if (cTCUserException instanceof ConnectionTypeError) {
                        string = string + "\nAn error occurred with the connection type. ";
                    }
                    throw new DeletionError(string);
                }
                netCircuitEnd.setStage(2);
            }
        }
    }

    protected void modifyConnection() throws CircuitProvError {
        if (NetCircuitNodeOperator.dbgOn()) {
            db.println("modifyConnection @ Node " + this.getName());
        }
        this.modifyConnectionType();
        this.modifyConnectionDropsAndSpans();
    }

    protected void modifyConnectionType() throws CircuitProvError {
        NetCcatCircuit netCcatCircuit = this.getCircuit();
        int n = netCcatCircuit.getCktOperation() == 5 ? this.node.calculateConnectionType() : this.node.findUpgradedConnType();
        if (n != this.node.getConnectionType()) {
            if (NetCircuitNodeOperator.dbgOn()) {
                db.println("modifyConnectionType: Node " + this.getName() + ". New conn type = " + EnumStrings.getString(IConnectionType.class, (int)n) + ". Old conn type = " + EnumStrings.getString(IConnectionType.class, (int)this.node.getConnectionType()));
            }
            try {
                this.node.setConnTypeInConnModel(n);
            }
            catch (CTCUserException cTCUserException) {
                if (NetCircuitNodeOperator.dbgOn()) {
                    db.println("modifyConnectionType: unable to change intended type");
                }
                throw new CircuitProvError("The connection on the node " + this.getName() + " could not be modified.");
            }
            if (n == 6 && this.node.getConnectionType() == 1) {
                this.node.cleanupUpsrEntities();
            }
            this.node.setConnectionType(n);
        }
    }

    protected void modifyConnectionDropsAndSpans() throws CircuitProvError {
        for (NetCircuitEnd netCircuitEnd : this.node.getDrops()) {
            if (netCircuitEnd.getStage() != 2) continue;
            if (NetCircuitNodeOperator.dbgOn()) {
                db.println("Adding routed drop to connection");
            }
            try {
                this.node.addOutputToConnModel(netCircuitEnd);
                this.node.addConnectionPathEnd(netCircuitEnd);
            }
            catch (CTCUserException cTCUserException) {
                this.cleanupLoAdits();
                if (NetCircuitNodeOperator.dbgOn()) {
                    db.println("failed to add output");
                    SDebug.printStackTrace((Throwable)cTCUserException);
                }
                String string = "The output to the connection on the node " + this.getName() + " cannot be added.";
                if (cTCUserException instanceof NoMoreLoCapableHo) {
                    string = string + "\n" + this.getNoLoCapableHoMessage() + " at " + this.getName();
                } else if (cTCUserException instanceof PathInUse) {
                    string = string + "\nThe path is already in use. ";
                } else if (cTCUserException instanceof DropsExceedMax) {
                    string = string + "\nThe maximum number of multicast drops has been reached.\nNo more new drops can be created.";
                }
                throw new CircuitProvError(string);
            }
            netCircuitEnd.setStage(3);
        }
        for (NetCircuitSpan netCircuitSpan : this.node.getOutSpans()) {
            if (netCircuitSpan.getSrcState() != 2) continue;
            if (NetCircuitNodeOperator.dbgOn()) {
                db.println("Adding routed span to connection");
            }
            try {
                this.node.addOutputToConnModel(netCircuitSpan);
                this.node.addConnectionPathEnd(netCircuitSpan);
            }
            catch (CTCUserException cTCUserException) {
                this.cleanupLoAdits();
                if (NetCircuitNodeOperator.dbgOn()) {
                    db.println("failed to add output");
                    SDebug.printStackTrace((Throwable)cTCUserException);
                }
                String string = "The output to the connection on the node " + this.getName() + " cannot be added.";
                if (cTCUserException instanceof NoMoreLoCapableHo) {
                    string = string + "\n" + this.getNoLoCapableHoMessage() + " on the node " + this.getName();
                } else if (cTCUserException instanceof PathInUse) {
                    string = string + "\nThe path is already in use.";
                }
                throw new CircuitProvError(string);
            }
            netCircuitSpan.setSrcState(3);
        }
        if (this.node.getConnectionType() == 8) {
            for (NetCircuitSpan netCircuitSpan : this.node.getBiSpans()) {
                if (this.node.findRoutingDir(netCircuitSpan) == eSpanDirection.TERMINATING && netCircuitSpan.getDstState() != 2 || this.node.findRoutingDir(netCircuitSpan) == eSpanDirection.ORIGINATING && netCircuitSpan.getSrcState() != 2) continue;
                try {
                    this.node.addOutputToConnModel(netCircuitSpan);
                    this.node.addConnectionPathEnd(netCircuitSpan);
                }
                catch (CTCUserException cTCUserException) {
                    if (NetCircuitNodeOperator.dbgOn()) {
                        db.println("failed to add output");
                        SDebug.printStackTrace((Throwable)cTCUserException);
                    }
                    String string = "The output to the connection on the node " + this.getName() + " cannot be added.";
                    if (cTCUserException instanceof PathInUse) {
                        string = string + "\nThe path is already in use.";
                    }
                    throw new CircuitProvError(string);
                }
            }
        }
    }

    protected boolean upsrEmpty(Object object) {
        Connection connection = this.node.findConnectionWithOutput(object);
        if (connection == null) {
            if (NetCircuitNodeOperator.dbgOn()) {
                db.println("upsrEmpty: no connection for output on node " + this.getName());
            }
            return true;
        }
        if (connection instanceof SelectorConnection) {
            SelectorConnection selectorConnection = (SelectorConnection)connection;
            if (NetCircuitNodeOperator.dbgOn()) {
                db.println("upsrEmpty: examining selector on node " + this.getName());
            }
            for (NetCircuitSpan netCircuitSpan : selectorConnection.getInSpans()) {
                if (!selectorConnection.hasInputPathDrop(selectorConnection, netCircuitSpan, object)) continue;
                if (NetCircuitNodeOperator.dbgOn()) {
                    db.println("upsrEmpty: found a drop depending on the connection on node " + this.getName());
                }
                return false;
            }
        } else {
            if (NetCircuitNodeOperator.dbgOn()) {
                db.println("upsrEmpty: output not connected to a selector on node " + this.getName());
            }
            return true;
        }
        if (NetCircuitNodeOperator.dbgOn()) {
            db.println("upsrEmpty: selector is empty on node " + this.getName());
        }
        return true;
    }

    private int upsrCountBridgePath(NetCircuitSpan netCircuitSpan) {
        int n = 0;
        int n2 = this.node.getConnectionType();
        if (NetCircuitNodeOperator.dbgOn()) {
            db.println("upsrCountBridgePath: Node " + this.getName());
        }
        if (!this.node.getBiSpans().contains(netCircuitSpan)) {
            if (n2 == 4 && this.isUndeletablePath(this.node.getPathDefIndexFromSpan(netCircuitSpan))) {
                ++n;
            }
            return n;
        }
        NetCircuitSpan netCircuitSpan2 = this.node.findAlternateBiSpan(netCircuitSpan);
        if (netCircuitSpan2 != null) {
            NetCircuitNode netCircuitNode = this.node.spanGetPeer(netCircuitSpan2);
            n = netCircuitNode.getOperator().upsrCountBridgePath(netCircuitSpan2);
        }
        if (netCircuitSpan2 == null && !this.node.getSources().isEmpty() && this.node.getPathDefIndexFromSpan(netCircuitSpan) < 2) {
            ++n;
        }
        return n;
    }

    private boolean onUpsrBridgePath() {
        for (NetCircuitSpan netCircuitSpan : this.node.getBiSpans()) {
            NetCircuitNode netCircuitNode = this.node.spanGetPeer(netCircuitSpan);
            int n = netCircuitNode.getOperator().upsrCountBridgePath(netCircuitSpan);
            if (n <= 0) continue;
            if (NetCircuitNodeOperator.dbgOn()) {
                db.println("Non zero source count " + n);
            }
            return true;
        }
        if (NetCircuitNodeOperator.dbgOn()) {
            db.println("onUpsrBridgePath is false");
        }
        return false;
    }

    private boolean isUndeletablePath(int n) {
        int n2 = this.node.getConnectionType();
        if (n2 == 6 || n2 == 4) {
            return n == 0 || n == 1;
        }
        return false;
    }

    protected void deleteDrop(INetCircuitEnd iNetCircuitEnd) throws DeletionError, SanityCheckFailed {
        if (NetCircuitNodeOperator.dbgOn()) {
            db.println("deleteDrop called at node " + this.getName());
        }
        boolean bl = this.upsrEmpty(iNetCircuitEnd);
        int n = this.node.getDrops().size() + this.node.getOutSpans().size();
        NetCcatCircuit netCcatCircuit = this.getCircuit();
        if (!netCcatCircuit.getCircuitTypeObj().isEthernetCircuitType()) {
            if (!this.deleteDropCheck(iNetCircuitEnd, bl)) {
                throw new SanityCheckFailed("This drop cannot be deleted. Deleting this drop will break the UPSR ring.");
            }
            if (n == 1 && bl) {
                block36: {
                    try {
                        this.destroyConnection();
                    }
                    catch (Busy busy) {
                        if (NetCircuitNodeOperator.dbgOn()) {
                            db.println("Busy destroying a connection in deleteDrop.");
                            SDebug.printStackTrace((Throwable)busy);
                        }
                    }
                    catch (ConnectionInTestAccess connectionInTestAccess) {
                        if (NetCircuitNodeOperator.dbgOn()) {
                            db.println("ConectionInTestAccess destroying a connection in deleteDrop.");
                            SDebug.printStackTrace((Throwable)connectionInTestAccess);
                        }
                    }
                    catch (ConnectionInRoll connectionInRoll) {
                        if (NetCircuitNodeOperator.dbgOn()) {
                            db.println("ConnectionInRoll destroying a connection in deleteDrop.");
                            SDebug.printStackTrace((Throwable)connectionInRoll);
                        }
                    }
                    catch (ConnectionHasFarendLoopback connectionHasFarendLoopback) {
                        if (NetCircuitNodeOperator.dbgOn()) {
                            db.println("ConnectionHasFarendLoopback destroying a connection in deleteDrop.");
                            SDebug.printStackTrace((Throwable)connectionHasFarendLoopback);
                        }
                    }
                    catch (ConnectionInTopologyUpgrade connectionInTopologyUpgrade) {
                        if (NetCircuitNodeOperator.dbgOn()) {
                            db.println("ConnectionInTopologyUpgrade destroying a connection in deleteDrop.");
                            SDebug.printStackTrace((Throwable)connectionInTopologyUpgrade);
                        }
                    }
                    catch (VcatMemberNotOutOfGroup vcatMemberNotOutOfGroup) {
                        if (NetCircuitNodeOperator.dbgOn()) {
                            db.println("VcatMemberNotOutOfGroup destroying a connection in deleteDrop.");
                            SDebug.printStackTrace((Throwable)vcatMemberNotOutOfGroup);
                        }
                    }
                    catch (VcatMemberInvalidState vcatMemberInvalidState) {
                        if (NetCircuitNodeOperator.dbgOn()) {
                            db.println("VcatMemberInvalidState destroying a connection in deleteDrop.");
                            SDebug.printStackTrace((Throwable)vcatMemberInvalidState);
                        }
                    }
                    catch (InvalidPath invalidPath) {
                        if (NetCircuitNodeOperator.dbgOn()) {
                            db.println("InvalidPath destroying a SVLAN connection in deleteDrop.");
                            SDebug.printStackTrace((Throwable)invalidPath);
                        }
                    }
                    catch (WrongInterfaceType wrongInterfaceType) {
                        if (!NetCircuitNodeOperator.dbgOn()) break block36;
                        db.println("WrongInterfaceType destroying a SVLAN connection in deleteDrop.");
                        SDebug.printStackTrace((Throwable)wrongInterfaceType);
                    }
                }
                this.removeActiveDrop((NetCircuitEnd)iNetCircuitEnd);
                this.destroyInputs();
            } else {
                try {
                    this.deleteDropFromConnection((NetCircuitEnd)iNetCircuitEnd);
                }
                catch (CTCUserException cTCUserException) {
                    if (NetCircuitNodeOperator.dbgOn()) {
                        db.println("unable to remove drop from connection");
                    }
                    String string = "The drop from the connection on the node " + this.getName() + " cannot be deleted.";
                    if (cTCUserException instanceof InvalidPath) {
                        string = string + "\nThe path is invalid. ";
                    } else if (cTCUserException instanceof ConnectionTypeError) {
                        string = string + "\nAn error occurred with the connection type. ";
                    }
                    throw new DeletionError(string);
                }
                this.removeActiveDrop((NetCircuitEnd)iNetCircuitEnd);
            }
        } else {
            try {
                this.deleteDropFromConnection((NetCircuitEnd)iNetCircuitEnd);
            }
            catch (CTCUserException cTCUserException) {
                if (NetCircuitNodeOperator.dbgOn()) {
                    db.println("unable to remove drop from connection");
                }
                String string = "The drop from the connection on the node " + this.getName() + " cannot be deleted.";
                if (cTCUserException instanceof InvalidPath) {
                    string = string + "\nThe path is invalid. ";
                } else if (cTCUserException instanceof ConnectionTypeError) {
                    string = string + "\nAn error occurred with the connection type. ";
                }
                throw new DeletionError(string);
            }
            this.removeActiveDrop((NetCircuitEnd)iNetCircuitEnd);
        }
    }

    protected boolean deleteDropCheck(INetCircuitEnd iNetCircuitEnd, boolean bl) {
        int n = this.node.getDrops().size() + this.node.getOutSpans().size();
        int n2 = this.node.getConnectionType();
        if (n2 == 1) {
            if (NetCircuitNodeOperator.dbgOn()) {
                db.println("deleteDropCheck: drop has two-way connection");
            }
            return false;
        }
        if (n2 == 6 || n2 == 7 || n2 == 5) {
            if (this.isUndeletablePath(this.node.getPathDefIndexFromCktEnd(iNetCircuitEnd))) {
                if (NetCircuitNodeOperator.dbgOn()) {
                    db.println("deleteDropCheck: drop is on an undeletable path");
                }
                return false;
            }
            if (n == 1 && bl && this.onUpsrBridgePath()) {
                if (NetCircuitNodeOperator.dbgOn()) {
                    db.println("deleteDropCheck: delete drop will break upsr ring");
                }
                return false;
            }
        } else if (n2 == 4 && this.isUndeletablePath(this.node.getPathDefIndexFromCktEnd(iNetCircuitEnd))) {
            if (NetCircuitNodeOperator.dbgOn()) {
                db.println("deleteDropCheck: drop is one of upsr bridge");
            }
            return false;
        }
        return true;
    }

    protected void destroyInputs() throws DeletionError {
        NetCircuitNode netCircuitNode;
        if (NetCircuitNodeOperator.dbgOn()) {
            db.println("destroying inputs at " + this.getName());
        }
        for (NetCircuitSpan netCircuitSpan : this.node.getInSpans()) {
            netCircuitSpan.setDstState(0);
            netCircuitNode = this.node.spanGetPeer(netCircuitSpan);
            netCircuitNode.getOperator().deleteOutputSpan(netCircuitSpan);
            this.node.removeSpan(netCircuitSpan, eSpanDirection.TERMINATING);
        }
        for (NetCircuitSpan netCircuitSpan : this.node.getBiSpans()) {
            if (netCircuitSpan.getLink().getSrc() == this.node.getNetElement()) {
                netCircuitSpan.setSrcState(0);
            } else {
                netCircuitSpan.setDstState(0);
            }
            netCircuitNode = this.node.spanGetPeer(netCircuitSpan);
            netCircuitNode.getOperator().deleteBiSpan(netCircuitSpan);
            this.node.removeSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
        }
    }

    protected void deleteBiSpan(NetCircuitSpan netCircuitSpan) throws DeletionError {
        block33: {
            if (NetCircuitNodeOperator.dbgOn()) {
                db.println("deleteBiSpan: Node " + this.getName() + " Span " + netCircuitSpan.prettyString());
            }
            if (this.node.getNodeDrop() != null) {
                try {
                    this.deleteSpanFromConnection(netCircuitSpan);
                }
                catch (CTCUserException cTCUserException) {
                    if (NetCircuitNodeOperator.dbgOn()) {
                        db.println("unable to delete span from connection");
                    }
                    String string = "The span from the connection on the node " + this.getName() + " cannot be deleted.";
                    if (cTCUserException instanceof InvalidPath) {
                        string = string + "\nThe path is invalid. ";
                    } else if (cTCUserException instanceof ConnectionTypeError) {
                        string = string + "\nAn error occurred with the connection type. ";
                    }
                    throw new DeletionError(string);
                }
                this.removeActiveBiSpan(netCircuitSpan);
                return;
            }
            if (!this.node.getBiSpans().contains(netCircuitSpan)) {
                this.deleteOutputSpan(netCircuitSpan);
                return;
            }
            if (netCircuitSpan.getLink().getSrc() == this.node.getNetElement()) {
                netCircuitSpan.setSrcState(0);
            } else {
                netCircuitSpan.setDstState(0);
            }
            this.removeActiveBiSpan(netCircuitSpan);
            try {
                this.destroyConnection();
            }
            catch (Busy busy) {
                if (NetCircuitNodeOperator.dbgOn()) {
                    db.println("Busy destroying a connection in deleteBiSpan.");
                    SDebug.printStackTrace((Throwable)busy);
                }
            }
            catch (ConnectionInTestAccess connectionInTestAccess) {
                if (NetCircuitNodeOperator.dbgOn()) {
                    db.println("ConectionInTestAccess destroying a connection in deleteBiSpan.");
                    SDebug.printStackTrace((Throwable)connectionInTestAccess);
                }
            }
            catch (ConnectionInRoll connectionInRoll) {
                if (NetCircuitNodeOperator.dbgOn()) {
                    db.println("ConnectionInRoll destroying a connection in deleteBiSpan.");
                    SDebug.printStackTrace((Throwable)connectionInRoll);
                }
            }
            catch (ConnectionHasFarendLoopback connectionHasFarendLoopback) {
                if (NetCircuitNodeOperator.dbgOn()) {
                    db.println("ConnectionHasFarendLoopback destroying a connection in deleteBiSpan.");
                    SDebug.printStackTrace((Throwable)connectionHasFarendLoopback);
                }
            }
            catch (ConnectionInTopologyUpgrade connectionInTopologyUpgrade) {
                if (NetCircuitNodeOperator.dbgOn()) {
                    db.println("ConnectionInTopologyUpgrade destroying a connection in deleteBiSpan.");
                    SDebug.printStackTrace((Throwable)connectionInTopologyUpgrade);
                }
            }
            catch (VcatMemberNotOutOfGroup vcatMemberNotOutOfGroup) {
                if (NetCircuitNodeOperator.dbgOn()) {
                    db.println("VcatMemberNotOutOfGroup destroying a connection in deleteBiSpan.");
                    SDebug.printStackTrace((Throwable)vcatMemberNotOutOfGroup);
                }
            }
            catch (VcatMemberInvalidState vcatMemberInvalidState) {
                if (NetCircuitNodeOperator.dbgOn()) {
                    db.println("VcatMemberInvalidState destroying a connection in deleteBiSpan.");
                    SDebug.printStackTrace((Throwable)vcatMemberInvalidState);
                }
            }
            catch (InvalidPath invalidPath) {
                if (NetCircuitNodeOperator.dbgOn()) {
                    db.println("InvalidPath destroying a SVLAN connection in deleteBiSpan.");
                    SDebug.printStackTrace((Throwable)invalidPath);
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!NetCircuitNodeOperator.dbgOn()) break block33;
                db.println("WrongInterfaceType destroying a SVLAN connection in deleteBiSpan.");
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        if (NetCircuitNodeUtil.isUpsrSelectorConnType(this.node.getConnectionType()) && this.getCircuit().isBidirectional()) {
            return;
        }
        for (NetCircuitSpan netCircuitSpan2 : this.node.getBiSpans()) {
            if (netCircuitSpan2.getLink().getSrc() == this.node.getNetElement()) {
                netCircuitSpan2.setSrcState(0);
            } else {
                netCircuitSpan2.setDstState(0);
            }
            NetCircuitNode netCircuitNode = this.node.spanGetPeer(netCircuitSpan2);
            netCircuitNode.getOperator().deleteBiSpan(netCircuitSpan2);
            this.node.removeSpan(netCircuitSpan2, eSpanDirection.BIDIRECTIONAL);
        }
    }

    private void deleteOutputSpan(NetCircuitSpan netCircuitSpan) throws DeletionError {
        boolean bl;
        if (NetCircuitNodeOperator.dbgOn()) {
            db.println("deleteOutputSpan: Node " + this.getName() + " Span " + netCircuitSpan.prettyString());
        }
        if (!this.node.getOutSpans().contains(netCircuitSpan)) {
            if (NetCircuitNodeOperator.dbgOn()) {
                db.println("Warning! : span not found");
            }
            return;
        }
        netCircuitSpan.setSrcState(0);
        int n = this.node.getOutSpans().size() + this.node.getDrops().size();
        boolean bl2 = bl = this.node.getBiSpans().size() == 0 && this.node.getOutSpans().size() == 2;
        if (n == 1 && this.upsrEmpty(netCircuitSpan) || bl && this.node.feedsNoDrops(null)) {
            block31: {
                try {
                    this.destroyConnection();
                }
                catch (Busy busy) {
                    if (NetCircuitNodeOperator.dbgOn()) {
                        db.println("Busy destroying a connection in deleteOutputSpan.");
                        SDebug.printStackTrace((Throwable)busy);
                    }
                }
                catch (ConnectionInTestAccess connectionInTestAccess) {
                    if (NetCircuitNodeOperator.dbgOn()) {
                        db.println("ConectionInTestAccess destroying a connection in deleteOutputSpan.");
                        SDebug.printStackTrace((Throwable)connectionInTestAccess);
                    }
                }
                catch (ConnectionInRoll connectionInRoll) {
                    if (NetCircuitNodeOperator.dbgOn()) {
                        db.println("ConnectionInRoll destroying a connection in deleteOutputSpan.");
                        SDebug.printStackTrace((Throwable)connectionInRoll);
                    }
                }
                catch (ConnectionHasFarendLoopback connectionHasFarendLoopback) {
                    if (NetCircuitNodeOperator.dbgOn()) {
                        db.println("ConnectionHasFarendLoopback destroying a connection in deleteOutputSpan.");
                        SDebug.printStackTrace((Throwable)connectionHasFarendLoopback);
                    }
                }
                catch (ConnectionInTopologyUpgrade connectionInTopologyUpgrade) {
                    if (NetCircuitNodeOperator.dbgOn()) {
                        db.println("ConnectionInTopologyUpgrade destroying a connection in deleteOutputSpan.");
                        SDebug.printStackTrace((Throwable)connectionInTopologyUpgrade);
                    }
                }
                catch (VcatMemberNotOutOfGroup vcatMemberNotOutOfGroup) {
                    if (NetCircuitNodeOperator.dbgOn()) {
                        db.println("VcatMemberNotOutOfGroup destroying a connection in deleteOutputSpan.");
                        SDebug.printStackTrace((Throwable)vcatMemberNotOutOfGroup);
                    }
                }
                catch (VcatMemberInvalidState vcatMemberInvalidState) {
                    if (NetCircuitNodeOperator.dbgOn()) {
                        db.println("VcatMemberInvalidState destroying a connection in deleteOutputSpan.");
                        SDebug.printStackTrace((Throwable)vcatMemberInvalidState);
                    }
                }
                catch (InvalidPath invalidPath) {
                    if (NetCircuitNodeOperator.dbgOn()) {
                        db.println("InvalidPath destroying a SVLAN connection in deleteOutputSpan.");
                        SDebug.printStackTrace((Throwable)invalidPath);
                    }
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (!NetCircuitNodeOperator.dbgOn()) break block31;
                    db.println("WrongInterfaceType destroying a SVLAN connection in deleteOutputSpan.");
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            this.destroyInputs();
        } else {
            if (NetCircuitNodeOperator.dbgOn()) {
                db.println("attempting to remove span (output) from connection");
            }
            try {
                this.deleteSpanFromConnection(netCircuitSpan);
            }
            catch (CTCUserException cTCUserException) {
                if (NetCircuitNodeOperator.dbgOn()) {
                    db.println("unable to delete span from connection");
                }
                String string = "The span from the connection on the node " + this.getName() + " cannot be deleted.";
                if (cTCUserException instanceof InvalidPath) {
                    string = string + "\nThe path is invalid. ";
                } else if (cTCUserException instanceof ConnectionTypeError) {
                    string = string + "\nAn error occurred with the connection type. ";
                }
                throw new DeletionError(string);
            }
            this.removeActiveOutSpan(netCircuitSpan);
        }
        if (this.node.getState() == 3 && this.node.numRoutedPaths() == 0) {
            this.node.setState(2);
        }
    }

    private void changeUpsrDcToTwoway() throws ConnectionTypeError, ConnectionInTopologyUpgrade, ConnectionInLoopback, ConnectionInTestAccess, ConnectionInRoll {
        if (this.node.getNumberOfPaths() == 2 && this.node.getConnectionType() == 6) {
            if (this.getConn() != null) {
                this.node.setConnTypeInConnModel(1);
            }
            this.node.setupConnListOnCreation();
            this.node.cleanupUpsrEntities();
        }
    }

    protected void deleteDropFromConnection(NetCircuitEnd netCircuitEnd) throws CTCUserException {
        if (netCircuitEnd.getStage() == 2) {
            return;
        }
        if (NetCircuitNodeOperator.dbgOn()) {
            db.println("Deleting drop from connection");
        }
        this.node.removeOutputFromConnModel(netCircuitEnd);
        this.node.setNumberOfPaths(this.node.getNumberOfPaths() - 1);
        this.changeUpsrDcToTwoway();
    }

    protected void deleteSpanFromConnection(NetCircuitSpan netCircuitSpan) throws CTCUserException {
        if (NetCircuitNodeOperator.dbgOn()) {
            db.println("Deleting span from connection");
        }
        this.node.removeOutputFromConnModel(netCircuitSpan);
        this.node.setNumberOfPaths(this.node.getNumberOfPaths() - 1);
        this.changeUpsrDcToTwoway();
        if (netCircuitSpan.getLink().getSrc() == this.node.getNetElement()) {
            netCircuitSpan.setSrcState(0);
        } else {
            netCircuitSpan.setDstState(0);
        }
    }

    protected void removeActiveBiSpan(NetCircuitSpan netCircuitSpan) {
        if (NetCircuitNodeOperator.dbgOn()) {
            db.println("Removing ACTIVE biSpan at " + this.getName());
        }
        this.node.removeSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
        this.node.setupConnListOnCreation();
    }

    private void removeActiveOutSpan(NetCircuitSpan netCircuitSpan) {
        if (NetCircuitNodeOperator.dbgOn()) {
            db.println("Removing ACTIVE outSpan at " + this.getName());
        }
        this.node.removeSpan(netCircuitSpan, eSpanDirection.ORIGINATING);
        this.node.setupConnListOnCreation();
    }

    protected void removeActiveDrop(NetCircuitEnd netCircuitEnd) throws SanityCheckFailed {
        if (NetCircuitNodeOperator.dbgOn()) {
            db.println("Removing ACTIVE drop at " + this.getName());
        }
        int n = this.node.getConnectionType();
        this.node.removeDrop(netCircuitEnd);
        this.node.setupConnListOnCreation();
    }

    protected boolean hasMonitor() {
        return false;
    }

    protected void destroySanityCheck() throws SanityCheckFailed {
        if (this.node.getNetElement().getNodeModel().isVersionUpStateEnabled()) {
            String string = "Software activation is in progress.\nNode in Circuit " + this.node.getCircuit().getCircuitName() + "\nhas not yet activated, so delete circuit operation is not allowed.";
            throw new SanityCheckFailed(string);
        }
    }

    protected void destroyConnection() throws Busy, ConnectionInTestAccess, ConnectionInRoll, ConnectionInTopologyUpgrade, VcatMemberNotOutOfGroup, VcatMemberInvalidState, DeletionError, InvalidPath, WrongInterfaceType, ConnectionHasFarendLoopback {
        this.destroyCrossConnection();
    }

    protected void destroyCrossConnection() throws Busy, ConnectionInTestAccess, ConnectionInRoll, ConnectionInTopologyUpgrade, VcatMemberNotOutOfGroup, VcatMemberInvalidState, InvalidPath, WrongInterfaceType, ConnectionHasFarendLoopback {
        block6: {
            if (this.getConn() != null) {
                if (NetCircuitNodeOperator.dbgOn()) {
                    db.println("destroyCrossConnection(" + this.getName() + "): destroy hoConn");
                }
                try {
                    if (this.node.getNodeModel().provides(Feature.FORCE_DESTROY)) {
                        this.connLocalDestroy(true);
                    } else {
                        this.connLocalDestroy(false);
                    }
                }
                catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                    if (!NetCircuitNodeOperator.dbgOn()) break block6;
                    db.println("hoConn already deleted");
                }
            }
        }
        this.node.clearConnectionPathEnds();
    }

    String getNoLoCapableHoMessage() {
        TDMTerminology tDMTerminology = NetworkDefaults.getCmsHostTDMTerms();
        String string = tDMTerminology.getGeneralTerms(1);
        String string2 = tDMTerminology.getGeneralTerms(0);
        return "Check the cross-connect resource-usage details under the maintenance tab.\nNo " + string + " capable " + string2 + "s are available.";
    }

    protected List getMonitorSourcePoints(Object[] objectArray, int n) throws SanityCheckFailed {
        if (this.node instanceof LoTunnelNode) {
            throw new SanityCheckFailed("The connection was not found on the node " + this.node.getName());
        }
        if (NetCircuitNodeOperator.dbgOn()) {
            db.println("getMonitorSourcePoints @ " + this.node.getName());
        }
        if (objectArray.length == 0 || n == 22) {
            if (NetCircuitNodeOperator.dbgOn()) {
                db.println("getMonitorSourcePoints: connection object is null");
            }
            throw new SanityCheckFailed("The connection was not found on the node " + this.node.getName());
        }
        INetElement iNetElement = this.node.getNetElement();
        LinkedList<NetCircuitEnd> linkedList = new LinkedList<NetCircuitEnd>();
        switch (n) {
            case 0: 
            case 9: {
                linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(iNetElement, objectArray[0]));
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(iNetElement, objectArray[0]));
                linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(iNetElement, objectArray[1]));
                break;
            }
            case 2: 
            case 10: {
                linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(iNetElement, objectArray[0]));
                linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(iNetElement, objectArray[1]));
                linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(iNetElement, objectArray[2]));
                break;
            }
            case 3: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(iNetElement, objectArray[0]));
                linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(iNetElement, objectArray[1]));
                linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(iNetElement, objectArray[2]));
                linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(iNetElement, objectArray[3]));
                break;
            }
            case 4: {
                linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(iNetElement, objectArray[2]));
                break;
            }
            case 8: {
                int n2 = objectArray.length;
                if (n2 > 0) {
                    linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(iNetElement, objectArray[0]));
                }
                if (n2 <= 1) break;
                linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(iNetElement, objectArray[1]));
            }
        }
        return linkedList;
    }

    protected void prettyPrint(List list) {
        if (NetCircuitNodeOperator.dbgOn()) {
            Iterator iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                db.println("Path " + n++ + "=" + this.prettyString((IPathDefModel)iterator.next()));
            }
        }
    }

    protected String prettyString(IPathDefModel iPathDefModel) {
        return "";
    }
}

