/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidProtectionOp;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.ProtectionSwitchError;
import cerent.cms.ncp.ProtectionSwitchHelper;
import cerent.util.SDebug;
import cerent.util.job.IJobControl;
import cerent.util.job.JobStatus;

public class NetCircuitProtectionSwitchWorker
implements IJobControl {
    private static final SDebug db = new SDebug("NetCircuitProtectionSwitchWorker");
    ProtectionSwitchHelper protectionSwitchHelper;
    NetCircuitNode node;

    public NetCircuitProtectionSwitchWorker(ProtectionSwitchHelper protectionSwitchHelper) {
        this.protectionSwitchHelper = protectionSwitchHelper;
        this.node = protectionSwitchHelper.getNode();
    }

    public JobStatus executeJob() throws Exception {
        String string = "";
        this.node = this.protectionSwitchHelper.getNode();
        int n = this.protectionSwitchHelper.getProtectionOp();
        boolean bl = this.protectionSwitchHelper.isPathZeroSelector();
        NetCircuitSpan netCircuitSpan = this.protectionSwitchHelper.getSpan();
        if (this.dbgOn()) {
            string = this.node.getCircuit().getCircuitName();
            db.println("excecuting protection switch " + n + " for circuit: " + string + " on node " + this.node.getName());
            db.println("Selector type: " + (bl ? "AB" : "CD"));
        }
        try {
            if (bl) {
                this.node.getUpsrOps(netCircuitSpan).setProtectionOp(n);
            } else {
                this.node.getUpsrOps(netCircuitSpan).setReverseProtectionOp(n);
            }
        }
        catch (InvalidProtectionOp invalidProtectionOp) {
            if (this.dbgOn()) {
                db.println("executeJob: Protection Switch " + n + " failed for circuit: " + string);
                db.println("executeJob: " + invalidProtectionOp.getMessage());
                SDebug.printStackTrace((Throwable)invalidProtectionOp);
            }
            return new JobStatus(2, (Object)new ProtectionSwitchError("Invalid Protection Operation"));
        }
        catch (InternalCommError internalCommError) {
            if (this.dbgOn()) {
                db.println("executeJob: Protection Switch " + n + " failed for circuit: " + string);
                db.println("executeJob: " + internalCommError.getMessage());
                SDebug.printStackTrace((Throwable)internalCommError);
            }
            return new JobStatus(2, (Object)new ProtectionSwitchError("Card communication failure"));
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (this.dbgOn()) {
                db.println("executeJob: caught IO exception for circuit " + string);
                db.println(abstractCmsIOException.getMessage());
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
            return new JobStatus(2, (Object)new ProtectionSwitchError("Communications error"));
        }
        catch (Exception exception) {
            if (this.dbgOn()) {
                db.println("executeJob: caught unexpected exception for circuit " + string);
                db.println(exception.getMessage());
                SDebug.printStackTrace((Throwable)exception);
            }
            return new JobStatus(2, (Object)new ProtectionSwitchError("Unexpected exception"));
        }
        if (this.dbgOn()) {
            db.println("Completed protection switch " + n + " for circuit: " + string);
        }
        return new JobStatus(4);
    }

    public void abortJob() {
    }

    public String getName() {
        return "NetCircuitProtectionSwitchWorker";
    }

    public NetCircuitNode getNode() {
        return this.node;
    }

    private boolean dbgOn() {
        return db.on();
    }
}

