/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.Feature;
import cerent.cms.model.FeatureNotSupported;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IProtectionOp;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidProtectionOp;
import cerent.cms.model.UpsrSelector;
import cerent.cms.ncp.IUpsrOps;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.List;

public class NetUpsrOps
extends CmsObservable
implements IUpsrOps {
    private static final SDebug db = new SDebug("NetUpsrOps");
    private short upsrSfBerLevel;
    private short upsrSdBerLevel;
    private boolean upsrSwitchOnPdiP;
    private IRevertiveBehavior upsrReversion;
    private short reverseUpsrSfBerLevel;
    private short reverseUpsrSdBerLevel;
    private boolean reverseUpsrSwitchOnPdiP;
    private IRevertiveBehavior reverseUpsrReversion;
    private static final int NUMBER_CHECKABLE_FEATURES = 3;
    private static final int SUPPORT_REVERSE_PDIP = 0;
    private static final int SUPPORT_REVERSE_REVERSION = 1;
    private static final int SUPPORT_REVERSE_SD_AND_SF_BER = 2;
    private boolean[] featuresArray;
    private int connObjIndex;
    private NetCircuitNode node;
    private static final FeatureNotSupported REVERSE_SD_AND_SF_BER_UNSUPPORTED = new FeatureNotSupported("This node does not support SD and SF BER operations on the second selector");
    private static final FeatureNotSupported REVERSE_PDIP_UNSUPPORTED = new FeatureNotSupported("This node does not support PDI-P operations on the second selector");
    private static final FeatureNotSupported REVERSE_REVERSION_UNSUPPORTED = new FeatureNotSupported("This node does not support reversion time operations on the second selector");

    public NetUpsrOps(NetCircuitNode netCircuitNode) {
        this.node = netCircuitNode;
        this.featuresArray = new boolean[3];
        for (int i = 0; i < this.featuresArray.length; ++i) {
            this.featuresArray[i] = false;
        }
        INodeModel iNodeModel = netCircuitNode.getNodeModel();
        if (iNodeModel != null) {
            if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.BLSR_UPSR_DRI)) {
                this.featuresArray[0] = true;
                this.featuresArray[1] = true;
            }
            if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.SELECTOR_ADDED_ATTRS)) {
                this.featuresArray[2] = true;
            }
        }
    }

    public short getUpsrBerLevel() {
        IConnectionModel iConnectionModel = this.node.getConn();
        if (iConnectionModel != null && iConnectionModel instanceof IHoConnectionModel) {
            return ((IHoConnectionModel)iConnectionModel).getUpsrBerLevel();
        }
        return 0;
    }

    public short getUpsrSfBerLevel() {
        return this.upsrSfBerLevel;
    }

    public short getReverseUpsrSfBerLevel() throws FeatureNotSupported {
        if (!this.featuresArray[2]) {
            throw REVERSE_SD_AND_SF_BER_UNSUPPORTED;
        }
        return this.reverseUpsrSfBerLevel;
    }

    public void setUpsrSfBerLevel(short s) {
        if (!this.node.hasSelector()) {
            if (db.on()) {
                db.println(this.node.getName() + " is not a UpsrSelectorConn. " + "No setUpsrSfBerlevel()");
            }
            return;
        }
        this.upsrSfBerLevel = s;
        IConnectionModel iConnectionModel = this.node.getConn();
        if (iConnectionModel != null) {
            if (iConnectionModel instanceof IHoConnectionModel) {
                ((IHoConnectionModel)iConnectionModel).setUpsrSfBerLevel(s);
            } else if (iConnectionModel instanceof ILoConnectionModel) {
                try {
                    ((ILoConnectionModel)iConnectionModel).getUpsrSfBerLevel();
                    ((ILoConnectionModel)iConnectionModel).setUpsrSfBerLevel(s);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    db.info("Nothing wrong here: we just don't support the operation" + unsupportedOperationException);
                }
            }
        }
    }

    public void setReverseUpsrSfBerLevel(short s) throws ConnectionTypeError, FeatureNotSupported {
        if (!this.node.hasSelector()) {
            if (db.on()) {
                db.println(this.node.getName() + " is not a UpsrSelectorConn. " + "No setReverseUpsrSfBerlevel()");
            }
            return;
        }
        if (!this.featuresArray[2]) {
            throw REVERSE_SD_AND_SF_BER_UNSUPPORTED;
        }
        this.reverseUpsrSfBerLevel = s;
        IConnectionModel iConnectionModel = this.node.getConn();
        if (iConnectionModel != null && iConnectionModel instanceof UpsrSelector) {
            ((UpsrSelector)iConnectionModel).setReverseUpsrSfBerLevel(s);
        }
    }

    public int getSwitchCount(int n, short s) {
        IConnectionModel iConnectionModel = this.node.getConn();
        if (iConnectionModel != null) {
            if (iConnectionModel instanceof IHoConnectionModel) {
                ((IHoConnectionModel)iConnectionModel).getSwitchCount(n, s);
            } else {
                ((ILoConnectionModel)iConnectionModel).getSwitchCount(n, s);
            }
        }
        return 0;
    }

    public boolean getUpsrSwitchOnPdiP() {
        return this.upsrSwitchOnPdiP;
    }

    public boolean getReverseUpsrSwitchOnPdiP() throws FeatureNotSupported {
        if (!this.featuresArray[0]) {
            throw REVERSE_PDIP_UNSUPPORTED;
        }
        return this.reverseUpsrSwitchOnPdiP;
    }

    public void setUpsrSwitchOnPdiP(boolean bl) throws ConnectionTypeError {
        if (!this.node.hasSelector()) {
            if (db.on()) {
                db.println(this.node.getName() + " is not a UpsrSelectorConn. " + "No setUpsrSwitchOnPdiP()");
            }
            return;
        }
        this.upsrSwitchOnPdiP = bl;
        IConnectionModel iConnectionModel = this.node.getConn();
        if (iConnectionModel != null) {
            if (iConnectionModel instanceof IHoConnectionModel) {
                ((IHoConnectionModel)iConnectionModel).setUpsrSwitchOnPdiP(bl);
            } else {
                ((ILoConnectionModel)iConnectionModel).setUpsrSwitchOnPdiP(bl);
            }
        }
    }

    public void setReverseUpsrSwitchOnPdiP(boolean bl) throws ConnectionTypeError, InvalidPath, FeatureNotSupported {
        if (!this.node.hasSelector()) {
            if (db.on()) {
                db.println(this.node.getName() + " is not a UpsrSelectorConn. " + "No setReverseUpsrSwitchOnPdiP()");
            }
            return;
        }
        if (!this.featuresArray[0]) {
            throw REVERSE_PDIP_UNSUPPORTED;
        }
        this.reverseUpsrSwitchOnPdiP = bl;
        IConnectionModel iConnectionModel = this.node.getConn();
        if (iConnectionModel != null && iConnectionModel instanceof UpsrSelector) {
            ((UpsrSelector)iConnectionModel).setReverseUpsrSwitchOnPdiP(bl);
        }
    }

    public short getUpsrSdBerLevel() {
        return this.upsrSdBerLevel;
    }

    public short getReverseUpsrSdBerLevel() throws FeatureNotSupported {
        if (!this.featuresArray[2]) {
            throw REVERSE_SD_AND_SF_BER_UNSUPPORTED;
        }
        return this.reverseUpsrSdBerLevel;
    }

    public void setUpsrSdBerLevel(short s) {
        if (!this.node.hasSelector()) {
            if (db.on()) {
                db.println(this.node.getName() + " is not a UpsrSelectorConn. " + "No setUpsrSdBerlevel()");
            }
            return;
        }
        this.upsrSdBerLevel = s;
        IConnectionModel iConnectionModel = this.node.getConn();
        if (iConnectionModel != null) {
            if (iConnectionModel instanceof IHoConnectionModel) {
                ((IHoConnectionModel)iConnectionModel).setUpsrSdBerLevel(s);
            } else if (iConnectionModel instanceof ILoConnectionModel) {
                try {
                    ((ILoConnectionModel)iConnectionModel).getUpsrSdBerLevel();
                    ((ILoConnectionModel)iConnectionModel).setUpsrSdBerLevel(s);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    db.info("Nothing wrong here: we just don't support the operation" + unsupportedOperationException);
                }
            }
        }
    }

    public void setReverseUpsrSdBerLevel(short s) throws ConnectionTypeError, FeatureNotSupported {
        if (!this.node.hasSelector()) {
            if (db.on()) {
                db.println(this.node.getName() + " is not a UpsrSelectorConn. " + "No setReverseUpsrSdBerlevel()");
            }
            return;
        }
        if (!this.featuresArray[2]) {
            throw REVERSE_SD_AND_SF_BER_UNSUPPORTED;
        }
        this.reverseUpsrSdBerLevel = s;
        IConnectionModel iConnectionModel = this.node.getConn();
        if (iConnectionModel != null && iConnectionModel instanceof UpsrSelector) {
            ((UpsrSelector)iConnectionModel).setReverseUpsrSdBerLevel(s);
        }
    }

    public IRevertiveBehavior getUpsrReversion() {
        return this.upsrReversion;
    }

    public IRevertiveBehavior getReverseUpsrReversion() throws FeatureNotSupported {
        if (!this.featuresArray[1]) {
            throw REVERSE_REVERSION_UNSUPPORTED;
        }
        return this.reverseUpsrReversion;
    }

    public void setUpsrReversion(IRevertiveBehavior iRevertiveBehavior) {
        if (!this.node.hasSelector()) {
            if (db.on()) {
                db.println(this.node.getName() + " is not a UpsrSelectorConn. " + "No setUpsrReversion()");
            }
            return;
        }
        this.upsrReversion = iRevertiveBehavior;
        IConnectionModel iConnectionModel = this.node.getConn();
        if (iConnectionModel != null) {
            if (iConnectionModel instanceof IHoConnectionModel) {
                ((IHoConnectionModel)iConnectionModel).setUpsrReversion(iRevertiveBehavior);
            } else {
                ((ILoConnectionModel)iConnectionModel).setUpsrReversion(iRevertiveBehavior);
            }
        }
    }

    public void setReverseUpsrReversion(IRevertiveBehavior iRevertiveBehavior) throws ConnectionTypeError, FeatureNotSupported {
        if (!this.node.hasSelector()) {
            if (db.on()) {
                db.println(this.node.getName() + " is not a UpsrSelectorConn. " + "No setUpsrReverseReversion()");
            }
            return;
        }
        if (!this.featuresArray[1]) {
            throw REVERSE_REVERSION_UNSUPPORTED;
        }
        this.reverseUpsrReversion = iRevertiveBehavior;
        IConnectionModel iConnectionModel = this.node.getConn();
        if (iConnectionModel != null && iConnectionModel instanceof UpsrSelector) {
            ((UpsrSelector)iConnectionModel).setReverseUpsrReversion(iRevertiveBehavior);
        }
    }

    public int getProtectionOp() {
        if (!this.node.hasConnection()) {
            return 0;
        }
        IConnectionModel iConnectionModel = this.node.getConn();
        if (iConnectionModel != null) {
            if (iConnectionModel instanceof IHoConnectionModel) {
                return ((IHoConnectionModel)iConnectionModel).getProtectionOp();
            }
            return ((ILoConnectionModel)iConnectionModel).getProtectionOp();
        }
        return 0;
    }

    public int getReverseProtectionOp() {
        if (!this.node.hasConnection()) {
            return 0;
        }
        IConnectionModel iConnectionModel = this.node.getConn();
        if (iConnectionModel != null) {
            if (iConnectionModel instanceof IHoConnectionModel) {
                return ((IHoConnectionModel)iConnectionModel).getReverseProtectionOp();
            }
            return ((ILoConnectionModel)iConnectionModel).getReverseProtectionOp();
        }
        return 0;
    }

    public void setProtectionOp(int n) throws InvalidProtectionOp, InternalCommError, ConnectionInLoopback, ConnectionTypeError, ConnectionInTestAccess {
        IConnectionModel iConnectionModel;
        if (this.dbgOn()) {
            this.debug("performing protection op " + EnumStrings.getString(IProtectionOp.class, (int)n) + " at node " + this.node.getName() + ". object index = " + this.connObjIndex);
        }
        if ((iConnectionModel = this.node.getConn()) != null) {
            if (iConnectionModel instanceof IHoConnectionModel) {
                if (this.dbgOn()) {
                    this.debug("setProtectionOp: connection type = HO");
                }
                ((IHoConnectionModel)iConnectionModel).setProtectionOp(n);
            } else {
                if (this.dbgOn()) {
                    this.debug("setProtectionOp: connection type = LO");
                }
                ((ILoConnectionModel)iConnectionModel).setProtectionOp(n);
            }
        } else {
            if (this.dbgOn()) {
                this.debug("setProtectionOp: connection is null, throwing InvalidProtectionOp exception");
            }
            throw new InvalidProtectionOp("Cannot perform requested protection op as connection is unavailable");
        }
    }

    public void setReverseProtectionOp(int n) throws InvalidProtectionOp, InternalCommError {
        IConnectionModel iConnectionModel;
        if (this.dbgOn()) {
            this.debug("performing reverse protection op " + EnumStrings.getString(IProtectionOp.class, (int)n) + " at node " + this.node.getName() + ". object index = " + this.connObjIndex);
        }
        if ((iConnectionModel = this.node.getConn()) != null) {
            if (iConnectionModel instanceof IHoConnectionModel) {
                if (this.dbgOn()) {
                    this.debug("setReverseProtectionOp: connection type = HO");
                }
                ((IHoConnectionModel)iConnectionModel).setReverseProtectionOp(n);
            } else {
                if (this.dbgOn()) {
                    this.debug("setReverseProtectionOp: connection type = LO");
                }
                ((ILoConnectionModel)iConnectionModel).setReverseProtectionOp(n);
            }
        } else {
            if (this.dbgOn()) {
                this.debug("setReverseProtectionOp: connection is null, throwing InvalidProtectionOp exception");
            }
            throw new InvalidProtectionOp("Cannot perform requested protection op as connection is unavailable");
        }
    }

    public List getWorkingSpans() {
        return this.node.getWorkingSpans();
    }

    public List getProtectSpans() {
        return this.node.getProtectSpans();
    }

    public List getActiveSpans() {
        return this.node.getActiveSpans();
    }

    private boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    private void debug(String string) {
        db.println(string);
    }
}

