/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.CmsObservable;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.INodeModel;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitRepairer;
import cerent.cms.ncp.NetCircuitWatchDog;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.NetVcatTermination;
import cerent.util.SDebug;
import java.util.HashSet;
import java.util.Set;

public class NetVcatCircuitRepairer
extends NetCircuitRepairer {
    private static NetVcatCircuit vcatCircuit;
    private static final SDebug db;

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    protected NetVcatCircuitRepairer(NetCircuit netCircuit) {
        vcatCircuit = (NetVcatCircuit)netCircuit;
    }

    protected NetCircuit getCircuit() {
        return vcatCircuit;
    }

    protected Set getAffectedNodes(int n, int n2) {
        HashSet<INodeModel> hashSet = new HashSet<INodeModel>();
        ICircuitId iCircuitId = vcatCircuit.getCircuitId();
        if (NetVcatCircuit.isNullCircuitId(iCircuitId)) {
            return hashSet;
        }
        for (CmsObservable cmsObservable : vcatCircuit.getAllMemberCircuits()) {
            NetCircuitRepairer netCircuitRepairer = NetCircuitManager.instance().getCircuitRepairer((NetCircuit)cmsObservable);
            hashSet.addAll(netCircuitRepairer.getAffectedNodes(n, n2));
        }
        if (iCircuitId.getNodeId() == n) {
            for (CmsObservable cmsObservable : vcatCircuit.getAllVcatTerms()) {
                hashSet.add(((NetVcatTermination)cmsObservable).getNodeModel());
            }
        }
        return hashSet;
    }

    protected boolean repairCircuit(int n, int n2) throws CircuitProvError {
        if (!this.isRepairable()) {
            return false;
        }
        boolean bl = true;
        for (NetCcatCircuit netCcatCircuit : vcatCircuit.getAllMemberCircuits()) {
            try {
                NetCircuitRepairer netCircuitRepairer = NetCircuitManager.instance().getCircuitRepairer(netCcatCircuit);
                if (netCircuitRepairer.repairCircuit(n, n2)) continue;
                bl = false;
            }
            catch (CircuitProvError circuitProvError) {
                if (NetVcatCircuitRepairer.dbgOn()) {
                    db.println("repairCircuit encountered exception " + circuitProvError.getMessage());
                }
                bl = false;
            }
        }
        if (!super.repairCircuit(n, n2)) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeCircuitId(ICircuitId iCircuitId) {
        NetVcatCircuit netVcatCircuit = vcatCircuit;
        synchronized (netVcatCircuit) {
            for (NetVcatTermination netVcatTermination : vcatCircuit.getAllVcatTerms()) {
                netVcatTermination.setVcatTermCircuitId(iCircuitId);
                vcatCircuit.disposeVcatTerm(netVcatTermination, false);
                NetCircuitWatchDog.instance().reloadVcatTerms(netVcatTermination.getNetElement());
            }
        }
    }

    static {
        db = new SDebug("NetVcatCircuitRepairer");
    }
}

