/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.CircuitId;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.IDwdmModuleModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IXPL2ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.ConnectionPathNotFound;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeOperator;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSplicer;
import cerent.cms.ncp.OchTrailTunnelNodeOperator;
import cerent.cms.ncp.OchccCircuitEnd;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ncp.OchncCircuitEnd;
import cerent.cms.ncp.OchncCircuitSpan;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.topo.INetElement;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class OchTrailTunnelNode
extends NetCircuitNode {
    private static final SDebug db = new SDebug("OchTrailTunnelNode");
    private IOchTrailAditModel ochtrailAdit;
    protected OchTrailTunnelNodeOperator operator;

    public OchTrailTunnelNode(INetElement iNetElement, OchncCircuit ochncCircuit) {
        super(iNetElement, ochncCircuit);
        this.cktId = new CircuitId(0, 0);
        this.serviceState = -2;
        this.pathWidth = (short)ochncCircuit.getCircuitSize();
        this.operator = new OchTrailTunnelNodeOperator(this);
    }

    public OchTrailTunnelNode(INetElement iNetElement, OchncCircuit ochncCircuit, Object object) throws AbstractCmsObjectNotExistException {
        super(iNetElement, ochncCircuit, object);
        this.ne = iNetElement;
        ochncCircuit.setChanged();
        this.pathWidth = (short)ochncCircuit.getCircuitSize();
        this.operator = new OchTrailTunnelNodeOperator(this);
    }

    protected void sanityCheckConnModel() {
        this.inUse();
    }

    protected int getConnTypeFromConnModel() {
        IOchTrailAditModel iOchTrailAditModel = this.ochtrailAdit;
        if (iOchTrailAditModel != null) {
            return 0;
        }
        return 22;
    }

    protected Object[] getPathsFromConnModel() {
        IOchTrailAditModel iOchTrailAditModel = this.ochtrailAdit;
        if (iOchTrailAditModel != null) {
            return iOchTrailAditModel.getPaths();
        }
        if (this.dbgOn()) {
            db.println("getPathsFromAditModel @ Node " + this.getName() + " with connection object deleted");
        }
        return new LinkedList().toArray();
    }

    protected int getConnDir() {
        return 1;
    }

    protected void activate() throws CircuitProvError {
        super.activate();
        this.numberOfPaths = this.countNumInputs() + this.countNumOutputs() + this.countNumOmniSpans() + (this.isDstCoLocatedCktNode() || this.isSrcCoLocatedCktNode() ? 2 : 0);
    }

    protected void conformToPaths(Object[] objectArray, NetCircuitSplicer netCircuitSplicer) {
        if (objectArray == null) {
            return;
        }
        this.numberOfPaths = objectArray.length;
        Iterator<Object> iterator = Arrays.asList(objectArray).iterator();
        if (this.dbgOn()) {
            db.println("OchTrailTunnelNode conformToPaths: " + this.getName() + " connType: " + EnumStrings.getString(IConnectionType.class, (int)this.connType) + " no. of paths:" + this.numberOfPaths);
        }
        if (this.numberOfPaths == 2) {
            Object object = iterator.next();
            this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
            object = iterator.next();
            this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
            this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.BIDIRECTIONAL, netCircuitSplicer);
        } else if (this.dbgOn()) {
            db.println("OchTrailTunnelNode conformToPath: invalid OTT ONEWAY");
        }
    }

    protected void createSpliceListener(NetCircuitEnd netCircuitEnd, eSpanDirection eSpanDirection2) {
        NetCircuitSplicer netCircuitSplicer = NetCircuitSplicer.instance();
        if (!this.hasConnectionPath(netCircuitEnd)) {
            if (this.dbgOn()) {
                this.debug("createSpliceListener: cktEnd has no connection path " + Integer.toHexString(netCircuitEnd.getEntityIndex()));
            }
            return;
        }
        try {
            int n = this.getConnectionPathIndex(netCircuitEnd);
        }
        catch (ConnectionPathNotFound connectionPathNotFound) {
            if (this.dbgOn()) {
                this.debug("createSpliceListener: cktEnd has no connection path index" + Integer.toHexString(netCircuitEnd.getEntityIndex()));
            }
            return;
        }
        if (this.dbgOn()) {
            this.debug("createSpliceListener: creating splice listener for " + Integer.toHexString(netCircuitEnd.getEntityIndex()) + " spliceDir: " + eSpanDirection2);
        }
        this.createSpliceListener(netCircuitSplicer, netCircuitEnd, eSpanDirection2);
    }

    public NetCircuitEnd getSpanEndpoint(NetCircuitSpan netCircuitSpan) {
        CircuitEnd circuitEnd = new CircuitEnd();
        circuitEnd.setNodeId(this.ne.getNodeId());
        if (netCircuitSpan.isInternalSpan()) {
            circuitEnd.setPortNum(netCircuitSpan.getInternalEntityIndex(this));
        } else {
            circuitEnd.setPortNum(netCircuitSpan.getEntityIndex(this.ne));
        }
        circuitEnd.setDropProt(false);
        return new OchncCircuitEnd(this.ne.getNodeModel(), circuitEnd, ((OchncCircuitSpan)netCircuitSpan).getOptChannel());
    }

    public int getEntityIndex() throws SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("getTunnelEntityIndex for OchTrail Adit");
        }
        if (this.ochtrailAdit == null) {
            throw new SanityCheckFailed("Invalid OchTrail Adit at " + this.getName());
        }
        IOchncPathDefModel[] iOchncPathDefModelArray = this.ochtrailAdit.getPaths();
        return iOchncPathDefModelArray[0].getPortEntityIdx();
    }

    protected int getTunnelEntityIndex() throws SanityCheckFailed {
        int n;
        block12: {
            n = this.getEntityIndex();
            INodeModel iNodeModel = this.ne.getNodeModel();
            if (iNodeModel.provides(Feature.STS_OVER_MSTP_ADM)) {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                try {
                    IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                    IModuleModel iModuleModel = iEntityModel.getModuleModel();
                    if (iModuleModel instanceof IDwdmModuleModel) {
                        IInterfaceModel iInterfaceModel;
                        IInterfaceModel[] iInterfaceModelArray;
                        IDwdmModuleModel iDwdmModuleModel = (IDwdmModuleModel)iModuleModel;
                        if (iDwdmModuleModel.isADMCard()) {
                            IEntityModel iEntityModel2;
                            List list = iDwdmModuleModel.getDescendantsOfEqType(61);
                            List list2 = iDwdmModuleModel.getDescendantsOfEqType(123);
                            Iterator iterator = list2.iterator();
                            int n2 = 0;
                            while (iterator.hasNext() && (iEntityModel2 = (IEntityModel)iterator.next()).getEntityIndex() != iEntityModel.getEntityIndex()) {
                                ++n2;
                            }
                            if (!list.isEmpty()) {
                                if (iNodeModel.provides(Feature.STS_OVER_MSTP_ADM_ENHANCED)) {
                                    iEntityModel2 = iDwdmModuleModel.isInSingleCardMode() ? (IEntityModel)list.get(n2) : (IEntityModel)list.get(0);
                                    n = iEntityModel2.getEntityIndex();
                                } else {
                                    iEntityModel2 = (IEntityModel)list.get(0);
                                    n = iEntityModel2.getEntityIndex();
                                }
                            }
                        } else if (iModuleModel instanceof IXPL2ModuleModel && ((IXPL2ModuleModel)iModuleModel).isL2Switch() && iNodeModel.provides(Feature.SVLAN_CKT) && (iInterfaceModelArray = (iInterfaceModel = ((IPortModel)iEntityModel).getInterfaceModel()).getHigherLayerModelsForNet()).length > 0 && iInterfaceModelArray[0] != null) {
                            n = iInterfaceModelArray[0].getIndex();
                        }
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) break block12;
                    db.println("getTunnelEntityIndex: Exception " + (Object)((Object)abstractCmsNoSuchEntityException));
                }
            }
        }
        if (db.on()) {
            db.println("getTunnelEntityIndex returns port " + Integer.toHexString(n));
        }
        return n;
    }

    protected INetCircuitNode getOchccConnection() {
        List list = this.getConnectionPathEnds();
        if (list.size() > 0) {
            INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)list.get(0);
            OchccCircuitEnd ochccCircuitEnd = new OchccCircuitEnd(iNetCircuitEnd);
            INetCircuit iNetCircuit = NetCircuitManager.instance().getCircuitFromCircuitEnd(ochccCircuitEnd);
            if (iNetCircuit != null) {
                return iNetCircuit.getCircuitNodeFromCktEnd(ochccCircuitEnd);
            }
        }
        if (db.on()) {
            db.println("WARNING: getOchccConnection: OCHCC not found!");
        }
        return null;
    }

    public int getOptChannel() throws SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("getTunnel Channel for OchTrail Adit");
        }
        if (this.ochtrailAdit != null) {
            throw new SanityCheckFailed("Invalid OchTrail Adit at " + this.getName());
        }
        IOchncPathDefModel[] iOchncPathDefModelArray = this.ochtrailAdit.getPaths();
        return iOchncPathDefModelArray[0].getOptChannel();
    }

    protected void setupConnListOnDiscovery() {
        this.connections = new LinkedList();
    }

    protected int findConnType() {
        return 0;
    }

    public boolean inUse() {
        return this.ochtrailAdit != null && this.ochtrailAdit.inUse();
    }

    protected void deleteDrop(INetCircuitEnd iNetCircuitEnd) throws DeletionError, SanityCheckFailed {
        super.deleteDrop(iNetCircuitEnd);
    }

    public void setConnectionCircuitId(ICircuitId iCircuitId) {
        if (this.dbgOn()) {
            db.println("setting the connection circuit Id at " + this.getName() + " to " + NetCircuit.prettyString(iCircuitId));
        }
        if (this.ochtrailAdit != null) {
            this.ochtrailAdit.setCircuitId(iCircuitId);
            this.cktId = iCircuitId;
        }
    }

    public ICircuitId getConnectionCircuitId() {
        if (this.ochtrailAdit != null) {
            return this.ochtrailAdit.getCircuitId();
        }
        if (this.dbgOn()) {
            db.println("getConnectionCircuitId @ Node " + this.getName() + " with connection object deleted");
        }
        return null;
    }

    protected boolean isSrcCoLocatedCktNode() {
        return !this.circuit.getSrcInternalSpliceLinkEnds().isEmpty() && ((NetCircuitEnd)this.circuit.getSrcInternalSpliceLinkEnds().get(0)).getNodeId() == this.getNodeModel().getNodeId();
    }

    protected boolean isDstCoLocatedCktNode() {
        return !this.circuit.getDstInternalSpliceLinkEnds().isEmpty() && ((NetCircuitEnd)this.circuit.getDstInternalSpliceLinkEnds().get(0)).getNodeId() == this.getNodeModel().getNodeId();
    }

    public boolean isOchTrailTunnelNode() {
        return true;
    }

    protected void handleTl1LoAditDeletion() {
        int n = this.circuit.getCircuitType();
        if (this.dbgOn()) {
            db.println("handleTl1LoAditDeletion :  DELETED for cktType" + n + " at node" + this.getName());
        }
        if (!this.circuit.circuitInfoActive() && this.circuit.getCircuitTypeObj().isOchTrailTunnelCircuitType() && !((OchncCircuit)this.circuit).hasOTTAdits()) {
            this.circuit.setCircuitType(9);
        }
    }

    protected List getSrcCoLocatedCktEnds() {
        LinkedList linkedList = new LinkedList();
        if (!this.circuit.getSrcInternalSpliceLinkEnds().isEmpty()) {
            linkedList.add(this.circuit.getSrcInternalSpliceLinkEnds().get(0));
        }
        return linkedList;
    }

    protected List getDstCoLocatedCktEnds() {
        LinkedList linkedList = new LinkedList();
        if (!this.circuit.getDstInternalSpliceLinkEnds().isEmpty()) {
            linkedList.add(this.circuit.getDstInternalSpliceLinkEnds().get(0));
        }
        return linkedList;
    }

    public IConnectionModel getConn() {
        return this.ochtrailAdit;
    }

    protected void setConn(IConnectionModel iConnectionModel) {
        this.ochtrailAdit = (IOchTrailAditModel)iConnectionModel;
    }

    protected int getAdminStateFromNE() {
        block4: {
            IPortModel iPortModel = this.getPortModel();
            if (iPortModel != null) {
                try {
                    int n = iPortModel.getAdminState();
                    if (db.on()) {
                        db.println("getAdminStateFromNE. Returning admin state from port: " + OchTrailTunnelNode.translateAdminState(n));
                    }
                    return n;
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (!db.on()) break block4;
                    db.warning("getAdminStateFromNE. Cannot get admin state for port " + iPortModel + ": " + noSuchInterface.getMessage());
                }
            }
        }
        return super.getAdminStateFromNE();
    }

    protected int getServiceStateFromNE() {
        block4: {
            IPortModel iPortModel = this.getPortModel();
            if (iPortModel != null) {
                try {
                    int n = iPortModel.getServiceStateType();
                    if (db.on()) {
                        db.println("getServiceStateFromNE. Returning service state from port: " + OchTrailTunnelNode.translateServiceState(n));
                    }
                    return n;
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (!db.on()) break block4;
                    db.warning("getServiceStateFromNE. Cannot get service state for port " + iPortModel + ": " + noSuchInterface.getMessage());
                }
            }
        }
        return super.getServiceStateFromNE();
    }

    public IPortModel getPortModel() {
        if (this.getConn() != null) {
            return this.ochtrailAdit.getPortModel();
        }
        return null;
    }

    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    protected void debug(String string) {
        db.println(string);
    }

    protected Object[] getActivePathsFromConnModel() {
        if (this.dbgOn()) {
            db.println("OchncCircuitNode -> getActivePathsFromConnModel @ Node " + this.getName());
        }
        return null;
    }

    protected int getProtectionOpFromConnModel() {
        if (this.dbgOn()) {
            db.println("OchncCircuitNode -> getProtectionOpFromConnModel @ Node " + this.getName());
        }
        return -1;
    }

    protected int getReverseProtectionOpFromConnModel() {
        if (this.dbgOn()) {
            db.println("OchncCircuitNode -> getReverseProtectionOpFromConnModel @ Node " + this.getName());
        }
        return -1;
    }

    protected NetCircuitNodeOperator getOperator() {
        return this.operator;
    }

    protected boolean completeCheck() {
        int n;
        block7: {
            this.numberOfPaths = this.countNumInputs() + this.countNumOutputs();
            if (this.getBiSpans().size() > 0) {
                this.numberOfPaths -= this.getBiSpans().size();
            }
            n = 0;
            try {
                n += this.getPathsFromConnModel().length;
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                if (this.dbgOn()) {
                    db.println("completeCheck: node may have been deleted");
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!this.dbgOn()) break block7;
                db.println("completeCheck: IO exception to node");
            }
        }
        if (n == this.numberOfPaths) {
            if (this.dbgOn()) {
                db.println("completeCheck passed");
            }
            return true;
        }
        return false;
    }

    public NetCircuitNode findColocatedOchncCircuitNode() {
        INetCircuitNode iNetCircuitNode;
        LinkedList linkedList = this.getInSpans();
        for (NetCircuitSpan netCircuitSpan : linkedList) {
            if (netCircuitSpan.getLink().getLinkType() != 10 || (iNetCircuitNode = netCircuitSpan.getSrcNCN()) == null || !iNetCircuitNode.isOchncCircuitNode()) continue;
            return (NetCircuitNode)iNetCircuitNode;
        }
        linkedList = this.getOutSpans();
        for (NetCircuitSpan netCircuitSpan : linkedList) {
            if (netCircuitSpan.getLink().getLinkType() != 10 || (iNetCircuitNode = netCircuitSpan.getDstNCN()) == null || !iNetCircuitNode.isOchncCircuitNode()) continue;
            return (NetCircuitNode)iNetCircuitNode;
        }
        return null;
    }

    public int getEntityIndexFromSpans() {
        int n = -1;
        LinkedList linkedList = this.getInSpans();
        if (linkedList.size() > 0) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)linkedList.get(0);
            return netCircuitSpan.getInternalEntityIndex(this);
        }
        LinkedList linkedList2 = this.getOutSpans();
        if (linkedList2.size() > 0) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)linkedList2.get(0);
            return netCircuitSpan.getInternalEntityIndex(this);
        }
        return n;
    }
}

